function [value, idx] = max_rng(values)
    % MAX_RNG  Outputs the highest [value] in [values] and a random [idx] of
    % [values] at which that [value] is found.
    %
    % Differs from the regular [max] function only if [value] is found in [values]
    % at multiple indices. From that set of indices, [max] returns the highest
    % index, but [max_rng] returns a random [idx].

    if isempty(values)
        value = [];
        idx = [];
        return;
    end
    if all(isnan(values))
        value = NaN;
        idx = 0;
        return;
    end

    idxs = 1:numel(values);
    value = max(values, [], "all");
    idx = randelem(idxs(values == value));  % This is faster than first doing randsample and then doing `max`
end
