MATLAB code to reproduce results presented in the paper "Optimal Graph 
Stretching for Distributed Averaging".

The source code is available as a git repository. Cached computation results are 
available as additional files.

**Git repository**  
Relevant code is stored in the `StretchSim` directory.

Runs and visualises optimal graph stretching. The settings in `StretchSim.m`
correspond exactly to the code that was executed to create the results in the 
paper. The code is fully deterministic and gives the exact same results as in 
the paper. By default, cached results are used.

See `ARTIFACT-EVALUATION.md` in the root folder for detailed end-user
instructions.

**Files**  
Cached computation results are optionally available, with filenames ending in 
`.cache.zip`. These allow inspecting the exact outputs without the need to 
re-run the computationally intensive experiments. Detailed usage instructions 
are available in the file `ARTIFACT-EVALUATION.md` inside the git repository.
