#########################################################################################################
# Final state of the convergent analysis in the research, Siska Fitrianie, Merijn Bruijnes, 
# Fengxiang Li, Amal Abdulrahman, Willem-Paul Brinkman. 2022. The Artificial-Social-Agent Questionnaire: 
# Establishing the long and short questionnaire versions. In ACM International Conference on Intelligent 
# Virtual Agents (IVA’22), September, 2022, Faro, Portugal. ACM, New York, NY, USA.
# https://doi.org/10.1145/3514197.3549612
#
# Run CFA of 19 individual models (n=532)
# Input:  result_all_pItem_std.csv (standardized observed data)
# Output: final_latentPredicted_convergentAnalysis.csv (predicted latent scores of constructs/dimensions)
#########################################################################################################

## Library
library(lavaan)

## Retrieve data
d_results_std=read.csv2("../r_results/result_all_pItem_std.csv", header = TRUE, sep =",")
d_results_std <- mutate_all(d_results_std, function(x) as.numeric(as.character(x)))

## CFA of individual models (constructs)
set.seed(1234)
model <- '
C01D01 =~ C01D01Q3 + C01D01Q10 + C01D01Q13 + C01D01Q15
C01D02 =~ C01D02Q7 + C01D02Q10 + C01D02Q0 + C01D02Q1  + C01D02Q9 
C01D03 =~ C01D03Q7 + C01D03Q9 +  C01D03Q11 + C01D03Q10 + C01D03Q12
C01D04 =~ C01D04Q0 +  C01D04Q13 +  C01D04Q15 
C01D05 =~ C01D05Q0 + C01D05Q2 + C01D05Q9 +  C01D05Q11 + C01D05Q12 
C01 =~ C01D04 + C01D01 + C01D02 + C01D03 +  C01D05
C01D02 ~~   C01D04
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C01 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C02 =~ C02D00Q1 + C02D00Q2 + C02D00Q8 + R_C02D00Q15
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C02 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C03 =~ C03D01Q7 + C03D01Q5 + C03D01Q6 + C03D01Q12 + C03D02Q5 + C03D02Q10
C03D01Q5 ~~ C03D01Q6
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C03 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- ' 
C04 =~ C04D00Q1 +  C04D00Q10 + R_C04D00Q11 + C04D00Q4 + C04D00Q12 
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C04 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C05 =~ R_C05D00Q3 +  C05D00Q6 + C05D00Q7 + C05D00Q1 + C05D00Q18 
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C05 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C06D01 =~  C06D01Q1 + R_C06D01Q6 + C06D01Q8 + C06D01Q11
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C06 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C07 =~  C07D00Q0 + C07D00Q11 + C07D00Q13 + R_C07D00Q15 +  C07D00Q14
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C07 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C08 =~ R_C08D00Q3 + C08D00Q4 + R_C08D00Q10 + C08D00Q0 + R_C08D00Q9 
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C08 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C09 =~  C09D00Q4 + C09D00Q10 +  C09D00Q1 + R_C09D00Q9 
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C09 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C10 =~ C10D00Q1 + C10D00Q6 + C10D00Q10 + C10D00Q16 + C10D00Q18 
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C10 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C11 =~ C11D01Q6 + C11D01Q9 + C11D01Q10 +  C11D01Q11 + C11D01Q14 + C11D02Q3 + C11D02Q4 + C11D02Q7 + C11D02Q8 + C11D02Q1
C11D01Q6 ~~ C11D02Q3
C11D01Q9 ~~ C11D01Q11
C11D01Q9 ~~ C11D01Q10
C11D02Q3 ~~ C11D02Q8
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C11 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C12 =~ C12D00Q0 +  C12D00Q1 + R_C12D00Q6 + C12D00Q13
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C12 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C13 =~ R_C13D00Q3 + C13D00Q7 + R_C13D00Q11 + R_C13D00Q6 + R_C13D00Q15
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C13 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C14 =~ C14D00Q0 + C14D00Q10 +  R_C14D00Q13 + C14D00Q15 + C14D00Q16 
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C14 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C15 =~ C15D00Q10 + C15D00Q11 + C15D00Q8 + C15D00Q12 + R_C15D00Q15 
C15D00Q8 ~~   C15D00Q12
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C15 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C16 =~ C16D00Q11 + C16D00Q13 +  C16D00Q12 +  C16D00Q16 + C16D00Q17 
C16D00Q11 ~~ C16D00Q16
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C16 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C17 =~  C17D00Q2 + C17D00Q3 + C17D00Q8 + C17D00Q9 + C17D00Q10 
C17D00Q2 ~~  C17D00Q3
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C17 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C18D01 =~ C18D01Q2 + C18D01Q3 +  R_C18D01Q5 + C18D01Q8 + R_C18D01Q14
C18D03 =~ C18D03Q0 + C18D03Q1 + C18D03Q2 +  C18D03Q12 
'
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C18 <- data.frame(lavPredict(fit, type="lv"))

set.seed(1234)
model <- '
C19 =~ C19D00Q3 + C19D00Q7 + C19D00Q14 + C19D00Q26 + C19D00Q28
'  
fit <- cfa(model, data=d_results_std)
summary(fit, fit.measures=TRUE, standardize=TRUE)
MI=modificationIndices(fit, sort.=TRUE, minimum.value=4.0)
MI
d_C19 <- data.frame(lavPredict(fit, type="lv"))

## Collect predicted latent scores of constructs/dimensions and write to .csv
d_predicted_std <- cbind(d_C01,d_C02,d_C03,d_C04,d_C05,d_C06,d_C07,d_C08,d_C09,d_C10,
                         d_C11,d_C12,d_C13,d_C14,d_C15,d_C16,d_C17,d_C18,d_C19)
write.csv(d_predicted_std,"../r_results/final_latentPredicted_convergentAnalysis.csv", row.names = FALSE)