#########################################################################################################
# Simulation prior the current research, Siska Fitrianie, Merijn Bruijnes, Fengxiang Li, Amal Abdulrahman, 
# Willem-Paul Brinkman. 2022b. The Artificial-Social-Agent Questionnaire: Establishing the long and short 
# questionnaire versions. In ACM International Conference on Intelligent Virtual Agents (IVA’22), September, 
# 2022, Faro, Portugal. ACM, New York, NY, USA. https://doi.org/10.1145/3514197.3549612
# 
# Reading the previous research:
# Siska Fitrianie, Merijn Bruijnes, Fengxiang Li, and Willem-Paul Brinkman. 2021. 
# Questionnaire Items for Evaluating Artificial Social Agents - Expert Generated, Content Validated and 
# Reliability Analysed. In Proceedings of the 21th ACM International Conference on Intelligent Virtual 
# Agents (IVA '21). Association for Computing Machinery, New York, NY, USA, 84–86. 
# DOI:https://doi.org/10.1145/3472306.3478341 
#
# Run CFA of two simulation datasets n=406
# Input:  sim_406p_14agents.csv (original simulated data) and 
#         sim_406p_14agents_std.csv (standardized)
# Acceptable goodness of fit cfa: https://www.cscu.cornell.edu/news/Handouts/SEM_fit.pdf
# Using original sim dataset    : Warning - Could not compute standard errors! The information matrix 
#                                 could not be inverted. This may be a symptom that the model is not 
#                                 identified.
# Using standardized sim dataset: OK! (see the output)
# Output:  ../r_results/simCFA_406p_14agents_std.rtf (using the standardized simulated data)
#########################################################################################################

## Library
library(dplyr) 
library(tidyr) 
library(lavaan)
library(knitr)

## Read data
dataOri <- read.csv2("../r_results/sim_406p_14agents.csv", header = TRUE, sep =",")
dataStd <- read.csv2("../r_results/sim_406p_14agents_std.csv", header = TRUE, sep =",")

## Initial theoreticalModel #items = 131 
theoreticalModel <- '
#latent variable first order
C01D01 =~ 1*C01D01Q3 + C01D01Q10 + C01D01Q13 + C01D01Q15 + C01D01Q16 
C01D02 =~ 1*C01D02Q7 + C01D02Q10 + C01D02Q0 + C01D02Q1 + C01D02Q9 
C01D03 =~ 1*C01D03Q7 + C01D03Q9 + C01D03Q10 + C01D03Q11 + C01D03Q12 
C01D04 =~ 1*C01D04Q0 + C01D04Q13 + C01D04Q15 + C01D04Q8 + C01D04Q9
C01D05 =~ 1*C01D05Q2 + C01D05Q9 + C01D05Q11 + C01D05Q12 + C01D05Q0
C02 =~ 1*C02D00Q1 + C02D00Q2 + C02D00Q8 + R_C02D00Q11 + R_C02D00Q15
C03D01 =~ 1*C03D01Q1 + C03D01Q7 + C03D01Q5 + C03D01Q6 + C03D01Q12
C03D02 =~ 1*C03D02Q0 + C03D02Q5 + C03D02Q10 + R_C03D02Q13 + R_C03D02Q1
C04 =~ 1*C04D00Q1 + C04D00Q10 + R_C04D00Q11 + C04D00Q4 + C04D00Q12 
C05 =~ 1*R_C05D00Q3 + C05D00Q6 + C05D00Q7 + C05D00Q1 + C05D00Q18 
C06D01 =~ 1*C06D01Q1 + R_C06D01Q6 + R_C06D01Q13 + C06D01Q8 + C06D01Q11
C07 =~ 1*C07D00Q0 + C07D00Q11 + C07D00Q13 + R_C07D00Q15 + C07D00Q14  
C08 =~ 1*R_C08D00Q3 + C08D00Q4 + R_C08D00Q10 + C08D00Q0 + R_C08D00Q9  
C09 =~ 1*C09D00Q4 + C09D00Q5 + C09D00Q10 + C09D00Q3 + C09D00Q1 + R_C09D00Q9 
C10 =~ 1*C10D00Q1 + C10D00Q6 + C10D00Q10 + C10D00Q16 + C10D00Q18 
C11D01 =~ 1*C11D01Q6 + C11D01Q9 + C11D01Q10 + C11D01Q11 + C11D01Q14 
C11D02 =~ 1*C11D02Q1 + C11D02Q3 + C11D02Q4 + C11D02Q7 + C11D02Q8 
C12 =~ 1*C12D00Q0 + C12D00Q13 + C12D00Q1 + C12D00Q8 + R_C12D00Q6 
C13 =~ 1*R_C13D00Q3 + C13D00Q7 + R_C13D00Q11 + R_C13D00Q6 + R_C13D00Q15
C14 =~ 1*C14D00Q0 + C14D00Q10 + R_C14D00Q13 + C14D00Q15 + C14D00Q16 
C15 =~ 1*C15D00Q10 + C15D00Q11 + C15D00Q8 + C15D00Q12 + R_C15D00Q15 
C16 =~ 1*C16D00Q11 + C16D00Q12 + C16D00Q13 + C16D00Q16 + C16D00Q17 
C17 =~ 1*C17D00Q2 + C17D00Q3 + C17D00Q8 + C17D00Q9 + C17D00Q10 
C18D01 =~ 1*C18D01Q2 + C18D01Q3 + R_C18D01Q5 + C18D01Q8 + R_C18D01Q14
C18D03 =~ 1*C18D03Q0 + C18D03Q1 + C18D03Q2 + C18D03Q9 + C18D03Q12  
C19 =~ 1*C19D00Q3 + C19D00Q7 + C19D00Q14 + C19D00Q26 + C19D00Q28  

#latent variable second order
C01 =~ 1*C01D01 + C01D02 + C01D03 + C01D04 + C01D05
C03 =~ 1*C03D01 + C03D02
C11 =~ 1*C11D01 + C11D02
C18 =~ 1*C18D01 + C18D03
'

## CFA using original simulated dataset
fitOri <- lavaan:::cfa(theoreticalModel, data=dataOri, check.gradient = FALSE)
options(max.print=10000000)
summary(fitOri, fit.measures=TRUE, standardize=TRUE, rsquare=TRUE)

## CFA using standardized simulated dataset
fitStd <- lavaan:::cfa(theoreticalModel, data=dataStd, check.gradient = FALSE)
options(max.print=10000000)
summary(fitStd, fit.measures=TRUE, standardize=TRUE, rsquare=TRUE)
