#########################################################################################################
# Generating ASA chart for 14 ASAs in research: 
# Siska Fitrianie, Merijn Bruijnes, Fengxiang Li, Amal Abdulrahman, Willem-Paul Brinkman. 2022. 
# The Artificial-Social-Agent Questionnaire: Establishing the long and short questionnaire versions. 
# In ACM International Conference on Intelligent Virtual Agents (IVA’22), September, 2022, Faro, Portugal. 
# ACM, New York, NY, USA. https://doi.org/10.1145/3514197.3549612
#
# Calculate the mean of each construct/dimension for 14 ASAs
# Input:  result_all.csv (raw observed data)
# Output: constructsMean_14agents.csv
#########################################################################################################

## Retrieve raw observed data
setwd("/Users/siska/Documents/my work/IVA/study 7 - CFA/calculation/")
d_131items=read.csv2("r/data/items_131.csv", header = TRUE, sep =";")
d_results_all=read.csv2("r/data/result_all.csv", header = TRUE, sep =";")

## calculate the mean of each construct/dimension for each agent
agents = c("AIBO", "AMY", "CHAPPIE", "DEEPBLUE","DOG","FURBY","HAL 9000","iCAT","NAO", "POPPIE","SIM SENSEI", "SIRI", "SARAH","MARCUS")
d_ASAindex<-cbind(d_results_all$GROUP, d_index)
d_ASAmean = data.frame(matrix(ncol = 24, nrow = 0))
row = 1
for (agent in agents){
  d_ASAmean[row,1] <- agent
  for(j in 2:25){
    d<-d_ASAindex[d_ASAindex[,1]==agent,j]
    if (length(d)==0) {
      print(j)
      print(paste("agent ", agent, " is empty", sep=" "))
    }
    MEAN <- round(mean(d),2)
    d_ASAmean[row,j] <- MEAN
  }
  row = row + 1
}
constructs = c("C01D01", "C01D02","C01D03","C01D04","C01D05","C02","C03","C04","C05","C06D01","C07","C08","C09", "C10", "C11","C12", "C13", "C14", "C15", "C16", "C17", "C18D01", "C18D03", "C19")
colnames(d_ASAmean)<-c("ASA",constructs)

## save to a .csv
write.csv(d_ASAmean,"../r_results/constructsMean_14agents.csv", row.names = TRUE)

