# Wi-Fi Fingerprinting Indoor Positioning System for Factory Noise Mapping
## Overview
This dataset supports research on zone-based Wi-Fi fingerprinting indoor positioning systems and factory noise mapping. It includes Wi-Fi RSSI (Received Signal Strength Indicator) data, noise levels, zone information, and timestamps, which can be used to develop models for indoor positioning, zone classification, and noise mapping within factory environments.

## Dataset
1. RSSI_rawdata_4days_sample200_37zone.csv
Raw RSSI measurements collected across 37 zones over four days. Each row contains RSSI values from six access points (AP1-AP6) and the corresponding zone label.

Columns:

AP1-AP6: RSSI values (in dBm) for six Wi-Fi access points.
label: Zone ID (integer) where the data was collected.
Purpose:
Used for training and evaluating machine learning models for indoor positioning and zone classification.

2. RSSI_fluctuate_6AP_Sample400.csv
Wi-Fi RSSI fluctuations collected from six access points (AP1-AP6) at the same location, with 400 samples to analyze signal stability.

Columns:

AP1-AP6: RSSI values (in dBm) for six access points.
Purpose:
Analyzed for signal stability and noise mapping, supporting indoor positioning and signal fluctuation evaluation in factory environments.

## Scripts
1. model.py
Processes the RSSI_rawdata_4days_sample200_37zone.csv file and evaluates machine learning model performance for indoor positioning and zone classification.

2. logic.py
Processes the RSSI_fluctuate_6AP_Sample400.csv file to evaluate Wi-Fi signal fluctuations, supporting signal stability analysis for noise mapping and positioning.

## Citation
If you use this dataset, please cite:
"A zone-based Wi-Fi fingerprinting indoor positioning system for factory noise mapping," Journal of Intelligent Manufacturing, 2025.

## License
This project is licensed under the MIT License. See the LICENSE file for details.
