% This script assembles the stiffness matrix of the fibroblasts.

S_n = sparse(n,n);
for i = 1:(n-1)
    clear Selem
	h = x(i+1)-x(i);
    
    f_1 = (1+r_F_max*c(i)/(a_c_I+c(i)))*(1-kappa_F*(N(i)+M(i)))*N(i)^q;
    f_2 = (1+r_F_max*c(i+1)/(a_c_I+c(i+1)))*(1-kappa_F*(N(i+1)+M(i+1)))*N(i+1)^q;
    c_1 = (c(i+1)-c(i))/h; c_2 = 0;
    if i~=n-1
        c_2 = (c(i+2)-c(i+1))/(x(i+2)-x(i+1));
    end
    A = N(i)+M(i)+N(i+1)+M(i+1);
    Selem = D_F*A/(2*h)*[1,-1;-1,1] ...
                - chi_F/2*[-c_1,-c_2;c_1,c_2]...
                + k_F*h/2*[c(i),0;0,c(i+1)] ...
                - r_F*h/2*[f_1,0;0,f_2]...
                + delta_N*h/6*[2,1;1,2];
            
    for ind1 = 1:topology
        for ind2 = 1:topology
            S_n(elmat(i,ind1),elmat(i,ind2))= Selem(ind1,ind2) + ...
                S_n(elmat(i,ind1),elmat(i,ind2));
        end
    end
end