%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%% 2020-09-07  %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%                                                                         %
%  This program simulates the one-dimensional version of the morphoelas-  %
%  tic model developed by D. Koppenol. In these simulations, the parame-  %
%  ters are varied along patients and along the domain of computation.    %
%  There are four groups of patients. For each group, the program takes   %
%  pre-defined parameter values and fluctuates the values over the domain %
%  if specified. It then simulates the model and writes the relative sur- %
%  face area and the strain energy density into excel files.              %
%                                                                         %
%  For more information about the model and the program, we refer to the  %
%  pdf and other files in this folder.                                    %
%                                                                         %
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function KarhunenLoeve7(nsims)
    % fixed parameters
    dt = 1;
    L = 3.6;
    s = 1;
    topology = 2;
    T = 365;
    R = 0.995;
    delta_M = 6e-2;
    r_F_max = 2;
    eta_I = 2;
    eta_II = 0.45;
    k_rho_max = 10;
    c_tilde = 1e-8;

    for isims = 1:nsims
        disp(['Processor 7, Simulation ' ,num2str(isims)])
        TakeSamples3;
        Output_morpho;
        writematrix(RSAW','morpho_group_3_rsaw_p7.xlsx',...
            'Sheet',1,'WriteMode','append');
        writematrix(Estrain_simp','morpho_group_3_strain_p7.xlsx',...
            'Sheet',1,'WriteMode','append');
    end
end