%%% GROUP 3 %%%
t = 1;

% No domain variations
N_eq = 9e3;
N_tilde = 0.2*N_eq;
rho_eq = 1.05e-1;
rho_tilde = 0.1*rho_eq;

% Mesh etcetera
GenerateMesh;
GenerateTopology;
InitialConditions;

% Means and variances of stochastic parameters
r_F_E         = 0.816;              r_F_S         = 0.0711^2;
delta_N_E     = 0.021;              delta_N_S     = 2.2727e-4^2;
k_F_E         = 1.02e7;             k_F_S         = 5.6842e5^2;
a_c_III_E     = 1.95e8;             a_c_III_S     = 4.3478e6^2;
mu_E          = 120;                mu_S          = 11.11^2;
kappa_F_E     = 1.5e-6;             kappa_F_S     = 1.11e-7^2;
zeta_E        = 4.2e2;              zeta_S        = 18.1818^2;
E_E           = 380;                E_S           = 9.8212^2;
D_F_E         = 8.5e-7;             D_F_S         = 1.4286e-7^2;
D_c_E         = 2.55e-3;            D_c_S         = 3.2e-4^2;
delta_rho_E   = 5.89e-6;            delta_rho_S   = 1.0909e-7^2;

chi_F_E       = 2e-3;               chi_F_S       = 2.2222e-04^2;
a_c_I_E       = 1e-8;               a_c_I_S       = 3.4483e-10^2;
a_c_II_E      = 1e-8;               a_c_II_S      = 6.2500e-10^2;
a_c_IV_E      = 1e-9;               a_c_IV_S      = 1e-10^2;
xi_E          = 0.044;              xi_S          = 0.0011^2;
delta_c_E     = 5e-4;               delta_c_S     = 9.8039e-06^2;
k_c_E         = 3e-13;              k_c_S         = 3.9474e-15^2;
rho_t_E       = 1.09;               rho_t_S       = 0.1211^2;

% Means and variances for the Karhunen-Lo�ve expansions
m_D_F = log(D_F_E/sqrt(1+D_F_S/D_F_E^2)); 
s_D_F = sqrt(log(1+D_F_S/D_F_E^2));
m_r_F = log(r_F_E/sqrt(1+r_F_S/r_F_E^2)); 
s_r_F = sqrt(log(1+r_F_S/r_F_E^2));
m_a_c_I = log(a_c_I_E/sqrt(1+a_c_I_S/a_c_I_E^2)); 
s_a_c_I = sqrt(log(1+a_c_I_S/a_c_I_E^2));
m_kappa_F = log(kappa_F_E/sqrt(1+kappa_F_S/kappa_F_E^2)); 
s_kappa_F = sqrt(log(1+kappa_F_S/kappa_F_E^2));
m_delta_N = log(delta_N_E/sqrt(1+delta_N_S/delta_N_E^2)); 
s_delta_N = sqrt(log(1+delta_N_S/delta_N_E^2));
m_k_F = log(k_F_E/sqrt(1+k_F_S/k_F_E^2)); 
s_k_F = sqrt(log(1+k_F_S/k_F_E^2));
m_D_c = log(D_c_E/sqrt(1+D_c_S/D_c_E^2)); 
s_D_c = sqrt(log(1+D_c_S/D_c_E^2));
m_a_c_II = log(a_c_II_E/sqrt(1+a_c_II_S/a_c_II_E^2)); 
s_a_c_II = sqrt(log(1+a_c_II_S/a_c_II_E^2));
m_k_c = log(k_c_E/sqrt(1+k_c_S/k_c_E^2)); 
s_k_c = sqrt(log(1+k_c_S/k_c_E^2));
m_delta_c = log(delta_c_E/sqrt(1+delta_c_S/delta_c_E^2)); 
s_delta_c = sqrt(log(1+delta_c_S/delta_c_E^2));
m_a_c_III = log(a_c_III_E/sqrt(1+a_c_III_S/a_c_III_E^2)); 
s_a_c_III = sqrt(log(1+a_c_III_S/a_c_III_E^2));
m_a_c_IV = log(a_c_IV_E/sqrt(1+a_c_IV_S/a_c_IV_E^2)); 
s_a_c_IV = sqrt(log(1+a_c_IV_S/a_c_IV_E^2));
m_delta_rho = log(delta_rho_E/sqrt(1+delta_rho_S/delta_rho_E^2)); 
s_delta_rho = sqrt(log(1+delta_rho_S/delta_rho_E^2));
m_rho_t = log(rho_t_E/sqrt(1+rho_t_S/rho_t_E^2)); 
s_rho_t = sqrt(log(1+rho_t_S/rho_t_E^2));
m_mu = log(mu_E/sqrt(1+mu_S/mu_E^2)); 
s_mu = sqrt(log(1+mu_S/mu_E^2));
m_E = log(E_E/sqrt(1+E_S/E_E^2)); 
s_E = sqrt(log(1+E_S/E_E^2));
m_xi = log(xi_E/sqrt(1+xi_S/xi_E^2)); 
s_xi = sqrt(log(1+xi_S/xi_E^2));
m_zeta = log(zeta_E/sqrt(1+zeta_S/zeta_E^2)); 
s_zeta = sqrt(log(1+zeta_S/zeta_E^2));
m_chi_F = log(chi_F_E/sqrt(1+chi_F_S/chi_F_E^2)); 
s_chi_F = sqrt(log(1+chi_F_S/chi_F_E^2));

n_parms = 19;
n_terms = 15;
 
Z = randn(n_terms,n_parms);
u_hat = zeros(n,n_parms);
for i = 1:n
    for k = 1:n_terms
        u_hat(i,:) = u_hat(i,:) + Z(k,:)*sqrt(2)*...
            sin((2*k-1)*pi*x(i)/20);
    end
end

D_F         = exp(m_D_F+s_D_F*u_hat(:,1)/sqrt(n_terms));
r_F         = exp(m_r_F+s_r_F*u_hat(:,2)/sqrt(n_terms));
a_c_I       = exp(m_a_c_I+s_a_c_I*u_hat(:,3)/sqrt(n_terms));
kappa_F     = exp(m_kappa_F+s_kappa_F*u_hat(:,4)/sqrt(n_terms));
delta_N     = exp(m_delta_N+s_delta_N*u_hat(:,5)/sqrt(n_terms));
k_F         = exp(m_k_F+s_k_F*u_hat(:,6)/sqrt(n_terms));
D_c         = exp(m_D_c+s_D_c*u_hat(:,8)/sqrt(n_terms));
a_c_II      = exp(m_a_c_II+s_a_c_II*u_hat(:,9)/sqrt(n_terms));
k_c         = exp(m_k_c+s_k_c*u_hat(:,10)/sqrt(n_terms));
delta_c     = exp(m_delta_c+s_delta_c*u_hat(:,11)/sqrt(n_terms));
a_c_III     = exp(m_a_c_III+s_a_c_III*u_hat(:,12)/sqrt(n_terms));
a_c_IV      = exp(m_a_c_IV+s_a_c_IV*u_hat(:,13)/sqrt(n_terms));
delta_rho   = exp(m_delta_rho+s_delta_rho*u_hat(:,14)/sqrt(n_terms));
rho_t       = exp(m_rho_t+s_rho_t*u_hat(:,15)/sqrt(n_terms));
mu          = exp(m_mu+s_mu*u_hat(:,16)/sqrt(n_terms));
E           = exp(m_E+s_E*u_hat(:,17)/sqrt(n_terms));
xi          = exp(m_xi+s_xi*u_hat(:,18)/sqrt(n_terms));
zeta        = exp(m_zeta+s_zeta*u_hat(:,18)/sqrt(n_terms));
chi_F       = exp(m_chi_F+s_chi_F*u_hat(:,19)/sqrt(n_terms));

q           = (log(delta_N)-log(r_F.*(1-kappa_F*N_eq)))/log(N_eq);
k_rho       = delta_rho*rho_eq^2;