import numpy as np
import matplotlib.pyplot as plt
import cvxpy as cp
import math
import sys

class SMP_Controller:
    def __init__(self, kp, ki, kd, max_vol):
        self.kp = kp
        self.ki = ki
        self.kd = kd
        self.max_vol = max_vol

        self.previous_error = 0
        self.integral = 0

        self.target_temp = None
        self.temp_cal = None
        self.change_target = False

    def set_target(self, new_target):
        self.target_temp = new_target
        self.previous_error = 0
        self.integral = 0
        self.change_target = True

    def sampling_update(self, new_temp_cal):
        self.temp_cal = new_temp_cal

    def check_before_pid(self):
        if self.change_target:
            self.previous_error = 0
            self.integral = 0
            # self.change_target = False

    def pid_controller(self):
        # Call check_before_pid before starting PID calculations
        self.check_before_pid()

        # If target temperature or current temperature not set, return 0
        if self.target_temp is None or self.temp_cal is None:
            return 0

        # Calculate current error
        error = self.target_temp - self.temp_cal

        # Integral term: accumulate error
        self.integral += error

        # Derivative term: change in error
        derivative = error - self.previous_error

        # PID control formula
        action = (self.kp * error) + (self.ki * self.integral) + (self.kd * derivative)

        # Update previous error
        self.previous_error = error



        # Limit the action value: if it's less than 0, set to 0
        # If it's greater than max_vol, set to max_vol
        if action < 0:
            action = 0
        elif action > self.max_vol:
            action = self.max_vol

        return action
       


    