
function [AUC]=AUC_calculation_trapzPosiT2(T_A)

p = [];
for i = 1:length(T_A)
    ptn = T_A(i).initial_ptn;
    p = [p;ptn];
end

pp = unique(p);

AUC = [];
AUC_norm = [];
for i = 1:length(pp)
    Index = find(p == pp(i)) ;
    T_A_ptn = [];
    for k = 1:length(Index)
        T_A_p = T_A(Index(k));
        T_A_ptn = [T_A_ptn;T_A_p];
    end
    
    
    
    for a = 1:length(Index)
        if (string(T_A_ptn(a).condition) == 'Achilles_HermesL0') || (string(T_A_ptn(a).condition) == 'Achilles_HermlesL0')
            if i==7
                angleL0 = [T_A_ptn(a).angle+4 ; T_A_ptn(a).angle_end+4];% +4 correction alignment between conditions
                torqueL0 =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_L0df = T_A_ptn(a).angle+4;
                angle_L0pf = T_A_ptn(a).angle_end+4;
                torque_L0df = T_A_ptn(a).torque;
                torque_L0pf = T_A_ptn(a).torque_end;
                angle_L0_mean = T_A_ptn(a).angleA+4;
                torque_L0_mean = T_A_ptn(a).torqueT;
            elseif i==8
                angleL0 = [T_A_ptn(a).angle+2 ; T_A_ptn(a).angle_end+2];% +2 correction alignment between conditions
                torqueL0 =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_L0df = T_A_ptn(a).angle+2;
                angle_L0pf = T_A_ptn(a).angle_end+2;
                torque_L0df = T_A_ptn(a).torque;
                torque_L0pf = T_A_ptn(a).torque_end;
                angle_L0_mean = T_A_ptn(a).angleA+2;
                torque_L0_mean = T_A_ptn(a).torqueT;
            elseif i==10
                angleL0 = [T_A_ptn(a).angle-10 ; T_A_ptn(a).angle_end-10];% -10 correction alignment between conditions
                torqueL0 =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_L0df = T_A_ptn(a).angle-10;
                angle_L0pf = T_A_ptn(a).angle_end-10;
                torque_L0df = T_A_ptn(a).torque;
                torque_L0pf = T_A_ptn(a).torque_end;
                angle_L0_mean = T_A_ptn(a).angleA-10;
                torque_L0_mean = T_A_ptn(a).torqueT;
            else
                angleL0 = [T_A_ptn(a).angle ; T_A_ptn(a).angle_end];
                torqueL0 =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_L0df = T_A_ptn(a).angle;
                angle_L0pf = T_A_ptn(a).angle_end;
                torque_L0df = T_A_ptn(a).torque;
                torque_L0pf = T_A_ptn(a).torque_end;
                angle_L0_mean = T_A_ptn(a).angleA;
                torque_L0_mean = T_A_ptn(a).torqueT;
            end
            
        end
        % selecteren data Lmax, special case of only when angle is less
        % than 15
        if (string(T_A_ptn(a).condition) == 'Achilles_HermesLmax') || (string(T_A_ptn(a).condition) == 'Achilles_Lmax')
            if i==1
                angle_df_Lmax = T_A_ptn(a).angle(T_A_ptn(a).angle<=15);
                angle_pf_Lmax = T_A_ptn(a).angle_end(T_A_ptn(a).angle_end<=15);
                torque_df_Lmax = T_A_ptn(a).torque(T_A_ptn(a).angle<=15);
                torque_pf_Lmax = T_A_ptn(a).torque_end(T_A_ptn(a).angle_end<=15);
                angle_Lmax = [angle_df_Lmax ; angle_pf_Lmax];
                torque_Lmax =[torque_df_Lmax ; torque_pf_Lmax];
                angle_Lmax_mean = T_A_ptn(a).angleA(T_A_ptn(a).angleA<=15);
                torque_Lmax_mean = T_A_ptn(a).torqueT(T_A_ptn(a).angleA<=15);
                
            elseif i==8
                angle_df_Lmax = T_A_ptn(a).angle+9;
                angle_pf_Lmax = T_A_ptn(a).angle_end+9;
                torque_df_Lmax = T_A_ptn(a).torque;
                torque_pf_Lmax = T_A_ptn(a).torque_end;
                angle_Lmax = [T_A_ptn(a).angle+9 ; T_A_ptn(a).angle_end+9];
                torque_Lmax =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_Lmax_mean = T_A_ptn(a).angleA+9;
                torque_Lmax_mean = T_A_ptn(a).torqueT;
            elseif i==7
                angle_df_Lmax = T_A_ptn(a).angle+4;
                angle_pf_Lmax = T_A_ptn(a).angle_end+4;
                torque_df_Lmax = T_A_ptn(a).torque;
                torque_pf_Lmax = T_A_ptn(a).torque_end;
                angle_Lmax = [T_A_ptn(a).angle+4 ; T_A_ptn(a).angle_end+4];
                torque_Lmax =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_Lmax_mean = T_A_ptn(a).angleA+4;
                torque_Lmax_mean = T_A_ptn(a).torqueT;
            elseif i==8
                angle_df_Lmax = T_A_ptn(a).angle+2;
                angle_pf_Lmax = T_A_ptn(a).angle_end+2;
                torque_df_Lmax = T_A_ptn(a).torque;
                torque_pf_Lmax = T_A_ptn(a).torque_end;
                angle_Lmax = [T_A_ptn(a).angle+2; T_A_ptn(a).angle_end+2];
                torque_Lmax =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_Lmax_mean = T_A_ptn(a).angleA+2;
                torque_Lmax_mean = T_A_ptn(a).torqueT;
            elseif i==10
                angle_df_Lmax = T_A_ptn(a).angle-10;
                angle_pf_Lmax = T_A_ptn(a).angle_end-10;
                torque_df_Lmax = T_A_ptn(a).torque;
                torque_pf_Lmax = T_A_ptn(a).torque_end;
                angle_Lmax = [T_A_ptn(a).angle-10; T_A_ptn(a).angle_end-10];
                torque_Lmax =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_Lmax_mean = T_A_ptn(a).angleA-10;
                torque_Lmax_mean = T_A_ptn(a).torqueT;
            else
                angle_df_Lmax = T_A_ptn(a).angle;
                angle_pf_Lmax = T_A_ptn(a).angle_end;
                torque_df_Lmax = T_A_ptn(a).torque;
                torque_pf_Lmax = T_A_ptn(a).torque_end;
                angle_Lmax = [T_A_ptn(a).angle ; T_A_ptn(a).angle_end];
                torque_Lmax =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_Lmax_mean = T_A_ptn(a).angleA;
                torque_Lmax_mean = T_A_ptn(a).torqueT;
                
            end
            
        end
        
        if (string(T_A_ptn(a).condition) == 'Achilles_NoHermes') || (string(T_A_ptn(a).condition) == 'Achilles_noHermes')
            if i==10
                angle_NHe = [T_A_ptn(a).angle ; T_A_ptn(a).angle_end];
                torque_NHe =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_df_NHe = T_A_ptn(a).angle;
                angle_pf_NHe = T_A_ptn(a).angle_end;
                torque_df_NHe = T_A_ptn(a).torque;
                torque_pf_NHe = T_A_ptn(a).torque_end;
                angle_NHe_mean = T_A_ptn(a).angleA;
                torque_NHe_mean = T_A_ptn(a).torqueT;
            elseif i==7
                angle_NHe = [T_A_ptn(a).angle+2 ; T_A_ptn(a).angle_end+2];
                torque_NHe =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_df_NHe = T_A_ptn(a).angle+2;
                angle_pf_NHe = T_A_ptn(a).angle_end+2;
                torque_df_NHe = T_A_ptn(a).torque;
                torque_pf_NHe = T_A_ptn(a).torque_end;
                angle_NHe_mean = T_A_ptn(a).angleA+2;
                torque_NHe_mean = T_A_ptn(a).torqueT;
            elseif i==8
                angle_NHe = [T_A_ptn(a).angle-2 ; T_A_ptn(a).angle_end-2];
                torque_NHe =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_df_NHe = T_A_ptn(a).angle-2;
                angle_pf_NHe = T_A_ptn(a).angle_end-2;
                torque_df_NHe = T_A_ptn(a).torque;
                torque_pf_NHe = T_A_ptn(a).torque_end;
                angle_NHe_mean = T_A_ptn(a).angleA-2;
                torque_NHe_mean = T_A_ptn(a).torqueT;
            else
                angle_NHe = [T_A_ptn(a).angle ; T_A_ptn(a).angle_end];
                torque_NHe =[T_A_ptn(a).torque ; T_A_ptn(a).torque_end];
                angle_df_NHe = T_A_ptn(a).angle;
                angle_pf_NHe = T_A_ptn(a).angle_end;
                torque_df_NHe = T_A_ptn(a).torque;
                torque_pf_NHe = T_A_ptn(a).torque_end;
                angle_NHe_mean = T_A_ptn(a).angleA;
                torque_NHe_mean = T_A_ptn(a).torqueT;
            end
            
        end
    end
    %% identifying common ROM
    min_max_Angle_L0_Lmax = min([max(angleL0) max(angle_Lmax) max(angle_NHe)]);
    max_min_Angle_L0_Lmax = max([min(angleL0) min(angle_Lmax) min(angle_NHe)]);
    
    row_df_L0 =   find(angle_L0df    <= min_max_Angle_L0_Lmax & angle_L0df    >= max_min_Angle_L0_Lmax);
    row_df_Lmax = find(angle_df_Lmax <= min_max_Angle_L0_Lmax & angle_df_Lmax >= max_min_Angle_L0_Lmax);
    row_df_NHe = find(angle_df_NHe <= min_max_Angle_L0_Lmax & angle_df_NHe >= max_min_Angle_L0_Lmax);
    
    row_pf_L0 =   find((angle_L0pf)    <= min_max_Angle_L0_Lmax & (angle_L0pf)   >=max_min_Angle_L0_Lmax);
    row_pf_Lmax = find((angle_pf_Lmax) <= min_max_Angle_L0_Lmax & (angle_pf_Lmax)>=max_min_Angle_L0_Lmax);
    row_pf_NHe = find((angle_pf_NHe) <= min_max_Angle_L0_Lmax & (angle_pf_NHe)>=max_min_Angle_L0_Lmax);
    
    
    
    %% Calculate average curves
    if numel(row_df_L0) > numel(row_pf_L0)
        meanA_L0=mean([angle_L0df(row_df_L0(1:numel(row_pf_L0))) flip(angle_L0pf(row_pf_L0))],2);
        meanT_L0=mean([torque_L0df(row_df_L0(1:numel(row_pf_L0))) flip(torque_L0pf(row_pf_L0))],2);
    elseif numel(row_df_L0) < numel(row_pf_L0)
        meanA_L0=mean([angle_L0df(row_df_L0) flip(angle_L0pf(row_pf_L0(1:numel(row_df_L0))))],2);
        meanT_L0=mean([torque_L0df(row_df_L0) flip(torque_L0pf(row_pf_L0(1:numel(row_df_L0))))],2);
    else
        meanA_L0=mean([angle_L0df(row_df_L0) flip(angle_L0pf(row_pf_L0))],2);
        meanT_L0=mean([torque_L0df(row_df_L0) flip(torque_L0pf(row_pf_L0))],2);
    end
    
    if numel(row_df_Lmax) > numel(row_pf_Lmax)
        meanA_Lmax=mean([angle_df_Lmax(row_df_Lmax(1:numel(row_pf_Lmax))) flip(angle_pf_Lmax(row_pf_Lmax))],2);
        meanT_Lmax=mean([torque_df_Lmax(row_df_Lmax(1:numel(row_pf_Lmax))) flip(torque_pf_Lmax(row_pf_Lmax))],2);
    elseif numel(row_df_Lmax) < numel(row_pf_Lmax)
        meanA_Lmax=mean([angle_df_Lmax(row_df_Lmax) flip(angle_pf_Lmax(row_pf_Lmax(1:numel(row_df_Lmax))))],2);
        meanT_Lmax=mean([torque_df_Lmax(row_df_Lmax) flip(torque_pf_Lmax(row_pf_Lmax(1:numel(row_df_Lmax))))],2);
    else
        meanA_Lmax=mean([angle_df_Lmax(row_df_Lmax) flip(angle_pf_Lmax(row_pf_Lmax))],2);
        meanT_Lmax=mean([torque_df_Lmax(row_df_Lmax) flip(torque_pf_Lmax(row_pf_Lmax))],2);
    end
    if numel(row_df_NHe) > numel(row_pf_NHe)
        meanA_NHe=mean([angle_df_NHe(row_df_NHe(1:numel(row_pf_NHe))) flip(angle_pf_NHe(row_pf_NHe))],2);
        meanT_NHe=mean([torque_df_NHe(row_df_NHe(1:numel(row_pf_NHe))) flip(torque_pf_NHe(row_pf_NHe))],2);
    elseif numel(row_df_NHe) < numel(row_pf_NHe)
        meanA_NHe=mean([angle_df_NHe(row_df_NHe) flip(angle_pf_NHe(row_pf_NHe(1:numel(row_df_NHe))))],2);
        meanT_NHe=mean([torque_df_NHe(row_df_NHe) flip(torque_pf_NHe(row_pf_NHe(1:numel(row_df_NHe))))],2);
    else
        meanA_NHe=mean([angle_df_NHe(row_df_NHe) flip(angle_pf_NHe(row_pf_NHe))],2);
        meanT_NHe=mean([torque_df_NHe(row_df_NHe) flip(torque_pf_NHe(row_pf_NHe))],2);
    end
    
    
    
    %% positive work under the curves  
    sROM=1; 
    refang=10;
    if sROM==1
        
        post_L0_mean=find(meanT_L0>=0 );
        post_Lmax_mean=find(meanT_Lmax>=0 );
        post_NHe_mean=find(meanT_NHe>=0 );
        
        post_L0_df=find(torque_L0df>=0 & angle_L0df <= min_max_Angle_L0_Lmax);
        post_Lmax_df=find(torque_df_Lmax>=0 & angle_df_Lmax <= min_max_Angle_L0_Lmax);
        post_NHe_df=find(torque_df_NHe>=0 & angle_df_NHe <= min_max_Angle_L0_Lmax);
        
        post_L0_pf=find((torque_L0pf)>=0  & angle_L0pf <= min_max_Angle_L0_Lmax);
        post_Lmax_pf=find((torque_pf_Lmax)>=0  & angle_pf_Lmax <= min_max_Angle_L0_Lmax);
        post_NHe_pf=find((torque_pf_NHe)>=0  & angle_pf_NHe <= min_max_Angle_L0_Lmax);
        
        deg10_L0_mean=find(meanA_L0>=refang & meanA_L0 <= refang+.01,1,'last');
        deg10_Lmax_mean=find(meanA_Lmax>=refang & meanA_Lmax <= refang+.01,1,'last');
        deg10_NHe_mean=find(meanA_NHe>=refang & meanA_NHe <= refang+.01,1,'last');
        
        deg10_L0_df=find(angle_L0df>=refang & angle_L0df <= refang+.01,1,'last');
        deg10_Lmax_df=find(angle_df_Lmax>=refang & angle_df_Lmax <= refang+.01,1,'last');
        deg10_NHe_df=find(angle_df_NHe>=refang & angle_df_NHe <= refang+.01,1,'last');
        
        deg10_L0_pf=find((angle_L0pf)>=refang  & angle_L0pf <= refang+.01,1,'last');
        deg10_Lmax_pf=find((angle_pf_Lmax)>=refang  & angle_pf_Lmax <= refang+.01,1,'last');
        deg10_NHe_pf=find((angle_pf_NHe)>=refang  & angle_pf_NHe <= refang+.01,1,'last');
        
    else
        post_L0_mean=find(meanT_L0>=0);
        post_Lmax_mean=find(meanT_Lmax>=0);
        post_NHe_mean=find(meanT_NHe>=0);
        
        post_L0_df=find(torque_L0df>=0);
        post_Lmax_df=find(torque_df_Lmax>=0);
        post_NHe_df=find(torque_df_NHe>=0);
        
        post_L0_pf=find((torque_L0pf)>=0);
        post_Lmax_pf=find((torque_pf_Lmax)>=0);
        post_NHe_pf=find((torque_pf_NHe)>=0);
    end
    
    AUC.posiT.L0_mean(i)= trapz(meanA_L0(post_L0_mean),meanT_L0(post_L0_mean));%
    AUC.posiT.L0_df(i)= trapz(angle_L0df(post_L0_df),torque_L0df(post_L0_df));%
    AUC.posiT.L0_pf(i)= -trapz((angle_L0pf(post_L0_pf)),(torque_L0pf(post_L0_pf)));%
    
    AUC.posiT.Lmax_mean(i)= trapz(meanA_Lmax(post_Lmax_mean),meanT_Lmax(post_Lmax_mean));%
    AUC.posiT.Lmax_df(i)= trapz(angle_df_Lmax(post_Lmax_df),torque_df_Lmax(post_Lmax_df));%
    AUC.posiT.Lmax_pf(i)= -trapz((angle_pf_Lmax(post_Lmax_pf)),(torque_pf_Lmax(post_Lmax_pf)));%
    
    AUC.posiT.NHe_mean(i)= trapz(meanA_NHe(post_NHe_mean),meanT_NHe(post_NHe_mean));%
    AUC.posiT.NHe_df(i)= trapz(angle_df_NHe(post_NHe_df),torque_df_NHe(post_NHe_df));%
    AUC.posiT.NHe_pf(i)= -trapz((angle_pf_NHe(post_NHe_pf)),(torque_pf_NHe(post_NHe_pf)));%
    
    %% Energy compensation
    AUC.posiT.EC_mean_NHe = (AUC.posiT.NHe_mean-AUC.posiT.Lmax_mean)*100./AUC.posiT.NHe_mean;
    AUC.posiT.EC_mean_L0 =  (AUC.posiT.L0_mean -AUC.posiT.Lmax_mean)*100./AUC.posiT.L0_mean;
    AUC.posiT.EC_df_NHe =   (AUC.posiT.NHe_df  -AUC.posiT.Lmax_df)*100./AUC.posiT.NHe_df;
    AUC.posiT.EC_df_L0 =    (AUC.posiT.L0_df   -AUC.posiT.Lmax_df)*100./AUC.posiT.L0_df;
    AUC.posiT.EC_pf_NHe =   (AUC.posiT.NHe_pf  -AUC.posiT.Lmax_pf)*100./AUC.posiT.NHe_pf;
    AUC.posiT.EC_pf_L0 =    (AUC.posiT.L0_pf   -AUC.posiT.Lmax_pf)*100./AUC.posiT.L0_pf;
    
    %% TORQUES FOR COMPARISON
    ZeroA_L0_mean=find(meanA_L0>=0,1,'first');
    ZeroA_L0_df=find(angle_L0df>=0,1,'first');
    ZeroA_L0_pf=find((angle_L0pf)>=0,1,'last');
    
    ZeroA_Lmax_mean=find(meanA_Lmax>=0,1,'first');
    ZeroA_Lmax_df=find(angle_df_Lmax>=0,1,'first');
    ZeroA_Lmax_pf=find(angle_pf_Lmax>=0,1,'last');
    
    ZeroA_NHe_mean=find(meanA_NHe>=0,1,'first');
    ZeroA_NHe_df=find(angle_df_NHe>=0,1,'first');
    ZeroA_NHe_pf=find((angle_pf_NHe)>=0,1,'last');
    
    
    if (~isempty(ZeroA_L0_mean) && ~isempty(deg10_L0_mean))
        AUC.T.L0_mean(i,1:3)= [meanT_L0(ZeroA_L0_mean(1)) meanT_L0(deg10_L0_mean) meanT_L0((end))];
        AUC.T.L0_df(i,1:3)= [torque_L0df(ZeroA_L0_df(1)) torque_L0df(deg10_L0_df) torque_L0df(row_df_L0(end))];
        AUC.T.L0_pf(i,1:3)= [torque_L0pf(ZeroA_L0_pf(1)) torque_L0pf(deg10_L0_pf) torque_L0pf(row_pf_L0(1))];
        
        AUC.T.Lmax_mean(i,1:3)= [meanT_Lmax(ZeroA_Lmax_mean(1)) meanT_Lmax(deg10_Lmax_mean) meanT_Lmax((end))];%
        AUC.T.Lmax_df(i,1:3)= [torque_df_Lmax(ZeroA_Lmax_df(1)) torque_df_Lmax(deg10_Lmax_df) torque_df_Lmax(row_df_Lmax(end))];%
        AUC.T.Lmax_pf(i,1:3)= [torque_pf_Lmax(ZeroA_Lmax_pf(1)) torque_pf_Lmax(deg10_Lmax_pf) torque_pf_Lmax(row_pf_Lmax(1))];%
        
        AUC.T.NHe_mean(i,1:3)= [meanT_NHe(ZeroA_NHe_mean(1)) meanT_NHe(deg10_NHe_mean) meanT_NHe((end))];%
        AUC.T.NHe_df(i,1:3)= [torque_df_NHe(ZeroA_NHe_df(1)) torque_df_NHe(deg10_NHe_df) torque_df_NHe(row_df_NHe(end))];%
        AUC.T.NHe_pf(i,1:3)= [torque_pf_NHe(ZeroA_NHe_pf(1)) torque_pf_NHe(deg10_NHe_pf) torque_pf_NHe(row_pf_NHe(1)) ];%
    elseif (isempty(ZeroA_L0_mean) && isempty(deg10_L0_mean))
        AUC.T.L0_mean(i,1:3)= [nan nan meanT_L0((end))];
        AUC.T.L0_df(i,1:3)= [nan nan torque_L0df(row_df_L0(end))];
        AUC.T.L0_pf(i,1:3)= [nan nan torque_L0pf(row_pf_L0(1))];
        
        AUC.T.Lmax_mean(i,1:3)= [nan nan meanT_Lmax((end))];%
        AUC.T.Lmax_df(i,1:3)= [nan nan torque_df_Lmax(row_df_Lmax(end))];%
        AUC.T.Lmax_pf(i,1:3)= [nan nan torque_pf_Lmax(row_pf_Lmax(1))];%
        
        AUC.T.NHe_mean(i,1:3)= [nan nan meanT_NHe((end))];%
        AUC.T.NHe_df(i,1:3)= [nan nan torque_df_NHe(row_df_NHe(end))];%
        AUC.T.NHe_pf(i,1:3)= [nan nan torque_pf_NHe(row_pf_NHe(1)) ];%
        
        
    elseif (isempty(ZeroA_L0_mean)) && ~isempty(deg10_L0_mean)
        AUC.T.L0_mean(i,1:3)= [nan meanT_L0(deg10_L0_mean) meanT_L0((end))];
        AUC.T.L0_df(i,1:3)= [nan torque_L0df(deg10_L0_df) torque_L0df(row_df_L0(end))];
        AUC.T.L0_pf(i,1:3)= [nan torque_L0pf(deg10_L0_pf) torque_L0pf(row_pf_L0(1))];
        
        AUC.T.Lmax_mean(i,1:3)= [nan meanT_Lmax(deg10_Lmax_mean) meanT_Lmax((end))];%
        AUC.T.Lmax_df(i,1:3)= [nan torque_df_Lmax(deg10_Lmax_df) torque_df_Lmax(row_df_Lmax(end))];%
        AUC.T.Lmax_pf(i,1:3)= [nan torque_pf_Lmax(deg10_Lmax_pf) torque_pf_Lmax(row_pf_Lmax(1))];%
        
        AUC.T.NHe_mean(i,1:3)= [nan meanT_NHe(deg10_NHe_mean) meanT_NHe((end))];%
        AUC.T.NHe_df(i,1:3)= [nan torque_df_NHe(deg10_NHe_df) torque_df_NHe(row_df_NHe(end))];%
        AUC.T.NHe_pf(i,1:3)= [nan torque_pf_NHe(deg10_NHe_pf) torque_pf_NHe(row_pf_NHe(1)) ];%
        
    elseif (~isempty(ZeroA_L0_mean)) && isempty(deg10_L0_mean)
        
        AUC.T.L0_mean(i,1:3)= [meanT_L0(ZeroA_L0_mean(1)) nan meanT_L0((end))];
        AUC.T.L0_df(i,1:3)= [torque_L0df(ZeroA_L0_df(1)) nan torque_L0df(row_df_L0(end))];
        AUC.T.L0_pf(i,1:3)= [torque_L0pf(ZeroA_L0_pf(1)) nan torque_L0pf(row_pf_L0(1))];
        
        AUC.T.Lmax_mean(i,1:3)= [meanT_Lmax(ZeroA_Lmax_mean(1)) nan meanT_Lmax((end))];%
        AUC.T.Lmax_df(i,1:3)= [torque_df_Lmax(ZeroA_Lmax_df(1)) nan torque_df_Lmax(row_df_Lmax(end))];%
        AUC.T.Lmax_pf(i,1:3)= [torque_pf_Lmax(ZeroA_Lmax_pf(1)) nan torque_pf_Lmax(row_pf_Lmax(1))];%
        
        AUC.T.NHe_mean(i,1:3)= [meanT_NHe(ZeroA_NHe_mean(1)) nan meanT_NHe((end))];%
        AUC.T.NHe_df(i,1:3)= [torque_df_NHe(ZeroA_NHe_df(1)) nan torque_df_NHe(row_df_NHe(end))];%
        AUC.T.NHe_pf(i,1:3)= [torque_pf_NHe(ZeroA_NHe_pf(1)) nan torque_pf_NHe(row_pf_NHe(1)) ];%
    end
    
    YLIM=[-10 20];
    XLIM=[max_min_Angle_L0_Lmax-1 min_max_Angle_L0_Lmax];
    
      
    %%
    if i==5
        colorlines=[0 0 0];
        
        ff=figure('Position', [0.1    0.5    859    280])
        tiledlayout(1,3, 'Padding', 'none', 'TileSpacing', 'compact');
        
        nexttile(1)
        xline(min_max_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);hold on
        b3=xline(max_min_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);
        xline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        yline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        xline(10,':','color',[0.2 0.2 0.2],'linewidth',0.5);
        
        aaa=area(angle_df_NHe(post_NHe_df),torque_df_NHe(post_NHe_df));
        aaa.FaceColor = [0.9 0.9 0.9];
        aaa.FaceAlpha=.3;
        aaa.LineStyle='none';
        
        b1=plot(angle_df_NHe(),torque_df_NHe(),'color',colorlines,'linewidth',1); hold on
        b2=plot(meanA_NHe(),meanT_NHe(),'-.','color',colorlines,'linewidth',1); hold on
        plot((angle_pf_NHe()),(torque_pf_NHe()),'color',colorlines,'linewidth',1); hold on
        
         plot(angle_df_NHe(row_df_NHe(end)),torque_df_NHe(row_df_NHe(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        if ~isempty(ZeroA_NHe_df)
             plot(angle_df_NHe(ZeroA_NHe_df(end)),torque_df_NHe(ZeroA_NHe_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        if ~isempty(deg10_NHe_df)
             plot(angle_df_NHe(deg10_NHe_df(end)),torque_df_NHe(deg10_NHe_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        ylabel('Torque (Nm)');
        xlabel('Angle (deg)');
        ylim(YLIM);%xlim(XLIM);
        grid off
        box off
        title(['Patient ' num2str(i) ' - A'])
        legend([b1 b2 b3],{'DF and PF movement','Average of DF and PF movement','Common ROM'})
        
        
        nexttile(2)
        xline(min_max_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);hold on
        xline(max_min_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);
        xline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        yline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        xline(10,':','color',[0.2 0.2 0.2],'linewidth',0.5);
         aaa=area(angle_L0df(post_L0_df),torque_L0df(post_L0_df));
        aaa.FaceColor = [0.8 0.8 0.8];
        aaa.FaceAlpha=.3;
        aaa.LineStyle='none';
        
        plot(smooth(angle_L0df()),smooth(torque_L0df(),200),'color',colorlines,'linewidth',1);%
        plot(meanA_L0(),meanT_L0(),'-.','color',colorlines,'linewidth',1);%
        plot(angle_L0pf(),torque_L0pf(),'color',colorlines,'linewidth',1);%
        
         plot(angle_L0df(row_df_L0(end)),torque_L0df(row_df_L0(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        
        if ~isempty(ZeroA_NHe_df)
             plot(angle_L0df(ZeroA_L0_df(end)),torque_L0df(ZeroA_L0_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        if ~isempty(deg10_L0_mean)
            
             plot(angle_L0df(deg10_L0_df(end)),torque_L0df(deg10_L0_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        ylim(YLIM);%xlim(XLIM);     grid off
        title('A+H_{0%}');
        xlabel('Angle (deg)');
        set(gca,'YTickLabel',[]);
        box off
        
        nexttile(3)
        xline(min_max_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);hold on
        xline(max_min_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);
        xline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        yline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        xline(10,':','color',[0.2 0.2 0.2],'linewidth',0.5);
        
        aaa=area(angle_df_Lmax(post_Lmax_df),torque_df_Lmax(post_Lmax_df));
        aaa.FaceColor = [0.8 0.8 0.8];
        aaa.FaceAlpha=.3;
        aaa.LineStyle='none';
        
        plot(angle_df_Lmax(),torque_df_Lmax(),'color',colorlines,'linewidth',1);%
        plot(meanA_Lmax(),meanT_Lmax(),'-.','color',colorlines,'linewidth',1);%
        plot(angle_pf_Lmax(),torque_pf_Lmax(),'color',colorlines,'linewidth',1);%
        
         plot(angle_df_Lmax(row_df_Lmax(end)),torque_df_Lmax(row_df_Lmax(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        if ~isempty(ZeroA_NHe_df)
            
             plot(angle_df_Lmax(ZeroA_Lmax_df(end)),torque_df_Lmax(ZeroA_Lmax_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        if ~isempty(deg10_NHe_df)
            
             plot(angle_df_Lmax(deg10_Lmax_df(end)),torque_df_Lmax(deg10_Lmax_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        ylim(YLIM);
        title('A+H_{100%}');
        set(gca,'YTickLabel',[]);
        xlabel('Angle (deg)');
        box off
   end
    
   if i~=5
        colorlines=[0 0 0];
        
        ff=figure('Position', [0.1    0.5    859    280]);
        tiledlayout(1,3, 'Padding', 'none', 'TileSpacing', 'compact');
        
        nexttile(1)
        xline(min_max_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);hold on
        b3=xline(max_min_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);
        xline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        yline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        xline(10,':','color',[0.2 0.2 0.2],'linewidth',0.5);
        
        aaa=area(angle_df_NHe(post_NHe_df),torque_df_NHe(post_NHe_df));
        aaa.FaceColor = [0.8 0.8 0.8];
        aaa.FaceAlpha=.3;
        aaa.LineStyle='none';
        
        b1=plot(angle_df_NHe(),torque_df_NHe(),'color',colorlines,'linewidth',1); hold on
        b2=plot(meanA_NHe(),meanT_NHe(),'-.','color',colorlines,'linewidth',1); hold on
        plot((angle_pf_NHe()),(torque_pf_NHe()),'color',colorlines,'linewidth',1); hold on
        
         plot(angle_df_NHe(row_df_NHe(end)),torque_df_NHe(row_df_NHe(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        if ~isempty(ZeroA_NHe_df)
             plot(angle_df_NHe(ZeroA_NHe_df(end)),torque_df_NHe(ZeroA_NHe_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        if ~isempty(deg10_NHe_df)
             plot(angle_df_NHe(deg10_NHe_df(end)),torque_df_NHe(deg10_NHe_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        ylabel('Torque (Nm)');
        xlabel('Angle (deg)');
        ylim(YLIM);
        if i~=11
            xlim(XLIM);
        end
        grid off
        box off
        title(['Patient ' num2str(i) ' - A'])
        legend([b1 b2 b3],{'DF and PF movement','Average of DF and PF movement','Common ROM'})
       
        
        nexttile(2)
        xline(min_max_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);hold on
        xline(max_min_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);
        xline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        yline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        xline(10,':','color',[0.2 0.2 0.2],'linewidth',0.5);
        aaa=area(angle_L0df(post_L0_df),torque_L0df(post_L0_df));
        aaa.FaceColor = [0.8 0.8 0.8];
        aaa.FaceAlpha=.3;
        aaa.LineStyle='none';
        
        plot(smooth(angle_L0df()),smooth(torque_L0df(),200),'color',colorlines,'linewidth',1);%
        plot(meanA_L0(),meanT_L0(),'-.','color',colorlines,'linewidth',1);%
        plot(angle_L0pf(),torque_L0pf(),'color',colorlines,'linewidth',1);%
        
         plot(angle_L0df(row_df_L0(end)),torque_L0df(row_df_L0(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        
        if ~isempty(ZeroA_NHe_df)
             plot(angle_L0df(ZeroA_L0_df(end)),torque_L0df(ZeroA_L0_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        if ~isempty(deg10_L0_df)
            
             plot(angle_L0df(deg10_L0_df(end)),torque_L0df(deg10_L0_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        ylim(YLIM);
        if i~=11
            xlim(XLIM);
        end
        grid off
        title('A+H_{0%}');
        xlabel('Angle (deg)');
        set(gca,'YTickLabel',[]);
        box off
        
        nexttile(3)
        xline(min_max_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);hold on
        xline(max_min_Angle_L0_Lmax,'--','color',colorlines,'linewidth',1);
        xline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        yline(0,'-','color',[0.2 0.2 0.2],'linewidth',0.5);
        xline(10,':','color',[0.2 0.2 0.2],'linewidth',0.5);
        
        aaa=area(angle_df_Lmax(post_Lmax_df),torque_df_Lmax(post_Lmax_df));
        aaa.FaceColor = [0.8 0.8 0.8];
        aaa.FaceAlpha=.3;
        aaa.LineStyle='none';
        
        plot(angle_df_Lmax(),torque_df_Lmax(),'color',colorlines,'linewidth',1);%
        plot(meanA_Lmax(),meanT_Lmax(),'-.','color',colorlines,'linewidth',1);%
        plot(angle_pf_Lmax(),torque_pf_Lmax(),'color',colorlines,'linewidth',1);%
        
         plot(angle_df_Lmax(row_df_Lmax(end)),torque_df_Lmax(row_df_Lmax(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        if ~isempty(ZeroA_NHe_df)
            
             plot(angle_df_Lmax(ZeroA_Lmax_df(end)),torque_df_Lmax(ZeroA_Lmax_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        if ~isempty(deg10_L0_df)
            
             plot(angle_df_Lmax(deg10_Lmax_df(end)),torque_df_Lmax(deg10_Lmax_df(end)),'-ok','MarkerFaceColor','k','MarkerSize',4)
        end
        ylim(YLIM);
        if i~=11
            xlim(XLIM);
        end
        grid off
        title('A+H_{100%}');
        set(gca,'YTickLabel',[]);
        xlabel('Angle (deg)');
        box off
   end
   exportgraphics(ff, ['Patient ' num2str(i) '.pdf'], 'ContentType', 'Vector')
    
end