//HEAD_DSCODES
/*
 <DUALSPHYSICS>  Copyright (c) 2020 by Dr Jose M. Dominguez et al. (see http://dual.sphysics.org/index.php/developers/). 

 EPHYSLAB Environmental Physics Laboratory, Universidade de Vigo, Ourense, Spain.
 School of Mechanical, Aerospace and Civil Engineering, University of Manchester, Manchester, U.K.

 This file is part of DualSPHysics. 

 DualSPHysics is free software: you can redistribute it and/or modify it under the terms of the GNU Lesser General Public License 
 as published by the Free Software Foundation; either version 2.1 of the License, or (at your option) any later version.
 
 DualSPHysics is distributed in the hope that it will be useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Lesser General Public License for more details. 

 You should have received a copy of the GNU Lesser General Public License along with DualSPHysics. If not, see <http://www.gnu.org/licenses/>. 
*/

//:#############################################################################
//:# Cambios:
//:# =========
//:# - Gestiona lista de archivos VTK con geometria generados por GenCase. (30-07-2018)
//:# - Nuevo metodo para obtener la lista de ficheros con una clave. (06-08-2018)
//:# - Nuevo metodo para obtener el fichero segun su posicion. (01-05-2019)
//:# - Nuevos metodos GetFileListMk() y GetListMkType(). (09-03-2020)
//:# - Cambio de nombre de J.SpaceVtkOut a J.CaseVtkOut. (28-06-2020)
//:#############################################################################

/// \file JCaseVtkOut.h \brief Declares the class \ref JCaseVtkOut.

#ifndef _JCaseVtkOut_
#define _JCaseVtkOut_

#include "JObject.h"
#include "TypesDef.h"
#include <vector>

class JXml;
class TiXmlElement;

//##############################################################################
//# JCaseVtkOutFile
//##############################################################################
/// \brief Manages the information of one VTK file.

class JCaseVtkOutFile
{
protected:
  std::string ListMk;
public:
  const std::string File;

  JCaseVtkOutFile(const std::string &file,const std::string &mks);
  ~JCaseVtkOutFile();
  void Reset();

  void SetMks(const std::string &mks);
  std::string GetMks()const{ return(ListMk); }
};


//##############################################################################
//# JCaseVtkOut
//##############################################################################
/// \brief Manages the information of output VTK files generated by GenCase.

class JCaseVtkOut : protected JObject
{
private:
  word MkBoundFirst;
  word MkFluidFirst;

  std::vector<JCaseVtkOutFile*> Files;

  void ReadXml(const JXml *sxml,TiXmlElement* lis);
  void WriteXml(JXml *sxml,TiXmlElement* lis)const;

public:
  JCaseVtkOut();
  ~JCaseVtkOut();
  void Reset();

  void ConfigMkFirst(word mkboundfirst,word mkfluidfirst);
  void AddFile(const std::string &fname,const std::string &mks);

  unsigned Count()const{ return(unsigned(Files.size())); }
  unsigned GetByFileName(std::string fname)const;

  std::string GetFile(unsigned idx)const;
  std::string GetFileListMk(unsigned idx)const;

  unsigned GetFiles(std::string key,std::vector<std::string> &list)const;
  unsigned GetFilesByMk(bool bound,word mk,std::vector<std::string> &list)const;

  std::string GetListMkType(bool bound,const std::string &mks)const;

  void LoadFileXml(const std::string &file,const std::string &path);

  void LoadXml(const JXml *sxml,const std::string &place,bool optional);
  void SaveXml(JXml *sxml,const std::string &place)const;
};

#endif

