# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue (in this repository), [email](mailto:dualsphysics@gmail.com), or any other method with the owners of this repository before making a change. 

## Commits

Please try to write the commits in english, stating the change that it makes, and with an extended description if necessary. To optimize comprehension and make reading them easier, follow a [style guide of commiting like this one](https://chris.beams.io/posts/git-commit/)

## For external developers: Pull Request Process

1. Ensure all of the code works, specially the cases not related to the new features, using the example cases included with the main DualSPHysics package.
2. Make sure all the new files included have a valid license comment
3. Include Doxygen documentation in each one of the classes created including relevant information to understand it.
4. Open a Pull Request or contact [Dr Jose M. Dominguez](mailto:jmdalonso@gmail.com) via email to agree on including the new features or the changes.

## For internal developers: Contributions and documentation

If you incorporate something to the code that changes the way DualSPHysics works or how it is managed (e.g new command line options, new options for the XML parsing, new features in general) please don't forget to add them to [the wiki](https://github.com/DualSPHysics/DualSPHysics/wiki) so the documentation would always be updated.