# Transfer Matrix Method (TMM) Data Repository

This repository contains simulated optical response data generated using the **Transfer Matrix Method (TMM)**. Each CSV file encodes key simulation parameters in its filename to ensure clarity, reproducibility, and ease of parsing for automated tools.

---

##  Filename Convention

```
TMM<YYYYMMDD>_<scanType>[_phi<angle>]_Pol_<polarization>_<spacerConfig>[_<materialStack>].csv
```

### Example Filenames

- `TMM20250608_thetaphi_Pol_P_eso1_ese1pt6_d6pt39.csv`
- `TMM20250608_thetalambda_phi0_Pol_SP_emitSiC_spacCaCO3_reflGold.csv`

---

##  Components Explained

| Component        | Description                                                                 |
|------------------|-----------------------------------------------------------------------------|
| `TMM`            | Simulation method: Transfer Matrix Method                                   |
| `YYYYMMDD`       | Date the simulation was run (e.g. `20250608` for June 8, 2025)              |
| `thetaphi`       | Scanned parameters: zenith (θ) and azimuth (φ) angles                       |
| `thetalambda`    | Scanned parameters: zenith angle (θ) and wavelength                         |
| `phi0`, `phi90`  | Constant azimuth angle (0° or 90°) used during θ–λ sweeps                   |
| `Pol_S/P/SP`     | Polarization state: `S`, `P`, or both (average, `SP`)                       |
| `esoX`           | Ordinary permittivity of the spacer (e.g. `eso1pt3` → εₒ = 1.3)              |
| `eseY`           | Extraordinary permittivity of the spacer (e.g. `ese4pt5` → εₑ = 4.5)         |
| `dZ`             | Spacer thickness in micrometers (e.g. `d6pt39` → 6.39 µm)                    |
| `emit<Material>` | Emitter material (e.g. `emitSiC`)                                            |
| `spac<Material>` | Spacer material (e.g. `spacCaCO3`)                                           |
| `refl<Material>` | Reflector material (e.g. `reflGold`)                                         |

> **Note on Decimal Points:** Decimal values are encoded as `pt`, e.g., `1pt6` = 1.6.

---

## File Contents

Each CSV file contains the absorption as a function of the scanned parameters.
zenith angle (θ) is always from 0 to 90 degrees with 0.5 degree step size.
azimuth angle (φ) is always from 0 to 360 degrees with 1 degree step size.
For the ideal materials lambda is always from 11 to 14 micrometers with 0.02 micrometer step size.
For the real material stacks, lambda is always from 12 to 15 micrometers with 0.01 micrometer step size.

---

## 🧱 Material Stacks

Some filenames include material information when simulations include specific emitter/spacer/reflector combinations:

- **emitSiC** – Emitter: Silicon Carbide  
- **spacCaCO3** – Spacer: Calcite (CaCO₃)  
- **reflGold** – Reflector: Gold

---

## 📚 Usage

You can filter or sort files based on:
- `Pol` to compare polarization effects
- `thetaphi` vs `thetalambda` to distinguish angular vs spectral scans
- Permittivity (`eso`, `ese`) and thickness (`d`) to study spacer effects
- Material stack keywords for multilayer analysis

---

## 📫 Contact

For questions or collaboration:

**Jelle Westerhof**  
University of Twente 
j.westerhof@utwente.nl
