(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.2' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    189049,       3952]
NotebookOptionsPosition[    188064,       3916]
NotebookOutlinePosition[    188419,       3932]
CellTagsIndexPosition[    188376,       3929]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"ClearAll", "[", "\"\<`*\>\"", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.6536316030268517`*^9, 3.65363161324973*^9}, {
  3.6536316531286592`*^9, 3.653631665144311*^9}, {3.6537160687612534`*^9, 
  3.653716070458041*^9}, {3.654494622203741*^9, 3.6544946231578207`*^9}, {
  3.655038314003243*^9, 3.655038317171796*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"*", " ", "Import", " ", "the", " ", "raw", " ", 
    RowBox[{"data", ".", " ", "Data"}], " ", "in", " ", "T_cooling", " ", 
    "and", " ", "Dinf_cooling", " ", "is", " ", "better", " ", "than", " ", 
    "the", " ", "heating", " ", "version"}], " ", "**)"}], 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataSO3Heating", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\</Users/Ke/Dropbox/MyData/task56/SO3_heating_L16_Jeff.data\>\"", 
       ",", "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataIHeating", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\</Users/Ke/Dropbox/MyData/task56/I_heating_L16_Jeff.data\>\"", ",", 
       "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataOHeating", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\</Users/Ke/Dropbox/MyData/task56/O_heating_L16_Jeff.data\>\"", ",", 
       "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataTHeating", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\</Users/Ke/Dropbox/MyData/task56/T_heating_L16_Jeff.data\>\"", ",", 
       "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataTCooling", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\</Users/Ke/Dropbox/MyData/task56/T_cooling_L16_Jeff.data\>\"", ",", 
       "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataDinfCooling", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\</Users/Ke/Dropbox/MyData/task56/Dinf_cooling_L16_Jeff.data\>\"", 
       ",", "\"\<Table\>\""}], "]"}]}], ";"}], " ", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataD2Heating", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\</Users/Ke/Dropbox/MyData/task56/D2_heating_L16_Jeff.data\>\"", 
       ",", "\"\<Table\>\""}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"dataD2Cooling", "=", 
     RowBox[{"Import", "[", 
      RowBox[{
      "\"\</Users/Ke/Dropbox/MyData/task56/D2_cooling_L16_Jeff.data\>\"", 
       ",", "\"\<Table\>\""}], "]"}]}], ";"}]}]}]], "Input",
 CellChangeTimes->{{3.656585659323928*^9, 3.656585862869082*^9}, {
  3.6565859305928507`*^9, 3.6565859342486687`*^9}, {3.656586644897711*^9, 
  3.656586700390998*^9}, {3.656586785937003*^9, 3.6565867862615023`*^9}, {
  3.656586888612349*^9, 3.656586897175117*^9}, {3.656591237187668*^9, 
  3.65659125304214*^9}, {3.656591297115139*^9, 3.656591298526576*^9}, {
  3.656592348809392*^9, 3.6565923606616907`*^9}, {3.656592472707342*^9, 
  3.656592485978805*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
   "*", " ", "inverse", " ", "the", " ", "temperature", " ", "and", " ", 
    "nomalized", " ", "Jeff", " ", "to", " ", "1"}], "**)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SO3Heating", " ", "=", " ", "dataSO3Heating"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SO3Heating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1", "/", 
      RowBox[{"dataSO3Heating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"SO3Heating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"dataSO3Heating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"IHeating", " ", "=", " ", "dataIHeating"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IHeating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1", "/", 
      RowBox[{"dataIHeating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"IHeating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"dataIHeating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"OHeating", " ", "=", " ", "dataOHeating"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OHeating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1", "/", 
      RowBox[{"dataOHeating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"OHeating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"dataOHeating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"THeating", " ", "=", " ", "dataTHeating"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"THeating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1", "/", 
      RowBox[{"dataTHeating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"THeating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"dataTHeating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TCooling", " ", "=", " ", "dataTCooling"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TCooling", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1", "/", 
      RowBox[{"dataTCooling", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"TCooling", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"dataTCooling", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"DinfCooling", " ", "=", " ", "dataDinfCooling"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DinfCooling", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1", "/", 
      RowBox[{"dataDinfCooling", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"DinfCooling", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"dataDinfCooling", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D2Heating", " ", "=", " ", "dataD2Heating"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"D2Heating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1", "/", 
      RowBox[{"dataD2Heating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"D2Heating", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"dataD2Heating", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "3"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"D2Cooling", " ", "=", " ", "dataD2Cooling"}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"D2Cooling", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "1"}], "]"}], "]"}], "=", 
     RowBox[{"1", "/", 
      RowBox[{"dataD2Cooling", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "1"}], "]"}], "]"}]}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"D2Cooling", "[", 
      RowBox[{"[", 
       RowBox[{"All", ",", "2"}], "]"}], "]"}], " ", "=", " ", 
     RowBox[{
      RowBox[{"dataD2Cooling", "[", 
       RowBox[{"[", 
        RowBox[{"All", ",", "2"}], "]"}], "]"}], "/", "3"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.654406751649404*^9, 3.654406762755425*^9}, {
   3.654494636317719*^9, 3.654494638643774*^9}, {3.6565859415261307`*^9, 
   3.656585973245132*^9}, {3.656586028728964*^9, 3.656586048154522*^9}, {
   3.6565861224015017`*^9, 3.6565861866656647`*^9}, {3.656586268260991*^9, 
   3.6565862850619373`*^9}, {3.656586325174879*^9, 3.6565863815144033`*^9}, {
   3.656586625438573*^9, 3.656586627733583*^9}, {3.656586928346489*^9, 
   3.656586941824182*^9}, {3.656591263871524*^9, 3.65659127620533*^9}, {
   3.656592370570333*^9, 3.656592380392427*^9}, {3.657280461505418*^9, 
   3.6572804818427267`*^9}, 3.657280542531639*^9, {3.6572830805798903`*^9, 
   3.657283081076202*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"*", " ", "Plot"}], " ", "**)"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"*", " ", "ticks"}], " ", "**)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"yTicks", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0", ",", "0"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.05", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.1", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.15", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.2", ",", "0.2"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.25", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.3", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.35", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.4", ",", "0.4"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.45", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.5", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.55", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.6", ",", "0.6"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.65", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.7", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.75", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.8", ",", "0.8"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.85", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.9", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0.95", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1", ",", "1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.05", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.1", ",", "Null"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"0.95", "/", "3"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(J\), \(eff, c\)]\)\>\""}], "}"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"yyTicks", "=", 
     RowBox[{"{", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0.95", "/", "3"}], ",", 
        "\"\<\!\(\*SubscriptBox[\(J\), \(eff, c\)]\)\>\"", ",", "0.01"}], 
       "}"}], "}"}]}], ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"xTicks", "=", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "5.8"}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(I\)]\)\>\"", ",", "0.01"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(O\)]\)\>\"", ",", "0.01"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.96"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(T\)]\)\>\"", ",", "0.01"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.3"}], ",", " ", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(chi\)]\)\>\"", ",", "0"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.22"}], ",", "Null", ",", "0.01"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.14"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(D\[Infinity]\)]\)\>\"", ",", "0"}], 
        "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.16"}], ",", "Null", ",", "0.01"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.01"}], ",", 
         "\"\<\!\(\*SubscriptBox[\(T\), \(D2\)]\)\>\"", ",", "0"}], "}"}], 
       ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.06"}], ",", "Null", ",", "0.01"}], "}"}]}], 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotJeff1", "=", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "D2Heating", ",", "DinfCooling", ",", "TCooling", ",", "OHeating", 
         ",", "IHeating"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Blue", "}"}], ",", 
          RowBox[{"{", "Green", "}"}], ",", 
          RowBox[{"{", "Purple", "}"}], ",", 
          RowBox[{"{", "Red", "}"}], ",", 
          RowBox[{"{", "Brown", "}"}]}], "}"}]}], ",", " ", 
       RowBox[{"PlotLegends", "\[Rule]", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*SubscriptBox[\(D\), \(2\)]\)\>\"", ",", 
            "\"\<\!\(\*SubscriptBox[\(D\), \(\[Infinity]\)]\)\>\"", ",", 
            "\"\<T\>\"", ",", "\"\<O\>\"", ",", "\"\<I\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Right", ",", "Top"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.04", ",", "1.45"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", 
        RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
       RowBox[{"Axes", "\[Rule]", "True"}], ",", 
       RowBox[{"AxesStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "12"}], "]"}]}], ",", 
       RowBox[{"AxesLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<T\>\"", ",", "\"\<\!\(\*SubscriptBox[\(J\), \(eff\)]\)/3\>\""}],
          "}"}]}], ",", 
       RowBox[{"Ticks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Automatic", ",", "yTicks"}], "}"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(T\), \(I\)]\)\>\"", ",", "Bold"}], 
             "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "6.7"}], ",", "0.03"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(T\), \(O\)]\)\>\"", ",", "Bold"}], 
             "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "3.3"}], ",", "0.03"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(T\), \(T\)]\)\>\"", ",", "Bold"}], 
             "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "2.1"}], ",", "0.03"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(T\), \(chi\)]\)\>\"", ",", "Bold"}], 
             "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "1.3"}], ",", "0.03"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(T\), SubscriptBox[\(D\), \(\[Infinity]\
\)]]\)\>\"", ",", "Bold"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "1.1"}], ",", "0.03"}], "}"}]}], "]"}], ",", 
          RowBox[{"Text", "[", 
           RowBox[{
            RowBox[{"Style", "[", 
             RowBox[{
             "\"\<\!\(\*SubscriptBox[\(T\), SubscriptBox[\(D\), \
\(2\)]]\)\>\"", ",", "Bold"}], "]"}], ",", 
            RowBox[{"{", 
             RowBox[{
              RowBox[{"1", "/", "1"}], ",", "0.03"}], "}"}]}], "]"}]}], 
         "}"}]}]}], "]"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotJeffP", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "D2Heating", ",", "DinfCooling", ",", "TCooling", ",", "OHeating", 
         ",", "IHeating"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Blue", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Darker", "[", 
            RowBox[{"Green", ",", "0.4"}], "]"}], "}"}], ",", 
          RowBox[{"{", "Purple", "}"}], ",", 
          RowBox[{"{", "Red", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", ".8", "]"}], ",", "Magenta"}], "}"}]}], 
         "}"}]}], ",", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\[FilledSmallCircle]", ",", "8"}], "}"}]}], ",", " ", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.04", ",", "1.45"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", 
        RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "12"}], "]"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<T\>\"", ",", "\"\<\!\(\*SubscriptBox[\(J\), \(eff\)]\)/3\>\""}],
          "}"}]}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "yyTicks"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "xTicks"}], "}"}]}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotJeffL", "=", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "D2Heating", ",", "DinfCooling", ",", "TCooling", ",", "OHeating", 
         ",", "IHeating", ",", "SO3Heating"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Blue", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Darker", "[", 
            RowBox[{"Green", ",", "0.4"}], "]"}], "}"}], ",", 
          RowBox[{"{", "Purple", "}"}], ",", 
          RowBox[{"{", "Red", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", "0.5", "]"}], ",", "Magenta"}], "}"}], 
          ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", "0.8", "]"}], ",", "Dashed", ",", 
            RowBox[{"Thickness", "[", "0.01", "]"}], ",", "Black"}], "}"}]}], 
         "}"}]}], ",", " ", 
       RowBox[{"PlotLegends", "\[Rule]", 
        RowBox[{"Placed", "[", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
           "\"\<\!\(\*SubscriptBox[\(D\), \(2\)]\)\>\"", ",", 
            "\"\<\!\(\*SubscriptBox[\(D\), \(\[Infinity]\)]\)\>\"", ",", 
            "\"\<T\>\"", ",", "\"\<O\>\"", ",", "\"\<I\>\"", ",", 
            "\"\<SO(3)\>\""}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Right", ",", "Top"}], "}"}]}], "]"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.04", ",", "1.45"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", 
        RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "12"}], "]"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<T\>\"", ",", "\"\<\!\(\*SubscriptBox[\(J\), \(eff\)]\)/3\>\""}],
          "}"}]}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "yyTicks"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "xTicks"}], "}"}]}], "}"}]}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.65658621257987*^9, 3.65658622245923*^9}, {
   3.6565862878020563`*^9, 3.656586308544972*^9}, {3.656586387998543*^9, 
   3.6565864368750687`*^9}, {3.656586479529216*^9, 3.6565864950951977`*^9}, 
   3.6565866287230787`*^9, 3.65658694346875*^9, {3.6565871782376204`*^9, 
   3.656587328019458*^9}, {3.6565873855719423`*^9, 3.6565873861597357`*^9}, {
   3.656587452342044*^9, 3.656587517320962*^9}, {3.6565906400989027`*^9, 
   3.656590652822528*^9}, {3.6565909375479*^9, 3.6565909424092407`*^9}, {
   3.656591283157398*^9, 3.6565912836619167`*^9}, {3.6565913161498213`*^9, 
   3.656591317629771*^9}, {3.656591367553626*^9, 3.656591368985317*^9}, {
   3.6565919159853563`*^9, 3.6565919376366463`*^9}, {3.656592241850354*^9, 
   3.65659229298392*^9}, {3.656592390548902*^9, 3.6565924561910887`*^9}, {
   3.6565924940188704`*^9, 3.656592539872365*^9}, {3.656592697717619*^9, 
   3.656592702183969*^9}, {3.656592794132785*^9, 3.656592861136806*^9}, {
   3.65659299846144*^9, 3.656593006727532*^9}, {3.656593088923924*^9, 
   3.656593100834989*^9}, {3.6565935527370243`*^9, 3.656593581778666*^9}, {
   3.656595920969228*^9, 3.6565959239899187`*^9}, {3.656599885852916*^9, 
   3.6565999130584393`*^9}, {3.656599965907934*^9, 3.656600144976585*^9}, {
   3.656600205533491*^9, 3.656600208494532*^9}, {3.656600257694618*^9, 
   3.656600263958778*^9}, {3.656601057476405*^9, 3.656601129037389*^9}, {
   3.656601160630415*^9, 3.6566011696936893`*^9}, {3.656601218385684*^9, 
   3.65660129617063*^9}, {3.656601393211937*^9, 3.656601432674095*^9}, {
   3.6566014797956123`*^9, 3.6566014883553553`*^9}, {3.656601690169546*^9, 
   3.656601692133502*^9}, {3.6566018871208687`*^9, 3.656601929357833*^9}, {
   3.656601962828738*^9, 3.656601969024239*^9}, {3.656602073750217*^9, 
   3.6566020974263144`*^9}, {3.656602146245461*^9, 3.656602191525404*^9}, {
   3.656602526187807*^9, 3.656602553410369*^9}, {3.656602588302767*^9, 
   3.6566025986271963`*^9}, {3.656602653493322*^9, 3.656602825827853*^9}, {
   3.656602866676608*^9, 3.6566029135866737`*^9}, {3.656603173077613*^9, 
   3.656603187235132*^9}, {3.6566056569568233`*^9, 3.6566056835240583`*^9}, {
   3.65660604946058*^9, 3.6566060953383417`*^9}, {3.656606126300571*^9, 
   3.656606192928033*^9}, {3.656606462462668*^9, 3.6566064673704233`*^9}, 
   3.656606847843197*^9, 3.656607544589765*^9, {3.656608170260878*^9, 
   3.656608242049326*^9}, {3.65660835741082*^9, 3.656608364299932*^9}, {
   3.65660853435528*^9, 3.6566086518434553`*^9}, {3.6566086820765944`*^9, 
   3.65660873964539*^9}, {3.6566087915829363`*^9, 3.6566088183274918`*^9}, {
   3.656608928538272*^9, 3.656608937342395*^9}, {3.6566091393944483`*^9, 
   3.656609297550126*^9}, {3.656609392997061*^9, 3.656609437334682*^9}, {
   3.656609480270241*^9, 3.656609487490237*^9}, {3.656609867599494*^9, 
   3.6566098814772053`*^9}, {3.6566099159649*^9, 3.6566099161276207`*^9}, {
   3.656610112468802*^9, 3.65661014526259*^9}, {3.656610187120944*^9, 
   3.656610201528508*^9}, {3.6566102323231907`*^9, 3.656610237467278*^9}, {
   3.656610279641533*^9, 3.656610302506838*^9}, {3.65661033781551*^9, 
   3.656610488098901*^9}, {3.6566105813890038`*^9, 3.656610838132134*^9}, {
   3.656610887069305*^9, 3.656611036752882*^9}, {3.656611090057034*^9, 
   3.656611297554998*^9}, {3.6566113322897*^9, 3.656611383288879*^9}, {
   3.656611479033708*^9, 3.656611485935379*^9}, {3.656611577366921*^9, 
   3.6566116049372787`*^9}, {3.656611757959303*^9, 3.656611866294463*^9}, {
   3.6566118988452673`*^9, 3.656612077635055*^9}, {3.656612110664914*^9, 
   3.6566121238351517`*^9}, {3.656612154852697*^9, 3.656612236553069*^9}, {
   3.6566122682810163`*^9, 3.6566123241386538`*^9}, {3.6566123849586678`*^9, 
   3.656612386813424*^9}, {3.656612424635449*^9, 3.656612505936677*^9}, {
   3.656612635619466*^9, 3.656612804955864*^9}, {3.6566128521372766`*^9, 
   3.656612853168244*^9}, {3.656612901087894*^9, 3.656612918410284*^9}, {
   3.656613048960174*^9, 3.656613189670682*^9}, {3.656613231691409*^9, 
   3.656613269121151*^9}, {3.6566133161980963`*^9, 3.6566133449900017`*^9}, {
   3.656613387391159*^9, 3.6566135682668133`*^9}, {3.6566136198871117`*^9, 
   3.656613622176606*^9}, {3.656613730699821*^9, 3.656613737104086*^9}, {
   3.6566138052446413`*^9, 3.656613828384432*^9}, {3.65661385958533*^9, 
   3.6566140689382668`*^9}, {3.656614122108294*^9, 3.656614327358972*^9}, {
   3.6566143732384367`*^9, 3.6566144026883907`*^9}, {3.656614445428919*^9, 
   3.6566144483035717`*^9}, {3.656614580638817*^9, 3.656614583157045*^9}, {
   3.657195623044465*^9, 3.657195623708414*^9}, {3.6572002760921097`*^9, 
   3.657200276968072*^9}, {3.657200318319778*^9, 3.657200338481958*^9}, {
   3.657200411079803*^9, 3.657200439749835*^9}, {3.657200501617399*^9, 
   3.6572005573514557`*^9}, {3.657279893630334*^9, 3.657279898572815*^9}, {
   3.657280443931161*^9, 3.657280445050878*^9}, 3.657280500365848*^9, {
   3.657281244006311*^9, 3.657281268753129*^9}, {3.6572820729343224`*^9, 
   3.657282097705002*^9}, {3.6572821500775843`*^9, 3.65728215511703*^9}, {
   3.6572822290187407`*^9, 3.6572822308307047`*^9}, {3.6572822890355463`*^9, 
   3.6572823334258127`*^9}, {3.657282440119465*^9, 3.657282448192959*^9}, {
   3.657282488363035*^9, 3.657282491440104*^9}, {3.657282574145915*^9, 
   3.65728261128237*^9}, {3.6572827958288193`*^9, 3.65728280168699*^9}, 
   3.659638192471675*^9, {3.6596382274965057`*^9, 3.6596382767130938`*^9}, {
   3.659638308318809*^9, 3.659638312104197*^9}, {3.659638409985314*^9, 
   3.65963841264458*^9}, {3.659638462579669*^9, 3.659638596751129*^9}, {
   3.6596386418271112`*^9, 3.659638674829863*^9}, {3.659638718440322*^9, 
   3.659638777707891*^9}, {3.659638993498735*^9, 3.659639001396817*^9}, {
   3.65963903489438*^9, 3.659639052235888*^9}, {3.659639114990543*^9, 
   3.659639250183964*^9}, {3.6596392950843487`*^9, 3.659639305571714*^9}, {
   3.659639367649763*^9, 3.659639368131298*^9}, {3.659642022138796*^9, 
   3.6596420224711733`*^9}, {3.659644816983457*^9, 3.6596450475308847`*^9}, {
   3.659645092603167*^9, 3.6596451286041527`*^9}, {3.6596451726372023`*^9, 
   3.6596451737445717`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"*", " ", "critical", " ", "points"}], " ", "**)"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"**", 
    RowBox[{"*", " ", "Critical", " ", "Jeff"}]}], "****)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"Jeffc", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.05", ",", 
         RowBox[{"0.95", "/", "3"}]}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"1.5", ",", 
         RowBox[{"0.95", "/", "3"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", 
     RowBox[{
     "*", " ", "T_c", " ", "of", " ", "chiral", " ", "phase", " ", 
      "transition"}]}], "****)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TcChi", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.22"}], ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.22"}], ",", " ", 
         RowBox[{"0.95", "/", "3"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"**", 
     RowBox[{
     "*", " ", "Tc", " ", "for", " ", "different", " ", "nematic", " ", 
      "transition"}]}], " ", "****)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TcD2", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.06"}], ",", " ", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.06"}], ",", " ", 
         RowBox[{"1.5", "/", "3"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TcDinf", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.16"}], ",", " ", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.16"}], ",", " ", 
         RowBox[{"0.993877", "/", "3"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TcT", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.96"}], ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "1.96"}], ",", 
         RowBox[{"2.25", "/", "3"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TcO", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "3"}], ",", 
         RowBox[{"2.5", "/", "3"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"TcI", " ", "=", " ", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "5.8"}], ",", "1.1"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"1", "/", "5.8"}], ",", 
         RowBox[{"2.75", "/", "3"}]}], "}"}]}], "}"}]}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{"*", " ", "plot", " ", "Tc", " ", "and", " ", "Jeffc"}], " ", 
    "**)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotTcJeffc", " ", "=", " ", 
     RowBox[{"ListLinePlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
        "Jeffc", ",", "TcChi", ",", " ", "TcD2", ",", "TcDinf", ",", "TcT", 
         ",", "TcO", ",", "TcI"}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Lighter", "[", 
             RowBox[{"Blue", ",", "0.5"}], "]"}], ",", "Dashed"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", "Dashed"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", "Dashed"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", "Dashed"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", "Dashed"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", "Dashed"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Gray", ",", "Dashed"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotRange", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"0.04", ",", "1.45"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"AspectRatio", "\[Rule]", 
        RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
       RowBox[{"Frame", "\[Rule]", "True"}], ",", 
       RowBox[{"FrameStyle", "->", 
        RowBox[{"Directive", "[", 
         RowBox[{"Black", ",", " ", "12"}], "]"}]}], ",", 
       RowBox[{"FrameLabel", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
         "\"\<T\>\"", ",", 
          "\"\<\!\(\*SubscriptBox[OverscriptBox[\(J\), \(_\)], \(eff\)]\)/3\>\
\""}], "}"}]}], ",", 
       RowBox[{"FrameTicks", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "Automatic"}], "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Automatic", ",", "xTicks"}], "}"}]}], "}"}]}], ",", 
       RowBox[{"Epilog", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"Text", "[", 
          RowBox[{
           RowBox[{"Style", "[", 
            RowBox[{
            "\"\<\!\(\*SubscriptBox[OverscriptBox[\(J\), \(_\)], \(eff, \
c\)]\)\>\"", ",", "Bold"}], "]"}], ",", 
           RowBox[{"{", 
            RowBox[{"0.3", ",", "0.35"}], "}"}]}], "]"}], "}"}]}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"plotTcMarkers", "=", 
     RowBox[{"ListPlot", "[", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "1.06"}], ",", " ", 
            RowBox[{"1.5", "/", "3"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "1.16"}], ",", " ", 
            RowBox[{"0.993877", "/", "3"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "1.96"}], ",", 
            RowBox[{"2.25", "/", "3"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "3"}], ",", 
            RowBox[{"2.5", "/", "3"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "5.8"}], ",", 
            RowBox[{"2.75", "/", "3"}]}], "}"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"1", "/", "1.22"}], ",", " ", 
            RowBox[{"0.95", "/", "3"}]}], "}"}], "}"}]}], "}"}], ",", 
       RowBox[{"PlotStyle", "\[Rule]", " ", 
        RowBox[{"{", 
         RowBox[{
          RowBox[{"{", "Blue", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{"Darker", "[", 
            RowBox[{"Green", ",", "0.4"}], "]"}], "}"}], ",", 
          RowBox[{"{", "Purple", "}"}], ",", 
          RowBox[{"{", "Red", "}"}], ",", 
          RowBox[{"{", 
           RowBox[{
            RowBox[{"Opacity", "[", ".8", "]"}], ",", "Magenta"}], "}"}], ",", 
          RowBox[{"{", "Black", "}"}]}], "}"}]}], ",", 
       RowBox[{"PlotMarkers", "\[Rule]", 
        RowBox[{"{", 
         RowBox[{"\[FivePointedStar]", ",", "14"}], "}"}]}]}], "]"}]}], ";"}],
    "\[IndentingNewLine]", "\n", 
   RowBox[{"(*", 
    RowBox[{"*", " ", "put", " ", "together"}], " ", "**)"}], "\n", 
   "\[IndentingNewLine]", 
   RowBox[{"Jeff", "=", 
    RowBox[{"Show", "[", 
     RowBox[{
     "plotTcJeffc", ",", "plotJeffL", ",", "plotJeffP", ",", 
      "plotTcMarkers"}], "]"}]}], "\[IndentingNewLine]", "\n"}]}]], "Input",
 CellChangeTimes->{{3.656593708900806*^9, 3.656593772005946*^9}, {
   3.6565939372427483`*^9, 3.656594087891271*^9}, {3.656594117955962*^9, 
   3.656594226524015*^9}, {3.6565943599772587`*^9, 3.6565944121630287`*^9}, {
   3.656594804103786*^9, 3.656594836560704*^9}, {3.656594996229048*^9, 
   3.6565951488420486`*^9}, {3.656595202940477*^9, 3.6565952140870934`*^9}, {
   3.656595251782461*^9, 3.656595339145184*^9}, {3.656595470211924*^9, 
   3.656595676286727*^9}, {3.65659602549485*^9, 3.656596212484474*^9}, {
   3.6565995000261383`*^9, 3.656599500425489*^9}, {3.656599867695541*^9, 
   3.6565998683017397`*^9}, {3.656600174492847*^9, 3.6566001959838467`*^9}, {
   3.656601524693207*^9, 3.656601572748104*^9}, {3.656601639186842*^9, 
   3.65660164315967*^9}, {3.656601725018345*^9, 3.656601835657968*^9}, {
   3.6566019895643263`*^9, 3.65660200998868*^9}, {3.6566020575372887`*^9, 
   3.656602060801145*^9}, {3.6566021298924294`*^9, 3.6566021356700277`*^9}, {
   3.656602343375996*^9, 3.656602389153949*^9}, {3.656602446977096*^9, 
   3.656602450873826*^9}, 3.656607530664534*^9, {3.656612858556673*^9, 
   3.656612896321371*^9}, {3.6566668283904333`*^9, 3.656666874133832*^9}, 
   3.656666912007246*^9, {3.657195219461141*^9, 3.657195267304957*^9}, {
   3.657195421185545*^9, 3.657195432667338*^9}, {3.657195563827032*^9, 
   3.657195568612939*^9}, {3.657282171692483*^9, 3.657282175603218*^9}, {
   3.657283243082678*^9, 3.657283289155723*^9}, {3.657283329006537*^9, 
   3.657283397430509*^9}, 3.6596383301284857`*^9, 3.6596383611857967`*^9, 
   3.659638515655532*^9, {3.659639085702022*^9, 3.659639104879437*^9}, {
   3.659639647098011*^9, 3.659639653943965*^9}, {3.659639685393182*^9, 
   3.6596397007388477`*^9}, {3.659639734211952*^9, 3.65963976572108*^9}, {
   3.659639865240624*^9, 3.659639881522531*^9}, {3.659640000433251*^9, 
   3.659640083027824*^9}, {3.659640184002213*^9, 3.659640259509658*^9}, {
   3.659644653007111*^9, 3.6596446708128757`*^9}, {3.6596447087308893`*^9, 
   3.659644762449285*^9}, 3.6596447999100723`*^9, {3.659645055059721*^9, 
   3.6596450651106777`*^9}, {3.659645183643556*^9, 3.659645254075472*^9}}],

Cell[BoxData[
 FormBox[
  TagBox[
   FormBox[
    GraphicsBox[{{{{}, {{}, {}, 
         {RGBColor[0.5, 0.5, 1.], PointSize[0.019444444444444445`], 
          AbsoluteThickness[1.6], Dashing[{Small, Small}], 
          LineBox[{{0.05, 0.31666666666666665`}, {1.5, 
           0.31666666666666665`}, {1.5, 0.31666666666666665`}}]}, 
         {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
          1.6], Dashing[{Small, Small}], 
          LineBox[{{0.819672131147541, 1.1}, {0.819672131147541, 
           0.31666666666666665`}, {0.819672131147541, 
           0.31666666666666665`}}]}, 
         {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
          1.6], Dashing[{Small, Small}], 
          LineBox[{{0.9433962264150942, 1.1}, {0.9433962264150942, 0.5}, {
           0.9433962264150942, 0.5}}]}, 
         {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
          1.6], Dashing[{Small, Small}], 
          LineBox[{{0.8620689655172414, 1.1}, {0.8620689655172414, 
           0.3312923333333333}, {0.8620689655172414, 0.3312923333333333}}]}, 
         {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
          1.6], Dashing[{Small, Small}], 
          LineBox[{{0.5102040816326531, 1.1}, {0.5102040816326531, 0.75}, {
           0.5102040816326531, 0.75}}]}, 
         {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
          1.6], Dashing[{Small, Small}], 
          LineBox[{{0.3333333333333333, 1.1}, {0.3333333333333333, 
           0.8333333333333333}, {0.3333333333333333, 0.8333333333333333}}]}, 
         {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
          1.6], Dashing[{Small, Small}], 
          LineBox[{{0.1724137931034483, 1.1}, {0.1724137931034483, 
           0.9166666666666666}, {0.1724137931034483, 
           0.9166666666666666}}]}}, {}}, {{}, {{}, {}, 
         {RGBColor[0, 0, 1], PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1UwtMk1cYrUykqHUr1AHOKaAwXpHFSDLG8PAYChJIcKDBiQwGimTydhEo
CI7HjBM2gwwBhzLYeLVQ3o9CLOVRQDKQ8tiQhSGPQtv/b8HpgDD30/09OTc3
X3If55z7XbPQ6LPhOgwGw5sa23Phg21UwtTaXGzzJ4kDZa4UqxBXaFx+aZCE
Ve1jYdZqFf45lV242UVipF3EWa+phulJMZ/RRuJgfyzFGoRwq7/lNZB4X+pK
kQed9oPF16n6kAZ85MRcUJXWkmAe5qpEerUYyLnrIuSTYGhQhwCPobzlKhIZ
77gxzTLqwNoyvFhTQYKtgQBWen3SmDIS+ckHQtp+FWBYyubplJK4d9SLYj1O
JrimDBWTiLB/3Jnxqh5nc57zQNUcJ4Ghk6ABnYxNmfQ+iWQO//RfSY24W9Kw
2krVARo0gXVxzyPdHBJhZnsCJW7NMNlbRIRmkzhlFJQw6tGCYUveQkc6CeOs
EIqtcHDMfTjIJfF/fm2wPu4j94rX5tUOXkdilXuUNh8hGqPyy+vCtXl0geN/
RXInWOv/CfRTxOd9A7R+RZARPovHPbX+uhG2L1q831nrRwxX9zc7jWy1+nsh
sHUhHIy0evuRtouvO6Kj1TcA1u1kuxQZQet5im7cbDQYJuj7R5A54C+qKCPo
+55B5d76PD6eoM8fR2SjfcPcMYI+73eIni1aKCRKev8sdr9uUXOClfT6BaiC
YtYaUhVouTbdfG16EeZcHSf2pBxTtx9SlOGWUYru1b4VVFdtYwVzZonSTI9l
FDHnC5nzK7j06Ie/RYeXocv64HrwITmox/bZHJOhuCmwqClQjoGN2dymBzK8
R3UDO1+OkY30glgXGbqWfaKTxuRgwUK6PrMEU1HKztdsBaJSJ97u+W4JCuPe
thw/BTIFmaZ6FkvQ2L2nwJSsNvKIYBFuw16mx6QKOH9ts3bVahGaOI2U8Nuw
3/ooewFt4yaVBZ8rIfHyNfxZOg+DP7ypllNiS1jpmSl4AdszL44YypT4YqtE
zE2cA08R7+nzIYGvrFnmYM7ip6VEigSOnoloJcaewlfRQ5GAc9CMYMpyCBxP
i6VwNonY2fG4K5aDCNaAhHOkY+cNuwEUJEQemqf+zbq/U53+OQmdvwrcJRuV
VUU/bpa78IKtVfhk/eVU/o5+7BcW3/rxMxXSZibeGjvXh1G/dHt+qgo1WZPM
yeZeOn8VLuc6R3xp0ItE1oJD3qQKH7utWdYk9aBnfndonK4aaaUl+XuVYpwY
/dTQ54QaefK0fwMuiPFu/feZdmFq5K7+4jC7Sww/k/sU1Thtn9KtuNGNOE3D
qeFI5O2beCOi9b7EE6W+wfRMB90fr5C18FuLrncTrWcDBcIdl7u+qaXXM1zK
z6skHqXl+A94/z7v
           "]]}, 
         {RGBColor[0., 0.6, 0.], PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1Uwkw3Gcc3SlipVJVZoiIa5KqI0IwiOOxLZFWmwTJVFIRVyQzjq4wVRtb
GkRDNGEiqSNhQtzivhKbXWdMBEW0mlDL3rv2L4qGkbZr+8+b98038x2/7703
v880LM4/8j0KhXJMMbbn/6Hqea10esZxsAjkgqfESWcy4+sK1NZsYxNMRtPO
hpEGdMS8bI95uY65V/HUg1Ot5PlVtPd3lNxnPEK84RDdcOg1zlQna16M4pD7
y5jeofub0eIA9IITfvXWW8KsMXHSSmcEtOdHTWymZLArEN/O6hjBvqN5CspQ
PpE46vbgOWT6A125J2TQlmh105NGYcJJUf1bWwaL0HwzY+4YWOIv45InpQgw
mqVmXxvHntCuSu0CKTpp3r08+xcobgsqaguSIqnOmrevcgZqu8wTQ4ykqM/s
dy/weIUiKq+QypNgb3Decs3qHOlXgvsZc2t1zHmUBd5JQrwEHcEXGiZ9udjS
va3JOSzBG4aberWcC9VCWqmFqgTVMyr17BsLGHMRFl8aFUNlVWR/XWcRhb9s
Q4wq/xb102mLCCqIVFAMlk7LWU3+Ivw+zh+OOCRGflx7l507j8xLjCHTtaZb
NTzYC3JcwkdF2FZHUeHj959KFBSBSD715IkNHyKVmvC4GBF8BDehn8SHx5v5
K1oeIlQ4ZG2ZdPKxnjqjcl5LhDVpKO3PZT58tQJHY7lC7Iq+dY7uLACNobG0
v1UIo6GtYbVAAa4qIcTufGn+cIEAhhYGCz+fESI64NiGpEeAhCX2N662QrCO
19cSYgFWgpzumN3jI/ERPTLcWYS0qoSIMU8e+v2dLD83FKPPVlPBRfj33TRY
eiaGyVvREWxy8U8zY6XxuAT9vJ1h8WpcMN39RHtYEvxQ4VkfYjEPh96nnWN6
UjKPecwIBlfT90vJPGdgox41a/2FDCeVeAGjwhz33A0Z8pQNNIGRsLC/6DFL
5P1xDPa+jXEbWIKyPekjkK2w/7DaISfrDcPP/N/U1cNy+CgbdAgy6+vxn56X
k/UHUDLB2cRVOXRdm3Rcm/pgG5FYKyyXk+/1ov5u/pwTSw5tJTj47Iq5+uCU
nHyfDe3dp177COQwUoKFjYG8EOsNOannMaw/iGI6qhP45GHZ48yVbiSOf3TC
RYcg9XWhSl8YRzMloJ8ZqmAnMlhcq0pLgtTbAY177K/6HQlEmL4f9JTWjrC5
8bQJd4LU34ZWtt3cRW8CDN2GI9zkVjg6JMWf8yNIPy3YNCs7IPQncOFgWU/6
ejMoB77N+e40Qfprxo+l7SaxoQQKGAaKH9aE6YUASk4UQfptgkecpX9oNIH0
D2lU0/RG3I1tyb5MJ0j/jRiGSc/oJQJU48vLHPWHYJZnadYmEWQeDXjAN/je
PoXA3ikvBetBEdmGnE0lyHzqwNbIoDqnExjv5uhu1NXCN2aBx7z6Lq8aeKU8
K7bJJmBQ7qVgDQ7ZqjGjct/lVw1a94BY+waB/wCGl1V0
           "]]}, 
         {RGBColor[0.5, 0, 0.5], PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwtk3s01GkYxxl0pZpuKo0u0i5at66ovp1qrO5HqUiFkWpFMi6bVBLHpou2
WinUYo1bDGokkkwN1jSNRC7NDDNM5spPNxFpRzvf83nPe973ff55nvN5F9CC
dvqRdHR0DmrW6P5/9Netr2cn7KtIgfZiHevrt7BoBgP38kbzFRe2Dk5xu8JE
aaDgYaCgH24Z3wfMP7O09Z+w8TmtqaS/HPS5tcFza9/jFDw/OTmyte99MMhq
LDfyr4bxgdAGqnEP8ld8L3Skc7H+5ab51k1qhMniZQG6L7Bo03UNaiyumWf/
+uQLqGdVlyW4qjEuzWpRCHiYzz6j/4WshrM/y+ZBJw+Vim1BpxpVIEVuzVyW
8hImPmXZ5JsqiDv59BoKH6klHiklHiqYo3NvvoQPA6OfwrxMVRh+WZwrFtUj
ZZw0eZxUiQSH+takgFfafpXIkyx/VtLzCulut06CrsTqLrnxVEojhqcnGbId
lcgsNCLNqmiCfvL6NAt9JTiOR+NzUt+g3kGWGsJXYMU/g+HmwmYk3x6NAg3i
umi75a3wuOmnQYFrJFOriQ5t2Lr4Rt0hewXEUVZtxeS32nkpIJ1LyzWZIcDS
7ssOvnw5KA2W89+yBGiNv6NBjiVNyd2UbCHkenm+QYFyTCjwuX3NTYS1A+KY
yWvlyLCdMe7nryL0n2vTOzxZDi7FrMb9RjtcJrvxj0tkcN7G982278D6yPE9
5iwZwhJ021SiDvzxIzI8KXtNpdiKMddiTudVTxlyhnQyVwSLEdpTtd/JVoZW
wS6vmHtixHfa0OMMZHAit2yMGBRr/ehGqJJ7JMJUAs+4Sa09xd3IyBaoF3pJ
kMdxo1navcOy+kWcIEoXZvfVSezFXTg5xujbtP1S+FvlFmQ+7MRuWrH3533v
EG0XH/OlQILMDA77kXU3qhtN9+qyxSBtSUkqMpNhRkXq+aRdYgzrvVatNpZr
5ydGgvTDvNdBCtwK9TeVMjswfDrauXmsEl4/0gFOs8ecd3FKTHcxl/mRO8Az
i7LtEyqxXc3R0A7mkc9DKpIKd2URGtohHG3XQoUCdYjLNtt2hHdxa07QVLDa
3GU2TS5CiWVqKSdThalvtxy1SRfBZUxWFcFToezN7NxbniJc6RYknhhSaf0X
oXND+Ishc7XWfyHO/R0sWeei1vovxIU7FqEHfdVa/4UwfVqqqD+r1s6/BXnn
jjaOfOpBke09V056I25uH9FVhPWCI51Aoxs0YMFxn74Nj3rRPLOMr2/IR2Li
YkaaoFfrOxemLXEXg0d6cdDbyS9n97/g0dUPRMYEErpWaajB4NjMlghrAgdG
yI7RdA5mjkHsizUEKAzB3j3EM/S7nJiSvJnAzK5yRlQ6GxGDRe9D9hBocI22
YZ6twsVvfl+kPgQM3JM/mo1UwoiZ1VoZSCCx0XX7rw5PUF1IHdAPJ0DaeIy2
k/EYC3dcZ94+TWj/VzkYH8JjG88TcLgqWR338RFGu7t7icDSlQcbWNxSnGkd
cLC6SqBq7f0cVDxEXU9s7Iy/CAQzIvW4nBI4ZAccM00mQH9ecTlGwsIhFyfP
X+4QsAqb2mI4hYVVsZbLI9MITKNt1/AARxcGnDzFIJCdb3GMm3wfIxnv7ahZ
BCrcQoXcj8XYeClANpRLgHl4SZWJezHYdu2/UZkE/A3TvdNqiqDImDSLfJ/A
pOBEC++1RSBdPLvPnkVgpTN1GelMIf4scFsTpzkfCNzhH3eZieubLxn1lRIg
e+6KGMwtQH9b78Q35YTWh3zkNlTyLj4mwFtpQZk1IR/OUbtN4p8QsI5yqq3d
fA+7236n9j0lMH481/1wYh4kvMJuHTaBG3fJdfaKXFhSDXyinxH4Dyg78R8=

           "]]}, 
         {RGBColor[1, 0, 0], PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lAs0VHkcxxGn6SkhpZKpkK3o5ZwQ30l5FHpYdQ6SUNgiFimPNrtZlmM5
ixRJtWk98m6QMmooTJiGvKXGeIwZYy42odptZ2bvfM/3nnvuuef+f7/P9/c7
l+oV6HROSUFBwUNySe+ZGVLlI9PrS6XjewLaOfslLgCzfVRP1ERgS8n9mtjp
Agx86+v4vpYA5ylTY77wEd7VceOCqgmsa/xR4kIc7KzDNTqB9R37JS6C/6L5
e76PCejIVIwGo+MMk1IClA1Rk8yFJQiLFxb9XERAQaZSMNJyM/oLCMSssKJQ
Y0phtKf7h5yHBNRkKsOMtZUbW/KcHqntWZ1bBv9yG4uDDwikbD4kcTlM6U1h
tXcJ+BnfZ8R8KgfrMze5IoOAhnmZunnZY6R/9WIZpxOI1Ci2HYygw4ttw/RJ
JXBCpgr85X9BJzORwFnqEpcmq0oset7x5nYCARst99A26yokXbnL6YkhsDrW
U+InOGVhwAiMIvB/ftXIo7iXdIXJ83oKs5Iye+dAeT41qGm2jjLwkedRC9qJ
YHOqp5z/BSyyrztfdpLzMrHYe8n+5YflfHXIEWlr7zOV89TDUzs2+TdDef+v
cGM4dUvSKnm/jdg1RX028o+Y7I+FqJ9WU/f1icl+WnBGqUo8mi8m63NAHeB9
pNiJyXrtsN5o68j2niDP78T8Re4XikAITpDT7EhZJ1Lqzfzi84SIko5DrQtt
/judlC4J4eC7886r0C68CGJua7QUoiqgvzKgvwsduwvmtYyEZH/d2BZwui5J
JIBV5KIJPXo3/AsU3ZezBZg++ck0R78HmbpCS4V8AXri70iNNdO87o1RAmiv
kaoXw3mscJGzgOTrxR/ZqjW2mwQkDxfn1Q1mzTX4CF82YpLWzUWvbmpi1q+j
CJYFMIg8K0NbcdcI3rZLxQPtGn1l66oR8vthiOp9ezR1h0n+Eej6rFuxfIhH
8ozCp/XPhBndQcTzjINjVfjIekcc0xjjInTixSnzHXz02Ykm8ku4WGeozUt2
42PaJXvhZV8u4mTi4/z5XlePzVySn49lu1hNLj0fYKfqzL44yEdC8VzIrP4H
fIruXeCjOgaV6W8Mcdx7WM5xr6tajsHama1cKh7A2IIC78CAMQT5OhQf1R8g
8xoDjdZ21D72HXaPJpp6s8fgmphGc6/qJ/kEiHn7i9ZVlX446Keyzu4S4OID
xRqVlX1wST8nsQAJ2g71k2q9ZL4C6DXeaWd+7sYbU35WiGROrc+lA+6CcqbV
PUNlIaL3mjDKfu/EV42bS5lmQsR9pzqio9eB+863riBYCOeH24unMtrxqEAq
yXuLPr2bIg5uU4YzKcNCmLnR/CyiOFBZZnDJQ2ccwquce0n0N8iqcLld4TKO
W0W8CMUhNtZK1y19HCcP8HTsN7BRK3AMjHg7Dq9mlf2uYa3QZV5VnlUTYa9+
dgPnZQtEq19VJx0XIb/iQNd2zRbI1jtFBGFMwSPN6GZYtR7SNeoQwYSu2BNN
aYZsPbUmwKDQWIsvvEZ155r8W24TUHHv9J+bZGFln73kFzMB3pWte/NPsLD1
8NAm9bEJaD7fd/lGUxOKRCF2jjvE0PxwbM5/fROy+eESizFlL5zy4zTiiOil
xGLEUj2MzWwaoWGnxz+nRuBJaEt4Q20D9rQdVHfcMwW/yMFnT4/Vwf3k0rRJ
m78xmDJ0RHCGgZLTjIgZ4QxcM92ohQ2V5LzmUb72gVf8x1Ky/r/ovB4YF/I5
F7mFhhdeZyrR0u2SW1bQ7+I/Ey/j1w==
           "]]}, 
         {RGBColor[1, 0, 1], PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], Opacity[0.5], LineBox[CompressedData["
1:eJw1lHs01Gkcxi0qToSalibEFkWlC9rK1oOlJLWbWlGohC6ycskJ0x6VVLvS
JrfGZROxIbdCnMh1zMgIuYRcBmPMmJkfCl3EDvvznOc973n/+L7f83ze73m1
Xbxs3aSlpKRcJGt2pz+Y1RP8Wrzo6+0uAtQUM4nTIXuQZUNjEliXnfQydCwd
D0I+Pa0sJdBQXE75nJmBsv3RwTeKCKjXeEuciZLub6PO+QQ0ms0kfooFVIdV
U7kENOeUBaH0/riYHAJyq2gj5Yuy4eL1yxXFLAJSc8oBZ7vMti8ZBEKUzeW0
Q3LgGnHvWU4aAZU55cJ9jL3tx1QC0UHUU0VpuRi97LlPO5lAxJp9Eudh1ENl
99UEAmc3JZWETOSBXZOf5BJPgGKSu8wk9xk4KXY3PkQTCKJk7eUEPsd4blR6
zd8EfptTPupM3aa+hhFw1V7swDQvQLm/RozzLQJ7VJ38Gi0LMV0YobHyKgG1
0FMSv0DJibENBkEE/udXBKNXdBlZ33lexQi44/Qo0GOez0uIw1jjLNd5HqVw
tGX+a3l0Pn8ZGs9Q18ZazOctR/w1pe06hvP5KhC7qNV5i/J8nkqovJmJrewU
k/VVYHGR0lMqBsXykMRViKd3v2PkifE40tZa73EVPreoa8Umi1GrnJnM/lqF
ceU7Yi1/MZm/GtdCp+UN7MRouGg7yc2txi5Hn/d6GmLQZnGrMEBdddiV3iqC
zZktCdV+DIjP100fDhGh0LOzwLOTgR+kdNZnmolIXjVoDf3Te1pXBPMgeZHO
8xqw7Y0SEhREGLOb2JGiy0SAvElej5QI724nSMzElo1tzDi+ENQVs2LB2H1G
z7xNSPJlgdal5Bb1SkjyrEOwbkVo2lEhmb8BA+yPOgYdwySvJpy9J6LBeJjM
14Jys7P6ufYC8r52PPTmmFp9zyfre2EhbVg3sYSHAEWucWRbLwQJk8LUq4Pw
mWvIgaD2TIDmey7eNs2qD00uMlMbKVyyfgCchbQ/1LQHyH5ciPy+HFnH7SP5
DGLpwcXOH5dzcLtvk0/oAh4Wq/cn2A30wk9U5miymYedoxWVSSm9UNej9t09
zsO31YMXKBd6cXNOPAz4UhSh00vy5OHJOu/NWa97YKV0pP53juQ8wb9cZ9qD
ieB2GXelIVSzvi2xvNqN3Z96ryvtHkLApfDv2oe7MCSTftrLcwiJ/p888vZ0
kfyHQG+9P0hLfA/DwbAdp+uHMPbTCxOPwk4yHx+Bjzf8rD7cARvd+yzXrXxo
aXf1fZTrgEO0m8R8fLFIXONk2E7y5cPs0YTVReV3eLODF+9bz0eszfIwa0Er
ZOnmD/VkBdBYzbC/H9mCKUqMQvlOAUr1VfVnjjUj6UjsZfgI4Bd5vV1WrQkZ
6bMSgH9zesJleSPi5AbocgMCnCjeZlae14AFimsvndAcRlGxPy380RvE5zvE
5TtI3r2q1YHKrcfK2fGNHgZVeLJN3rwepfwDXoFvh3HxaIWoP4gNrfIrspMq
QkRNOp9b2F0HoVp1UfghIVYwurSOra/D3DhFCOE+MvlXe8RrmLP3aRk0C9G1
tTg6uaMWc+OuKoJb892TJa61KGpZ8ST2uAhVDYIBhWoWlnbsl3xJIuiNplpl
7GVhvXX/6mVDIvQ+u2Uyms3EU6Gv1YHNYnQUSGuUGTORyAuQWAzL1HO7ztXX
4KCwSmIx1IINNSP21oBipcNzUyHQ8oe9o3wtA0aNFssOGI3ipqpFSqpTBZzs
FCJH9nzAg5nzQwHWJch2LgkcF4zD5Xl4uu6tAvK9PuMhO0Y2qjuH7D8NxumF
+v09aUjL1POopUubanNHlrpt/wf/Ae9B/EU=
           "]]}, 
         {GrayLevel[0], PointSize[0.008333333333333333], Thickness[0.01], 
          Opacity[0.8], Dashing[{Small, Small}], LineBox[CompressedData["
1:eJwtU3s0lGkcVoxGcaSZNJha2pBsG1ZbVuuRcmtXJ45qJ1SS0kWz1GpRe7Zy
ppSz7aojyYTdXEJuRY2V3BmVXGKRalhjbt/3jQrDnmp3zH7Ped7z/vV7n9/z
vL+fzT5+UORcPT29Hdoze2dcn8VtFPCv90Q6q2F5a6OWhTi7O7fA+jM1Vpbm
1AjeFsKz70DcuJ0andX17JniIjAXsG8+tFaD2xqjZTGW+r0x6LVQY+nzjVre
Qa7zLt/tLDWW6VACoYbIO2OsBvOTU+P180rBtte4sxlq6OlQBlebuvcrP1BI
WujFtEkqg9g+kLt6goKZDuVI457cMk9FIS3RMlyUX44g++zksmEKqSv8tayA
iYu4jddPIWpNzsOkqQr0Jz+wa39Mge1eznIvv4s+06YU/QYKiewS3+GEewg/
VXThzl0K23WoxLBj/qpdeRT22yzgtXlVQTHHMPTwNQo+S8JOdHnfh7dJXvj0
BQocQbiWDzD9vTgm/wSF//MTwSJw0OpUOEXnVQ23pqB1q7ZQdD41sODalnY4
U3QetfhyOWPDDnOK9l8HYYTnVIKGpP3WQxxPBI/1kLS/Bljap2/uLCJpP40I
i27+WJFI0v03Y3JBXGOVN0n324rTeTFn/Q1Iuj8xYgyPTuysJOh+niAuhRMR
EETQ+p3gzQ9p2duvovW6sfX+gHftehX9fi86b1wM5oQo6fcG4DT5Lm/5YgVd
L4F/Q1G3vrEM8SbStVf/kmC1xSBr3ZkxxOoEh2GQm1iW1S9FT/csRtD39mWd
xkxK14/CLOTgoatWo7SeFNmLORXVvSO4H/2iKvrFGDz+PGR9bu4wkkfWxAoY
MuSUG23SPJLgBFkX6u4kQ1Mfz1IqkIDrYDlyOUQGsqSFgLcE53WQYcWtkMxl
cyTwSjQibe/J8DRVb23l0dfwMw3uODYswyL/CZeL0leY+nlA/4CpHOt3Vhfo
+7yCx7TknKmHHN9pft/mkPwScv3CCH60HMrXzMiJqiHtnAm1lKPt0p5L40ZD
+GIsxS2iQ45c07Btr11e0P4U+JX9W/hi/iC+tbsi3u+iwBCxfA+XPwBeWqSW
CsQbmnxghfbT+SrAEVoohZo+PHOTZR7vUGBXrdW0h1cfDDK8sh0MlKCCe5gL
Oc/xnn3NuP4rJYY4K82lj7qQE5z+I2KVeOT8xlVg14WiwlkowTKWWR6I6sQN
5mgGc1QJ0cVm/nzHTjBM7H/Ys0yFnxzMuyeIDmRW8m5U8lSQUwFjLn4dsNJu
m1maCuaOh51MGp+iVhHAT+hRYfC44Fnj1BNY15820JgRMI866efs+QQEp1n0
SyCB240alXvxY+jGKZVA1PveqWTzx/B66m/9+XMCLb1tJfdS2qEb1yUkjmli
s7iMdoh6LW6nh5AQHTGayT4oxqLBb7QrTcKIkSq8NdYGxy1/f8qSk2Dk1Fz+
w60Nd4jjfgFOFNJFPWVvX7XipixeSwpDWZcEKb6t2Eo0aUnh7N6oC1+3toDt
ZyuLNFMj1PuoMDewBa5dm1kBrm8wU238r8KwAWE7jK+O+7zDhtZom8q4GpTu
fpgwqZxEXZzTviy9Kvq/ZlBguylxxK6M1v+I4Kq1pgEtecgvdjjSnjHXM8l+
4p8r05n4DwL1ihY=
           "]]}}, {}}, {{}, {
         {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          GeometricTransformationBox[InsetBox[
            StyleBox["\[FilledSmallCircle]",
             StripOnInput->False,
             FontSize->8], {0., 0.}], CompressedData["
1:eJw1U2tMk2cYLSgCat0KdYBzCiiMW2QxkowxPFyGgqQkONDgRAYDRTK5u8il
CI7CzCZsBhkCDmWwcStQ7vdYyqWAZCDlsiELQ6CFtt/XgtMBYe6z+3pynh9P
8l7OOe/zWoTFnI3YwWAwfKnSoUqXqsL7b1AJc1tLkd2fJA6UuVOsQnyhafml
YRI2dY+6staq8M+p7MKtHhJjHUL2Rk01zE+KahntJA4OxlGsQWhq9Tf8RhLv
Sdwp8qHbcbD4OtUf0qAWObEXVKV1JAwOp6qE+nUYyrnj1lVLgqFBPQK9RvJW
qkhkvu1hYJFZD+a28cWaChIsDQSw0R+QxJaRyE85ENr+qwCjEhZft5TE3aM+
FBtwMtGdO1JMItLxUXfmywaczXnGB9WzXQTGLoJGdDO2ZJJ7JFLYtaf/Sm7C
nZLGtTaqD9SgGcyLex7q5ZAIt9gTJPZogdneIiIsm8Qpk+DEca9WjFrzlzoz
SJhmhVJsg5Nz7oPhVBL/59cO2+McuU+CNq8O8DuTqjyjtfl0oSk6v7w+QptH
D9gBV8Tfhmj9P4YhV3TeL1DrVwgZwVk+7q3114vwfTGi/a5aPyK4e77eaWKv
1d8Pgb0b4WSi1TuI9F21emO6Wn1DYN5OceDKCFrPE/TiZpPRKEHfPwbeUICw
ooyg73sKlWfbs4QEgj5/ElFNjo0Lxwj6vN8hfLpspRAr6f3z2P2qVc0OUdLr
l6AKjl1vTFOg9dpsy7XZZVim6rqwpuWYuf2Aogy3TLh6VwdWUV31BqtYsEiS
8LxWUGSwWGiwuIpLD3/4W3h4BXrM96+HHJKDemzO1oQMxc1BRc1Bcgxtzuc2
35fhXWoaWPlyjG1mFMS5ydCzwolJnpCDCSvJxpwU5kLuzlcsBaLTpt7q+04K
hWl/e46/AjwBz1zfSgqN3bsKzMjqoo4IluEx6mN+TKKA61d261dtlqGJ00QJ
/03H7Q+zl9A+aVZZ8JkSYh8/458lizD6w5caOSW2uyq9eYLnsD/z/IixTInP
t0tEqUkL4CsSvDkfEPjSlmkJg3n8JE2iSODomcg2YuIJ/BR9FAm4Bs8JZqxH
wPa2kkawSMTNT8ZfsR5GiAYkXKOcu284DKEgMerQIvVvNgJc6g3Pien8VUiV
2qlsKgZxs9yNH2KrwscbL2bydQaxv6v41o+fqpA+N7Vj4twAxv0zHGvTVKjJ
mjaYbumn81fhcq5r5BdG/UhiLjnlTavwkce6dU1yH/oWd4fF66mRXlqSv1cp
wonxT4w5J9TIk6f/G3hBhHcavuc5hKuRu/aL0/wuEfzN7lFU47Qjt1dxoxfx
moFTw5nI2zf1WkjrfYHHSkOj2blOej5eImvpt1Y932ZazyYKunQu93xdR69n
uJWfV4m9SsvxH4pTPvE=
           "]]}, 
         {RGBColor[0., 0.6, 0.], AbsolutePointSize[6], AbsoluteThickness[1.6],
           GeometricTransformationBox[InsetBox[
            StyleBox["\[FilledSmallCircle]",
             StripOnInput->False,
             FontSize->8], {0., 0.}], CompressedData["
1:eJw1U3lQ1GUY3gJkMYxomQERERiNOEQQGUCOB7dALEoFdEJD5BKdcaVFmIiV
DZLDFElhRONQGVHORZEbZd3llBEXArQ2lVjY+/ohAQmD1brz45nn++c73vd5
nnk/+7jk8EQDCoWyV7fe0633KaswDDp/87nQa6AM5EaQ0ps2nvvNbdTXvcMy
2KymtY3DjWhnvGhjvFjE5MsU6raJFvL+PNr62itusR4gxWaQaTP4GodrM0xP
JPHJ81k8X2Pxu+1MPyyjU38LttTg1SbigAttGPSne+zcJtTwKFFcPdc+jM17
inRUo2osTeB/5ynUVv2dhfvVMFeadTHTBbDjZxr+Y66GU2yxwybRCLiKr5Iz
xlWIsH1FvXB+FBtiO6vNS1TooAf3iD2fobw1qqw1SoX0Blfx5mohjNY5psXY
qsDJ6wsoCXyJMqq4lCpWYmN00Wzd/CTpV4lbuZMLDewpVEZeS0eKEu3RxxvH
Q0VYsbhqyt+pxBuWv3GtVgTDUvpNJ0MlaoUGHN6laYz4yspPCxQwmJd7XqTN
oPTXd1CgJrzZ+FD2DKJKEnVUgEtrPmIqmUHYJ8VDCdsVKE5u6/QIEJN5KTBo
v9B0pU4MT2mBb7xAjnfqKAYS/PFzhY5yEBkHHz1yk0BuUBefzJAjRHoZVukS
BL6ZOmsWKMftHedW7DokWMwSGhwzk2NBFUv/a1aCULNIwSmRDOtOXjnK9JGC
zjLRbGmRwXZwZcgoUop8PWRYX6wqHiqRwsbJevqXwzKcjNi7pOyWIlXD+9bP
XQbuPk49oZBiLsr7msMNCdIeMBPjfeTIrklNGAkSoy/c2/kLGwV63U11nEF4
72VrzRMF7N7Kd2NZhH/vs+bu7VOiT7w2LsVIBHZAmHwDV4kfbwdxYpymsKPn
cceIpYrMYwpC6cB8zhYVmacQbsZJr1y/VOOAHs9gW1oQULikRpF+gMYwHBf3
N5OhId+PYqDnLcO/XwP9eDKHoZ7j/emyRkvWG0KY439Z8zu1CNEP6CDUrhdT
PjumJev3o2KMv4x8LSz8mmh+Tb1wT0irl1VpyX494FwvnvTmamGuBx+fn3U0
HpjQkv15MF9/8HWIVAtbPbhY6i+KcV3SknoewvXDJLaXMYFP71Y+zJvrQtro
x/t9aQSprxM1VrJkuj0Bq7xYHTuQyxW5VDsTpN52mNzgfd3nRSDB/oOox/Q2
xE2OZo8FEKT+VrTwPCZPBBNgWTTuFmW0wGtHesrRMIL004xlh8qtsnACx7dV
ducs3gdl63cF3x8iSH/38dPNNrtTsQRKWNa6H9aE59MRlIIkgvTbhMBk5/DY
kwRyPqJT7XPu4fqp5gtnmATp/x6GYNctOE2AuunMLN/4LthV50zr0wkyj0bc
kVj/4JlJYOPELh05oMjdY45kEWQ+DeCZ5FJ9cgiMdvEtlhrqEcqYFrPzV/Oq
w67MJ+VuFwhYV+3SsQ7b3Y3YSYWr+dWC3tWvML9E4H+Ye1V2
           "]]}, 
         {RGBColor[0.5, 0, 0.5], AbsolutePointSize[6], AbsoluteThickness[1.6],
           GeometricTransformationBox[InsetBox[
            StyleBox["\[FilledSmallCircle]",
             StripOnInput->False,
             FontSize->8], {0., 0.}], CompressedData["
1:eJw1k3s01GkYxxmUimoq0WWmi7SLttAV1bdTWKl0lK6KjJQVyYRNNynHRqWt
VmqoxRqMGNRIJJmaWEMjl1yaGWaQufLTTYm0ozP7PZ/nj+d933+e53zeebSQ
bf56Ojo63prS1RRJ5//or1tfx03YW5YM7cE6ztdv4dFMJu7ljOYrLm4enOx5
hY3iYOHDYOEAPNO/f7H4xNG+/win57SmooFS0GdXhc6ueoeT8Pro6MDV3vfD
ILOx1DjwBUz3h9U7m/Yid8X3fAc6H+tfbpy7uEmNcFmcLEi3Bgs2XtegxsLK
OXYNJ2qgNntRkuChhmGq9YLjqMVc7hn9z2Q1XAI5Sx501qJcsSXkZKMKpFOb
M5Ylv8Qs35Is8k0VJJ0CeiVFgJSiPclFe1SwQOeuXKkABsY/hftQVRh+WciS
iOuQbNjNMOxWIsG+rjUp6JV2XiVypMufFfW+QprnrROgK7G6S246hdKI4WlJ
RlwHJTLyjUlmZU3QZ6xPtdRXgucQEJed8hp19rKU4wIFVvwzGGEhagbj9mgU
qJdUR9sub8Wem/4aFLhGolpPsG/D5oU3qg/aKSCJsm4rJL/R7kuB7tk01iwT
IZb2XLb3E8hBqbea+4YjRGvcHQ1yLGpi9FCyRJDr5fiFBMsxPs/39jVPMdZ+
kVyYtFaOdBsTw5+/ijFwrk3v0CQ5+BTzyt032uE6yVNwVCqDyxaBX5ZdB9af
GtdrwZEhPEG3TSXuwB8/IsOTkgZnio0Esy1ndl71kiF7SCdjRagEYb0V+xxt
ZGgVbve5cE+CuM4l9FgDGRzJLU6RgxKtHz0IU/IPR1Kl8Iqd2Npb2IP0LKF6
vo8UOTxPmpXtWyyrW8ALoXRhRn+11E7ShRNjjL9N3deNQGtWXsbDTuygFR74
tPctom3jLnzOkyIjncd9tLgHLxqpu3S5EpA2JScVmMtgUpZyPmm7BMN6DarV
pnLt/iRI6H4/pyFEgVthgdRudgeGT0e7NI9VwudHOsBr3jPzbawS01wtZP7k
DtSaR9n0i5RwV/M0tIN9+NOQiqTCXVmkhnaIRse1VCFPfdx1i007Irr4lcdo
Kli7dZlPlYtRZJVSzMtQYcqbTQFL0sRwHZNZQdSqUPJ6BuuWlxhXeoSJx4ZU
Wv/F6NwQUTNkodb6L8K5v0Ol61zVWv9FuHjHMszbT631XwTq02JF3Vm1dv8t
yDkX0DjysRcFNvc8eGmNuOk+oqsI7wOvezyNblCPeUd9+zc86kPz9BKBvpEA
iYkLmanCPq3vfFBbYuNDR/rgfcDRP3vHv6ilqx+ITQkkdK3SUInBsRktkYsJ
7B8hO0TTeZg+BjE1awhQmMJdO4lnGHA9NpnhRmB6VykzKo2LyMGCd8d3Eqj3
iF7CPluB+G/+n7t9CRjsZnwwHymHMTuztTyYQGKjh/uv9k/wIt/5i34EAZLT
Edo25mPM33qdffs0of1fpWC+j4hpPE/A/qp0deyHRxid7u4lAktXetdz+MU4
0/rF3voqgYq197NR9hDVvTExJn8RCGWe0uPzimCfFXSEyiBAf152+YKUg4Ou
jl6/3CFgHT6lxWgyB6tirJafSiUwleau4QEC5gedOMkkkJVreYTPuI+R9He2
zpkEyjzDRPwPhXC6FCQbYhFgH1pUMWt3Ibi27b85swkEGqUdSK0sgCJ9ohn5
PoGJoYmWB9YWgBR/dq8dh8BKF+dlpDP5+DPPc02spt8fvDUw9jIb190uGfcX
EyB7bY8cZOVhoK1vwutSQutDLlj15bXxjwnUrrSkmI3PhUvUjllxTwgsjnKs
qnK7hx1tvzv3PyUwbhx/96HEHEhr83t0uARu3CVX2ylYsHI28I1+RuA/PDvx
IQ==
           "]]}, 
         {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          GeometricTransformationBox[InsetBox[
            StyleBox["\[FilledSmallCircle]",
             StripOnInput->False,
             FontSize->8], {0., 0.}], CompressedData["
1:eJw1VHs0lHkYRpymq4SUSqZCtqKbc0I8Q7kUulh1DpJQ2CIWKZc2u1mWYzmL
FEm1aTG555IyaihMmIbcpcaEMWNmPmxCtdvO2G+e87x//M7v/L73eZ73PR/V
O8j57AIFBQVPaSlKS0laWZkyFCDL+0uV0zsC2rlWUtLB7BjVEzUT2FJyrzZu
io7Bb/2d39cR4DxhaswVPsTbem58cA2BdU0/SlmIA131uFpBYH2nlZRFCFg0
d9fvEQGdeRSj0egYw6SUAGVD9ARzYQnCE4RFPxcRUJhHKRjpeZkDdAKxK6wp
1NhSGO3p+SH3AQG1eZRh2sbanS09Z0Rpe9XklSGg3NbiwH0CqZsPSlkO04rm
8Lo7BPyN7zFiP5WD9ZmbUplJQMO8TN287BEyvnqzjDMIRGkU2w1FVsCbbcv0
TSNwfB6V+CvgvE5WEoEz1CWuzdZVWPSs8/WtRAK2Wh5h7TbVSL58h9MbS2B1
nJeUj3HSwoARFE3g//xqkE/xKOkOl+f1BGYlZQ4uQfJ8alHbYhNt4CvPow60
4yHmVC+5/+ewyLnmcslZ7peJxT5LrJYfkvurR65IW3ufqdxPA7y041J+M5Tr
f4nrw2lbklfJ9TZh1yT16cg/ElIfC9E/rabu65eQelpxWqlaMlogIftzQB3k
faTYS8h+HbDZaOfE9hGT3+/C3AXuF4pACE6w88xIWRdSG8z8E/KFiJaNQ60b
7QE7nZUuCuHot/P2y7BuPA9mbmuyFKI6cKAqcKAbnbvpc1pGQlJfD7YFnqpP
FglgHbVIrFfRgwC6osdytgBTJz6Z5ur3IktXaKlQIEBvwm0ZsWaK17MxWgDt
NTL0YTifFSFyEZD++vBHjmqt3SYB6YeLc+oGM+YafEQsGzFJ7+GiTzctKfvX
UYTMBzCEfGtDO0n3CN50yMAD7WrFyrZVI+T7YYga/Ho1dYdJ/yPQ9V23YvkH
HulnFL5tfyZO6w4hgWccEqfCR/Zb4qjGGBdh4ucnzXfw0W8vEheUcLHOUJuX
4s7HlGvOwkt+XMTPg49z5/rcPDdzSf98LNvFanbtfQ97VRf2hSE+EotnQ2f0
3+NTTN8CX9UxqEx9Y0ji38FylntN1XIMNi5s5VLJIMYW0H2CAscQ7OdYfER/
kMxrDDRa+xGHuLfYPZpk6sMeg1tSOs2jeoD0J0Dsm1+0rqgMwFE/jXVmlwAX
7ivWqqzsh2vGWSkFSNR2bJhQ6yPzFUCv6XYH83MPXpvys0Olc2p7JhtwN5Sz
rO8aKgsRs9eEUfZ7F75q3FjKNBMi/jvVER29TtxzuXkZIUK4PNhePJnZgYd0
GaT3Fv16N0Qc3KIMZ1GGhTBzp/lbRHOgsszgoqfOOIRXOHeTK14ju9L1VqXr
OG4W8SIVP7CxVrZuGeM4sZ+n47CBjTqBU1Dkm3F4t6hYuYW3QZd5RXlGTYS9
+jmNnBetEK1+WZN8TISCyv3d2zVbMb/eqSIIY+kPNWNaYN12UNeoUwSTCsXe
GEoL5tdTSwwGhcZafP4VarrWFNx0F0PFoytgdoKFlf0O0l+MGLzLW/cWHGdh
66EPm9THxNB8tu/S9eZmFIlC7Z12SKD5/uhswPpm5PAjpJRg0kE46c9pwmHR
CykliKN6GpvZNkHDXo9/Vo3A47DWiMa6RuxpP6DutGcS/lFDT58crYfHiaXp
E7Z/Yyj1w2HBaQZKTjEip4XTcMtypxY2VpHzmkP52vveCR9Lyf7/outaUHzo
5zzkFRqef5WlRMuwT2ldUXEH/wEnU+PZ
           "]]}, 
         {RGBColor[1, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          Opacity[0.8], GeometricTransformationBox[InsetBox[
            StyleBox["\[FilledSmallCircle]",
             StripOnInput->False,
             FontSize->8], {0., 0.}], CompressedData["
1:eJw1lHs01GkYx4WKE6GmpQmxRVHpgray9cVSktpNrShUQhdZueTkUoeSalfa
5JbbJmJDboU4kXEZM0LIJeQyGHMxMz8Uuogd9ud7vs8f7x/P+5zv533Oq+nk
Ye0iJSEh4SSuBeKSFFfcw1k9xW8li7/d6SZATTUROwPSh5hWgQwC63OSX4WO
ZeBhyOdnlWUEGktolC9ZmSg/EB10s5iAao2n2Fko7fk+6lhAQK3FROxnWEi1
Wz2VR0B9TtkQSB6Ij8klILM6cIS2OAdOHr9elc8mIDGnXLB2SG3/mkkgRNFU
RjMkF84R95/nphNQmlMeXMfqt/+URiA6gHq6OD0Po1fc92umEIhYu1/sfIy6
Ke0JTiRwbnNyachEPuprCpKdEghQjPKWG+U9ByvV5ubHaAIBlOx9LP8XGM+L
yqj5m8DvcypAnbHL1LcwAs6aS+wYpoWg+arFON4msFfZwafJvAjTRRFqq4IJ
qISeFvslSk+ObdQLIPA/v2IYvI6Tkvae51UCv7sOj/3d5vm8giiMOc50nudR
Bntrxr/mx+bzl6PpLHVdrNl8XhoSrivs0NKfz1eB2MVtjlsV5/NUQuntTGxl
l4jsrwKTjdTeMhEo5ofFrkJCXM97er4ITyKtLXWeVOFLq6pGbIoItYpZKfXf
qjCueFek4Ssi81fjeui0rJ6NCI2XrCfZedXYbe/1QUdNhMBZ3Ep0UFcfcY5r
E8Lq7NbEah86RBfqpo+ECFHk3lXo3kXHjxJaG7JMhCSvGrSF/uk5rS2EaYCs
UOtFDeptDRIT5YQYs5nYmarNgJ+sUX6vhBDv7ySKzcDWTe2MeJ4A1JWzYsLQ
dUbHtF1A8mUisFvBJeq1gORZhyDtitD0YwIyfyMG6z9p6XUOk7yace6+MBCG
w2S+VtBMzunm2fLJ+zrwyJNlbPEDj+zvg5mkft3EUg785NmGke194CdOCtKC
h+A1N5AFfu1ZP/UPbLxrnlU/mp2kpjZR2GT/IFiLAq+paA6S89gQ+nw9up7d
T/IZwrJDSxw/rWDhTv9mr9CFHCxRHUi0GeyDj7Dc3mgLB7tGKyqTU/ugqkPt
v3eCg+9rhi5SLvbh1pw4GPSmyEOrj+TJwdP1nluy3/TCQuFowx8s8XmCd6XO
uBcTQR1SrgpcVDO/LzUP7sGez303FPZw4Xc5fEHHcDe4UhlnPNy5SPL97Ja/
t5vkz0Vc24OhwKQP0B8K23mmgYuxn18auRV1kfl48H+y8RfV4U5YaT9gOm/j
QUOzu/+TTCfsol3E5uGrWdJaB/0Oki8PJo8nLC4pvsfbnZwE7wYeYq1WhFny
2yAdZ/pIR5oPtTV02weRrZiixMjRdvFRpqusO3O8BclHY6/Aiw+fyBsd0irN
yMyYFR+8W9MTTiuaEC8zGCczyMfJku0mtPxGLJRfd/mk+jCKS3wDwx+/RUKB
XXyBnfjdq9rsqOwGrJpd3+hhUAWn2mVNG1DGO+jh/24Yl45VCAcC6qFBuyo9
qSRA1KTj+UU9dRCoVBeHHxZgJb1b4/iGOsytU4QAriOTf3VEvIFp/X4NvRYB
ureVRKd01mJu3ZWFcGm5d6rUuRbFrSufxp4QoqqRPyhXzcSyzgPiL0kIndE0
i8x9TGywHFiznCtE3/PbRqM5DDwTeFsc3CJCZ6GkWrkhA0kcP7FFME87v/t8
Qw0OCarEFkElSF89Yl8NKBZaHBclAq3XbO1la+kwaDJbftBgFLeUzVLTHCrg
YCMXObL3Ix7OXOD6WZYix7HUf5w/DqcX4RnatwvJ9/qCR/Ux0lE9ueT8adDP
LNId6E1HepaOW22cpLEme2SZy45/8B8D4PxH
           "]]}, {}}, {}}, {{}, {
         {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          GeometricTransformationBox[InsetBox[
            StyleBox["\[FivePointedStar]",
             StripOnInput->False,
             FontSize->14], {0., 0.}], {{{0.9433962264150942, 0.5}}, {{
           0.9433962264150942, 0.5}}}]}, 
         {RGBColor[0., 0.6, 0.], AbsolutePointSize[6], AbsoluteThickness[1.6],
           GeometricTransformationBox[InsetBox[
            StyleBox["\[FivePointedStar]",
             StripOnInput->False,
             FontSize->14], {0., 0.}], {{{0.8620689655172414, 
           0.3312923333333333}}, {{0.8620689655172414, 
           0.3312923333333333}}}]}, 
         {RGBColor[0.5, 0, 0.5], AbsolutePointSize[6], AbsoluteThickness[1.6],
           GeometricTransformationBox[InsetBox[
            StyleBox["\[FivePointedStar]",
             StripOnInput->False,
             FontSize->14], {0., 0.}], {{{0.5102040816326531, 0.75}}, {{
           0.5102040816326531, 0.75}}}]}, 
         {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          GeometricTransformationBox[InsetBox[
            StyleBox["\[FivePointedStar]",
             StripOnInput->False,
             FontSize->14], {0., 0.}], {{{0.3333333333333333, 
           0.8333333333333333}}, {{0.3333333333333333, 
           0.8333333333333333}}}]}, 
         {RGBColor[1, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          Opacity[0.8], GeometricTransformationBox[InsetBox[
            StyleBox["\[FivePointedStar]",
             StripOnInput->False,
             FontSize->14], {0., 0.}], {{{0.1724137931034483, 
           0.9166666666666666}}, {{0.1724137931034483, 
           0.9166666666666666}}}]}, 
         {GrayLevel[0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
          GeometricTransformationBox[InsetBox[
            StyleBox["\[FivePointedStar]",
             StripOnInput->False,
             FontSize->14], {0., 0.}], {{{0.819672131147541, 
           0.31666666666666665`}}, {{0.819672131147541, 
           0.31666666666666665`}}}]}, {}}, {}}}, InsetBox[
       TemplateBox[{
        "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(2\\)]\\)\"",
         "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(\[Infinity]\\)]\\)\"","\"T\"",
         "\"O\"","\"I\"","\"SO(3)\""},
        "LineLegend",
        DisplayFunction->(FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0., 0.6, 0.]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0., 0.6, 0.]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.5, 0, 0.5]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.5, 0, 0.5]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    RGBColor[1, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    RGBColor[1, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.8], 
                    Dashing[{Small, Small}], 
                    Thickness[0.09], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.8], 
                    Dashing[{Small, Small}], 
                    Thickness[0.09], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ),
        Editable->True,
        InterpretationFunction:>(RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0., 0.6, 0.], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0.4, 0.], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0., 0.6, 0.]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0., 0.6, 0.]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0., 0.6, 0.], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.5, 0, 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.33333333333333337`, 0., 0.33333333333333337`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.5, 0, 0.5]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.5, 0, 0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.5, 0, 0.5], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1, 0, 1]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.8`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    RowBox[{"Thickness", "[", "0.01`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[0]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                   "]"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], 
               "}"}], ",", 
             RowBox[{"LegendMarkers", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
             ",", 
             RowBox[{"Joined", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                   ",", "True"}], "}"}]}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
       Scaled[{0.99, 0.99}], ImageScaled[{1, 1}],
       BaseStyle->{FontSize -> Larger},
       FormatType->StandardForm]},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->{True, True},
     AxesLabel->{None, None},
     AxesOrigin->{0.04705, 0},
     DisplayFunction->Identity,
     Epilog->{
       InsetBox[
        FormBox[
         StyleBox[
         "\"\\!\\(\\*SubscriptBox[OverscriptBox[\\(J\\), \\(_\\)], \\(eff, \
c\\)]\\)\"", Bold, StripOnInput -> False], TraditionalForm], {0.3, 0.35}]},
     Frame->{{True, True}, {True, True}},
     FrameLabel->{{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[OverscriptBox[\\(J\\), \\(_\\)], \
\\(eff\\)]\\)/3\"", TraditionalForm], None}, {
        FormBox["\"T\"", TraditionalForm], None}},
     FrameStyle->Directive[
       GrayLevel[0], 12],
     FrameTicks->{{Automatic, Automatic}, {Automatic, {{0.1724137931034483, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(I\\)]\\)\"", TraditionalForm], 
          0.01}, {
          NCache[
           Rational[1, 3], 0.3333333333333333], 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(O\\)]\\)\"", TraditionalForm], 
          0.01}, {0.5102040816326531, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(T\\)]\\)\"", TraditionalForm], 
          0.01}, {0.7692307692307692, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(chi\\)]\\)\"", 
           TraditionalForm], 0}, {0.819672131147541, "", 0.01}, {
         0.8771929824561404, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(D\[Infinity]\\)]\\)\"", 
           TraditionalForm], 0}, {0.8620689655172414, "", 0.01}, {
         0.9900990099009901, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(D2\\)]\\)\"", TraditionalForm],
           0}, {0.9433962264150942, "", 0.01}}}},
     GridLines->{None, None},
     GridLinesStyle->Directive[
       GrayLevel[0.5, 0.4]],
     Method->{},
     PlotRange->{{0.04, 1.45}, {0, 1.1}},
     PlotRangeClipping->True,
     PlotRangePadding->{{0, 0}, {0, 0}},
     Ticks->{Automatic, Automatic}],
    TraditionalForm],
   InterpretTemplate[Legended[
     Graphics[{{{}, {{{}, {}, {
           Hue[0.67, 0.6, 0.6], 
           Directive[
            PointSize[0.019444444444444445`], 
            AbsoluteThickness[1.6], 
            RGBColor[0.5, 0.5, 1.], 
            Dashing[{Small, Small}]], 
           
           Line[{{0.05, 0.31666666666666665`}, {1.5, 0.31666666666666665`}, {
            1.5, 0.31666666666666665`}}]}, {
           Hue[0.9060679774997897, 0.6, 0.6], 
           Directive[
            PointSize[0.019444444444444445`], 
            AbsoluteThickness[1.6], 
            GrayLevel[0.5], 
            Dashing[{Small, Small}]], 
           
           Line[{{0.819672131147541, 1.1}, {0.819672131147541, 
            0.31666666666666665`}, {0.819672131147541, 
            0.31666666666666665`}}]}, {
           Hue[0.1421359549995791, 0.6, 0.6], 
           Directive[
            PointSize[0.019444444444444445`], 
            AbsoluteThickness[1.6], 
            GrayLevel[0.5], 
            Dashing[{Small, Small}]], 
           
           Line[{{0.9433962264150942, 1.1}, {0.9433962264150942, 0.5}, {
            0.9433962264150942, 0.5}}]}, {
           Hue[0.37820393249936934`, 0.6, 0.6], 
           Directive[
            PointSize[0.019444444444444445`], 
            AbsoluteThickness[1.6], 
            GrayLevel[0.5], 
            Dashing[{Small, Small}]], 
           
           Line[{{0.8620689655172414, 1.1}, {0.8620689655172414, 
            0.3312923333333333}, {0.8620689655172414, 0.3312923333333333}}]}, {
           Hue[0.6142719099991583, 0.6, 0.6], 
           Directive[
            PointSize[0.019444444444444445`], 
            AbsoluteThickness[1.6], 
            GrayLevel[0.5], 
            Dashing[{Small, Small}]], 
           
           Line[{{0.5102040816326531, 1.1}, {0.5102040816326531, 0.75}, {
            0.5102040816326531, 0.75}}]}, {
           Hue[0.8503398874989481, 0.6, 0.6], 
           Directive[
            PointSize[0.019444444444444445`], 
            AbsoluteThickness[1.6], 
            GrayLevel[0.5], 
            Dashing[{Small, Small}]], 
           
           Line[{{0.3333333333333333, 1.1}, {0.3333333333333333, 
            0.8333333333333333}, {0.3333333333333333, 0.8333333333333333}}]}, {
           Hue[0.08640786499873876, 0.6, 0.6], 
           Directive[
            PointSize[0.019444444444444445`], 
            AbsoluteThickness[1.6], 
            GrayLevel[0.5], 
            Dashing[{Small, Small}]], 
           
           Line[{{0.1724137931034483, 1.1}, {0.1724137931034483, 
            0.9166666666666666}, {0.1724137931034483, 
            0.9166666666666666}}]}}}, {}}, {{}, {{{}, {}, {
           Hue[0.67, 0.6, 0.6], 
           Directive[
            PointSize[0.008333333333333333], 
            AbsoluteThickness[1.6], 
            RGBColor[0, 0, 1]], 
           Line[CompressedData["
1:eJw1UwtMk1cYrUykqHUr1AHOKaAwXpHFSDLG8PAYChJIcKDBiQwGimTydhEo
CI7HjBM2gwwBhzLYeLVQ3o9CLOVRQDKQ8tiQhSGPQtv/b8HpgDD30/09OTc3
X3If55z7XbPQ6LPhOgwGw5sa23Phg21UwtTaXGzzJ4kDZa4UqxBXaFx+aZCE
Ve1jYdZqFf45lV242UVipF3EWa+phulJMZ/RRuJgfyzFGoRwq7/lNZB4X+pK
kQed9oPF16n6kAZ85MRcUJXWkmAe5qpEerUYyLnrIuSTYGhQhwCPobzlKhIZ
77gxzTLqwNoyvFhTQYKtgQBWen3SmDIS+ckHQtp+FWBYyubplJK4d9SLYj1O
JrimDBWTiLB/3Jnxqh5nc57zQNUcJ4Ghk6ABnYxNmfQ+iWQO//RfSY24W9Kw
2krVARo0gXVxzyPdHBJhZnsCJW7NMNlbRIRmkzhlFJQw6tGCYUveQkc6CeOs
EIqtcHDMfTjIJfF/fm2wPu4j94rX5tUOXkdilXuUNh8hGqPyy+vCtXl0geN/
RXInWOv/CfRTxOd9A7R+RZARPovHPbX+uhG2L1q831nrRwxX9zc7jWy1+nsh
sHUhHIy0evuRtouvO6Kj1TcA1u1kuxQZQet5im7cbDQYJuj7R5A54C+qKCPo
+55B5d76PD6eoM8fR2SjfcPcMYI+73eIni1aKCRKev8sdr9uUXOClfT6BaiC
YtYaUhVouTbdfG16EeZcHSf2pBxTtx9SlOGWUYru1b4VVFdtYwVzZonSTI9l
FDHnC5nzK7j06Ie/RYeXocv64HrwITmox/bZHJOhuCmwqClQjoGN2dymBzK8
R3UDO1+OkY30glgXGbqWfaKTxuRgwUK6PrMEU1HKztdsBaJSJ97u+W4JCuPe
thw/BTIFmaZ6FkvQ2L2nwJSsNvKIYBFuw16mx6QKOH9ts3bVahGaOI2U8Nuw
3/ooewFt4yaVBZ8rIfHyNfxZOg+DP7ypllNiS1jpmSl4AdszL44YypT4YqtE
zE2cA08R7+nzIYGvrFnmYM7ip6VEigSOnoloJcaewlfRQ5GAc9CMYMpyCBxP
i6VwNonY2fG4K5aDCNaAhHOkY+cNuwEUJEQemqf+zbq/U53+OQmdvwrcJRuV
VUU/bpa78IKtVfhk/eVU/o5+7BcW3/rxMxXSZibeGjvXh1G/dHt+qgo1WZPM
yeZeOn8VLuc6R3xp0ItE1oJD3qQKH7utWdYk9aBnfndonK4aaaUl+XuVYpwY
/dTQ54QaefK0fwMuiPFu/feZdmFq5K7+4jC7Sww/k/sU1Thtn9KtuNGNOE3D
qeFI5O2beCOi9b7EE6W+wfRMB90fr5C18FuLrncTrWcDBcIdl7u+qaXXM1zK
z6skHqXl+A94/z7v
            "]]}, {
           Hue[0.9060679774997897, 0.6, 0.6], 
           Directive[
            PointSize[0.008333333333333333], 
            AbsoluteThickness[1.6], 
            RGBColor[0., 0.6, 0.]], 
           Line[CompressedData["
1:eJw1Uwkw3Gcc3SlipVJVZoiIa5KqI0IwiOOxLZFWmwTJVFIRVyQzjq4wVRtb
GkRDNGEiqSNhQtzivhKbXWdMBEW0mlDL3rv2L4qGkbZr+8+b98038x2/7703
v880LM4/8j0KhXJMMbbn/6Hqea10esZxsAjkgqfESWcy4+sK1NZsYxNMRtPO
hpEGdMS8bI95uY65V/HUg1Ot5PlVtPd3lNxnPEK84RDdcOg1zlQna16M4pD7
y5jeofub0eIA9IITfvXWW8KsMXHSSmcEtOdHTWymZLArEN/O6hjBvqN5CspQ
PpE46vbgOWT6A125J2TQlmh105NGYcJJUf1bWwaL0HwzY+4YWOIv45InpQgw
mqVmXxvHntCuSu0CKTpp3r08+xcobgsqaguSIqnOmrevcgZqu8wTQ4ykqM/s
dy/weIUiKq+QypNgb3Decs3qHOlXgvsZc2t1zHmUBd5JQrwEHcEXGiZ9udjS
va3JOSzBG4aberWcC9VCWqmFqgTVMyr17BsLGHMRFl8aFUNlVWR/XWcRhb9s
Q4wq/xb102mLCCqIVFAMlk7LWU3+Ivw+zh+OOCRGflx7l507j8xLjCHTtaZb
NTzYC3JcwkdF2FZHUeHj959KFBSBSD715IkNHyKVmvC4GBF8BDehn8SHx5v5
K1oeIlQ4ZG2ZdPKxnjqjcl5LhDVpKO3PZT58tQJHY7lC7Iq+dY7uLACNobG0
v1UIo6GtYbVAAa4qIcTufGn+cIEAhhYGCz+fESI64NiGpEeAhCX2N662QrCO
19cSYgFWgpzumN3jI/ERPTLcWYS0qoSIMU8e+v2dLD83FKPPVlPBRfj33TRY
eiaGyVvREWxy8U8zY6XxuAT9vJ1h8WpcMN39RHtYEvxQ4VkfYjEPh96nnWN6
UjKPecwIBlfT90vJPGdgox41a/2FDCeVeAGjwhz33A0Z8pQNNIGRsLC/6DFL
5P1xDPa+jXEbWIKyPekjkK2w/7DaISfrDcPP/N/U1cNy+CgbdAgy6+vxn56X
k/UHUDLB2cRVOXRdm3Rcm/pgG5FYKyyXk+/1ov5u/pwTSw5tJTj47Iq5+uCU
nHyfDe3dp177COQwUoKFjYG8EOsNOannMaw/iGI6qhP45GHZ48yVbiSOf3TC
RYcg9XWhSl8YRzMloJ8ZqmAnMlhcq0pLgtTbAY177K/6HQlEmL4f9JTWjrC5
8bQJd4LU34ZWtt3cRW8CDN2GI9zkVjg6JMWf8yNIPy3YNCs7IPQncOFgWU/6
ejMoB77N+e40Qfprxo+l7SaxoQQKGAaKH9aE6YUASk4UQfptgkecpX9oNIH0
D2lU0/RG3I1tyb5MJ0j/jRiGSc/oJQJU48vLHPWHYJZnadYmEWQeDXjAN/je
PoXA3ikvBetBEdmGnE0lyHzqwNbIoDqnExjv5uhu1NXCN2aBx7z6Lq8aeKU8
K7bJJmBQ7qVgDQ7ZqjGjct/lVw1a94BY+waB/wCGl1V0
            "]]}, {
           Hue[0.1421359549995791, 0.6, 0.6], 
           Directive[
            PointSize[0.008333333333333333], 
            AbsoluteThickness[1.6], 
            RGBColor[0.5, 0, 0.5]], 
           Line[CompressedData["
1:eJwtk3s01GkYxxl0pZpuKo0u0i5at66ovp1qrO5HqUiFkWpFMi6bVBLHpou2
WinUYo1bDGokkkwN1jSNRC7NDDNM5spPNxFpRzvf83nPe973ff55nvN5F9CC
dvqRdHR0DmrW6P5/9Netr2cn7KtIgfZiHevrt7BoBgP38kbzFRe2Dk5xu8JE
aaDgYaCgH24Z3wfMP7O09Z+w8TmtqaS/HPS5tcFza9/jFDw/OTmyte99MMhq
LDfyr4bxgdAGqnEP8ld8L3Skc7H+5ab51k1qhMniZQG6L7Bo03UNaiyumWf/
+uQLqGdVlyW4qjEuzWpRCHiYzz6j/4WshrM/y+ZBJw+Vim1BpxpVIEVuzVyW
8hImPmXZ5JsqiDv59BoKH6klHiklHiqYo3NvvoQPA6OfwrxMVRh+WZwrFtUj
ZZw0eZxUiQSH+takgFfafpXIkyx/VtLzCulut06CrsTqLrnxVEojhqcnGbId
lcgsNCLNqmiCfvL6NAt9JTiOR+NzUt+g3kGWGsJXYMU/g+HmwmYk3x6NAg3i
umi75a3wuOmnQYFrJFOriQ5t2Lr4Rt0hewXEUVZtxeS32nkpIJ1LyzWZIcDS
7ssOvnw5KA2W89+yBGiNv6NBjiVNyd2UbCHkenm+QYFyTCjwuX3NTYS1A+KY
yWvlyLCdMe7nryL0n2vTOzxZDi7FrMb9RjtcJrvxj0tkcN7G982278D6yPE9
5iwZwhJ021SiDvzxIzI8KXtNpdiKMddiTudVTxlyhnQyVwSLEdpTtd/JVoZW
wS6vmHtixHfa0OMMZHAit2yMGBRr/ehGqJJ7JMJUAs+4Sa09xd3IyBaoF3pJ
kMdxo1navcOy+kWcIEoXZvfVSezFXTg5xujbtP1S+FvlFmQ+7MRuWrH3533v
EG0XH/OlQILMDA77kXU3qhtN9+qyxSBtSUkqMpNhRkXq+aRdYgzrvVatNpZr
5ydGgvTDvNdBCtwK9TeVMjswfDrauXmsEl4/0gFOs8ecd3FKTHcxl/mRO8Az
i7LtEyqxXc3R0A7mkc9DKpIKd2URGtohHG3XQoUCdYjLNtt2hHdxa07QVLDa
3GU2TS5CiWVqKSdThalvtxy1SRfBZUxWFcFToezN7NxbniJc6RYknhhSaf0X
oXND+Ishc7XWfyHO/R0sWeei1vovxIU7FqEHfdVa/4UwfVqqqD+r1s6/BXnn
jjaOfOpBke09V056I25uH9FVhPWCI51Aoxs0YMFxn74Nj3rRPLOMr2/IR2Li
YkaaoFfrOxemLXEXg0d6cdDbyS9n97/g0dUPRMYEErpWaajB4NjMlghrAgdG
yI7RdA5mjkHsizUEKAzB3j3EM/S7nJiSvJnAzK5yRlQ6GxGDRe9D9hBocI22
YZ6twsVvfl+kPgQM3JM/mo1UwoiZ1VoZSCCx0XX7rw5PUF1IHdAPJ0DaeIy2
k/EYC3dcZ94+TWj/VzkYH8JjG88TcLgqWR338RFGu7t7icDSlQcbWNxSnGkd
cLC6SqBq7f0cVDxEXU9s7Iy/CAQzIvW4nBI4ZAccM00mQH9ecTlGwsIhFyfP
X+4QsAqb2mI4hYVVsZbLI9MITKNt1/AARxcGnDzFIJCdb3GMm3wfIxnv7ahZ
BCrcQoXcj8XYeClANpRLgHl4SZWJezHYdu2/UZkE/A3TvdNqiqDImDSLfJ/A
pOBEC++1RSBdPLvPnkVgpTN1GelMIf4scFsTpzkfCNzhH3eZieubLxn1lRIg
e+6KGMwtQH9b78Q35YTWh3zkNlTyLj4mwFtpQZk1IR/OUbtN4p8QsI5yqq3d
fA+7236n9j0lMH481/1wYh4kvMJuHTaBG3fJdfaKXFhSDXyinxH4Dyg78R8=

            "]]}, {
           Hue[0.37820393249936934`, 0.6, 0.6], 
           Directive[
            PointSize[0.008333333333333333], 
            AbsoluteThickness[1.6], 
            RGBColor[1, 0, 0]], 
           Line[CompressedData["
1:eJw1lAs0VHkcxxGn6SkhpZKpkK3o5ZwQ30l5FHpYdQ6SUNgiFimPNrtZlmM5
ixRJtWk98m6QMmooTJiGvKXGeIwZYy42odptZ2bvfM/3nnvuuef+f7/P9/c7
l+oV6HROSUFBwUNySe+ZGVLlI9PrS6XjewLaOfslLgCzfVRP1ERgS8n9mtjp
Agx86+v4vpYA5ylTY77wEd7VceOCqgmsa/xR4kIc7KzDNTqB9R37JS6C/6L5
e76PCejIVIwGo+MMk1IClA1Rk8yFJQiLFxb9XERAQaZSMNJyM/oLCMSssKJQ
Y0phtKf7h5yHBNRkKsOMtZUbW/KcHqntWZ1bBv9yG4uDDwikbD4kcTlM6U1h
tXcJ+BnfZ8R8KgfrMze5IoOAhnmZunnZY6R/9WIZpxOI1Ci2HYygw4ttw/RJ
JXBCpgr85X9BJzORwFnqEpcmq0oset7x5nYCARst99A26yokXbnL6YkhsDrW
U+InOGVhwAiMIvB/ftXIo7iXdIXJ83oKs5Iye+dAeT41qGm2jjLwkedRC9qJ
YHOqp5z/BSyyrztfdpLzMrHYe8n+5YflfHXIEWlr7zOV89TDUzs2+TdDef+v
cGM4dUvSKnm/jdg1RX028o+Y7I+FqJ9WU/f1icl+WnBGqUo8mi8m63NAHeB9
pNiJyXrtsN5o68j2niDP78T8Re4XikAITpDT7EhZJ1Lqzfzi84SIko5DrQtt
/judlC4J4eC7886r0C68CGJua7QUoiqgvzKgvwsduwvmtYyEZH/d2BZwui5J
JIBV5KIJPXo3/AsU3ZezBZg++ck0R78HmbpCS4V8AXri70iNNdO87o1RAmiv
kaoXw3mscJGzgOTrxR/ZqjW2mwQkDxfn1Q1mzTX4CF82YpLWzUWvbmpi1q+j
CJYFMIg8K0NbcdcI3rZLxQPtGn1l66oR8vthiOp9ezR1h0n+Eej6rFuxfIhH
8ozCp/XPhBndQcTzjINjVfjIekcc0xjjInTixSnzHXz02Ykm8ku4WGeozUt2
42PaJXvhZV8u4mTi4/z5XlePzVySn49lu1hNLj0fYKfqzL44yEdC8VzIrP4H
fIruXeCjOgaV6W8Mcdx7WM5xr6tajsHama1cKh7A2IIC78CAMQT5OhQf1R8g
8xoDjdZ21D72HXaPJpp6s8fgmphGc6/qJ/kEiHn7i9ZVlX446Keyzu4S4OID
xRqVlX1wST8nsQAJ2g71k2q9ZL4C6DXeaWd+7sYbU35WiGROrc+lA+6CcqbV
PUNlIaL3mjDKfu/EV42bS5lmQsR9pzqio9eB+863riBYCOeH24unMtrxqEAq
yXuLPr2bIg5uU4YzKcNCmLnR/CyiOFBZZnDJQ2ccwquce0n0N8iqcLld4TKO
W0W8CMUhNtZK1y19HCcP8HTsN7BRK3AMjHg7Dq9mlf2uYa3QZV5VnlUTYa9+
dgPnZQtEq19VJx0XIb/iQNd2zRbI1jtFBGFMwSPN6GZYtR7SNeoQwYSu2BNN
aYZsPbUmwKDQWIsvvEZ155r8W24TUHHv9J+bZGFln73kFzMB3pWte/NPsLD1
8NAm9bEJaD7fd/lGUxOKRCF2jjvE0PxwbM5/fROy+eESizFlL5zy4zTiiOil
xGLEUj2MzWwaoWGnxz+nRuBJaEt4Q20D9rQdVHfcMwW/yMFnT4/Vwf3k0rRJ
m78xmDJ0RHCGgZLTjIgZ4QxcM92ohQ2V5LzmUb72gVf8x1Ky/r/ovB4YF/I5
F7mFhhdeZyrR0u2SW1bQ7+I/Ey/j1w==
            "]]}, {
           Hue[0.6142719099991583, 0.6, 0.6], 
           Directive[
            PointSize[0.008333333333333333], 
            AbsoluteThickness[1.6], 
            Opacity[0.5], 
            RGBColor[1, 0, 1]], 
           Line[CompressedData["
1:eJw1lHs01Gkcxi0qToSalibEFkWlC9rK1oOlJLWbWlGohC6ycskJ0x6VVLvS
JrfGZROxIbdCnMh1zMgIuYRcBmPMmJkfCl3EDvvznOc973n/+L7f83ze73m1
Xbxs3aSlpKRcJGt2pz+Y1RP8Wrzo6+0uAtQUM4nTIXuQZUNjEliXnfQydCwd
D0I+Pa0sJdBQXE75nJmBsv3RwTeKCKjXeEuciZLub6PO+QQ0ms0kfooFVIdV
U7kENOeUBaH0/riYHAJyq2gj5Yuy4eL1yxXFLAJSc8oBZ7vMti8ZBEKUzeW0
Q3LgGnHvWU4aAZU55cJ9jL3tx1QC0UHUU0VpuRi97LlPO5lAxJp9Eudh1ENl
99UEAmc3JZWETOSBXZOf5BJPgGKSu8wk9xk4KXY3PkQTCKJk7eUEPsd4blR6
zd8EfptTPupM3aa+hhFw1V7swDQvQLm/RozzLQJ7VJ38Gi0LMV0YobHyKgG1
0FMSv0DJibENBkEE/udXBKNXdBlZ33lexQi44/Qo0GOez0uIw1jjLNd5HqVw
tGX+a3l0Pn8ZGs9Q18ZazOctR/w1pe06hvP5KhC7qNV5i/J8nkqovJmJrewU
k/VVYHGR0lMqBsXykMRViKd3v2PkifE40tZa73EVPreoa8Umi1GrnJnM/lqF
ceU7Yi1/MZm/GtdCp+UN7MRouGg7yc2txi5Hn/d6GmLQZnGrMEBdddiV3iqC
zZktCdV+DIjP100fDhGh0LOzwLOTgR+kdNZnmolIXjVoDf3Te1pXBPMgeZHO
8xqw7Y0SEhREGLOb2JGiy0SAvElej5QI724nSMzElo1tzDi+ENQVs2LB2H1G
z7xNSPJlgdal5Bb1SkjyrEOwbkVo2lEhmb8BA+yPOgYdwySvJpy9J6LBeJjM
14Jys7P6ufYC8r52PPTmmFp9zyfre2EhbVg3sYSHAEWucWRbLwQJk8LUq4Pw
mWvIgaD2TIDmey7eNs2qD00uMlMbKVyyfgCchbQ/1LQHyH5ciPy+HFnH7SP5
DGLpwcXOH5dzcLtvk0/oAh4Wq/cn2A30wk9U5miymYedoxWVSSm9UNej9t09
zsO31YMXKBd6cXNOPAz4UhSh00vy5OHJOu/NWa97YKV0pP53juQ8wb9cZ9qD
ieB2GXelIVSzvi2xvNqN3Z96ryvtHkLApfDv2oe7MCSTftrLcwiJ/p888vZ0
kfyHQG+9P0hLfA/DwbAdp+uHMPbTCxOPwk4yHx+Bjzf8rD7cARvd+yzXrXxo
aXf1fZTrgEO0m8R8fLFIXONk2E7y5cPs0YTVReV3eLODF+9bz0eszfIwa0Er
ZOnmD/VkBdBYzbC/H9mCKUqMQvlOAUr1VfVnjjUj6UjsZfgI4Bd5vV1WrQkZ
6bMSgH9zesJleSPi5AbocgMCnCjeZlae14AFimsvndAcRlGxPy380RvE5zvE
5TtI3r2q1YHKrcfK2fGNHgZVeLJN3rwepfwDXoFvh3HxaIWoP4gNrfIrspMq
QkRNOp9b2F0HoVp1UfghIVYwurSOra/D3DhFCOE+MvlXe8RrmLP3aRk0C9G1
tTg6uaMWc+OuKoJb892TJa61KGpZ8ST2uAhVDYIBhWoWlnbsl3xJIuiNplpl
7GVhvXX/6mVDIvQ+u2Uyms3EU6Gv1YHNYnQUSGuUGTORyAuQWAzL1HO7ztXX
4KCwSmIx1IINNSP21oBipcNzUyHQ8oe9o3wtA0aNFssOGI3ipqpFSqpTBZzs
FCJH9nzAg5nzQwHWJch2LgkcF4zD5Xl4uu6tAvK9PuMhO0Y2qjuH7D8NxumF
+v09aUjL1POopUubanNHlrpt/wf/Ae9B/EU=
            "]]}, {
           Hue[0.8503398874989481, 0.6, 0.6], 
           Directive[
            PointSize[0.008333333333333333], 
            AbsoluteThickness[1.6], 
            Opacity[0.8], 
            Dashing[{Small, Small}], 
            Thickness[0.01], 
            GrayLevel[0]], 
           Line[CompressedData["
1:eJwtU3s0lGkcVoxGcaSZNJha2pBsG1ZbVuuRcmtXJ45qJ1SS0kWz1GpRe7Zy
ppSz7aojyYTdXEJuRY2V3BmVXGKRalhjbt/3jQrDnmp3zH7Ped7z/vV7n9/z
vL+fzT5+UORcPT29Hdoze2dcn8VtFPCv90Q6q2F5a6OWhTi7O7fA+jM1Vpbm
1AjeFsKz70DcuJ0andX17JniIjAXsG8+tFaD2xqjZTGW+r0x6LVQY+nzjVre
Qa7zLt/tLDWW6VACoYbIO2OsBvOTU+P180rBtte4sxlq6OlQBlebuvcrP1BI
WujFtEkqg9g+kLt6goKZDuVI457cMk9FIS3RMlyUX44g++zksmEKqSv8tayA
iYu4jddPIWpNzsOkqQr0Jz+wa39Mge1eznIvv4s+06YU/QYKiewS3+GEewg/
VXThzl0K23WoxLBj/qpdeRT22yzgtXlVQTHHMPTwNQo+S8JOdHnfh7dJXvj0
BQocQbiWDzD9vTgm/wSF//MTwSJw0OpUOEXnVQ23pqB1q7ZQdD41sODalnY4
U3QetfhyOWPDDnOK9l8HYYTnVIKGpP3WQxxPBI/1kLS/Bljap2/uLCJpP40I
i27+WJFI0v03Y3JBXGOVN0n324rTeTFn/Q1Iuj8xYgyPTuysJOh+niAuhRMR
EETQ+p3gzQ9p2duvovW6sfX+gHftehX9fi86b1wM5oQo6fcG4DT5Lm/5YgVd
L4F/Q1G3vrEM8SbStVf/kmC1xSBr3ZkxxOoEh2GQm1iW1S9FT/csRtD39mWd
xkxK14/CLOTgoatWo7SeFNmLORXVvSO4H/2iKvrFGDz+PGR9bu4wkkfWxAoY
MuSUG23SPJLgBFkX6u4kQ1Mfz1IqkIDrYDlyOUQGsqSFgLcE53WQYcWtkMxl
cyTwSjQibe/J8DRVb23l0dfwMw3uODYswyL/CZeL0leY+nlA/4CpHOt3Vhfo
+7yCx7TknKmHHN9pft/mkPwScv3CCH60HMrXzMiJqiHtnAm1lKPt0p5L40ZD
+GIsxS2iQ45c07Btr11e0P4U+JX9W/hi/iC+tbsi3u+iwBCxfA+XPwBeWqSW
CsQbmnxghfbT+SrAEVoohZo+PHOTZR7vUGBXrdW0h1cfDDK8sh0MlKCCe5gL
Oc/xnn3NuP4rJYY4K82lj7qQE5z+I2KVeOT8xlVg14WiwlkowTKWWR6I6sQN
5mgGc1QJ0cVm/nzHTjBM7H/Ys0yFnxzMuyeIDmRW8m5U8lSQUwFjLn4dsNJu
m1maCuaOh51MGp+iVhHAT+hRYfC44Fnj1BNY15820JgRMI866efs+QQEp1n0
SyCB240alXvxY+jGKZVA1PveqWTzx/B66m/9+XMCLb1tJfdS2qEb1yUkjmli
s7iMdoh6LW6nh5AQHTGayT4oxqLBb7QrTcKIkSq8NdYGxy1/f8qSk2Dk1Fz+
w60Nd4jjfgFOFNJFPWVvX7XipixeSwpDWZcEKb6t2Eo0aUnh7N6oC1+3toDt
ZyuLNFMj1PuoMDewBa5dm1kBrm8wU238r8KwAWE7jK+O+7zDhtZom8q4GpTu
fpgwqZxEXZzTviy9Kvq/ZlBguylxxK6M1v+I4Kq1pgEtecgvdjjSnjHXM8l+
4p8r05n4DwL1ihY=
            "]]}}}, {}}, {{}, {{{
           Directive[
            PointSize[0.007333333333333334], 
            AbsoluteThickness[1.6], 
            RGBColor[0, 0, 1], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FilledSmallCircle], FontSize -> 8], {0., 
             0.}], CompressedData["
1:eJw1U2tMk2cYLSgCat0KdYBzCiiMW2QxkowxPFyGgqQkONDgRAYDRTK5u8il
CI7CzCZsBhkCDmWwcStQ7vdYyqWAZCDlsiELQ6CFtt/XgtMBYe6z+3pynh9P
8l7OOe/zWoTFnI3YwWAwfKnSoUqXqsL7b1AJc1tLkd2fJA6UuVOsQnyhafml
YRI2dY+6staq8M+p7MKtHhJjHUL2Rk01zE+KahntJA4OxlGsQWhq9Tf8RhLv
Sdwp8qHbcbD4OtUf0qAWObEXVKV1JAwOp6qE+nUYyrnj1lVLgqFBPQK9RvJW
qkhkvu1hYJFZD+a28cWaChIsDQSw0R+QxJaRyE85ENr+qwCjEhZft5TE3aM+
FBtwMtGdO1JMItLxUXfmywaczXnGB9WzXQTGLoJGdDO2ZJJ7JFLYtaf/Sm7C
nZLGtTaqD9SgGcyLex7q5ZAIt9gTJPZogdneIiIsm8Qpk+DEca9WjFrzlzoz
SJhmhVJsg5Nz7oPhVBL/59cO2+McuU+CNq8O8DuTqjyjtfl0oSk6v7w+QptH
D9gBV8Tfhmj9P4YhV3TeL1DrVwgZwVk+7q3114vwfTGi/a5aPyK4e77eaWKv
1d8Pgb0b4WSi1TuI9F21emO6Wn1DYN5OceDKCFrPE/TiZpPRKEHfPwbeUICw
ooyg73sKlWfbs4QEgj5/ElFNjo0Lxwj6vN8hfLpspRAr6f3z2P2qVc0OUdLr
l6AKjl1vTFOg9dpsy7XZZVim6rqwpuWYuf2Aogy3TLh6VwdWUV31BqtYsEiS
8LxWUGSwWGiwuIpLD3/4W3h4BXrM96+HHJKDemzO1oQMxc1BRc1Bcgxtzuc2
35fhXWoaWPlyjG1mFMS5ydCzwolJnpCDCSvJxpwU5kLuzlcsBaLTpt7q+04K
hWl/e46/AjwBz1zfSgqN3bsKzMjqoo4IluEx6mN+TKKA61d261dtlqGJ00QJ
/03H7Q+zl9A+aVZZ8JkSYh8/458lizD6w5caOSW2uyq9eYLnsD/z/IixTInP
t0tEqUkL4CsSvDkfEPjSlmkJg3n8JE2iSODomcg2YuIJ/BR9FAm4Bs8JZqxH
wPa2kkawSMTNT8ZfsR5GiAYkXKOcu284DKEgMerQIvVvNgJc6g3Pien8VUiV
2qlsKgZxs9yNH2KrwscbL2bydQaxv6v41o+fqpA+N7Vj4twAxv0zHGvTVKjJ
mjaYbumn81fhcq5r5BdG/UhiLjnlTavwkce6dU1yH/oWd4fF66mRXlqSv1cp
wonxT4w5J9TIk6f/G3hBhHcavuc5hKuRu/aL0/wuEfzN7lFU47Qjt1dxoxfx
moFTw5nI2zf1WkjrfYHHSkOj2blOej5eImvpt1Y932ZazyYKunQu93xdR69n
uJWfV4m9SsvxH4pTPvE=
            "]]}, {
           Directive[
            PointSize[0.007333333333333334], 
            AbsoluteThickness[1.6], 
            RGBColor[0., 0.6, 0.], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FilledSmallCircle], FontSize -> 8], {0., 
             0.}], CompressedData["
1:eJw1U3lQ1GUY3gJkMYxomQERERiNOEQQGUCOB7dALEoFdEJD5BKdcaVFmIiV
DZLDFElhRONQGVHORZEbZd3llBEXArQ2lVjY+/ohAQmD1brz45nn++c73vd5
nnk/+7jk8EQDCoWyV7fe0633KaswDDp/87nQa6AM5EaQ0ps2nvvNbdTXvcMy
2KymtY3DjWhnvGhjvFjE5MsU6raJFvL+PNr62itusR4gxWaQaTP4GodrM0xP
JPHJ81k8X2Pxu+1MPyyjU38LttTg1SbigAttGPSne+zcJtTwKFFcPdc+jM17
inRUo2osTeB/5ynUVv2dhfvVMFeadTHTBbDjZxr+Y66GU2yxwybRCLiKr5Iz
xlWIsH1FvXB+FBtiO6vNS1TooAf3iD2fobw1qqw1SoX0Blfx5mohjNY5psXY
qsDJ6wsoCXyJMqq4lCpWYmN00Wzd/CTpV4lbuZMLDewpVEZeS0eKEu3RxxvH
Q0VYsbhqyt+pxBuWv3GtVgTDUvpNJ0MlaoUGHN6laYz4yspPCxQwmJd7XqTN
oPTXd1CgJrzZ+FD2DKJKEnVUgEtrPmIqmUHYJ8VDCdsVKE5u6/QIEJN5KTBo
v9B0pU4MT2mBb7xAjnfqKAYS/PFzhY5yEBkHHz1yk0BuUBefzJAjRHoZVukS
BL6ZOmsWKMftHedW7DokWMwSGhwzk2NBFUv/a1aCULNIwSmRDOtOXjnK9JGC
zjLRbGmRwXZwZcgoUop8PWRYX6wqHiqRwsbJevqXwzKcjNi7pOyWIlXD+9bP
XQbuPk49oZBiLsr7msMNCdIeMBPjfeTIrklNGAkSoy/c2/kLGwV63U11nEF4
72VrzRMF7N7Kd2NZhH/vs+bu7VOiT7w2LsVIBHZAmHwDV4kfbwdxYpymsKPn
cceIpYrMYwpC6cB8zhYVmacQbsZJr1y/VOOAHs9gW1oQULikRpF+gMYwHBf3
N5OhId+PYqDnLcO/XwP9eDKHoZ7j/emyRkvWG0KY439Z8zu1CNEP6CDUrhdT
PjumJev3o2KMv4x8LSz8mmh+Tb1wT0irl1VpyX494FwvnvTmamGuBx+fn3U0
HpjQkv15MF9/8HWIVAtbPbhY6i+KcV3SknoewvXDJLaXMYFP71Y+zJvrQtro
x/t9aQSprxM1VrJkuj0Bq7xYHTuQyxW5VDsTpN52mNzgfd3nRSDB/oOox/Q2
xE2OZo8FEKT+VrTwPCZPBBNgWTTuFmW0wGtHesrRMIL004xlh8qtsnACx7dV
ducs3gdl63cF3x8iSH/38dPNNrtTsQRKWNa6H9aE59MRlIIkgvTbhMBk5/DY
kwRyPqJT7XPu4fqp5gtnmATp/x6GYNctOE2AuunMLN/4LthV50zr0wkyj0bc
kVj/4JlJYOPELh05oMjdY45kEWQ+DeCZ5FJ9cgiMdvEtlhrqEcqYFrPzV/Oq
w67MJ+VuFwhYV+3SsQ7b3Y3YSYWr+dWC3tWvML9E4H+Ye1V2
            "]]}, {
           Directive[
            PointSize[0.007333333333333334], 
            AbsoluteThickness[1.6], 
            RGBColor[0.5, 0, 0.5], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FilledSmallCircle], FontSize -> 8], {0., 
             0.}], CompressedData["
1:eJw1k3s01GkYxxmUimoq0WWmi7SLttAV1bdTWKl0lK6KjJQVyYRNNynHRqWt
VmqoxRqMGNRIJJmaWEMjl1yaGWaQufLTTYm0ozP7PZ/nj+d933+e53zeebSQ
bf56Ojo63prS1RRJ5//or1tfx03YW5YM7cE6ztdv4dFMJu7ljOYrLm4enOx5
hY3iYOHDYOEAPNO/f7H4xNG+/win57SmooFS0GdXhc6ueoeT8Pro6MDV3vfD
ILOx1DjwBUz3h9U7m/Yid8X3fAc6H+tfbpy7uEmNcFmcLEi3Bgs2XtegxsLK
OXYNJ2qgNntRkuChhmGq9YLjqMVc7hn9z2Q1XAI5Sx501qJcsSXkZKMKpFOb
M5Ylv8Qs35Is8k0VJJ0CeiVFgJSiPclFe1SwQOeuXKkABsY/hftQVRh+WciS
iOuQbNjNMOxWIsG+rjUp6JV2XiVypMufFfW+QprnrROgK7G6S246hdKI4WlJ
RlwHJTLyjUlmZU3QZ6xPtdRXgucQEJed8hp19rKU4wIFVvwzGGEhagbj9mgU
qJdUR9sub8Wem/4aFLhGolpPsG/D5oU3qg/aKSCJsm4rJL/R7kuB7tk01iwT
IZb2XLb3E8hBqbea+4YjRGvcHQ1yLGpi9FCyRJDr5fiFBMsxPs/39jVPMdZ+
kVyYtFaOdBsTw5+/ijFwrk3v0CQ5+BTzyt032uE6yVNwVCqDyxaBX5ZdB9af
GtdrwZEhPEG3TSXuwB8/IsOTkgZnio0Esy1ndl71kiF7SCdjRagEYb0V+xxt
ZGgVbve5cE+CuM4l9FgDGRzJLU6RgxKtHz0IU/IPR1Kl8Iqd2Npb2IP0LKF6
vo8UOTxPmpXtWyyrW8ALoXRhRn+11E7ShRNjjL9N3deNQGtWXsbDTuygFR74
tPctom3jLnzOkyIjncd9tLgHLxqpu3S5EpA2JScVmMtgUpZyPmm7BMN6DarV
pnLt/iRI6H4/pyFEgVthgdRudgeGT0e7NI9VwudHOsBr3jPzbawS01wtZP7k
DtSaR9n0i5RwV/M0tIN9+NOQiqTCXVmkhnaIRse1VCFPfdx1i007Irr4lcdo
Kli7dZlPlYtRZJVSzMtQYcqbTQFL0sRwHZNZQdSqUPJ6BuuWlxhXeoSJx4ZU
Wv/F6NwQUTNkodb6L8K5v0Ol61zVWv9FuHjHMszbT631XwTq02JF3Vm1dv8t
yDkX0DjysRcFNvc8eGmNuOk+oqsI7wOvezyNblCPeUd9+zc86kPz9BKBvpEA
iYkLmanCPq3vfFBbYuNDR/rgfcDRP3vHv6ilqx+ITQkkdK3SUInBsRktkYsJ
7B8hO0TTeZg+BjE1awhQmMJdO4lnGHA9NpnhRmB6VykzKo2LyMGCd8d3Eqj3
iF7CPluB+G/+n7t9CRjsZnwwHymHMTuztTyYQGKjh/uv9k/wIt/5i34EAZLT
Edo25mPM33qdffs0of1fpWC+j4hpPE/A/qp0deyHRxid7u4lAktXetdz+MU4
0/rF3voqgYq197NR9hDVvTExJn8RCGWe0uPzimCfFXSEyiBAf152+YKUg4Ou
jl6/3CFgHT6lxWgyB6tirJafSiUwleau4QEC5gedOMkkkJVreYTPuI+R9He2
zpkEyjzDRPwPhXC6FCQbYhFgH1pUMWt3Ibi27b85swkEGqUdSK0sgCJ9ohn5
PoGJoYmWB9YWgBR/dq8dh8BKF+dlpDP5+DPPc02spt8fvDUw9jIb190uGfcX
EyB7bY8cZOVhoK1vwutSQutDLlj15bXxjwnUrrSkmI3PhUvUjllxTwgsjnKs
qnK7hx1tvzv3PyUwbhx/96HEHEhr83t0uARu3CVX2ylYsHI28I1+RuA/PDvx
IQ==
            "]]}, {
           Directive[
            PointSize[0.007333333333333334], 
            AbsoluteThickness[1.6], 
            RGBColor[1, 0, 0], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FilledSmallCircle], FontSize -> 8], {0., 
             0.}], CompressedData["
1:eJw1VHs0lHkYRpymq4SUSqZCtqKbc0I8Q7kUulh1DpJQ2CIWKZc2u1mWYzmL
FEm1aTG555IyaihMmIbcpcaEMWNmPmxCtdvO2G+e87x//M7v/L73eZ73PR/V
O8j57AIFBQVPaSlKS0laWZkyFCDL+0uV0zsC2rlWUtLB7BjVEzUT2FJyrzZu
io7Bb/2d39cR4DxhaswVPsTbem58cA2BdU0/SlmIA131uFpBYH2nlZRFCFg0
d9fvEQGdeRSj0egYw6SUAGVD9ARzYQnCE4RFPxcRUJhHKRjpeZkDdAKxK6wp
1NhSGO3p+SH3AQG1eZRh2sbanS09Z0Rpe9XklSGg3NbiwH0CqZsPSlkO04rm
8Lo7BPyN7zFiP5WD9ZmbUplJQMO8TN287BEyvnqzjDMIRGkU2w1FVsCbbcv0
TSNwfB6V+CvgvE5WEoEz1CWuzdZVWPSs8/WtRAK2Wh5h7TbVSL58h9MbS2B1
nJeUj3HSwoARFE3g//xqkE/xKOkOl+f1BGYlZQ4uQfJ8alHbYhNt4CvPow60
4yHmVC+5/+ewyLnmcslZ7peJxT5LrJYfkvurR65IW3ufqdxPA7y041J+M5Tr
f4nrw2lbklfJ9TZh1yT16cg/ElIfC9E/rabu65eQelpxWqlaMlogIftzQB3k
faTYS8h+HbDZaOfE9hGT3+/C3AXuF4pACE6w88xIWRdSG8z8E/KFiJaNQ60b
7QE7nZUuCuHot/P2y7BuPA9mbmuyFKI6cKAqcKAbnbvpc1pGQlJfD7YFnqpP
FglgHbVIrFfRgwC6osdytgBTJz6Z5ur3IktXaKlQIEBvwm0ZsWaK17MxWgDt
NTL0YTifFSFyEZD++vBHjmqt3SYB6YeLc+oGM+YafEQsGzFJ7+GiTzctKfvX
UYTMBzCEfGtDO0n3CN50yMAD7WrFyrZVI+T7YYga/Ho1dYdJ/yPQ9V23YvkH
HulnFL5tfyZO6w4hgWccEqfCR/Zb4qjGGBdh4ucnzXfw0W8vEheUcLHOUJuX
4s7HlGvOwkt+XMTPg49z5/rcPDdzSf98LNvFanbtfQ97VRf2hSE+EotnQ2f0
3+NTTN8CX9UxqEx9Y0ji38FylntN1XIMNi5s5VLJIMYW0H2CAscQ7OdYfER/
kMxrDDRa+xGHuLfYPZpk6sMeg1tSOs2jeoD0J0Dsm1+0rqgMwFE/jXVmlwAX
7ivWqqzsh2vGWSkFSNR2bJhQ6yPzFUCv6XYH83MPXpvys0Olc2p7JhtwN5Sz
rO8aKgsRs9eEUfZ7F75q3FjKNBMi/jvVER29TtxzuXkZIUK4PNhePJnZgYd0
GaT3Fv16N0Qc3KIMZ1GGhTBzp/lbRHOgsszgoqfOOIRXOHeTK14ju9L1VqXr
OG4W8SIVP7CxVrZuGeM4sZ+n47CBjTqBU1Dkm3F4t6hYuYW3QZd5RXlGTYS9
+jmNnBetEK1+WZN8TISCyv3d2zVbMb/eqSIIY+kPNWNaYN12UNeoUwSTCsXe
GEoL5tdTSwwGhcZafP4VarrWFNx0F0PFoytgdoKFlf0O0l+MGLzLW/cWHGdh
66EPm9THxNB8tu/S9eZmFIlC7Z12SKD5/uhswPpm5PAjpJRg0kE46c9pwmHR
CykliKN6GpvZNkHDXo9/Vo3A47DWiMa6RuxpP6DutGcS/lFDT58crYfHiaXp
E7Z/Yyj1w2HBaQZKTjEip4XTcMtypxY2VpHzmkP52vveCR9Lyf7/outaUHzo
5zzkFRqef5WlRMuwT2ldUXEH/wEnU+PZ
            "]]}, {
           Directive[
            PointSize[0.007333333333333334], 
            AbsoluteThickness[1.6], 
            Opacity[0.8], 
            RGBColor[1, 0, 1], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FilledSmallCircle], FontSize -> 8], {0., 
             0.}], CompressedData["
1:eJw1lHs01GkYx4WKE6GmpQmxRVHpgray9cVSktpNrShUQhdZueTkUoeSalfa
5JbbJmJDboU4kXEZM0LIJeQyGHMxMz8Uuogd9ud7vs8f7x/P+5zv533Oq+nk
Ye0iJSEh4SSuBeKSFFfcw1k9xW8li7/d6SZATTUROwPSh5hWgQwC63OSX4WO
ZeBhyOdnlWUEGktolC9ZmSg/EB10s5iAao2n2Fko7fk+6lhAQK3FROxnWEi1
Wz2VR0B9TtkQSB6Ij8klILM6cIS2OAdOHr9elc8mIDGnXLB2SG3/mkkgRNFU
RjMkF84R95/nphNQmlMeXMfqt/+URiA6gHq6OD0Po1fc92umEIhYu1/sfIy6
Ke0JTiRwbnNyachEPuprCpKdEghQjPKWG+U9ByvV5ubHaAIBlOx9LP8XGM+L
yqj5m8DvcypAnbHL1LcwAs6aS+wYpoWg+arFON4msFfZwafJvAjTRRFqq4IJ
qISeFvslSk+ObdQLIPA/v2IYvI6Tkvae51UCv7sOj/3d5vm8giiMOc50nudR
Bntrxr/mx+bzl6PpLHVdrNl8XhoSrivs0NKfz1eB2MVtjlsV5/NUQuntTGxl
l4jsrwKTjdTeMhEo5ofFrkJCXM97er4ITyKtLXWeVOFLq6pGbIoItYpZKfXf
qjCueFek4Ssi81fjeui0rJ6NCI2XrCfZedXYbe/1QUdNhMBZ3Ep0UFcfcY5r
E8Lq7NbEah86RBfqpo+ECFHk3lXo3kXHjxJaG7JMhCSvGrSF/uk5rS2EaYCs
UOtFDeptDRIT5YQYs5nYmarNgJ+sUX6vhBDv7ySKzcDWTe2MeJ4A1JWzYsLQ
dUbHtF1A8mUisFvBJeq1gORZhyDtitD0YwIyfyMG6z9p6XUOk7yace6+MBCG
w2S+VtBMzunm2fLJ+zrwyJNlbPEDj+zvg5mkft3EUg785NmGke194CdOCtKC
h+A1N5AFfu1ZP/UPbLxrnlU/mp2kpjZR2GT/IFiLAq+paA6S89gQ+nw9up7d
T/IZwrJDSxw/rWDhTv9mr9CFHCxRHUi0GeyDj7Dc3mgLB7tGKyqTU/ugqkPt
v3eCg+9rhi5SLvbh1pw4GPSmyEOrj+TJwdP1nluy3/TCQuFowx8s8XmCd6XO
uBcTQR1SrgpcVDO/LzUP7sGez303FPZw4Xc5fEHHcDe4UhlnPNy5SPL97Ja/
t5vkz0Vc24OhwKQP0B8K23mmgYuxn18auRV1kfl48H+y8RfV4U5YaT9gOm/j
QUOzu/+TTCfsol3E5uGrWdJaB/0Oki8PJo8nLC4pvsfbnZwE7wYeYq1WhFny
2yAdZ/pIR5oPtTV02weRrZiixMjRdvFRpqusO3O8BclHY6/Aiw+fyBsd0irN
yMyYFR+8W9MTTiuaEC8zGCczyMfJku0mtPxGLJRfd/mk+jCKS3wDwx+/RUKB
XXyBnfjdq9rsqOwGrJpd3+hhUAWn2mVNG1DGO+jh/24Yl45VCAcC6qFBuyo9
qSRA1KTj+UU9dRCoVBeHHxZgJb1b4/iGOsytU4QAriOTf3VEvIFp/X4NvRYB
ureVRKd01mJu3ZWFcGm5d6rUuRbFrSufxp4QoqqRPyhXzcSyzgPiL0kIndE0
i8x9TGywHFiznCtE3/PbRqM5DDwTeFsc3CJCZ6GkWrkhA0kcP7FFME87v/t8
Qw0OCarEFkElSF89Yl8NKBZaHBclAq3XbO1la+kwaDJbftBgFLeUzVLTHCrg
YCMXObL3Ix7OXOD6WZYix7HUf5w/DqcX4RnatwvJ9/qCR/Ux0lE9ueT8adDP
LNId6E1HepaOW22cpLEme2SZy45/8B8D4PxH
            "]]}, {}}}, {}}, {{}, {{{
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[1.6], 
            RGBColor[0, 0, 1], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FivePointedStar], FontSize -> 14], {0., 
             0.}], {{{0.9433962264150942, 0.5}}, {{0.9433962264150942, 
            0.5}}}]}, {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[1.6], 
            RGBColor[0., 0.6, 0.], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FivePointedStar], FontSize -> 14], {0., 
             0.}], {{{0.8620689655172414, 0.3312923333333333}}, {{
            0.8620689655172414, 0.3312923333333333}}}]}, {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[1.6], 
            RGBColor[0.5, 0, 0.5], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FivePointedStar], FontSize -> 14], {0., 
             0.}], {{{0.5102040816326531, 0.75}}, {{0.5102040816326531, 
            0.75}}}]}, {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[1.6], 
            RGBColor[1, 0, 0], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FivePointedStar], FontSize -> 14], {0., 
             0.}], {{{0.3333333333333333, 0.8333333333333333}}, {{
            0.3333333333333333, 0.8333333333333333}}}]}, {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[1.6], 
            Opacity[0.8], 
            RGBColor[1, 0, 1], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FivePointedStar], FontSize -> 14], {0., 
             0.}], {{{0.1724137931034483, 0.9166666666666666}}, {{
            0.1724137931034483, 0.9166666666666666}}}]}, {
           Directive[
            PointSize[0.012833333333333334`], 
            AbsoluteThickness[1.6], 
            GrayLevel[0], 
            AbsolutePointSize[6]], 
           GeometricTransformation[
            Inset[
             Style[$CellContext`\[FivePointedStar], FontSize -> 14], {0., 
             0.}], {{{0.819672131147541, 0.31666666666666665`}}, {{
            0.819672131147541, 0.31666666666666665`}}}]}, {}}}, {}}}, {
      DisplayFunction -> Identity, PlotRangePadding -> {{0, 0}, {0, 0}}, 
       AxesOrigin -> {0.04705, 0}, PlotRange -> {{0.04, 1.45}, {0, 1.1}}, 
       DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
       Axes -> {True, True}, AxesLabel -> {None, None}, 
       AxesOrigin -> {0.04705, 0}, DisplayFunction :> Identity, Epilog -> {
         Text[
          Style[
          "\!\(\*SubscriptBox[OverscriptBox[\(J\), \(_\)], \(eff, c\)]\)", 
           Bold], {0.3, 0.35}]}, Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{
         "\!\(\*SubscriptBox[OverscriptBox[\(J\), \(_\)], \(eff\)]\)/3", 
          None}, {"T", None}}, FrameStyle -> Directive[
         GrayLevel[0], 12], 
       FrameTicks -> {{Automatic, Automatic}, {
         Automatic, {{
           0.1724137931034483, "\!\(\*SubscriptBox[\(T\), \(I\)]\)", 0.01}, {
            Rational[1, 3], "\!\(\*SubscriptBox[\(T\), \(O\)]\)", 0.01}, {
           0.5102040816326531, "\!\(\*SubscriptBox[\(T\), \(T\)]\)", 0.01}, {
           0.7692307692307692, "\!\(\*SubscriptBox[\(T\), \(chi\)]\)", 0}, {
           0.819672131147541, Null, 0.01}, {
           0.8771929824561404, 
            "\!\(\*SubscriptBox[\(T\), \(D\[Infinity]\)]\)", 0}, {
           0.8620689655172414, Null, 0.01}, {
           0.9900990099009901, "\!\(\*SubscriptBox[\(T\), \(D2\)]\)", 0}, {
           0.9433962264150942, Null, 0.01}}}}, GridLines -> {None, None}, 
       GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], Method -> {}, 
       PlotRange -> {{0.04, 1.45}, {0, 1.1}}, PlotRangeClipping -> True, 
       PlotRangePadding -> {{0, 0}, {0, 0}}, 
       Ticks -> {Automatic, Automatic}}], 
     Placed[
      Unevaluated[
       LineLegend[{
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          RGBColor[0., 0.6, 0.]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          RGBColor[0.5, 0, 0.5]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          Opacity[0.5], 
          RGBColor[1, 0, 1]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          Opacity[0.8], 
          Dashing[{Small, Small}], 
          Thickness[0.01], 
          GrayLevel[0]]}, {
        "\!\(\*SubscriptBox[\(D\), \(2\)]\)", 
         "\!\(\*SubscriptBox[\(D\), \(\[Infinity]\)]\)", "T", "O", "I", 
         "SO(3)"}, 
        LegendMarkers -> {{False, Automatic}, {False, Automatic}, {
          False, Automatic}, {False, Automatic}, {False, Automatic}, {
          False, Automatic}}, Joined -> {True, True, True, True, True, True}, 
        LabelStyle -> {}, LegendLayout -> "Column"]], {Right, Top}, 
      Identity]]& ],
   AutoDelete->True,
   Editable->True,
   SelectWithContents->False,
   Selectable->True], TraditionalForm]], "Output",
 CellChangeTimes->{
  3.6596397775428057`*^9, {3.659639867458597*^9, 3.659639882039806*^9}, {
   3.659640006822441*^9, 3.6596400318219624`*^9}, 3.659640073006428*^9, {
   3.659640218652749*^9, 3.659640259993053*^9}, 3.659642025825079*^9, 
   3.6596450658949003`*^9, 3.659645133291379*^9, {3.65964519697369*^9, 
   3.659645254583762*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{
   RowBox[{"Show", "[", "plotJeffL", "]"}], "\[IndentingNewLine]", 
   RowBox[{"Show", "[", "plotJeffP", "]"}]}]}]], "Input",
 CellChangeTimes->{{3.657281089020195*^9, 3.657281106647336*^9}, {
  3.6572826521035852`*^9, 3.657282657608506*^9}}],

Cell[BoxData[
 FormBox[
  TagBox[
   FormBox[
    GraphicsBox[{{{}, {{}, {}, 
        {RGBColor[0, 0, 1], PointSize[0.008333333333333333], 
         AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1UwtMk1cYrUykqHUr1AHOKaAwXpHFSDLG8PAYChJIcKDBiQwGimTydhEo
CI7HjBM2gwwBhzLYeLVQ3o9CLOVRQDKQ8tiQhSGPQtv/b8HpgDD30/09OTc3
X3If55z7XbPQ6LPhOgwGw5sa23Phg21UwtTaXGzzJ4kDZa4UqxBXaFx+aZCE
Ve1jYdZqFf45lV242UVipF3EWa+phulJMZ/RRuJgfyzFGoRwq7/lNZB4X+pK
kQed9oPF16n6kAZ85MRcUJXWkmAe5qpEerUYyLnrIuSTYGhQhwCPobzlKhIZ
77gxzTLqwNoyvFhTQYKtgQBWen3SmDIS+ckHQtp+FWBYyubplJK4d9SLYj1O
JrimDBWTiLB/3Jnxqh5nc57zQNUcJ4Ghk6ABnYxNmfQ+iWQO//RfSY24W9Kw
2krVARo0gXVxzyPdHBJhZnsCJW7NMNlbRIRmkzhlFJQw6tGCYUveQkc6CeOs
EIqtcHDMfTjIJfF/fm2wPu4j94rX5tUOXkdilXuUNh8hGqPyy+vCtXl0geN/
RXInWOv/CfRTxOd9A7R+RZARPovHPbX+uhG2L1q831nrRwxX9zc7jWy1+nsh
sHUhHIy0evuRtouvO6Kj1TcA1u1kuxQZQet5im7cbDQYJuj7R5A54C+qKCPo
+55B5d76PD6eoM8fR2SjfcPcMYI+73eIni1aKCRKev8sdr9uUXOClfT6BaiC
YtYaUhVouTbdfG16EeZcHSf2pBxTtx9SlOGWUYru1b4VVFdtYwVzZonSTI9l
FDHnC5nzK7j06Ie/RYeXocv64HrwITmox/bZHJOhuCmwqClQjoGN2dymBzK8
R3UDO1+OkY30glgXGbqWfaKTxuRgwUK6PrMEU1HKztdsBaJSJ97u+W4JCuPe
thw/BTIFmaZ6FkvQ2L2nwJSsNvKIYBFuw16mx6QKOH9ts3bVahGaOI2U8Nuw
3/ooewFt4yaVBZ8rIfHyNfxZOg+DP7ypllNiS1jpmSl4AdszL44YypT4YqtE
zE2cA08R7+nzIYGvrFnmYM7ip6VEigSOnoloJcaewlfRQ5GAc9CMYMpyCBxP
i6VwNonY2fG4K5aDCNaAhHOkY+cNuwEUJEQemqf+zbq/U53+OQmdvwrcJRuV
VUU/bpa78IKtVfhk/eVU/o5+7BcW3/rxMxXSZibeGjvXh1G/dHt+qgo1WZPM
yeZeOn8VLuc6R3xp0ItE1oJD3qQKH7utWdYk9aBnfndonK4aaaUl+XuVYpwY
/dTQ54QaefK0fwMuiPFu/feZdmFq5K7+4jC7Sww/k/sU1Thtn9KtuNGNOE3D
qeFI5O2beCOi9b7EE6W+wfRMB90fr5C18FuLrncTrWcDBcIdl7u+qaXXM1zK
z6skHqXl+A94/z7v
          "]]}, 
        {RGBColor[0, 1, 0], PointSize[0.008333333333333333], 
         AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1Uwkw3Gcc3SlipVJVZoiIa5KqI0IwiOOxLZFWmwTJVFIRVyQzjq4wVRtb
GkRDNGEiqSNhQtzivhKbXWdMBEW0mlDL3rv2L4qGkbZr+8+b98038x2/7703
v880LM4/8j0KhXJMMbbn/6Hqea10esZxsAjkgqfESWcy4+sK1NZsYxNMRtPO
hpEGdMS8bI95uY65V/HUg1Ot5PlVtPd3lNxnPEK84RDdcOg1zlQna16M4pD7
y5jeofub0eIA9IITfvXWW8KsMXHSSmcEtOdHTWymZLArEN/O6hjBvqN5CspQ
PpE46vbgOWT6A125J2TQlmh105NGYcJJUf1bWwaL0HwzY+4YWOIv45InpQgw
mqVmXxvHntCuSu0CKTpp3r08+xcobgsqaguSIqnOmrevcgZqu8wTQ4ykqM/s
dy/weIUiKq+QypNgb3Decs3qHOlXgvsZc2t1zHmUBd5JQrwEHcEXGiZ9udjS
va3JOSzBG4aberWcC9VCWqmFqgTVMyr17BsLGHMRFl8aFUNlVWR/XWcRhb9s
Q4wq/xb102mLCCqIVFAMlk7LWU3+Ivw+zh+OOCRGflx7l507j8xLjCHTtaZb
NTzYC3JcwkdF2FZHUeHj959KFBSBSD715IkNHyKVmvC4GBF8BDehn8SHx5v5
K1oeIlQ4ZG2ZdPKxnjqjcl5LhDVpKO3PZT58tQJHY7lC7Iq+dY7uLACNobG0
v1UIo6GtYbVAAa4qIcTufGn+cIEAhhYGCz+fESI64NiGpEeAhCX2N662QrCO
19cSYgFWgpzumN3jI/ERPTLcWYS0qoSIMU8e+v2dLD83FKPPVlPBRfj33TRY
eiaGyVvREWxy8U8zY6XxuAT9vJ1h8WpcMN39RHtYEvxQ4VkfYjEPh96nnWN6
UjKPecwIBlfT90vJPGdgox41a/2FDCeVeAGjwhz33A0Z8pQNNIGRsLC/6DFL
5P1xDPa+jXEbWIKyPekjkK2w/7DaISfrDcPP/N/U1cNy+CgbdAgy6+vxn56X
k/UHUDLB2cRVOXRdm3Rcm/pgG5FYKyyXk+/1ov5u/pwTSw5tJTj47Iq5+uCU
nHyfDe3dp177COQwUoKFjYG8EOsNOannMaw/iGI6qhP45GHZ48yVbiSOf3TC
RYcg9XWhSl8YRzMloJ8ZqmAnMlhcq0pLgtTbAY177K/6HQlEmL4f9JTWjrC5
8bQJd4LU34ZWtt3cRW8CDN2GI9zkVjg6JMWf8yNIPy3YNCs7IPQncOFgWU/6
ejMoB77N+e40Qfprxo+l7SaxoQQKGAaKH9aE6YUASk4UQfptgkecpX9oNIH0
D2lU0/RG3I1tyb5MJ0j/jRiGSc/oJQJU48vLHPWHYJZnadYmEWQeDXjAN/je
PoXA3ikvBetBEdmGnE0lyHzqwNbIoDqnExjv5uhu1NXCN2aBx7z6Lq8aeKU8
K7bJJmBQ7qVgDQ7ZqjGjct/lVw1a94BY+waB/wCGl1V0
          "]]}, 
        {RGBColor[0.5, 0, 0.5], PointSize[0.008333333333333333], 
         AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJwtk3s01GkYxxl0pZpuKo0u0i5at66ovp1qrO5HqUiFkWpFMi6bVBLHpou2
WinUYo1bDGokkkwN1jSNRC7NDDNM5spPNxFpRzvf83nPe973ff55nvN5F9CC
dvqRdHR0DmrW6P5/9Netr2cn7KtIgfZiHevrt7BoBgP38kbzFRe2Dk5xu8JE
aaDgYaCgH24Z3wfMP7O09Z+w8TmtqaS/HPS5tcFza9/jFDw/OTmyte99MMhq
LDfyr4bxgdAGqnEP8ld8L3Skc7H+5ab51k1qhMniZQG6L7Bo03UNaiyumWf/
+uQLqGdVlyW4qjEuzWpRCHiYzz6j/4WshrM/y+ZBJw+Vim1BpxpVIEVuzVyW
8hImPmXZ5JsqiDv59BoKH6klHiklHiqYo3NvvoQPA6OfwrxMVRh+WZwrFtUj
ZZw0eZxUiQSH+takgFfafpXIkyx/VtLzCulut06CrsTqLrnxVEojhqcnGbId
lcgsNCLNqmiCfvL6NAt9JTiOR+NzUt+g3kGWGsJXYMU/g+HmwmYk3x6NAg3i
umi75a3wuOmnQYFrJFOriQ5t2Lr4Rt0hewXEUVZtxeS32nkpIJ1LyzWZIcDS
7ssOvnw5KA2W89+yBGiNv6NBjiVNyd2UbCHkenm+QYFyTCjwuX3NTYS1A+KY
yWvlyLCdMe7nryL0n2vTOzxZDi7FrMb9RjtcJrvxj0tkcN7G982278D6yPE9
5iwZwhJ021SiDvzxIzI8KXtNpdiKMddiTudVTxlyhnQyVwSLEdpTtd/JVoZW
wS6vmHtixHfa0OMMZHAit2yMGBRr/ehGqJJ7JMJUAs+4Sa09xd3IyBaoF3pJ
kMdxo1navcOy+kWcIEoXZvfVSezFXTg5xujbtP1S+FvlFmQ+7MRuWrH3533v
EG0XH/OlQILMDA77kXU3qhtN9+qyxSBtSUkqMpNhRkXq+aRdYgzrvVatNpZr
5ydGgvTDvNdBCtwK9TeVMjswfDrauXmsEl4/0gFOs8ecd3FKTHcxl/mRO8Az
i7LtEyqxXc3R0A7mkc9DKpIKd2URGtohHG3XQoUCdYjLNtt2hHdxa07QVLDa
3GU2TS5CiWVqKSdThalvtxy1SRfBZUxWFcFToezN7NxbniJc6RYknhhSaf0X
oXND+Ishc7XWfyHO/R0sWeei1vovxIU7FqEHfdVa/4UwfVqqqD+r1s6/BXnn
jjaOfOpBke09V056I25uH9FVhPWCI51Aoxs0YMFxn74Nj3rRPLOMr2/IR2Li
YkaaoFfrOxemLXEXg0d6cdDbyS9n97/g0dUPRMYEErpWaajB4NjMlghrAgdG
yI7RdA5mjkHsizUEKAzB3j3EM/S7nJiSvJnAzK5yRlQ6GxGDRe9D9hBocI22
YZ6twsVvfl+kPgQM3JM/mo1UwoiZ1VoZSCCx0XX7rw5PUF1IHdAPJ0DaeIy2
k/EYC3dcZ94+TWj/VzkYH8JjG88TcLgqWR338RFGu7t7icDSlQcbWNxSnGkd
cLC6SqBq7f0cVDxEXU9s7Iy/CAQzIvW4nBI4ZAccM00mQH9ecTlGwsIhFyfP
X+4QsAqb2mI4hYVVsZbLI9MITKNt1/AARxcGnDzFIJCdb3GMm3wfIxnv7ahZ
BCrcQoXcj8XYeClANpRLgHl4SZWJezHYdu2/UZkE/A3TvdNqiqDImDSLfJ/A
pOBEC++1RSBdPLvPnkVgpTN1GelMIf4scFsTpzkfCNzhH3eZieubLxn1lRIg
e+6KGMwtQH9b78Q35YTWh3zkNlTyLj4mwFtpQZk1IR/OUbtN4p8QsI5yqq3d
fA+7236n9j0lMH481/1wYh4kvMJuHTaBG3fJdfaKXFhSDXyinxH4Dyg78R8=

          "]]}, 
        {RGBColor[1, 0, 0], PointSize[0.008333333333333333], 
         AbsoluteThickness[1.6], LineBox[CompressedData["
1:eJw1lAs0VHkcxxGn6SkhpZKpkK3o5ZwQ30l5FHpYdQ6SUNgiFimPNrtZlmM5
ixRJtWk98m6QMmooTJiGvKXGeIwZYy42odptZ2bvfM/3nnvuuef+f7/P9/c7
l+oV6HROSUFBwUNySe+ZGVLlI9PrS6XjewLaOfslLgCzfVRP1ERgS8n9mtjp
Agx86+v4vpYA5ylTY77wEd7VceOCqgmsa/xR4kIc7KzDNTqB9R37JS6C/6L5
e76PCejIVIwGo+MMk1IClA1Rk8yFJQiLFxb9XERAQaZSMNJyM/oLCMSssKJQ
Y0phtKf7h5yHBNRkKsOMtZUbW/KcHqntWZ1bBv9yG4uDDwikbD4kcTlM6U1h
tXcJ+BnfZ8R8KgfrMze5IoOAhnmZunnZY6R/9WIZpxOI1Ci2HYygw4ttw/RJ
JXBCpgr85X9BJzORwFnqEpcmq0oset7x5nYCARst99A26yokXbnL6YkhsDrW
U+InOGVhwAiMIvB/ftXIo7iXdIXJ83oKs5Iye+dAeT41qGm2jjLwkedRC9qJ
YHOqp5z/BSyyrztfdpLzMrHYe8n+5YflfHXIEWlr7zOV89TDUzs2+TdDef+v
cGM4dUvSKnm/jdg1RX028o+Y7I+FqJ9WU/f1icl+WnBGqUo8mi8m63NAHeB9
pNiJyXrtsN5o68j2niDP78T8Re4XikAITpDT7EhZJ1Lqzfzi84SIko5DrQtt
/judlC4J4eC7886r0C68CGJua7QUoiqgvzKgvwsduwvmtYyEZH/d2BZwui5J
JIBV5KIJPXo3/AsU3ZezBZg++ck0R78HmbpCS4V8AXri70iNNdO87o1RAmiv
kaoXw3mscJGzgOTrxR/ZqjW2mwQkDxfn1Q1mzTX4CF82YpLWzUWvbmpi1q+j
CJYFMIg8K0NbcdcI3rZLxQPtGn1l66oR8vthiOp9ezR1h0n+Eej6rFuxfIhH
8ozCp/XPhBndQcTzjINjVfjIekcc0xjjInTixSnzHXz02Ykm8ku4WGeozUt2
42PaJXvhZV8u4mTi4/z5XlePzVySn49lu1hNLj0fYKfqzL44yEdC8VzIrP4H
fIruXeCjOgaV6W8Mcdx7WM5xr6tajsHama1cKh7A2IIC78CAMQT5OhQf1R8g
8xoDjdZ21D72HXaPJpp6s8fgmphGc6/qJ/kEiHn7i9ZVlX446Keyzu4S4OID
xRqVlX1wST8nsQAJ2g71k2q9ZL4C6DXeaWd+7sYbU35WiGROrc+lA+6CcqbV
PUNlIaL3mjDKfu/EV42bS5lmQsR9pzqio9eB+863riBYCOeH24unMtrxqEAq
yXuLPr2bIg5uU4YzKcNCmLnR/CyiOFBZZnDJQ2ccwquce0n0N8iqcLld4TKO
W0W8CMUhNtZK1y19HCcP8HTsN7BRK3AMjHg7Dq9mlf2uYa3QZV5VnlUTYa9+
dgPnZQtEq19VJx0XIb/iQNd2zRbI1jtFBGFMwSPN6GZYtR7SNeoQwYSu2BNN
aYZsPbUmwKDQWIsvvEZ155r8W24TUHHv9J+bZGFln73kFzMB3pWte/NPsLD1
8NAm9bEJaD7fd/lGUxOKRCF2jjvE0PxwbM5/fROy+eESizFlL5zy4zTiiOil
xGLEUj2MzWwaoWGnxz+nRuBJaEt4Q20D9rQdVHfcMwW/yMFnT4/Vwf3k0rRJ
m78xmDJ0RHCGgZLTjIgZ4QxcM92ohQ2V5LzmUb72gVf8x1Ky/r/ovB4YF/I5
F7mFhhdeZyrR0u2SW1bQ7+I/Ey/j1w==
          "]]}, 
        {RGBColor[1, 0, 1], PointSize[0.008333333333333333], 
         AbsoluteThickness[1.6], Opacity[0.5], LineBox[CompressedData["
1:eJw1lHs01Gkcxi0qToSalibEFkWlC9rK1oOlJLWbWlGohC6ycskJ0x6VVLvS
JrfGZROxIbdCnMh1zMgIuYRcBmPMmJkfCl3EDvvznOc973n/+L7f83ze73m1
Xbxs3aSlpKRcJGt2pz+Y1RP8Wrzo6+0uAtQUM4nTIXuQZUNjEliXnfQydCwd
D0I+Pa0sJdBQXE75nJmBsv3RwTeKCKjXeEuciZLub6PO+QQ0ms0kfooFVIdV
U7kENOeUBaH0/riYHAJyq2gj5Yuy4eL1yxXFLAJSc8oBZ7vMti8ZBEKUzeW0
Q3LgGnHvWU4aAZU55cJ9jL3tx1QC0UHUU0VpuRi97LlPO5lAxJp9Eudh1ENl
99UEAmc3JZWETOSBXZOf5BJPgGKSu8wk9xk4KXY3PkQTCKJk7eUEPsd4blR6
zd8EfptTPupM3aa+hhFw1V7swDQvQLm/RozzLQJ7VJ38Gi0LMV0YobHyKgG1
0FMSv0DJibENBkEE/udXBKNXdBlZ33lexQi44/Qo0GOez0uIw1jjLNd5HqVw
tGX+a3l0Pn8ZGs9Q18ZazOctR/w1pe06hvP5KhC7qNV5i/J8nkqovJmJrewU
k/VVYHGR0lMqBsXykMRViKd3v2PkifE40tZa73EVPreoa8Umi1GrnJnM/lqF
ceU7Yi1/MZm/GtdCp+UN7MRouGg7yc2txi5Hn/d6GmLQZnGrMEBdddiV3iqC
zZktCdV+DIjP100fDhGh0LOzwLOTgR+kdNZnmolIXjVoDf3Te1pXBPMgeZHO
8xqw7Y0SEhREGLOb2JGiy0SAvElej5QI724nSMzElo1tzDi+ENQVs2LB2H1G
z7xNSPJlgdal5Bb1SkjyrEOwbkVo2lEhmb8BA+yPOgYdwySvJpy9J6LBeJjM
14Jys7P6ufYC8r52PPTmmFp9zyfre2EhbVg3sYSHAEWucWRbLwQJk8LUq4Pw
mWvIgaD2TIDmey7eNs2qD00uMlMbKVyyfgCchbQ/1LQHyH5ciPy+HFnH7SP5
DGLpwcXOH5dzcLtvk0/oAh4Wq/cn2A30wk9U5miymYedoxWVSSm9UNej9t09
zsO31YMXKBd6cXNOPAz4UhSh00vy5OHJOu/NWa97YKV0pP53juQ8wb9cZ9qD
ieB2GXelIVSzvi2xvNqN3Z96ryvtHkLApfDv2oe7MCSTftrLcwiJ/p888vZ0
kfyHQG+9P0hLfA/DwbAdp+uHMPbTCxOPwk4yHx+Bjzf8rD7cARvd+yzXrXxo
aXf1fZTrgEO0m8R8fLFIXONk2E7y5cPs0YTVReV3eLODF+9bz0eszfIwa0Er
ZOnmD/VkBdBYzbC/H9mCKUqMQvlOAUr1VfVnjjUj6UjsZfgI4Bd5vV1WrQkZ
6bMSgH9zesJleSPi5AbocgMCnCjeZlae14AFimsvndAcRlGxPy380RvE5zvE
5TtI3r2q1YHKrcfK2fGNHgZVeLJN3rwepfwDXoFvh3HxaIWoP4gNrfIrspMq
QkRNOp9b2F0HoVp1UfghIVYwurSOra/D3DhFCOE+MvlXe8RrmLP3aRk0C9G1
tTg6uaMWc+OuKoJb892TJa61KGpZ8ST2uAhVDYIBhWoWlnbsl3xJIuiNplpl
7GVhvXX/6mVDIvQ+u2Uyms3EU6Gv1YHNYnQUSGuUGTORyAuQWAzL1HO7ztXX
4KCwSmIx1IINNSP21oBipcNzUyHQ8oe9o3wtA0aNFssOGI3ipqpFSqpTBZzs
FCJH9nzAg5nzQwHWJch2LgkcF4zD5Xl4uu6tAvK9PuMhO0Y2qjuH7D8NxumF
+v09aUjL1POopUubanNHlrpt/wf/Ae9B/EU=
          "]]}, 
        {GrayLevel[0], PointSize[0.008333333333333333], AbsoluteThickness[
         1.6], Opacity[0.5], Dashing[{Small, Small}], LineBox[CompressedData["

1:eJwtU3001GkYVYxGcaSZNJhabEi2Dastq3WliDadOKqdUElKRbPUapnas5Uz
m3K2XXUkmWQ3HyEfFTVW8s1Q8hHrqxrWmK/f/EaFYY/aHbO/e+573r/e57n3
vs9jc5AbFDlfT09vj/bM3Rk35nAX+dwb3ZEualje2aRlAc7vy8m3/kyNVSXZ
Vfx3BfDqPRw/bq9GR2Utc6aoEPRFzFtPrNVgN8dqWYTlfm8NeizUWP5yk5b3
kOOyd+suhhordCiGQEPknjNWg/7JmfHaBSVgOmg8mDQ19HQohZtNzeyqDySS
FnvTbZJKIXIIZK+ZIGGmQxnS2Ke3LVCSSONZhgvzyhDkcDu5dJhE6kp/Le/D
xFXUwukjEbU2+0nS1H30JT+2b20jwfQoY3iUPUCvaUOKfh0JHrN463DiQ4Sf
Kbx47wGJXTqUY9gpb/XeXBKHbBZxWrwrIJ9nGHrsOgnfZWGnOn0ewcckN3z6
IgkWP1zLx5j+ThSbd4rE//kJYRE4YHUmnKTyqoR7Q9D61dtIKp8qWLDtStpd
SCqPanxpS9u425yk/NdAEOE1lahRUX5rIUoggse6VZS/Olg6pG/pKFRRfuoR
FtP48T5PRelvxOSi+PoKHxWltxlnc2PP+xuoKH0ixBpGT+wpJyg9zxCfwooI
CCKo/h3gLAxpOtCnpPp1Ycejfp/qDUqqfg86bl4KZoUoqHr9cJ58n2u7VE69
F8O/rrBL31iKBBPJumt/ibHGYoCx/twY4nQNh2GQwyvN6pOgu2sOI+h996pG
Yyah3o/CLOTI0WtWo1Q/CehxO+u2D47gUcxgRczgGDz/PGp9Yf4wkkfWxvFp
UmSXGW3WPBXjlKom1MNZioZejqWELwbb0XLkSogUquImAj5i/KyDFCvvhGSu
mCeGN89IZfdQiuepeuvKo9/AzzS4/cSwFEv8J1wvSV5j6qd+/cOmMmzYU5mv
7/santPiC6aeMnyr+X2nY/IryPQLIrgxMije0CMnKoa0cybQUoaWy/svjxsN
4YuxFPeIdhlyTMN2vnEdpPzJ8Svzt/Cl3AFst78qOuQqxxBhu5/N7QcnLVJL
ORIMTT4wQvuofOVgCSwUAk0vXrhLM0+2y7G32mra07sXBhnetx0NFCCDu+mL
WS8xy7xuXPuVAkOsVeaSp53IDk7/AXEKPHV568a370RhwRwUYBhLLQ9HdeAm
fTSDPqqA8FIjd6FTB2gmDt/vX6HEj47mXRNEOzLLOTfLOUrIyIAxV792WGm3
zSxNCXOnY84m9c9RLQ/gJnYrMXCS/6J+6hmsa88aaMwImEed9nPxegaC1Sj8
JZDA3XqN0qOoDbpxSiUQNdszlWzeBu/n/tafvyTQ1NNS/DClFbpxXabCCU1c
FpvWCmGPxd30EBWEx41mbh8RYcnAN9qVVsGIliq4M9YCp21/f8qQqUDLrrry
h3sL7hEn/QKcSaQLu0vfvW7GLWmCliSGsi7zU7Y2YwfRoCWJ8weiLn7d3ASm
n5000kyNUJ9oQU5gE/U/44jO4s22DTbArXMLI8DtLWYqjf+VG9YhbLfxtXHf
99jYHGNTHl+Fkn1PEicVk6iJdz6YpVdB/d8M8u0280bsSyk9HxFcsc40oCkX
eUWOx1sz5nslOUz8c3U6E/8BOk2QFg==
          "]]}}, {}}, InsetBox[
       TemplateBox[{
        "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(2\\)]\\)\"",
         "\"\\!\\(\\*SubscriptBox[\\(D\\), \\(\[Infinity]\\)]\\)\"","\"T\"",
         "\"O\"","\"I\"","\"SO(3)\""},
        "LineLegend",
        DisplayFunction->(FormBox[
          StyleBox[
           StyleBox[
            PaneBox[
             TagBox[
              GridBox[{{
                 TagBox[
                  GridBox[{{
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 1, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.5, 0, 0.5]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0.5, 0, 0.5]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    RGBColor[1, 0, 1]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    RGBColor[1, 0, 1]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                    GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {
                    LineBox[{{0, 10}, {40, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.075], 
                    AbsoluteThickness[1.6], 
                    Opacity[0.5], 
                    Dashing[{Small, Small}], 
                    GrayLevel[0]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {40, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}}, 
                   GridBoxAlignment -> {
                    "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                   AutoDelete -> False, 
                   GridBoxDividers -> {
                    "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                   GridBoxItemSize -> {
                    "Columns" -> {{All}}, "Rows" -> {{All}}}, 
                   GridBoxSpacings -> {
                    "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
               GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}},
                AutoDelete -> False, 
               GridBoxItemSize -> {
                "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
               GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
              "Grid"], Alignment -> Left, AppearanceElements -> None, 
             ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
             "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
           FontFamily -> "Arial"}, Background -> Automatic, StripOnInput -> 
           False], TraditionalForm]& ),
        Editable->True,
        InterpretationFunction:>(RowBox[{"LineLegend", "[", 
           RowBox[{
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 1, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0.6666666666666666, 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 1, 0]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 1, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 1, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.5, 0, 0.5], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.33333333333333337`, 0., 0.33333333333333337`], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.5, 0, 0.5]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.5, 0, 0.5]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.5, 0, 0.5], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[0.6666666666666666, 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1, 0, 1]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
                 RowBox[{"Directive", "[", 
                   RowBox[{
                    RowBox[{"PointSize", "[", "0.008333333333333333`", "]"}], 
                    ",", 
                    RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                    RowBox[{"Opacity", "[", "0.5`", "]"}], ",", 
                    RowBox[{"Dashing", "[", 
                    RowBox[{"{", 
                    RowBox[{"Small", ",", "Small"}], "}"}], "]"}], ",", 
                    InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    GrayLevel[0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> GrayLevel[0.], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], "GrayLevel[0]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    GrayLevel[0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["GrayLevelColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    GrayLevel[0], Editable -> False, Selectable -> False]}], 
                   "]"}]}], "}"}], ",", 
             RowBox[{"{", 
               RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6}], 
               "}"}], ",", 
             RowBox[{"LegendMarkers", "\[Rule]", 
               RowBox[{"{", 
                 RowBox[{
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                   RowBox[{"{", 
                    RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], 
             ",", 
             RowBox[{"Joined", "\[Rule]", 
               RowBox[{"{", 
                 
                 RowBox[{
                  "True", ",", "True", ",", "True", ",", "True", ",", "True", 
                   ",", "True"}], "}"}]}], ",", 
             RowBox[{"LabelStyle", "\[Rule]", 
               RowBox[{"{", "}"}]}], ",", 
             RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& )], 
       Scaled[{0.99, 0.99}], ImageScaled[{1, 1}],
       BaseStyle->{FontSize -> Larger},
       FormatType->StandardForm]},
     AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
     Axes->{True, True},
     AxesLabel->{None, None},
     AxesOrigin->{0.04705, 0},
     DisplayFunction->Identity,
     Frame->{{True, True}, {True, True}},
     FrameLabel->{{
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(J\\), \\(eff\\)]\\)/3\"", 
         TraditionalForm], None}, {
        FormBox["\"T\"", TraditionalForm], None}},
     FrameStyle->Directive[
       GrayLevel[0], 12],
     FrameTicks->{{Automatic, {{0.31666666666666665`, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(J\\), \\(eff, c\\)]\\)\"", 
           TraditionalForm], 0.01}}}, {Automatic, {{0.1724137931034483, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(I\\)]\\)\"", TraditionalForm], 
          0.01}, {
          NCache[
           Rational[1, 3], 0.3333333333333333], 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(O\\)]\\)\"", TraditionalForm], 
          0.01}, {0.5102040816326531, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(T\\)]\\)\"", TraditionalForm], 
          0.01}, {0.7692307692307692, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(chi\\)]\\)\"", 
           TraditionalForm], 0}, {0.819672131147541, "", 0.01}, {
         0.8771929824561404, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(D\[Infinity]\\)]\\)\"", 
           TraditionalForm], 0}, {0.8620689655172414, "", 0.01}, {
         0.9900990099009901, 
          FormBox[
          "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(D2\\)]\\)\"", TraditionalForm],
           0}, {0.9433962264150942, "", 0.01}}}},
     GridLines->{None, None},
     GridLinesStyle->Directive[
       GrayLevel[0.5, 0.4]],
     ImageSize->{538.109375, Automatic},
     Method->{},
     PlotRange->{{0.04, 1.45}, {0, 1.1}},
     PlotRangeClipping->True,
     PlotRangePadding->{{0, 0}, {0, 0}},
     Ticks->{Automatic, Automatic}],
    TraditionalForm],
   InterpretTemplate[Legended[
     Graphics[{{}, {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.008333333333333333], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1]], 
          Line[CompressedData["
1:eJw1UwtMk1cYrUykqHUr1AHOKaAwXpHFSDLG8PAYChJIcKDBiQwGimTydhEo
CI7HjBM2gwwBhzLYeLVQ3o9CLOVRQDKQ8tiQhSGPQtv/b8HpgDD30/09OTc3
X3If55z7XbPQ6LPhOgwGw5sa23Phg21UwtTaXGzzJ4kDZa4UqxBXaFx+aZCE
Ve1jYdZqFf45lV242UVipF3EWa+phulJMZ/RRuJgfyzFGoRwq7/lNZB4X+pK
kQed9oPF16n6kAZ85MRcUJXWkmAe5qpEerUYyLnrIuSTYGhQhwCPobzlKhIZ
77gxzTLqwNoyvFhTQYKtgQBWen3SmDIS+ckHQtp+FWBYyubplJK4d9SLYj1O
JrimDBWTiLB/3Jnxqh5nc57zQNUcJ4Ghk6ABnYxNmfQ+iWQO//RfSY24W9Kw
2krVARo0gXVxzyPdHBJhZnsCJW7NMNlbRIRmkzhlFJQw6tGCYUveQkc6CeOs
EIqtcHDMfTjIJfF/fm2wPu4j94rX5tUOXkdilXuUNh8hGqPyy+vCtXl0geN/
RXInWOv/CfRTxOd9A7R+RZARPovHPbX+uhG2L1q831nrRwxX9zc7jWy1+nsh
sHUhHIy0evuRtouvO6Kj1TcA1u1kuxQZQet5im7cbDQYJuj7R5A54C+qKCPo
+55B5d76PD6eoM8fR2SjfcPcMYI+73eIni1aKCRKev8sdr9uUXOClfT6BaiC
YtYaUhVouTbdfG16EeZcHSf2pBxTtx9SlOGWUYru1b4VVFdtYwVzZonSTI9l
FDHnC5nzK7j06Ie/RYeXocv64HrwITmox/bZHJOhuCmwqClQjoGN2dymBzK8
R3UDO1+OkY30glgXGbqWfaKTxuRgwUK6PrMEU1HKztdsBaJSJ97u+W4JCuPe
thw/BTIFmaZ6FkvQ2L2nwJSsNvKIYBFuw16mx6QKOH9ts3bVahGaOI2U8Nuw
3/ooewFt4yaVBZ8rIfHyNfxZOg+DP7ypllNiS1jpmSl4AdszL44YypT4YqtE
zE2cA08R7+nzIYGvrFnmYM7ip6VEigSOnoloJcaewlfRQ5GAc9CMYMpyCBxP
i6VwNonY2fG4K5aDCNaAhHOkY+cNuwEUJEQemqf+zbq/U53+OQmdvwrcJRuV
VUU/bpa78IKtVfhk/eVU/o5+7BcW3/rxMxXSZibeGjvXh1G/dHt+qgo1WZPM
yeZeOn8VLuc6R3xp0ItE1oJD3qQKH7utWdYk9aBnfndonK4aaaUl+XuVYpwY
/dTQ54QaefK0fwMuiPFu/feZdmFq5K7+4jC7Sww/k/sU1Thtn9KtuNGNOE3D
qeFI5O2beCOi9b7EE6W+wfRMB90fr5C18FuLrncTrWcDBcIdl7u+qaXXM1zK
z6skHqXl+A94/z7v
           "]]}, {
          Hue[0.9060679774997897, 0.6, 0.6], 
          Directive[
           PointSize[0.008333333333333333], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 1, 0]], 
          Line[CompressedData["
1:eJw1Uwkw3Gcc3SlipVJVZoiIa5KqI0IwiOOxLZFWmwTJVFIRVyQzjq4wVRtb
GkRDNGEiqSNhQtzivhKbXWdMBEW0mlDL3rv2L4qGkbZr+8+b98038x2/7703
v880LM4/8j0KhXJMMbbn/6Hqea10esZxsAjkgqfESWcy4+sK1NZsYxNMRtPO
hpEGdMS8bI95uY65V/HUg1Ot5PlVtPd3lNxnPEK84RDdcOg1zlQna16M4pD7
y5jeofub0eIA9IITfvXWW8KsMXHSSmcEtOdHTWymZLArEN/O6hjBvqN5CspQ
PpE46vbgOWT6A125J2TQlmh105NGYcJJUf1bWwaL0HwzY+4YWOIv45InpQgw
mqVmXxvHntCuSu0CKTpp3r08+xcobgsqaguSIqnOmrevcgZqu8wTQ4ykqM/s
dy/weIUiKq+QypNgb3Decs3qHOlXgvsZc2t1zHmUBd5JQrwEHcEXGiZ9udjS
va3JOSzBG4aberWcC9VCWqmFqgTVMyr17BsLGHMRFl8aFUNlVWR/XWcRhb9s
Q4wq/xb102mLCCqIVFAMlk7LWU3+Ivw+zh+OOCRGflx7l507j8xLjCHTtaZb
NTzYC3JcwkdF2FZHUeHj959KFBSBSD715IkNHyKVmvC4GBF8BDehn8SHx5v5
K1oeIlQ4ZG2ZdPKxnjqjcl5LhDVpKO3PZT58tQJHY7lC7Iq+dY7uLACNobG0
v1UIo6GtYbVAAa4qIcTufGn+cIEAhhYGCz+fESI64NiGpEeAhCX2N662QrCO
19cSYgFWgpzumN3jI/ERPTLcWYS0qoSIMU8e+v2dLD83FKPPVlPBRfj33TRY
eiaGyVvREWxy8U8zY6XxuAT9vJ1h8WpcMN39RHtYEvxQ4VkfYjEPh96nnWN6
UjKPecwIBlfT90vJPGdgox41a/2FDCeVeAGjwhz33A0Z8pQNNIGRsLC/6DFL
5P1xDPa+jXEbWIKyPekjkK2w/7DaISfrDcPP/N/U1cNy+CgbdAgy6+vxn56X
k/UHUDLB2cRVOXRdm3Rcm/pgG5FYKyyXk+/1ov5u/pwTSw5tJTj47Iq5+uCU
nHyfDe3dp177COQwUoKFjYG8EOsNOannMaw/iGI6qhP45GHZ48yVbiSOf3TC
RYcg9XWhSl8YRzMloJ8ZqmAnMlhcq0pLgtTbAY177K/6HQlEmL4f9JTWjrC5
8bQJd4LU34ZWtt3cRW8CDN2GI9zkVjg6JMWf8yNIPy3YNCs7IPQncOFgWU/6
ejMoB77N+e40Qfprxo+l7SaxoQQKGAaKH9aE6YUASk4UQfptgkecpX9oNIH0
D2lU0/RG3I1tyb5MJ0j/jRiGSc/oJQJU48vLHPWHYJZnadYmEWQeDXjAN/je
PoXA3ikvBetBEdmGnE0lyHzqwNbIoDqnExjv5uhu1NXCN2aBx7z6Lq8aeKU8
K7bJJmBQ7qVgDQ7ZqjGjct/lVw1a94BY+waB/wCGl1V0
           "]]}, {
          Hue[0.1421359549995791, 0.6, 0.6], 
          Directive[
           PointSize[0.008333333333333333], 
           AbsoluteThickness[1.6], 
           RGBColor[0.5, 0, 0.5]], 
          Line[CompressedData["
1:eJwtk3s01GkYxxl0pZpuKo0u0i5at66ovp1qrO5HqUiFkWpFMi6bVBLHpou2
WinUYo1bDGokkkwN1jSNRC7NDDNM5spPNxFpRzvf83nPe973ff55nvN5F9CC
dvqRdHR0DmrW6P5/9Netr2cn7KtIgfZiHevrt7BoBgP38kbzFRe2Dk5xu8JE
aaDgYaCgH24Z3wfMP7O09Z+w8TmtqaS/HPS5tcFza9/jFDw/OTmyte99MMhq
LDfyr4bxgdAGqnEP8ld8L3Skc7H+5ab51k1qhMniZQG6L7Bo03UNaiyumWf/
+uQLqGdVlyW4qjEuzWpRCHiYzz6j/4WshrM/y+ZBJw+Vim1BpxpVIEVuzVyW
8hImPmXZ5JsqiDv59BoKH6klHiklHiqYo3NvvoQPA6OfwrxMVRh+WZwrFtUj
ZZw0eZxUiQSH+takgFfafpXIkyx/VtLzCulut06CrsTqLrnxVEojhqcnGbId
lcgsNCLNqmiCfvL6NAt9JTiOR+NzUt+g3kGWGsJXYMU/g+HmwmYk3x6NAg3i
umi75a3wuOmnQYFrJFOriQ5t2Lr4Rt0hewXEUVZtxeS32nkpIJ1LyzWZIcDS
7ssOvnw5KA2W89+yBGiNv6NBjiVNyd2UbCHkenm+QYFyTCjwuX3NTYS1A+KY
yWvlyLCdMe7nryL0n2vTOzxZDi7FrMb9RjtcJrvxj0tkcN7G982278D6yPE9
5iwZwhJ021SiDvzxIzI8KXtNpdiKMddiTudVTxlyhnQyVwSLEdpTtd/JVoZW
wS6vmHtixHfa0OMMZHAit2yMGBRr/ehGqJJ7JMJUAs+4Sa09xd3IyBaoF3pJ
kMdxo1navcOy+kWcIEoXZvfVSezFXTg5xujbtP1S+FvlFmQ+7MRuWrH3533v
EG0XH/OlQILMDA77kXU3qhtN9+qyxSBtSUkqMpNhRkXq+aRdYgzrvVatNpZr
5ydGgvTDvNdBCtwK9TeVMjswfDrauXmsEl4/0gFOs8ecd3FKTHcxl/mRO8Az
i7LtEyqxXc3R0A7mkc9DKpIKd2URGtohHG3XQoUCdYjLNtt2hHdxa07QVLDa
3GU2TS5CiWVqKSdThalvtxy1SRfBZUxWFcFToezN7NxbniJc6RYknhhSaf0X
oXND+Ishc7XWfyHO/R0sWeei1vovxIU7FqEHfdVa/4UwfVqqqD+r1s6/BXnn
jjaOfOpBke09V056I25uH9FVhPWCI51Aoxs0YMFxn74Nj3rRPLOMr2/IR2Li
YkaaoFfrOxemLXEXg0d6cdDbyS9n97/g0dUPRMYEErpWaajB4NjMlghrAgdG
yI7RdA5mjkHsizUEKAzB3j3EM/S7nJiSvJnAzK5yRlQ6GxGDRe9D9hBocI22
YZ6twsVvfl+kPgQM3JM/mo1UwoiZ1VoZSCCx0XX7rw5PUF1IHdAPJ0DaeIy2
k/EYC3dcZ94+TWj/VzkYH8JjG88TcLgqWR338RFGu7t7icDSlQcbWNxSnGkd
cLC6SqBq7f0cVDxEXU9s7Iy/CAQzIvW4nBI4ZAccM00mQH9ecTlGwsIhFyfP
X+4QsAqb2mI4hYVVsZbLI9MITKNt1/AARxcGnDzFIJCdb3GMm3wfIxnv7ahZ
BCrcQoXcj8XYeClANpRLgHl4SZWJezHYdu2/UZkE/A3TvdNqiqDImDSLfJ/A
pOBEC++1RSBdPLvPnkVgpTN1GelMIf4scFsTpzkfCNzhH3eZieubLxn1lRIg
e+6KGMwtQH9b78Q35YTWh3zkNlTyLj4mwFtpQZk1IR/OUbtN4p8QsI5yqq3d
fA+7236n9j0lMH481/1wYh4kvMJuHTaBG3fJdfaKXFhSDXyinxH4Dyg78R8=

           "]]}, {
          Hue[0.37820393249936934`, 0.6, 0.6], 
          Directive[
           PointSize[0.008333333333333333], 
           AbsoluteThickness[1.6], 
           RGBColor[1, 0, 0]], 
          Line[CompressedData["
1:eJw1lAs0VHkcxxGn6SkhpZKpkK3o5ZwQ30l5FHpYdQ6SUNgiFimPNrtZlmM5
ixRJtWk98m6QMmooTJiGvKXGeIwZYy42odptZ2bvfM/3nnvuuef+f7/P9/c7
l+oV6HROSUFBwUNySe+ZGVLlI9PrS6XjewLaOfslLgCzfVRP1ERgS8n9mtjp
Agx86+v4vpYA5ylTY77wEd7VceOCqgmsa/xR4kIc7KzDNTqB9R37JS6C/6L5
e76PCejIVIwGo+MMk1IClA1Rk8yFJQiLFxb9XERAQaZSMNJyM/oLCMSssKJQ
Y0phtKf7h5yHBNRkKsOMtZUbW/KcHqntWZ1bBv9yG4uDDwikbD4kcTlM6U1h
tXcJ+BnfZ8R8KgfrMze5IoOAhnmZunnZY6R/9WIZpxOI1Ci2HYygw4ttw/RJ
JXBCpgr85X9BJzORwFnqEpcmq0oset7x5nYCARst99A26yokXbnL6YkhsDrW
U+InOGVhwAiMIvB/ftXIo7iXdIXJ83oKs5Iye+dAeT41qGm2jjLwkedRC9qJ
YHOqp5z/BSyyrztfdpLzMrHYe8n+5YflfHXIEWlr7zOV89TDUzs2+TdDef+v
cGM4dUvSKnm/jdg1RX028o+Y7I+FqJ9WU/f1icl+WnBGqUo8mi8m63NAHeB9
pNiJyXrtsN5o68j2niDP78T8Re4XikAITpDT7EhZJ1Lqzfzi84SIko5DrQtt
/judlC4J4eC7886r0C68CGJua7QUoiqgvzKgvwsduwvmtYyEZH/d2BZwui5J
JIBV5KIJPXo3/AsU3ZezBZg++ck0R78HmbpCS4V8AXri70iNNdO87o1RAmiv
kaoXw3mscJGzgOTrxR/ZqjW2mwQkDxfn1Q1mzTX4CF82YpLWzUWvbmpi1q+j
CJYFMIg8K0NbcdcI3rZLxQPtGn1l66oR8vthiOp9ezR1h0n+Eej6rFuxfIhH
8ozCp/XPhBndQcTzjINjVfjIekcc0xjjInTixSnzHXz02Ykm8ku4WGeozUt2
42PaJXvhZV8u4mTi4/z5XlePzVySn49lu1hNLj0fYKfqzL44yEdC8VzIrP4H
fIruXeCjOgaV6W8Mcdx7WM5xr6tajsHama1cKh7A2IIC78CAMQT5OhQf1R8g
8xoDjdZ21D72HXaPJpp6s8fgmphGc6/qJ/kEiHn7i9ZVlX446Keyzu4S4OID
xRqVlX1wST8nsQAJ2g71k2q9ZL4C6DXeaWd+7sYbU35WiGROrc+lA+6CcqbV
PUNlIaL3mjDKfu/EV42bS5lmQsR9pzqio9eB+863riBYCOeH24unMtrxqEAq
yXuLPr2bIg5uU4YzKcNCmLnR/CyiOFBZZnDJQ2ccwquce0n0N8iqcLld4TKO
W0W8CMUhNtZK1y19HCcP8HTsN7BRK3AMjHg7Dq9mlf2uYa3QZV5VnlUTYa9+
dgPnZQtEq19VJx0XIb/iQNd2zRbI1jtFBGFMwSPN6GZYtR7SNeoQwYSu2BNN
aYZsPbUmwKDQWIsvvEZ155r8W24TUHHv9J+bZGFln73kFzMB3pWte/NPsLD1
8NAm9bEJaD7fd/lGUxOKRCF2jjvE0PxwbM5/fROy+eESizFlL5zy4zTiiOil
xGLEUj2MzWwaoWGnxz+nRuBJaEt4Q20D9rQdVHfcMwW/yMFnT4/Vwf3k0rRJ
m78xmDJ0RHCGgZLTjIgZ4QxcM92ohQ2V5LzmUb72gVf8x1Ky/r/ovB4YF/I5
F7mFhhdeZyrR0u2SW1bQ7+I/Ey/j1w==
           "]]}, {
          Hue[0.6142719099991583, 0.6, 0.6], 
          Directive[
           PointSize[0.008333333333333333], 
           AbsoluteThickness[1.6], 
           Opacity[0.5], 
           RGBColor[1, 0, 1]], 
          Line[CompressedData["
1:eJw1lHs01Gkcxi0qToSalibEFkWlC9rK1oOlJLWbWlGohC6ycskJ0x6VVLvS
JrfGZROxIbdCnMh1zMgIuYRcBmPMmJkfCl3EDvvznOc973n/+L7f83ze73m1
Xbxs3aSlpKRcJGt2pz+Y1RP8Wrzo6+0uAtQUM4nTIXuQZUNjEliXnfQydCwd
D0I+Pa0sJdBQXE75nJmBsv3RwTeKCKjXeEuciZLub6PO+QQ0ms0kfooFVIdV
U7kENOeUBaH0/riYHAJyq2gj5Yuy4eL1yxXFLAJSc8oBZ7vMti8ZBEKUzeW0
Q3LgGnHvWU4aAZU55cJ9jL3tx1QC0UHUU0VpuRi97LlPO5lAxJp9Eudh1ENl
99UEAmc3JZWETOSBXZOf5BJPgGKSu8wk9xk4KXY3PkQTCKJk7eUEPsd4blR6
zd8EfptTPupM3aa+hhFw1V7swDQvQLm/RozzLQJ7VJ38Gi0LMV0YobHyKgG1
0FMSv0DJibENBkEE/udXBKNXdBlZ33lexQi44/Qo0GOez0uIw1jjLNd5HqVw
tGX+a3l0Pn8ZGs9Q18ZazOctR/w1pe06hvP5KhC7qNV5i/J8nkqovJmJrewU
k/VVYHGR0lMqBsXykMRViKd3v2PkifE40tZa73EVPreoa8Umi1GrnJnM/lqF
ceU7Yi1/MZm/GtdCp+UN7MRouGg7yc2txi5Hn/d6GmLQZnGrMEBdddiV3iqC
zZktCdV+DIjP100fDhGh0LOzwLOTgR+kdNZnmolIXjVoDf3Te1pXBPMgeZHO
8xqw7Y0SEhREGLOb2JGiy0SAvElej5QI724nSMzElo1tzDi+ENQVs2LB2H1G
z7xNSPJlgdal5Bb1SkjyrEOwbkVo2lEhmb8BA+yPOgYdwySvJpy9J6LBeJjM
14Jys7P6ufYC8r52PPTmmFp9zyfre2EhbVg3sYSHAEWucWRbLwQJk8LUq4Pw
mWvIgaD2TIDmey7eNs2qD00uMlMbKVyyfgCchbQ/1LQHyH5ciPy+HFnH7SP5
DGLpwcXOH5dzcLtvk0/oAh4Wq/cn2A30wk9U5miymYedoxWVSSm9UNej9t09
zsO31YMXKBd6cXNOPAz4UhSh00vy5OHJOu/NWa97YKV0pP53juQ8wb9cZ9qD
ieB2GXelIVSzvi2xvNqN3Z96ryvtHkLApfDv2oe7MCSTftrLcwiJ/p888vZ0
kfyHQG+9P0hLfA/DwbAdp+uHMPbTCxOPwk4yHx+Bjzf8rD7cARvd+yzXrXxo
aXf1fZTrgEO0m8R8fLFIXONk2E7y5cPs0YTVReV3eLODF+9bz0eszfIwa0Er
ZOnmD/VkBdBYzbC/H9mCKUqMQvlOAUr1VfVnjjUj6UjsZfgI4Bd5vV1WrQkZ
6bMSgH9zesJleSPi5AbocgMCnCjeZlae14AFimsvndAcRlGxPy380RvE5zvE
5TtI3r2q1YHKrcfK2fGNHgZVeLJN3rwepfwDXoFvh3HxaIWoP4gNrfIrspMq
QkRNOp9b2F0HoVp1UfghIVYwurSOra/D3DhFCOE+MvlXe8RrmLP3aRk0C9G1
tTg6uaMWc+OuKoJb892TJa61KGpZ8ST2uAhVDYIBhWoWlnbsl3xJIuiNplpl
7GVhvXX/6mVDIvQ+u2Uyms3EU6Gv1YHNYnQUSGuUGTORyAuQWAzL1HO7ztXX
4KCwSmIx1IINNSP21oBipcNzUyHQ8oe9o3wtA0aNFssOGI3ipqpFSqpTBZzs
FCJH9nzAg5nzQwHWJch2LgkcF4zD5Xl4uu6tAvK9PuMhO0Y2qjuH7D8NxumF
+v09aUjL1POopUubanNHlrpt/wf/Ae9B/EU=
           "]]}, {
          Hue[0.8503398874989481, 0.6, 0.6], 
          Directive[
           PointSize[0.008333333333333333], 
           AbsoluteThickness[1.6], 
           Opacity[0.5], 
           Dashing[{Small, Small}], 
           GrayLevel[0]], 
          Line[CompressedData["
1:eJwtU3001GkYVYxGcaSZNJhabEi2Dastq3WliDadOKqdUElKRbPUapnas5Uz
m3K2XXUkmWQ3HyEfFTVW8s1Q8hHrqxrWmK/f/EaFYY/aHbO/e+573r/e57n3
vs9jc5AbFDlfT09vj/bM3Rk35nAX+dwb3ZEualje2aRlAc7vy8m3/kyNVSXZ
Vfx3BfDqPRw/bq9GR2Utc6aoEPRFzFtPrNVgN8dqWYTlfm8NeizUWP5yk5b3
kOOyd+suhhordCiGQEPknjNWg/7JmfHaBSVgOmg8mDQ19HQohZtNzeyqDySS
FnvTbZJKIXIIZK+ZIGGmQxnS2Ke3LVCSSONZhgvzyhDkcDu5dJhE6kp/Le/D
xFXUwukjEbU2+0nS1H30JT+2b20jwfQoY3iUPUCvaUOKfh0JHrN463DiQ4Sf
Kbx47wGJXTqUY9gpb/XeXBKHbBZxWrwrIJ9nGHrsOgnfZWGnOn0ewcckN3z6
IgkWP1zLx5j+ThSbd4rE//kJYRE4YHUmnKTyqoR7Q9D61dtIKp8qWLDtStpd
SCqPanxpS9u425yk/NdAEOE1lahRUX5rIUoggse6VZS/Olg6pG/pKFRRfuoR
FtP48T5PRelvxOSi+PoKHxWltxlnc2PP+xuoKH0ixBpGT+wpJyg9zxCfwooI
CCKo/h3gLAxpOtCnpPp1Ycejfp/qDUqqfg86bl4KZoUoqHr9cJ58n2u7VE69
F8O/rrBL31iKBBPJumt/ibHGYoCx/twY4nQNh2GQwyvN6pOgu2sOI+h996pG
Yyah3o/CLOTI0WtWo1Q/CehxO+u2D47gUcxgRczgGDz/PGp9Yf4wkkfWxvFp
UmSXGW3WPBXjlKom1MNZioZejqWELwbb0XLkSogUquImAj5i/KyDFCvvhGSu
mCeGN89IZfdQiuepeuvKo9/AzzS4/cSwFEv8J1wvSV5j6qd+/cOmMmzYU5mv
7/santPiC6aeMnyr+X2nY/IryPQLIrgxMije0CMnKoa0cybQUoaWy/svjxsN
4YuxFPeIdhlyTMN2vnEdpPzJ8Svzt/Cl3AFst78qOuQqxxBhu5/N7QcnLVJL
ORIMTT4wQvuofOVgCSwUAk0vXrhLM0+2y7G32mra07sXBhnetx0NFCCDu+mL
WS8xy7xuXPuVAkOsVeaSp53IDk7/AXEKPHV568a370RhwRwUYBhLLQ9HdeAm
fTSDPqqA8FIjd6FTB2gmDt/vX6HEj47mXRNEOzLLOTfLOUrIyIAxV792WGm3
zSxNCXOnY84m9c9RLQ/gJnYrMXCS/6J+6hmsa88aaMwImEed9nPxegaC1Sj8
JZDA3XqN0qOoDbpxSiUQNdszlWzeBu/n/tafvyTQ1NNS/DClFbpxXabCCU1c
FpvWCmGPxd30EBWEx41mbh8RYcnAN9qVVsGIliq4M9YCp21/f8qQqUDLrrry
h3sL7hEn/QKcSaQLu0vfvW7GLWmCliSGsi7zU7Y2YwfRoCWJ8weiLn7d3ASm
n5000kyNUJ9oQU5gE/U/44jO4s22DTbArXMLI8DtLWYqjf+VG9YhbLfxtXHf
99jYHGNTHl+Fkn1PEicVk6iJdz6YpVdB/d8M8u0280bsSyk9HxFcsc40oCkX
eUWOx1sz5nslOUz8c3U6E/8BOk2QFg==
           "]]}}}, {}}, {
      DisplayFunction -> Identity, PlotRangePadding -> {{0, 0}, {0, 0}}, 
       AxesOrigin -> {0.04705, 0}, PlotRange -> {{0.04, 1.45}, {0, 1.1}}, 
       DisplayFunction -> Identity, AspectRatio -> GoldenRatio^(-1), 
       Axes -> {True, True}, AxesLabel -> {None, None}, 
       AxesOrigin -> {0.04705, 0}, DisplayFunction :> Identity, 
       Frame -> {{True, True}, {True, True}}, 
       FrameLabel -> {{"\!\(\*SubscriptBox[\(J\), \(eff\)]\)/3", None}, {
         "T", None}}, FrameStyle -> Directive[
         GrayLevel[0], 12], 
       FrameTicks -> {{
         Automatic, {{
           0.31666666666666665`, "\!\(\*SubscriptBox[\(J\), \(eff, c\)]\)", 
            0.01}}}, {
         Automatic, {{
           0.1724137931034483, "\!\(\*SubscriptBox[\(T\), \(I\)]\)", 0.01}, {
            Rational[1, 3], "\!\(\*SubscriptBox[\(T\), \(O\)]\)", 0.01}, {
           0.5102040816326531, "\!\(\*SubscriptBox[\(T\), \(T\)]\)", 0.01}, {
           0.7692307692307692, "\!\(\*SubscriptBox[\(T\), \(chi\)]\)", 0}, {
           0.819672131147541, Null, 0.01}, {
           0.8771929824561404, 
            "\!\(\*SubscriptBox[\(T\), \(D\[Infinity]\)]\)", 0}, {
           0.8620689655172414, Null, 0.01}, {
           0.9900990099009901, "\!\(\*SubscriptBox[\(T\), \(D2\)]\)", 0}, {
           0.9433962264150942, Null, 0.01}}}}, GridLines -> {None, None}, 
       GridLinesStyle -> Directive[
         GrayLevel[0.5, 0.4]], Method -> {}, 
       PlotRange -> {{0.04, 1.45}, {0, 1.1}}, PlotRangeClipping -> True, 
       PlotRangePadding -> {{0, 0}, {0, 0}}, 
       Ticks -> {Automatic, Automatic}}], 
     Placed[
      Unevaluated[
       LineLegend[{
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 0, 1]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          RGBColor[0, 1, 0]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          RGBColor[0.5, 0, 0.5]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          RGBColor[1, 0, 0]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          Opacity[0.5], 
          RGBColor[1, 0, 1]], 
         Directive[
          PointSize[0.008333333333333333], 
          AbsoluteThickness[1.6], 
          Opacity[0.5], 
          Dashing[{Small, Small}], 
          GrayLevel[0]]}, {
        "\!\(\*SubscriptBox[\(D\), \(2\)]\)", 
         "\!\(\*SubscriptBox[\(D\), \(\[Infinity]\)]\)", "T", "O", "I", 
         "SO(3)"}, 
        LegendMarkers -> {{False, Automatic}, {False, Automatic}, {
          False, Automatic}, {False, Automatic}, {False, Automatic}, {
          False, Automatic}}, Joined -> {True, True, True, True, True, True}, 
        LabelStyle -> {}, LegendLayout -> "Column"]], {Right, Top}, 
      Identity]]& ],
   AutoDelete->True,
   Editable->True,
   SelectWithContents->False,
   Selectable->True], TraditionalForm]], "Output",
 CellChangeTimes->{3.657281107411249*^9, 3.6572826265490503`*^9, 
  3.657282658303287*^9}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {
     {RGBColor[0, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSmallCircle]",
         StripOnInput->False,
         FontSize->8], {0., 0.}], CompressedData["
1:eJw1U2tMk2cYLSgCat0KdYBzCiiMW2QxkowxPFyGgqQkONDgRAYDRTK5u8il
CI7CzCZsBhkCDmWwcStQ7vdYyqWAZCDlsiELQ6CFtt/XgtMBYe6z+3pynh9P
8l7OOe/zWoTFnI3YwWAwfKnSoUqXqsL7b1AJc1tLkd2fJA6UuVOsQnyhafml
YRI2dY+6staq8M+p7MKtHhJjHUL2Rk01zE+KahntJA4OxlGsQWhq9Tf8RhLv
Sdwp8qHbcbD4OtUf0qAWObEXVKV1JAwOp6qE+nUYyrnj1lVLgqFBPQK9RvJW
qkhkvu1hYJFZD+a28cWaChIsDQSw0R+QxJaRyE85ENr+qwCjEhZft5TE3aM+
FBtwMtGdO1JMItLxUXfmywaczXnGB9WzXQTGLoJGdDO2ZJJ7JFLYtaf/Sm7C
nZLGtTaqD9SgGcyLex7q5ZAIt9gTJPZogdneIiIsm8Qpk+DEca9WjFrzlzoz
SJhmhVJsg5Nz7oPhVBL/59cO2+McuU+CNq8O8DuTqjyjtfl0oSk6v7w+QptH
D9gBV8Tfhmj9P4YhV3TeL1DrVwgZwVk+7q3114vwfTGi/a5aPyK4e77eaWKv
1d8Pgb0b4WSi1TuI9F21emO6Wn1DYN5OceDKCFrPE/TiZpPRKEHfPwbeUICw
ooyg73sKlWfbs4QEgj5/ElFNjo0Lxwj6vN8hfLpspRAr6f3z2P2qVc0OUdLr
l6AKjl1vTFOg9dpsy7XZZVim6rqwpuWYuf2Aogy3TLh6VwdWUV31BqtYsEiS
8LxWUGSwWGiwuIpLD3/4W3h4BXrM96+HHJKDemzO1oQMxc1BRc1Bcgxtzuc2
35fhXWoaWPlyjG1mFMS5ydCzwolJnpCDCSvJxpwU5kLuzlcsBaLTpt7q+04K
hWl/e46/AjwBz1zfSgqN3bsKzMjqoo4IluEx6mN+TKKA61d261dtlqGJ00QJ
/03H7Q+zl9A+aVZZ8JkSYh8/458lizD6w5caOSW2uyq9eYLnsD/z/IixTInP
t0tEqUkL4CsSvDkfEPjSlmkJg3n8JE2iSODomcg2YuIJ/BR9FAm4Bs8JZqxH
wPa2kkawSMTNT8ZfsR5GiAYkXKOcu284DKEgMerQIvVvNgJc6g3Pien8VUiV
2qlsKgZxs9yNH2KrwscbL2bydQaxv6v41o+fqpA+N7Vj4twAxv0zHGvTVKjJ
mjaYbumn81fhcq5r5BdG/UhiLjnlTavwkce6dU1yH/oWd4fF66mRXlqSv1cp
wonxT4w5J9TIk6f/G3hBhHcavuc5hKuRu/aL0/wuEfzN7lFU47Qjt1dxoxfx
moFTw5nI2zf1WkjrfYHHSkOj2blOej5eImvpt1Y932ZazyYKunQu93xdR69n
uJWfV4m9SsvxH4pTPvE=
       "]]}, 
     {RGBColor[0, 1, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSmallCircle]",
         StripOnInput->False,
         FontSize->8], {0., 0.}], CompressedData["
1:eJw1U3lQ1GUY3gJkMYxomQERERiNOEQQGUCOB7dALEoFdEJD5BKdcaVFmIiV
DZLDFElhRONQGVHORZEbZd3llBEXArQ2lVjY+/ohAQmD1brz45nn++c73vd5
nnk/+7jk8EQDCoWyV7fe0633KaswDDp/87nQa6AM5EaQ0ps2nvvNbdTXvcMy
2KymtY3DjWhnvGhjvFjE5MsU6raJFvL+PNr62itusR4gxWaQaTP4GodrM0xP
JPHJ81k8X2Pxu+1MPyyjU38LttTg1SbigAttGPSne+zcJtTwKFFcPdc+jM17
inRUo2osTeB/5ynUVv2dhfvVMFeadTHTBbDjZxr+Y66GU2yxwybRCLiKr5Iz
xlWIsH1FvXB+FBtiO6vNS1TooAf3iD2fobw1qqw1SoX0Blfx5mohjNY5psXY
qsDJ6wsoCXyJMqq4lCpWYmN00Wzd/CTpV4lbuZMLDewpVEZeS0eKEu3RxxvH
Q0VYsbhqyt+pxBuWv3GtVgTDUvpNJ0MlaoUGHN6laYz4yspPCxQwmJd7XqTN
oPTXd1CgJrzZ+FD2DKJKEnVUgEtrPmIqmUHYJ8VDCdsVKE5u6/QIEJN5KTBo
v9B0pU4MT2mBb7xAjnfqKAYS/PFzhY5yEBkHHz1yk0BuUBefzJAjRHoZVukS
BL6ZOmsWKMftHedW7DokWMwSGhwzk2NBFUv/a1aCULNIwSmRDOtOXjnK9JGC
zjLRbGmRwXZwZcgoUop8PWRYX6wqHiqRwsbJevqXwzKcjNi7pOyWIlXD+9bP
XQbuPk49oZBiLsr7msMNCdIeMBPjfeTIrklNGAkSoy/c2/kLGwV63U11nEF4
72VrzRMF7N7Kd2NZhH/vs+bu7VOiT7w2LsVIBHZAmHwDV4kfbwdxYpymsKPn
cceIpYrMYwpC6cB8zhYVmacQbsZJr1y/VOOAHs9gW1oQULikRpF+gMYwHBf3
N5OhId+PYqDnLcO/XwP9eDKHoZ7j/emyRkvWG0KY439Z8zu1CNEP6CDUrhdT
PjumJev3o2KMv4x8LSz8mmh+Tb1wT0irl1VpyX494FwvnvTmamGuBx+fn3U0
HpjQkv15MF9/8HWIVAtbPbhY6i+KcV3SknoewvXDJLaXMYFP71Y+zJvrQtro
x/t9aQSprxM1VrJkuj0Bq7xYHTuQyxW5VDsTpN52mNzgfd3nRSDB/oOox/Q2
xE2OZo8FEKT+VrTwPCZPBBNgWTTuFmW0wGtHesrRMIL004xlh8qtsnACx7dV
ducs3gdl63cF3x8iSH/38dPNNrtTsQRKWNa6H9aE59MRlIIkgvTbhMBk5/DY
kwRyPqJT7XPu4fqp5gtnmATp/x6GYNctOE2AuunMLN/4LthV50zr0wkyj0bc
kVj/4JlJYOPELh05oMjdY45kEWQ+DeCZ5FJ9cgiMdvEtlhrqEcqYFrPzV/Oq
w67MJ+VuFwhYV+3SsQ7b3Y3YSYWr+dWC3tWvML9E4H+Ye1V2
       "]]}, 
     {RGBColor[0.5, 0, 0.5], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSmallCircle]",
         StripOnInput->False,
         FontSize->8], {0., 0.}], CompressedData["
1:eJw1k3s01GkYxxmUimoq0WWmi7SLttAV1bdTWKl0lK6KjJQVyYRNNynHRqWt
VmqoxRqMGNRIJJmaWEMjl1yaGWaQufLTTYm0ozP7PZ/nj+d933+e53zeebSQ
bf56Ojo63prS1RRJ5//or1tfx03YW5YM7cE6ztdv4dFMJu7ljOYrLm4enOx5
hY3iYOHDYOEAPNO/f7H4xNG+/win57SmooFS0GdXhc6ueoeT8Pro6MDV3vfD
ILOx1DjwBUz3h9U7m/Yid8X3fAc6H+tfbpy7uEmNcFmcLEi3Bgs2XtegxsLK
OXYNJ2qgNntRkuChhmGq9YLjqMVc7hn9z2Q1XAI5Sx501qJcsSXkZKMKpFOb
M5Ylv8Qs35Is8k0VJJ0CeiVFgJSiPclFe1SwQOeuXKkABsY/hftQVRh+WciS
iOuQbNjNMOxWIsG+rjUp6JV2XiVypMufFfW+QprnrROgK7G6S246hdKI4WlJ
RlwHJTLyjUlmZU3QZ6xPtdRXgucQEJed8hp19rKU4wIFVvwzGGEhagbj9mgU
qJdUR9sub8Wem/4aFLhGolpPsG/D5oU3qg/aKSCJsm4rJL/R7kuB7tk01iwT
IZb2XLb3E8hBqbea+4YjRGvcHQ1yLGpi9FCyRJDr5fiFBMsxPs/39jVPMdZ+
kVyYtFaOdBsTw5+/ijFwrk3v0CQ5+BTzyt032uE6yVNwVCqDyxaBX5ZdB9af
GtdrwZEhPEG3TSXuwB8/IsOTkgZnio0Esy1ndl71kiF7SCdjRagEYb0V+xxt
ZGgVbve5cE+CuM4l9FgDGRzJLU6RgxKtHz0IU/IPR1Kl8Iqd2Npb2IP0LKF6
vo8UOTxPmpXtWyyrW8ALoXRhRn+11E7ShRNjjL9N3deNQGtWXsbDTuygFR74
tPctom3jLnzOkyIjncd9tLgHLxqpu3S5EpA2JScVmMtgUpZyPmm7BMN6DarV
pnLt/iRI6H4/pyFEgVthgdRudgeGT0e7NI9VwudHOsBr3jPzbawS01wtZP7k
DtSaR9n0i5RwV/M0tIN9+NOQiqTCXVmkhnaIRse1VCFPfdx1i007Irr4lcdo
Kli7dZlPlYtRZJVSzMtQYcqbTQFL0sRwHZNZQdSqUPJ6BuuWlxhXeoSJx4ZU
Wv/F6NwQUTNkodb6L8K5v0Ol61zVWv9FuHjHMszbT631XwTq02JF3Vm1dv8t
yDkX0DjysRcFNvc8eGmNuOk+oqsI7wOvezyNblCPeUd9+zc86kPz9BKBvpEA
iYkLmanCPq3vfFBbYuNDR/rgfcDRP3vHv6ilqx+ITQkkdK3SUInBsRktkYsJ
7B8hO0TTeZg+BjE1awhQmMJdO4lnGHA9NpnhRmB6VykzKo2LyMGCd8d3Eqj3
iF7CPluB+G/+n7t9CRjsZnwwHymHMTuztTyYQGKjh/uv9k/wIt/5i34EAZLT
Edo25mPM33qdffs0of1fpWC+j4hpPE/A/qp0deyHRxid7u4lAktXetdz+MU4
0/rF3voqgYq197NR9hDVvTExJn8RCGWe0uPzimCfFXSEyiBAf152+YKUg4Ou
jl6/3CFgHT6lxWgyB6tirJafSiUwleau4QEC5gedOMkkkJVreYTPuI+R9He2
zpkEyjzDRPwPhXC6FCQbYhFgH1pUMWt3Ibi27b85swkEGqUdSK0sgCJ9ohn5
PoGJoYmWB9YWgBR/dq8dh8BKF+dlpDP5+DPPc02spt8fvDUw9jIb190uGfcX
EyB7bY8cZOVhoK1vwutSQutDLlj15bXxjwnUrrSkmI3PhUvUjllxTwgsjnKs
qnK7hx1tvzv3PyUwbhx/96HEHEhr83t0uARu3CVX2ylYsHI28I1+RuA/PDvx
IQ==
       "]]}, 
     {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSmallCircle]",
         StripOnInput->False,
         FontSize->8], {0., 0.}], CompressedData["
1:eJw1VHs0lHkYRpymq4SUSqZCtqKbc0I8Q7kUulh1DpJQ2CIWKZc2u1mWYzmL
FEm1aTG555IyaihMmIbcpcaEMWNmPmxCtdvO2G+e87x//M7v/L73eZ73PR/V
O8j57AIFBQVPaSlKS0laWZkyFCDL+0uV0zsC2rlWUtLB7BjVEzUT2FJyrzZu
io7Bb/2d39cR4DxhaswVPsTbem58cA2BdU0/SlmIA131uFpBYH2nlZRFCFg0
d9fvEQGdeRSj0egYw6SUAGVD9ARzYQnCE4RFPxcRUJhHKRjpeZkDdAKxK6wp
1NhSGO3p+SH3AQG1eZRh2sbanS09Z0Rpe9XklSGg3NbiwH0CqZsPSlkO04rm
8Lo7BPyN7zFiP5WD9ZmbUplJQMO8TN287BEyvnqzjDMIRGkU2w1FVsCbbcv0
TSNwfB6V+CvgvE5WEoEz1CWuzdZVWPSs8/WtRAK2Wh5h7TbVSL58h9MbS2B1
nJeUj3HSwoARFE3g//xqkE/xKOkOl+f1BGYlZQ4uQfJ8alHbYhNt4CvPow60
4yHmVC+5/+ewyLnmcslZ7peJxT5LrJYfkvurR65IW3ufqdxPA7y041J+M5Tr
f4nrw2lbklfJ9TZh1yT16cg/ElIfC9E/rabu65eQelpxWqlaMlogIftzQB3k
faTYS8h+HbDZaOfE9hGT3+/C3AXuF4pACE6w88xIWRdSG8z8E/KFiJaNQ60b
7QE7nZUuCuHot/P2y7BuPA9mbmuyFKI6cKAqcKAbnbvpc1pGQlJfD7YFnqpP
FglgHbVIrFfRgwC6osdytgBTJz6Z5ur3IktXaKlQIEBvwm0ZsWaK17MxWgDt
NTL0YTifFSFyEZD++vBHjmqt3SYB6YeLc+oGM+YafEQsGzFJ7+GiTzctKfvX
UYTMBzCEfGtDO0n3CN50yMAD7WrFyrZVI+T7YYga/Ho1dYdJ/yPQ9V23YvkH
HulnFL5tfyZO6w4hgWccEqfCR/Zb4qjGGBdh4ucnzXfw0W8vEheUcLHOUJuX
4s7HlGvOwkt+XMTPg49z5/rcPDdzSf98LNvFanbtfQ97VRf2hSE+EotnQ2f0
3+NTTN8CX9UxqEx9Y0ji38FylntN1XIMNi5s5VLJIMYW0H2CAscQ7OdYfER/
kMxrDDRa+xGHuLfYPZpk6sMeg1tSOs2jeoD0J0Dsm1+0rqgMwFE/jXVmlwAX
7ivWqqzsh2vGWSkFSNR2bJhQ6yPzFUCv6XYH83MPXpvys0Olc2p7JhtwN5Sz
rO8aKgsRs9eEUfZ7F75q3FjKNBMi/jvVER29TtxzuXkZIUK4PNhePJnZgYd0
GaT3Fv16N0Qc3KIMZ1GGhTBzp/lbRHOgsszgoqfOOIRXOHeTK14ju9L1VqXr
OG4W8SIVP7CxVrZuGeM4sZ+n47CBjTqBU1Dkm3F4t6hYuYW3QZd5RXlGTYS9
+jmNnBetEK1+WZN8TISCyv3d2zVbMb/eqSIIY+kPNWNaYN12UNeoUwSTCsXe
GEoL5tdTSwwGhcZafP4VarrWFNx0F0PFoytgdoKFlf0O0l+MGLzLW/cWHGdh
66EPm9THxNB8tu/S9eZmFIlC7Z12SKD5/uhswPpm5PAjpJRg0kE46c9pwmHR
CykliKN6GpvZNkHDXo9/Vo3A47DWiMa6RuxpP6DutGcS/lFDT58crYfHiaXp
E7Z/Yyj1w2HBaQZKTjEip4XTcMtypxY2VpHzmkP52vveCR9Lyf7/outaUHzo
5zzkFRqef5WlRMuwT2ldUXEH/wEnU+PZ
       "]]}, 
     {RGBColor[1, 0, 1], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSmallCircle]",
         StripOnInput->False,
         FontSize->8], {0., 0.}], CompressedData["
1:eJw1lHs01GkYx4WKE6GmpQmxRVHpgray9cVSktpNrShUQhdZueTkUoeSalfa
5JbbJmJDboU4kXEZM0LIJeQyGHMxMz8Uuogd9ud7vs8f7x/P+5zv533Oq+nk
Ye0iJSEh4SSuBeKSFFfcw1k9xW8li7/d6SZATTUROwPSh5hWgQwC63OSX4WO
ZeBhyOdnlWUEGktolC9ZmSg/EB10s5iAao2n2Fko7fk+6lhAQK3FROxnWEi1
Wz2VR0B9TtkQSB6Ij8klILM6cIS2OAdOHr9elc8mIDGnXLB2SG3/mkkgRNFU
RjMkF84R95/nphNQmlMeXMfqt/+URiA6gHq6OD0Po1fc92umEIhYu1/sfIy6
Ke0JTiRwbnNyachEPuprCpKdEghQjPKWG+U9ByvV5ubHaAIBlOx9LP8XGM+L
yqj5m8DvcypAnbHL1LcwAs6aS+wYpoWg+arFON4msFfZwafJvAjTRRFqq4IJ
qISeFvslSk+ObdQLIPA/v2IYvI6Tkvae51UCv7sOj/3d5vm8giiMOc50nudR
Bntrxr/mx+bzl6PpLHVdrNl8XhoSrivs0NKfz1eB2MVtjlsV5/NUQuntTGxl
l4jsrwKTjdTeMhEo5ofFrkJCXM97er4ITyKtLXWeVOFLq6pGbIoItYpZKfXf
qjCueFek4Ssi81fjeui0rJ6NCI2XrCfZedXYbe/1QUdNhMBZ3Ep0UFcfcY5r
E8Lq7NbEah86RBfqpo+ECFHk3lXo3kXHjxJaG7JMhCSvGrSF/uk5rS2EaYCs
UOtFDeptDRIT5YQYs5nYmarNgJ+sUX6vhBDv7ySKzcDWTe2MeJ4A1JWzYsLQ
dUbHtF1A8mUisFvBJeq1gORZhyDtitD0YwIyfyMG6z9p6XUOk7yace6+MBCG
w2S+VtBMzunm2fLJ+zrwyJNlbPEDj+zvg5mkft3EUg785NmGke194CdOCtKC
h+A1N5AFfu1ZP/UPbLxrnlU/mp2kpjZR2GT/IFiLAq+paA6S89gQ+nw9up7d
T/IZwrJDSxw/rWDhTv9mr9CFHCxRHUi0GeyDj7Dc3mgLB7tGKyqTU/ugqkPt
v3eCg+9rhi5SLvbh1pw4GPSmyEOrj+TJwdP1nluy3/TCQuFowx8s8XmCd6XO
uBcTQR1SrgpcVDO/LzUP7sGez303FPZw4Xc5fEHHcDe4UhlnPNy5SPL97Ja/
t5vkz0Vc24OhwKQP0B8K23mmgYuxn18auRV1kfl48H+y8RfV4U5YaT9gOm/j
QUOzu/+TTCfsol3E5uGrWdJaB/0Oki8PJo8nLC4pvsfbnZwE7wYeYq1WhFny
2yAdZ/pIR5oPtTV02weRrZiixMjRdvFRpqusO3O8BclHY6/Aiw+fyBsd0irN
yMyYFR+8W9MTTiuaEC8zGCczyMfJku0mtPxGLJRfd/mk+jCKS3wDwx+/RUKB
XXyBnfjdq9rsqOwGrJpd3+hhUAWn2mVNG1DGO+jh/24Yl45VCAcC6qFBuyo9
qSRA1KTj+UU9dRCoVBeHHxZgJb1b4/iGOsytU4QAriOTf3VEvIFp/X4NvRYB
ureVRKd01mJu3ZWFcGm5d6rUuRbFrSufxp4QoqqRPyhXzcSyzgPiL0kIndE0
i8x9TGywHFiznCtE3/PbRqM5DDwTeFsc3CJCZ6GkWrkhA0kcP7FFME87v/t8
Qw0OCarEFkElSF89Yl8NKBZaHBclAq3XbO1la+kwaDJbftBgFLeUzVLTHCrg
YCMXObL3Ix7OXOD6WZYix7HUf5w/DqcX4RnatwvJ9/qCR/Ux0lE9ueT8adDP
LNId6E1HepaOW22cpLEme2SZy45/8B8D4PxH
       "]]}, {}}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0.04705, 0},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(J\\), \\(eff\\)]\\)/3\"", TraditionalForm], 
      None}, {
      FormBox["\"T\"", TraditionalForm], None}},
   FrameStyle->Directive[
     GrayLevel[0], 12],
   FrameTicks->{{Automatic, {{0.31666666666666665`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(J\\), \\(eff, c\\)]\\)\"", 
         TraditionalForm], 0.01}}}, {Automatic, {{0.1724137931034483, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(I\\)]\\)\"", TraditionalForm], 
        0.01}, {
        NCache[
         Rational[1, 3], 0.3333333333333333], 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(O\\)]\\)\"", TraditionalForm], 
        0.01}, {0.5102040816326531, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(T\\)]\\)\"", TraditionalForm], 
        0.01}, {0.7692307692307692, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(chi\\)]\\)\"", TraditionalForm], 
        0}, {0.819672131147541, "", 0.01}, {0.8771929824561404, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(D\[Infinity]\\)]\\)\"", 
         TraditionalForm], 0}, {0.8620689655172414, "", 0.01}, {
       0.9900990099009901, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(D2\\)]\\)\"", TraditionalForm], 
        0}, {0.9433962264150942, "", 0.01}}}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   ImageSize->{538.109375, Automatic},
   Method->{},
   PlotRange->{{0.04, 1.45}, {0, 1.1}},
   PlotRangeClipping->True,
   PlotRangePadding->{{0, 0}, {0, 0}},
   Ticks->{Automatic, Automatic}], TraditionalForm]], "Output",
 CellChangeTimes->{3.657281107411249*^9, 3.6572826265490503`*^9, 
  3.6572826583313713`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"ListPlot", "[", 
   RowBox[{
    RowBox[{"{", "OHeating", "}"}], ",", 
    RowBox[{"PlotStyle", "\[Rule]", " ", 
     RowBox[{"{", "Red", "}"}]}], ",", 
    RowBox[{"PlotMarkers", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{"\[FilledSmallCircle]", ",", "8"}], "}"}]}], ",", " ", 
    RowBox[{"PlotRange", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"0.04", ",", "1.45"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}]}], ",", 
    RowBox[{"AspectRatio", "\[Rule]", 
     RowBox[{"1", "/", "GoldenRatio"}]}], ",", 
    RowBox[{"Frame", "\[Rule]", "True"}], ",", 
    RowBox[{"FrameStyle", "->", 
     RowBox[{"Directive", "[", 
      RowBox[{"Black", ",", " ", "12"}], "]"}]}], ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
      "\"\<T\>\"", ",", "\"\<\!\(\*SubscriptBox[\(J\), \(eff\)]\)/3\>\""}], 
      "}"}]}], ",", 
    RowBox[{"FrameTicks", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "yyTicks"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{"Automatic", ",", "xTicks"}], "}"}]}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.657282731182184*^9, 3.657282763686121*^9}}],

Cell[BoxData[
 FormBox[
  GraphicsBox[{{}, {
     {RGBColor[1, 0, 0], AbsolutePointSize[6], AbsoluteThickness[1.6], 
      GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSmallCircle]",
         StripOnInput->False,
         FontSize->8], {0., 0.}], CompressedData["
1:eJw1VHs0lHkYRpymq4SUSqZCtqKbc0I8Q7kUulh1DpJQ2CIWKZc2u1mWYzmL
FEm1aTG555IyaihMmIbcpcaEMWNmPmxCtdvO2G+e87x//M7v/L73eZ73PR/V
O8j57AIFBQVPaSlKS0laWZkyFCDL+0uV0zsC2rlWUtLB7BjVEzUT2FJyrzZu
io7Bb/2d39cR4DxhaswVPsTbem58cA2BdU0/SlmIA131uFpBYH2nlZRFCFg0
d9fvEQGdeRSj0egYw6SUAGVD9ARzYQnCE4RFPxcRUJhHKRjpeZkDdAKxK6wp
1NhSGO3p+SH3AQG1eZRh2sbanS09Z0Rpe9XklSGg3NbiwH0CqZsPSlkO04rm
8Lo7BPyN7zFiP5WD9ZmbUplJQMO8TN287BEyvnqzjDMIRGkU2w1FVsCbbcv0
TSNwfB6V+CvgvE5WEoEz1CWuzdZVWPSs8/WtRAK2Wh5h7TbVSL58h9MbS2B1
nJeUj3HSwoARFE3g//xqkE/xKOkOl+f1BGYlZQ4uQfJ8alHbYhNt4CvPow60
4yHmVC+5/+ewyLnmcslZ7peJxT5LrJYfkvurR65IW3ufqdxPA7y041J+M5Tr
f4nrw2lbklfJ9TZh1yT16cg/ElIfC9E/rabu65eQelpxWqlaMlogIftzQB3k
faTYS8h+HbDZaOfE9hGT3+/C3AXuF4pACE6w88xIWRdSG8z8E/KFiJaNQ60b
7QE7nZUuCuHot/P2y7BuPA9mbmuyFKI6cKAqcKAbnbvpc1pGQlJfD7YFnqpP
FglgHbVIrFfRgwC6osdytgBTJz6Z5ur3IktXaKlQIEBvwm0ZsWaK17MxWgDt
NTL0YTifFSFyEZD++vBHjmqt3SYB6YeLc+oGM+YafEQsGzFJ7+GiTzctKfvX
UYTMBzCEfGtDO0n3CN50yMAD7WrFyrZVI+T7YYga/Ho1dYdJ/yPQ9V23YvkH
HulnFL5tfyZO6w4hgWccEqfCR/Zb4qjGGBdh4ucnzXfw0W8vEheUcLHOUJuX
4s7HlGvOwkt+XMTPg49z5/rcPDdzSf98LNvFanbtfQ97VRf2hSE+EotnQ2f0
3+NTTN8CX9UxqEx9Y0ji38FylntN1XIMNi5s5VLJIMYW0H2CAscQ7OdYfER/
kMxrDDRa+xGHuLfYPZpk6sMeg1tSOs2jeoD0J0Dsm1+0rqgMwFE/jXVmlwAX
7ivWqqzsh2vGWSkFSNR2bJhQ6yPzFUCv6XYH83MPXpvys0Olc2p7JhtwN5Sz
rO8aKgsRs9eEUfZ7F75q3FjKNBMi/jvVER29TtxzuXkZIUK4PNhePJnZgYd0
GaT3Fv16N0Qc3KIMZ1GGhTBzp/lbRHOgsszgoqfOOIRXOHeTK14ju9L1VqXr
OG4W8SIVP7CxVrZuGeM4sZ+n47CBjTqBU1Dkm3F4t6hYuYW3QZd5RXlGTYS9
+jmNnBetEK1+WZN8TISCyv3d2zVbMb/eqSIIY+kPNWNaYN12UNeoUwSTCsXe
GEoL5tdTSwwGhcZafP4VarrWFNx0F0PFoytgdoKFlf0O0l+MGLzLW/cWHGdh
66EPm9THxNB8tu/S9eZmFIlC7Z12SKD5/uhswPpm5PAjpJRg0kE46c9pwmHR
CykliKN6GpvZNkHDXo9/Vo3A47DWiMa6RuxpP6DutGcS/lFDT58crYfHiaXp
E7Z/Yyj1w2HBaQZKTjEip4XTcMtypxY2VpHzmkP52vveCR9Lyf7/outaUHzo
5zzkFRqef5WlRMuwT2ldUXEH/wEnU+PZ
       "]]}, {}}, {}},
   AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
   Axes->{True, True},
   AxesLabel->{None, None},
   AxesOrigin->{0.04705, 0},
   DisplayFunction->Identity,
   Frame->{{True, True}, {True, True}},
   FrameLabel->{{
      FormBox[
      "\"\\!\\(\\*SubscriptBox[\\(J\\), \\(eff\\)]\\)/3\"", TraditionalForm], 
      None}, {
      FormBox["\"T\"", TraditionalForm], None}},
   FrameStyle->Directive[
     GrayLevel[0], 12],
   FrameTicks->{{Automatic, {{0.31666666666666665`, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(J\\), \\(eff, c\\)]\\)\"", 
         TraditionalForm], 0.01}}}, {Automatic, {{0.1724137931034483, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(I\\)]\\)\"", TraditionalForm], 
        0.01}, {
        NCache[
         Rational[1, 3], 0.3333333333333333], 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(O\\)]\\)\"", TraditionalForm], 
        0.01}, {0.5102040816326531, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(T\\)]\\)\"", TraditionalForm], 
        0.01}, {0.7692307692307692, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(chi\\)]\\)\"", TraditionalForm], 
        0}, {0.819672131147541, "", 0.01}, {0.8771929824561404, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(D\[Infinity]\\)]\\)\"", 
         TraditionalForm], 0}, {0.8620689655172414, "", 0.01}, {
       0.9900990099009901, 
        FormBox[
        "\"\\!\\(\\*SubscriptBox[\\(T\\), \\(D2\\)]\\)\"", TraditionalForm], 
        0}, {0.9433962264150942, "", 0.01}}}},
   GridLines->{None, None},
   GridLinesStyle->Directive[
     GrayLevel[0.5, 0.4]],
   Method->{},
   PlotRange->{{0.04, 1.45}, {0, 1.1}},
   PlotRangeClipping->True,
   PlotRangePadding->{{0, 0}, {0, 0}},
   Ticks->{Automatic, Automatic}], TraditionalForm]], "Output",
 CellChangeTimes->{3.657282765203361*^9}]
}, Open  ]],

Cell[BoxData[
 FormBox[
  FormBox["",
   TraditionalForm], TraditionalForm]], "Input",
 CellChangeTimes->{{3.656612791903585*^9, 3.656612814649642*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{"\"\</Users/Ke/Desktop/Jeff.pdf\>\"", ",", "Jeff"}], "]"}]], "Input",\

 CellChangeTimes->{{3.656614716035871*^9, 3.656614744612256*^9}}],

Cell[BoxData[
 FormBox["\<\"/Users/Ke/Desktop/Jeff.pdf\"\>", TraditionalForm]], "Output",
 CellChangeTimes->{
  3.656614745794869*^9, 3.656614807871257*^9, 3.656666925652996*^9, 
   3.657195642320137*^9, 3.657200576168026*^9, {3.657200643417152*^9, 
   3.6572006457708197`*^9}, 3.659639395023382*^9, 3.659640273881299*^9, 
   3.659642036845483*^9, 3.659645268482505*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.659640112057725*^9, 3.6596401512102213`*^9}}]
},
WindowSize->{632, 774},
WindowMargins->{{-8, Automatic}, {Automatic, 0}},
FrontEndVersion->"10.3 for Mac OS X x86 (32-bit, 64-bit Kernel) (October 9, \
2015)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 354, 6, 28, "Input"],
Cell[915, 28, 2721, 63, 607, "Input"],
Cell[3639, 93, 6805, 201, 556, "Input"],
Cell[10447, 296, 18404, 415, 858, "Input"],
Cell[CellGroupData[{
Cell[28876, 715, 10121, 259, 691, "Input"],
Cell[39000, 976, 80388, 1559, 301, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[119425, 2540, 300, 6, 63, "Input"],
Cell[119728, 2548, 50321, 986, 361, "Output"],
Cell[170052, 3536, 11789, 223, 361, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[181878, 3764, 1317, 36, 114, "Input"],
Cell[183198, 3802, 3983, 85, 251, "Output"]
}, Open  ]],
Cell[187196, 3890, 152, 4, 28, "Input"],
Cell[CellGroupData[{
Cell[187373, 3898, 186, 4, 28, "Input"],
Cell[187562, 3904, 370, 6, 86, "Output"]
}, Open  ]],
Cell[187947, 3913, 113, 1, 46, "Input"]
}
]
*)

(* End of internal cache information *)
