(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 10.0' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[     39854,       1003]
NotebookOptionsPosition[     38593,        958]
NotebookOutlinePosition[     38925,        973]
CellTagsIndexPosition[     38882,        970]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{
Cell[BoxData[
 RowBox[{
  RowBox[{"SetDirectory", "[", "\"\</home/ke/Documents/XY-ZN\>\"", "]"}], ";",
   " ", 
  RowBox[{"(*", 
   RowBox[{"set", " ", "directory"}], "*)"}]}]], "Input",
 CellChangeTimes->{{3.627282789633087*^9, 3.627282824790003*^9}, {
  3.627283134455329*^9, 3.627283159970231*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{"XY", "-", "Z2"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataAllZ2", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z2-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", "All", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data1Z2", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z2-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", 
         RowBox[{"{", 
          RowBox[{
          "1", ",", "2", ",", "3", ",", "4", ",", "5", ",", "6", ",", "7", 
           ",", "8", ",", "9", ",", "10", ",", "11"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], " ", ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"data2Z2", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z2-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", 
         RowBox[{"Range", "[", 
          RowBox[{"12", ",", "15"}], "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], " ", ";", 
    RowBox[{"(*", 
     RowBox[{
      RowBox[{
       RowBox[{
       "\"\<name.type\>\"", "import", " ", "data", " ", "from", " ", "file"}],
        ";", " ", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{"\"\<Data\>\"", ",", "row", ",", "column", ",", "..."}], 
         "}"}], "\"\<Data\>\"", " ", "specify", " ", "the", " ", "data"}]}], 
      ",", "row", ",", 
      RowBox[{"column", " ", "specify", " ", "the", " ", 
       RowBox[{"data", ".", " ", "All"}]}], ",", " ", 
      RowBox[{
       RowBox[{"all", " ", "rows", 
        RowBox[{"(", 
         RowBox[{
         "or", " ", "colomns", " ", "depending", " ", "the", " ", 
          "position"}], ")"}]}], ";", 
       RowBox[{"Range", "[", "11", "]"}]}], ",", 
      RowBox[{"first", " ", "11", " ", "rows"}], ",", 
      RowBox[{"-", 
       RowBox[{"Range", "[", "11", "]"}]}], ",", 
      RowBox[{"last", " ", "11", " ", 
       RowBox[{"row", ".", " ", 
        RowBox[{"Range", "[", 
         RowBox[{"12", ",", "15"}], "]"}]}]}], ",", 
      RowBox[{"12", "th", " ", "to", " ", "15", "th", " ", 
       RowBox[{"rows", ".", 
        RowBox[{"{", 
         RowBox[{"2", ",", "4"}], "}"}]}], " ", "the", " ", "2", "nd", " ", 
       "and", " ", "4", "th", " ", 
       RowBox[{"column", "/", 
        RowBox[{"rows", "."}]}]}]}], "*)"}]}]}]}]], "Input",
 CellChangeTimes->{{3.6272828451046877`*^9, 3.627282857019289*^9}, {
   3.62728291951612*^9, 3.6272829229544373`*^9}, {3.62728316694733*^9, 
   3.627283223745514*^9}, {3.627283286414596*^9, 3.627283326455241*^9}, {
   3.6272833576462708`*^9, 3.627283370223165*^9}, {3.627284165125051*^9, 
   3.62728419288771*^9}, {3.6272843244167233`*^9, 3.627284490660446*^9}, {
   3.6272845211928167`*^9, 3.627284543085443*^9}, {3.627284574936248*^9, 
   3.6272848051787977`*^9}, {3.6272856654572153`*^9, 
   3.6272856730940247`*^9}, {3.627285725556509*^9, 3.6272857793485727`*^9}, 
   3.627285922169263*^9, {3.627286750164576*^9, 3.627286765871217*^9}, 
   3.627286866512638*^9, {3.6272869178885202`*^9, 3.627286928691436*^9}, {
   3.627287003064876*^9, 3.627287089872633*^9}, 3.627291315367222*^9, {
   3.627291358969048*^9, 3.627291405894195*^9}, {3.6272919486315603`*^9, 
   3.6272919542046337`*^9}}],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.627282929079637*^9, 3.627282929574061*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plotAll", " ", "=", " ", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"dataAllZ2", ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", "Blue", "}"}]}], ",", 
      RowBox[{"PlotMarkers", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[FilledSquare]", ",", "14"}], "}"}]}], ",", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "1"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "2"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", 
      RowBox[{"FrameLabel", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"K", ",", "J"}], "}"}]}]}], "]"}]}], ";"}], " ", 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"plot", " ", "by", " ", "points"}], ",", 
    RowBox[{"*", "PlotStyle", " ", "specify", " ", "color"}], ",", " ", 
    "dash", ",", 
    RowBox[{"thickness", ".", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", " ", "dash", ",", " ", "thick"}], "}"}]}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot1", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data1Z2", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Gray"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot2", " ", "=", " ", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data2Z2", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Gray"}]}], "]"}]}], ";", " ", 
  RowBox[{"(*", 
   RowBox[{"plot", " ", "by", " ", "line"}], "*)"}]}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJxTTMoPSmViYGAQB2IQPe2iiX0d22tHtcYoRxD946mhQT2QVtnsAqYf8DP5
guiw3IYwEB2zj7EWRPcevd4PojfO+DsVRO9qN58Gol83+Ms3AGmu/lh1EM33
/K0xiDZy1TMF0Qf+fnED0fHdG91BtBRLgHgzkF68IUYCRN956e0Boo/duR8O
or8UxMaAaElPtlgQLfN3bWkLSJz9ejWIFnm5oB5Ez7fKbATRWU8fdYLoaXqn
Z4LoIMfvW0D0zLD83SB6/9HpZ0H0hX+PwLRY/rT7IPrF2dgnYPOair6B6Fef
2X6CaC7j6/9AdJphKkMrkDbtXMQCop8JerOB6OTZhkog2sLfFkzbah/sB9Em
i49NBNEJi7dNBdFXCkOmgWgArTCqJA==
  "]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"p1", " ", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"plotAll", ",", "plot1", ",", "plot2"}], "]"}]}], 
  "\[IndentingNewLine]"}]], "Input",
 CellChangeTimes->{{3.627282937650584*^9, 3.627282954828265*^9}, {
   3.6272848655593224`*^9, 3.6272848661468678`*^9}, {3.627285096064438*^9, 
   3.6272851720133467`*^9}, {3.627285480054487*^9, 3.627285630742865*^9}, {
   3.627285679924889*^9, 3.627285681735318*^9}, {3.627286778484487*^9, 
   3.627286842923711*^9}, {3.627286943434455*^9, 3.6272869534459467`*^9}, {
   3.6272870956559753`*^9, 3.627287101548263*^9}, {3.6272928585005007`*^9, 
   3.627292866896562*^9}, {3.6272932503722973`*^9, 3.6272933749957*^9}, {
   3.627293410920038*^9, 3.627293416196423*^9}, {3.627295661437147*^9, 
   3.627295710719721*^9}, {3.627295741028452*^9, 3.627295755288406*^9}, {
   3.6272958230905046`*^9, 3.6272959503494368`*^9}, {3.6272961677267237`*^9, 
   3.627296219479321*^9}, {3.627296364742889*^9, 3.627296367093605*^9}, {
   3.6272965087010603`*^9, 3.627296546931385*^9}, {3.6272966915783787`*^9, 
   3.6272967122172747`*^9}, 3.6272967587249804`*^9}],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[0, 0, 1], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSquare]",
         StripOnInput->False,
         FontSize->14], {0., 0.}], {{{0., 1.6}}, {{0.1, 1.42}}, {{0.2, 
       1.22}}, {{0.3, 1.06}}, {{0.4, 0.9}}, {{0.5, 0.74}}, {{0.6, 0.62}}, {{
       0.7, 0.5}}, {{0.8, 0.5}}, {{0.9, 0.48}}, {{1., 0.46}}, {{0.75, 
       0.48}}, {{0.75, 0.4}}, {{0.75, 0.2}}, {{0.75, 
       0.}}}]}, {}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{0., 1.6}, {0.1, 1.42}, {0.2, 1.22}, {0.3, 1.06}, {0.4, 
       0.9}, {0.5, 0.74}, {0.6, 0.62}, {0.7, 0.5}, {0.8, 0.5}, {0.9, 0.48}, {
       1., 0.46}}]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{0.75, 0.48}, {0.75, 0.4}, {0.75, 0.2}, {0.75, 
       0.}}]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["J", TraditionalForm], None}, {
     FormBox["K", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{0, 1}, {0, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{
  3.6272967736853733`*^9, 3.6272969847517643`*^9, 3.627297048274066*^9, {
   3.627297960496462*^9, 3.627297980979898*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plotXYZ2", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"p1", ",", 
    RowBox[{"PlotLabel", "\[Rule]", "None"}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", "Bold"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.627306090449614*^9, 3.6273061014305687`*^9}},
 NumberMarks->False],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[0, 0, 1], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSquare]",
         StripOnInput->False,
         FontSize->14], {0., 0.}], {{{0., 1.6}}, {{0.1, 1.42}}, {{0.2, 
       1.22}}, {{0.3, 1.06}}, {{0.4, 0.9}}, {{0.5, 0.74}}, {{0.6, 0.62}}, {{
       0.7, 0.5}}, {{0.8, 0.5}}, {{0.9, 0.48}}, {{1., 0.46}}, {{0.75, 
       0.48}}, {{0.75, 0.4}}, {{0.75, 0.2}}, {{0.75, 
       0.}}}]}, {}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{0., 1.6}, {0.1, 1.42}, {0.2, 1.22}, {0.3, 1.06}, {0.4, 
       0.9}, {0.5, 0.74}, {0.6, 0.62}, {0.7, 0.5}, {0.8, 0.5}, {0.9, 0.48}, {
       1., 0.46}}]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{0.75, 0.48}, {0.75, 0.4}, {0.75, 0.2}, {0.75, 
       0.}}]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox["J", TraditionalForm], None}, {
     FormBox["K", TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{
    GrayLevel[0], Bold},
  Method->{},
  PlotLabel->None,
  PlotRange->{{0, 1}, {0, 2}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{3.627297995727229*^9, 3.627306105304957*^9}]
}, Open  ]],

Cell[BoxData[
 RowBox[{"\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{"XY", "-", "Z6"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataAllZ6", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z6-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", "All", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], " ", ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data1Z6", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z6-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", 
         RowBox[{"Range", "[", "8", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], " ", ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"data2Z6", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z6-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", 
         RowBox[{"Range", "[", 
          RowBox[{"9", ",", "12"}], "]"}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], " ", 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.6272828451046877`*^9, 3.627282857019289*^9}, {
   3.62728291951612*^9, 3.6272829229544373`*^9}, {3.62728316694733*^9, 
   3.627283223745514*^9}, {3.627283286414596*^9, 3.627283326455241*^9}, {
   3.6272833576462708`*^9, 3.627283370223165*^9}, {3.627284165125051*^9, 
   3.62728419288771*^9}, {3.6272843244167233`*^9, 3.627284490660446*^9}, {
   3.6272845211928167`*^9, 3.627284543085443*^9}, {3.627284574936248*^9, 
   3.6272848051787977`*^9}, {3.6272856654572153`*^9, 
   3.6272856730940247`*^9}, {3.627285725556509*^9, 3.6272857793485727`*^9}, 
   3.627285922169263*^9, {3.627286750164576*^9, 3.627286765871217*^9}, 
   3.627286866512638*^9, {3.6272869178885202`*^9, 3.627286928691436*^9}, {
   3.627287003064876*^9, 3.627287089872633*^9}, {3.627287128232665*^9, 
   3.6272871443243027`*^9}, {3.627291059285006*^9, 3.627291196121722*^9}, 
   3.627291311256641*^9, {3.6272919345717*^9, 3.627291963917898*^9}, {
   3.62729207892113*^9, 3.627292091063036*^9}, {3.627297345988008*^9, 
   3.627297356813788*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plotAllZ6", " ", "=", " ", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"dataAllZ6", ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", "Blue", "}"}]}], ",", 
      RowBox[{"PlotMarkers", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[FilledSquare]", ",", "14"}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"0", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "14"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"Epilog", "\[Rule]", 
       RowBox[{"Inset", "[", 
        RowBox[{"smallZ6", ",", 
         RowBox[{"{", 
          RowBox[{"2.8", ",", "9"}], "}"}]}], "]"}]}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"plot", " ", "by", " ", "points"}], ",", 
    RowBox[{"*", "PlotStyle", " ", "specify", " ", "color"}], ",", " ", 
    "dash", ",", 
    RowBox[{"thickness", ".", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", " ", "dash", ",", " ", "thick"}], "}"}]}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot1Z6", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data1Z6", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Gray"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot2Z6", " ", "=", " ", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data2Z6", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Gray"}]}], "]"}]}], ";", " ", 
  RowBox[{"(*", 
   RowBox[{"plot", " ", "by", " ", "line"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"plotZ6", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"plotAllZ6", ",", "plot1Z6", ",", "plot2Z6"}], "]"}], 
   "\[IndentingNewLine]"}]}]}], "Input",
 CellChangeTimes->CompressedData["
1:eJwdzk0ogwEAxvHXLOFAGUsSE40ihs18TtNmyFqhpWU2qyHf0w4+wuZri167
sEQuVlZykdjsgGIlVjaJi8MoObztoCRheJ8dnn6X5/DP0g236BkEQaTTg/YA
v3Y6hhJzzSox/Hwp5s3Q5hxIIgYTGXKoHDQpYcdJ1BQkvQ82uL8eXoMei9AO
KZMi00Qbb1PnwoTXUCkskRYK4Fn4vR5qlvdl8NyQ4Z6lHXFGn0IP9emFt4G6
a9g6fvMFU0NNv9AYvGTO4belS4E/z9Uc+BQnzIZlbpkAsgw1ItiyS6mhb+lP
C92c9sd5dA0cRvT728oXaJP6+kUwlhMlh4TvO2JvMlsFr0JMDWzWbvRANt8y
BDdXBEbod5ERHSzXGBxImzTDiq4qKzSF9SS0OxzbcNR5sQPf7hVFi7R5hIQH
P472JJA7fdwIj6WVFthw0G2FnQVDJLzLn1iF/3CMy0E=
  "]],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[0, 0, 1], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSquare]",
         StripOnInput->False,
         FontSize->14], {0., 0.}], {{{0., 12.2}}, {{0.5, 10.}}, {{1., 
       7.5}}, {{1.5, 5.}}, {{2., 3.}}, {{2.5, 1.}}, {{2.9, 0.5}}, {{3., 
       0.5}}, {{3.5, 0.5}}, {{4., 0.5}}, {{3., 0.5}}, {{3., 0.4}}, {{3., 
       0.2}}, {{3., 0.}}}]}, {}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{0., 12.2}, {0.5, 10.}, {1., 7.5}, {1.5, 5.}, {2., 3.}, {
       2.5, 1.}, {2.9, 0.5}, {3., 0.5}, {3.5, 0.5}, {4., 
       0.5}}]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{3., 0.}, {3., 0.2}, {3., 0.4}, {3., 0.5}}]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Epilog->InsetBox[
    GraphicsBox[{{{}, {{{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.019444444444444445`], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1]], 
          GeometricTransformationBox[
           InsetBox[
            BoxData[
             FormBox[
              StyleBox[
              "\[FilledSquare]", FontSize -> 14, StripOnInput -> False], 
              TraditionalForm]], {0., 0.}], {{{0., 12.2}}, {{0.5, 10.}}, {{1.,
            7.5}}, {{1.5, 5.}}, {{2., 3.}}, {{2.5, 1.}}, {{2.9, 0.5}}, {{3., 
           0.5}}, {{3.5, 0.5}}, {{4., 0.5}}, {{3., 0.5}}, {{3., 0.4}}, {{3., 
           0.2}}, {{3., 0.}}}]}, {}}}, {}}, {{}, {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.019444444444444445`], 
           AbsoluteThickness[1.6], 
           GrayLevel[0.5]], 
          
          LineBox[{{0., 12.2}, {0.5, 10.}, {1., 7.5}, {1.5, 5.}, {2., 3.}, {
           2.5, 1.}, {2.9, 0.5}, {3., 0.5}, {3.5, 0.5}, {4., 
           0.5}}]}}}, {}}, {{}, {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.019444444444444445`], 
           AbsoluteThickness[1.6], 
           GrayLevel[0.5]], 
          LineBox[{{3., 0.}, {3., 0.2}, {3., 0.4}, {3., 0.5}}]}}}, {}}}, {
     DisplayFunction -> Identity, PlotRangePadding -> {{0, 0}, {0, 0}}, 
      AxesOrigin -> {2.5075, 0}, PlotRange -> {{2.5, 4}, {0, 1.1}}, 
      DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {None, None}, AxesOrigin -> {2.5075, 0}, DisplayFunction :> 
      Identity, Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{None, None}, {None, None}}, FrameTicks -> {{{{0, 
           FormBox["0", TraditionalForm]}, {0.1, ""}, {0.2, ""}, {0.3, ""}, {
          0.4, ""}, {0.5, 
           FormBox["0.5`", TraditionalForm]}, {0.6, ""}, {0.7, ""}, {
          0.8, ""}, {0.9, ""}, {1., 
           FormBox["1", TraditionalForm]}}, {{0, ""}, {0.1, ""}, {0.2, ""}, {
          0.3, ""}, {0.4, ""}, {0.5, ""}, {0.6, ""}, {0.7, ""}, {0.8, ""}, {
          0.9, ""}, {1., ""}}}, {{{2.5, 
           FormBox["2.5`", TraditionalForm]}, {2.6, ""}, {2.7, ""}, {
          2.8, ""}, {2.9, ""}, {3., 
           FormBox["3", TraditionalForm]}, {3.1, ""}, {3.2, ""}, {3.3, ""}, {
          3.4, ""}, {3.5, 
           FormBox["3.5`", TraditionalForm]}, {3.6, ""}, {3.7, ""}, {
          3.8, ""}, {3.9, ""}, {4., 
           FormBox["4", TraditionalForm]}}, {{2.5, ""}, {2.6, ""}, {
          2.7, ""}, {2.8, ""}, {2.9, ""}, {3., ""}, {3.1, ""}, {3.2, ""}, {
          3.3, ""}, {3.4, ""}, {3.5, ""}, {3.6, ""}, {3.7, ""}, {3.8, ""}, {
          3.9, ""}, {4., ""}}}}, GridLines -> {None, None}, GridLinesStyle -> 
      Directive[
        GrayLevel[0.5, 0.4]], Method -> {}, PlotRange -> {{2.5, 4}, {0, 1.1}},
       PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
      Ticks -> {Automatic, Automatic}}], {2.8, 9}],
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{0, 4}, {0, 14}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.627297232563586*^9, 3.6272972681317797`*^9}, {
   3.627297362771553*^9, 3.627297392366085*^9}, {3.6272976268760147`*^9, 
   3.627297653037231*^9}, {3.627297691421042*^9, 3.627297701506732*^9}, 
   3.6272978046335*^9, 3.627297900527614*^9, 3.627298103566593*^9, {
   3.627299389509787*^9, 3.6272994077608347`*^9}, 3.6272999086489573`*^9, {
   3.627299954731105*^9, 3.62730000450045*^9}, 3.6273057470322657`*^9, 
   3.6273059474006844`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"plotXYZ6", "=", 
  RowBox[{"Show", "[", 
   RowBox[{"%790", ",", 
    RowBox[{"FrameLabel", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"{", 
        RowBox[{
         RowBox[{"HoldForm", "[", "J", "]"}], ",", "None"}], "}"}], ",", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"HoldForm", "[", "K", "]"}], ",", "None"}], "}"}]}], "}"}]}],
     ",", 
    RowBox[{"PlotLabel", "\[Rule]", "None"}], ",", 
    RowBox[{"LabelStyle", "\[Rule]", 
     RowBox[{"{", 
      RowBox[{
       RowBox[{"GrayLevel", "[", "0", "]"}], ",", "Bold"}], "}"}]}]}], 
   "]"}]}]], "Input",
 CellChangeTimes->{{3.627305980994206*^9, 3.627305985979637*^9}},
 NumberMarks->False],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[0, 0, 1], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSquare]",
         StripOnInput->False,
         FontSize->14], {0., 0.}], {{{0., 12.2}}, {{0.5, 10.}}, {{1., 
       7.5}}, {{1.5, 5.}}, {{2., 3.}}, {{2.5, 1.}}, {{2.9, 0.5}}, {{3., 
       0.5}}, {{3.5, 0.5}}, {{4., 0.5}}, {{3., 0.5}}, {{3., 0.4}}, {{3., 
       0.2}}, {{3., 0.}}}]}, {}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{0., 12.2}, {0.5, 10.}, {1., 7.5}, {1.5, 5.}, {2., 3.}, {
       2.5, 1.}, {2.9, 0.5}, {3., 0.5}, {3.5, 0.5}, {4., 
       0.5}}]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{3., 0.}, {3., 0.2}, {3., 0.4}, {3., 0.5}}]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{0, 0},
  DisplayFunction->Identity,
  Epilog->InsetBox[
    GraphicsBox[{{{}, {{{
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.019444444444444445`], 
           AbsoluteThickness[1.6], 
           RGBColor[0, 0, 1]], 
          GeometricTransformationBox[
           InsetBox[
            BoxData[
             FormBox[
              StyleBox[
              "\[FilledSquare]", FontSize -> 14, StripOnInput -> False], 
              TraditionalForm]], {0., 0.}], {{{0., 12.2}}, {{0.5, 10.}}, {{1.,
            7.5}}, {{1.5, 5.}}, {{2., 3.}}, {{2.5, 1.}}, {{2.9, 0.5}}, {{3., 
           0.5}}, {{3.5, 0.5}}, {{4., 0.5}}, {{3., 0.5}}, {{3., 0.4}}, {{3., 
           0.2}}, {{3., 0.}}}]}, {}}}, {}}, {{}, {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.019444444444444445`], 
           AbsoluteThickness[1.6], 
           GrayLevel[0.5]], 
          
          LineBox[{{0., 12.2}, {0.5, 10.}, {1., 7.5}, {1.5, 5.}, {2., 3.}, {
           2.5, 1.}, {2.9, 0.5}, {3., 0.5}, {3.5, 0.5}, {4., 
           0.5}}]}}}, {}}, {{}, {{{}, {}, {
          Hue[0.67, 0.6, 0.6], 
          Directive[
           PointSize[0.019444444444444445`], 
           AbsoluteThickness[1.6], 
           GrayLevel[0.5]], 
          LineBox[{{3., 0.}, {3., 0.2}, {3., 0.4}, {3., 0.5}}]}}}, {}}}, {
     DisplayFunction -> Identity, PlotRangePadding -> {{0, 0}, {0, 0}}, 
      AxesOrigin -> {2.5075, 0}, PlotRange -> {{2.5, 4}, {0, 1.1}}, 
      DisplayFunction -> Identity, AspectRatio -> 
      NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
      AxesLabel -> {None, None}, AxesOrigin -> {2.5075, 0}, DisplayFunction :> 
      Identity, Frame -> {{True, True}, {True, True}}, 
      FrameLabel -> {{None, None}, {None, None}}, FrameTicks -> {{{{0, 
           FormBox["0", TraditionalForm]}, {0.1, ""}, {0.2, ""}, {0.3, ""}, {
          0.4, ""}, {0.5, 
           FormBox["0.5`", TraditionalForm]}, {0.6, ""}, {0.7, ""}, {
          0.8, ""}, {0.9, ""}, {1., 
           FormBox["1", TraditionalForm]}}, {{0, ""}, {0.1, ""}, {0.2, ""}, {
          0.3, ""}, {0.4, ""}, {0.5, ""}, {0.6, ""}, {0.7, ""}, {0.8, ""}, {
          0.9, ""}, {1., ""}}}, {{{2.5, 
           FormBox["2.5`", TraditionalForm]}, {2.6, ""}, {2.7, ""}, {
          2.8, ""}, {2.9, ""}, {3., 
           FormBox["3", TraditionalForm]}, {3.1, ""}, {3.2, ""}, {3.3, ""}, {
          3.4, ""}, {3.5, 
           FormBox["3.5`", TraditionalForm]}, {3.6, ""}, {3.7, ""}, {
          3.8, ""}, {3.9, ""}, {4., 
           FormBox["4", TraditionalForm]}}, {{2.5, ""}, {2.6, ""}, {
          2.7, ""}, {2.8, ""}, {2.9, ""}, {3., ""}, {3.1, ""}, {3.2, ""}, {
          3.3, ""}, {3.4, ""}, {3.5, ""}, {3.6, ""}, {3.7, ""}, {3.8, ""}, {
          3.9, ""}, {4., ""}}}}, GridLines -> {None, None}, GridLinesStyle -> 
      Directive[
        GrayLevel[0.5, 0.4]], Method -> {}, PlotRange -> {{2.5, 4}, {0, 1.1}},
       PlotRangeClipping -> True, PlotRangePadding -> {{0, 0}, {0, 0}}, 
      Ticks -> {Automatic, Automatic}}], {2.8, 9}],
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{
     FormBox[
      TagBox["J", HoldForm], TraditionalForm], None}, {
     FormBox[
      TagBox["K", HoldForm], TraditionalForm], None}},
  FrameTicks->{{Automatic, Automatic}, {Automatic, Automatic}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  LabelStyle->{
    GrayLevel[0], Bold},
  Method->{},
  PlotLabel->None,
  PlotRange->{{0, 4}, {0, 14}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.627305976617382*^9, 3.627305990160739*^9}}]
}, Open  ]],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"small", " ", "XY"}], "-", "Z6"}], "*)"}], "\[IndentingNewLine]", 
  "\[IndentingNewLine]", "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"dataAllZ6", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z6-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", "All", ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], ";"}], " ", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"data1Z6", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z6-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", 
         RowBox[{"Range", "[", "10", "]"}], ",", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], " ", ";"}], 
   "\n", 
   RowBox[{
    RowBox[{"data2Z6", " ", "=", " ", 
     RowBox[{"Import", "[", 
      RowBox[{"\"\<XY-Z6-J-K.data\>\"", ",", 
       RowBox[{"{", 
        RowBox[{"\"\<Data\>\"", ",", 
         RowBox[{"-", 
          RowBox[{"Range", "[", "4", "]"}]}], ",", " ", 
         RowBox[{"{", 
          RowBox[{"2", ",", "4"}], "}"}]}], "}"}]}], "]"}]}], " ", 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.627298166562642*^9, 3.627298173856406*^9}, {
   3.627298435347711*^9, 3.627298475685944*^9}, {3.62729854602394*^9, 
   3.6272985963591557`*^9}, {3.627298656331215*^9, 3.6272986649091*^9}, 
   3.6272987635519867`*^9, {3.6273042560938463`*^9, 3.6273042607714643`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"leftticks", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "0"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "0.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", "1"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"rightticks", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"0", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.1", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.2", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.3", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.4", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.5", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.6", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.7", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.8", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"0.9", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"1.0", ",", "Null"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"bottomicks", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.5", ",", "2.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.7", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.8", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.9", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.0", ",", "3"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.1", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.4", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.5", ",", "3.5"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.6", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.7", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.8", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.0", ",", "4"}], "}"}]}], "}"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"topicks", "=", 
   RowBox[{"{", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"2.5", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.6", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.7", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.8", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"2.9", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.0", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.1", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.2", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.3", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.4", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.5", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.6", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.7", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.8", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"3.9", ",", "Null"}], "}"}], ",", 
     RowBox[{"{", 
      RowBox[{"4.0", ",", "Null"}], "}"}]}], "}"}]}], ";"}]}], "Input",
 CellChangeTimes->{{3.627298166562642*^9, 3.627298173856406*^9}, {
   3.627298435347711*^9, 3.627298475685944*^9}, {3.62729854602394*^9, 
   3.6272985963591557`*^9}, {3.627298656331215*^9, 3.6272986649091*^9}, 
   3.6272987635519867`*^9, {3.6273042560938463`*^9, 3.627304270114524*^9}, {
   3.627304300134062*^9, 3.627304359879272*^9}, {3.627304407578082*^9, 
   3.627304482206276*^9}, {3.627304849935923*^9, 3.627304899138914*^9}, {
   3.6273051816324797`*^9, 3.627305270065796*^9}, {3.627305338267932*^9, 
   3.6273056655149403`*^9}, {3.627305714564334*^9, 3.627305714716959*^9}, {
   3.6273059200128813`*^9, 3.627305929374196*^9}}],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{
   RowBox[{"plotAllZ6", " ", "=", " ", 
    RowBox[{"ListPlot", "[", 
     RowBox[{"dataAllZ6", ",", 
      RowBox[{"PlotStyle", "\[Rule]", 
       RowBox[{"{", "Blue", "}"}]}], ",", 
      RowBox[{"PlotMarkers", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{"\[FilledSquare]", ",", "14"}], "}"}]}], ",", 
      RowBox[{"Frame", "\[Rule]", "True"}], ",", " ", 
      RowBox[{"PlotRange", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"2.5", ",", "4"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"0", ",", "1.1"}], "}"}]}], "}"}]}], ",", 
      RowBox[{"FrameTicks", "\[Rule]", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"{", 
          RowBox[{"leftticks", ",", "rightticks"}], "}"}], ",", 
         RowBox[{"{", 
          RowBox[{"bottomicks", ",", "topicks"}], "}"}]}], "}"}]}]}], "]"}]}],
    ";"}], "\[IndentingNewLine]", 
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"plot", " ", "by", " ", "points"}], ",", 
    RowBox[{"*", "PlotStyle", " ", "specify", " ", "color"}], ",", " ", 
    "dash", ",", 
    RowBox[{"thickness", ".", 
     RowBox[{"{", 
      RowBox[{"Blue", ",", " ", "dash", ",", " ", "thick"}], "}"}]}]}], 
   "*)"}]}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot1Z6", "=", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data1Z6", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Gray"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"plot2Z6", " ", "=", " ", 
   RowBox[{"ListLinePlot", "[", 
    RowBox[{"data2Z6", ",", 
     RowBox[{"PlotStyle", "\[Rule]", "Gray"}]}], "]"}]}], ";", " ", 
  RowBox[{"(*", 
   RowBox[{"plot", " ", "by", " ", "line"}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{"smallZ6", "=", 
   RowBox[{"Show", "[", 
    RowBox[{"plotAllZ6", ",", "plot1Z6", ",", "plot2Z6"}], 
    "]"}]}]}]}], "Input",
 CellChangeTimes->{{3.627298187367332*^9, 3.627298246044333*^9}, {
  3.62729916923699*^9, 3.627299173895732*^9}, {3.627302177063733*^9, 
  3.62730219121791*^9}, {3.627303094633243*^9, 3.6273031643299513`*^9}, {
  3.627303897108597*^9, 3.627303915412181*^9}, {3.6273041728379087`*^9, 
  3.62730423490596*^9}, {3.62730427957545*^9, 3.6273043134223833`*^9}, {
  3.6273044906987133`*^9, 3.6273044966198893`*^9}, {3.627304557747251*^9, 
  3.627304574811501*^9}, {3.62730483720328*^9, 3.6273048467137213`*^9}, {
  3.627305461119438*^9, 3.627305464429977*^9}, {3.6273056718174458`*^9, 
  3.627305723633875*^9}}],

Cell[BoxData[
 GraphicsBox[{{{}, {
     {RGBColor[0, 0, 1], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], GeometricTransformationBox[InsetBox[
        StyleBox["\[FilledSquare]",
         StripOnInput->False,
         FontSize->14], {0., 0.}], {{{0., 12.2}}, {{0.5, 10.}}, {{1., 
       7.5}}, {{1.5, 5.}}, {{2., 3.}}, {{2.5, 1.}}, {{2.9, 0.5}}, {{3., 
       0.5}}, {{3.5, 0.5}}, {{4., 0.5}}, {{3., 0.5}}, {{3., 0.4}}, {{3., 
       0.2}}, {{3., 0.}}}]}, {}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{0., 12.2}, {0.5, 10.}, {1., 7.5}, {1.5, 5.}, {2., 3.}, {
       2.5, 1.}, {2.9, 0.5}, {3., 0.5}, {3.5, 0.5}, {4., 
       0.5}}]}}, {}}, {{}, {{}, {}, 
     {GrayLevel[0.5], PointSize[0.019444444444444445`], AbsoluteThickness[
      1.6], LineBox[{{3., 0.}, {3., 0.2}, {3., 0.4}, {3., 0.5}}]}}, {}}},
  AspectRatio->NCache[GoldenRatio^(-1), 0.6180339887498948],
  Axes->{True, True},
  AxesLabel->{None, None},
  AxesOrigin->{2.5075, 0},
  DisplayFunction->Identity,
  Frame->{{True, True}, {True, True}},
  FrameLabel->{{None, None}, {None, None}},
  FrameTicks->{{{{0, 
       FormBox["0", TraditionalForm]}, {0.1, ""}, {0.2, ""}, {0.3, ""}, {
      0.4, ""}, {0.5, 
       FormBox["0.5`", TraditionalForm]}, {0.6, ""}, {0.7, ""}, {0.8, ""}, {
      0.9, ""}, {1., 
       FormBox["1", TraditionalForm]}}, {{0, ""}, {0.1, ""}, {0.2, ""}, {
      0.3, ""}, {0.4, ""}, {0.5, ""}, {0.6, ""}, {0.7, ""}, {0.8, ""}, {
      0.9, ""}, {1., ""}}}, {{{2.5, 
       FormBox["2.5`", TraditionalForm]}, {2.6, ""}, {2.7, ""}, {2.8, ""}, {
      2.9, ""}, {3., 
       FormBox["3", TraditionalForm]}, {3.1, ""}, {3.2, ""}, {3.3, ""}, {
      3.4, ""}, {3.5, 
       FormBox["3.5`", TraditionalForm]}, {3.6, ""}, {3.7, ""}, {3.8, ""}, {
      3.9, ""}, {4., 
       FormBox["4", TraditionalForm]}}, {{2.5, ""}, {2.6, ""}, {2.7, ""}, {
      2.8, ""}, {2.9, ""}, {3., ""}, {3.1, ""}, {3.2, ""}, {3.3, ""}, {
      3.4, ""}, {3.5, ""}, {3.6, ""}, {3.7, ""}, {3.8, ""}, {3.9, ""}, {
      4., ""}}}},
  GridLines->{None, None},
  GridLinesStyle->Directive[
    GrayLevel[0.5, 0.4]],
  Method->{},
  PlotRange->{{2.5, 4}, {0, 1.1}},
  PlotRangeClipping->True,
  PlotRangePadding->{{0, 0}, {0, 0}},
  Ticks->{Automatic, Automatic}]], "Output",
 CellChangeTimes->{{3.6273056986205378`*^9, 3.6273057245294*^9}, 
   3.6273059391525183`*^9}]
}, Open  ]],

Cell[BoxData[""], "Input",
 CellChangeTimes->{{3.627302811152885*^9, 3.6273028112254343`*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"Export", "[", 
  RowBox[{
  "\"\</home/ke/Desktop/phase_digram_XY-Z2.pdf\>\"", ",", "plotXYZ2"}], "]"}]],\
 "Input",
 CellChangeTimes->{{3.6273007028954067`*^9, 3.6273007052774487`*^9}, {
  3.62730219628721*^9, 3.62730226936582*^9}, {3.627306003948512*^9, 
  3.627306027895958*^9}, {3.627306059671482*^9, 3.627306066236747*^9}, {
  3.6273061132326927`*^9, 3.627306116212998*^9}}],

Cell[BoxData["\<\"/home/ke/Desktop/phase_digram_XY-Z2.pdf\"\>"], "Output",
 CellChangeTimes->{{3.627302245697324*^9, 3.6273022706782217`*^9}, 
   3.6273060342786903`*^9, 3.627306068281728*^9, 3.627306118625259*^9}]
}, Open  ]],

Cell[BoxData["\[IndentingNewLine]"], "Input",
 CellChangeTimes->{{3.627324775590067*^9, 3.627324784022641*^9}}]
},
WindowSize->{799, 875},
WindowMargins->{{Automatic, 0}, {Automatic, 0}},
FrontEndVersion->"10.0 for Linux x86 (64-bit) (June 27, 2014)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[558, 20, 301, 7, 32, "Input"],
Cell[862, 29, 3535, 84, 275, "Input"],
Cell[4400, 115, 92, 1, 32, "Input"],
Cell[4495, 118, 1999, 53, 165, "Input"],
Cell[CellGroupData[{
Cell[6519, 175, 1119, 18, 55, "Input"],
Cell[7641, 195, 1731, 38, 253, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[9409, 238, 394, 11, 32, "Input"],
Cell[9806, 251, 1712, 39, 254, "Output"]
}, Open  ]],
Cell[11533, 293, 2247, 50, 143, "Input"],
Cell[CellGroupData[{
Cell[13805, 347, 2323, 60, 209, "Input"],
Cell[16131, 409, 4935, 98, 250, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[21103, 512, 706, 21, 77, "Input"],
Cell[21812, 535, 4712, 99, 259, "Output"]
}, Open  ]],
Cell[26539, 637, 1528, 40, 143, "Input"],
Cell[28070, 679, 4718, 136, 297, "Input"],
Cell[CellGroupData[{
Cell[32813, 819, 2476, 61, 187, "Input"],
Cell[35292, 882, 2417, 50, 255, "Output"]
}, Open  ]],
Cell[37724, 935, 94, 1, 32, InheritFromParent],
Cell[CellGroupData[{
Cell[37843, 940, 403, 8, 32, InheritFromParent],
Cell[38249, 950, 214, 2, 32, "Output"]
}, Open  ]],
Cell[38478, 955, 111, 1, 55, "Input"]
}
]
*)

(* End of internal cache information *)
