## Contributing Factors to Flight-Centric Complexity in En-Route Air Traffic Control ##
Authors: G. de Rooij, A. Stienstra, C. Borst, A.B. Tisza, M.M. van Paassen, M. Mulder

Faculty of Aerospace Engineering, Delft University of Technology

Corresponding author: G. de Rooij

Contact Information:
g.derooij@tudelft.nl

## General Introduction ##

This dataset contains data collected from 15 professional air traffic controllers 
during a human-in-the-loop experiment at Maastricht Upper Area Control Centre (MUAC) 
in the Netherlands. It accompanies the following article:
"Contributing Factors to Flight-Centric Complexity in En-Route Air Traffic Control"
http://resolver.tudelft.nl/uuid:5bbdd7aa-5d43-48e6-974c-ebcf76d3472a

## Description of the data collection campaign ##

See the Method section of the accompanying article for a description of the data 
collection campaign which ran in May 2022 and March 2023:
"Contributing Factors to Flight-Centric Complexity in En-Route Air Traffic Control"
http://resolver.tudelft.nl/uuid:5bbdd7aa-5d43-48e6-974c-ebcf76d3472a

## Description of the data in this data set ##

There is just a single file in this data set: a comma seperated file called `data.csv'.
Each row gives the characteristics of a flight with respect to a scenario's flight of 
interest and the number of air traffic controllers that included this flight when asked
whether it added to the perceived complexity of the flight of interest (FOI).

The columns are as follows:

|column|description|unit|
|---|---|---|
|sector|MUAC sector group|n/a|
|scenario|Scenario identifier|n/a|
|altitude_ft|Current altitude|feet|
|target_altitude_ft|Cleared altitude|feet|
|exit_altitude_ft|Exit altitude|feet|
|copx|Exit coordination point identifier|n/a|
|flightstate|Flightstate|n/a|
|distance_nm|Current distance with respect to FOI|NM|
|distance_to_copx_nm|Distance to exit coordination point|NM|
|altitude_diff_ft|Altitude difference between flight and FOI|feet|
|exit_altitude_diff_ft|Exit altitude difference between flight and FOI|feet|
|altitude_to_climbdescend_ft|Altitude to climb or descend till exit altitude|feet|
|gs_diff_kts|Groundspeed difference between flight and FOI|feet|
|time_to_copx_s|Time to go till exit coordination point|sec|
|cpa_s|Time to go till closest point of approach|sec|
|cpa_nm|Separation at closest point of approach with respect to FOI|NM|
|convergence_angle_deg|Convergence angle with respect to FOI|deg|
|altitude_overlap|Overlapping altitude bands|bool|
|min_altitude_ft|Minimum planned altitude|feet|
|max_altitude_ft|Maximum planned altitude|feet|
|climbing|Climbing flight|bool|
|descending|Descending flight|bool|
|number_of_inclusions|Number of air traffic controllers that included this flight|int|