clc
close all
clear all
format long
%% Membrane Data & Global Parameters (always run in beginning!)
%System: PAHPAA 10 BL
%Membrane Data
L = 0.17625; % Fiber Length [m]
d = 0.0007; % Fiber diameter [m]
Ri = d/2; % Fiber radius [m]
Pw_F=[1.795379304 1.787562536 1.772098261 1.937877443 2.905087626 2.877060588 3.020850131 3.19959866 3.918396004 3.846977075 3.886079336 4.175925428]; % Flux from pure water measurement [L/(m^2h)]
Pw_P=[2.025 2.025 2.025 2.025 2.99 2.99 2.99 2.99 4.01 4.01 4.01 4.01]; % Pressure from pure water measurement [bar]
vw = 1; %crossflow velocity [m/s]
vm = 1; %crossflow velocity [m/s]
fluxMW = ones(8,12);
for i=1:4 %Flux from PEG retention measurement, make matrix [L/(m^2h)]
fluxMW(i*2-1,:)=[1.577301992 1.484918777 1.577301992 1.484020157 3.069194758 2.978949555 3.160812512 3.1861113 4.689956454 4.496941523 4.580887699 5.013677681]; %EG
fluxMW(i*2,:)=[1.603310695 1.177248106 1.603310695 1.66448708 3.171383792 2.917527915 3.08916273 3.259512537 5.13953254 4.606623023 5.226432849 5.299008931]; %DEG 
end
fluxMW = fluxMW./1000./60./60; %flux to [m/s]
ret62 = [0.162 0.168 0.172 0.168 0.258 0.269 0.272 0.262 0.338 0.348 0.36 0.351]; %Retention of EG at each Flux [-]
ret106 = [0.759 0.8 0.783 0.77 0.847 0.863 0.867 0.867 0.882 0.891 0.886 0.884]; %Retention of DEG at each Flux [-]
ret200 = [0.919 0.938 0.944 0.941 0.935 0.94 0.947 0.937 0.948 0.957 0.963 0.962]; %Retention of 200 at each Flux [-]
ret400 = [0.966 0.98 0.977 0.972 0.96 0.963 0.973 0.97 0.972 0.974 0.975 0.972]; %Retention of 400 at each Flux [-]
ret600 = [0.983 0.991 0.998  0.998 0.973 0.969 0.982 0.972 0.98 0.983 0.993 0.992]; %Retention of 600 at each Flux [-]
ret1000 = [0.981 0.986 0.99 0.984 0.966 0.966 0.978 0.974 0.976 0.976 0.978 0.975]; %Retention of 1000 at each Flux [-]
ret2000 = [0.997 0.998 0.998 0.998 0.987 0.986 0.997 0.989 0.992 0.997 0.998 0.998]; %Retention of 2000 at each Flux [-]
ret3000 = [0.989 0.997 0.996 0.996 0.974 0.976 0.984 0.98 0.982 0.985 0.988 0.982]; %Retention of 3000 at each Flux [-]

%get average and 95% confidence intervals
for j=1:1:8
for i=1:1:3
fluxMWavg(j,i)=sum(fluxMW(j,(i-1)*4+1:i*4))/4;
fluxMWci(j,i)=std(fluxMW(j,(i-1)*4+1:i*4))/2*tinv(0.975,3);
end
end
for i=1:1:3
ret62avg(i)=sum(ret62((i-1)*4+1:i*4))/4;
ret62ci(i)=std(ret62((i-1)*4+1:i*4))/2*tinv(0.975,3);
ret106avg(i)=sum(ret106((i-1)*4+1:i*4))/4;
ret106ci(i)=std(ret106((i-1)*4+1:i*4))/2*tinv(0.975,3);
ret200avg(i)=sum(ret200((i-1)*4+1:i*4))/4;
ret200ci(i)=std(ret200((i-1)*4+1:i*4))/2*tinv(0.975,3);
ret400avg(i)=sum(ret400((i-1)*4+1:i*4))/4;
ret400ci(i)=std(ret400((i-1)*4+1:i*4))/2*tinv(0.975,3);
ret600avg(i)=sum(ret600((i-1)*4+1:i*4))/4;
ret600ci(i)=std(ret600((i-1)*4+1:i*4))/2*tinv(0.975,3);
ret1000avg(i)=sum(ret1000((i-1)*4+1:i*4))/4;
ret1000ci(i)=std(ret1000((i-1)*4+1:i*4))/2*tinv(0.975,3);
ret2000avg(i)=sum(ret2000((i-1)*4+1:i*4))/4;
ret2000ci(i)=std(ret2000((i-1)*4+1:i*4))/2*tinv(0.975,3);
ret3000avg(i)=sum(ret3000((i-1)*4+1:i*4))/4;
ret3000ci(i)=std(ret3000((i-1)*4+1:i*4))/2*tinv(0.975,3);
end

figure;
hold on;
plot(fluxMW(1,:),ret62,'.','MarkerSize',16,'Color',[0,0,0]);
plot(fluxMW(2,:),ret106,'.','MarkerSize',16,'Color',[0,0,0]);
plot(fluxMW(3,:),ret200,'.','MarkerSize',16,'Color',[0,0,0]);
plot(fluxMW(4,:),ret400,'.','MarkerSize',16,'Color',[0,0,0]);
plot(fluxMW(5,:),ret600,'.','MarkerSize',16,'Color',[0,0,0]);
plot(fluxMW(6,:),ret1000,'.','MarkerSize',16,'Color',[0,0,0]);
plot(fluxMW(7,:),ret2000,'.','MarkerSize',16,'Color',[0,0,0]);
plot(fluxMW(8,:),ret3000,'.','MarkerSize',16,'Color',[0,0,0]);
axis([0 2E-6 0 1])
hold off;

%Parameters
eta = 1.0016E-3; %water viscosity [Pa*s]
rho = 998.21; %density [kg/m^3]
Na = 6.02214076*10^23; %Avogadro constant [1/mol]
kB = physconst('Boltzmann'); %Boltzmann constant [J/K]
Rg = 8.314; %ideal gas constant [J/(mol*K)]
T = 293.15; %temperature [K]
e0 = 1.602*10^(-19); %elementary charge [C]
eps_0 = 8.854*10^(-12); %vacuum permittivity [C/(V*m)]
F = 96500; %Faraday constant [C/mol]
n = 40; %x dimension (radial direction) grid points
relax = 0.5; %relaxation coefficient
residual = 10^(-5); %residual DSPM&DE
maxIter = 300; %maximum Number of Iterations DSPM^DE
cmass = 1; % concentration PEG [g/L]
MW = [62 106 200 400 600 1000 2000 3000]; % Molecular Weight PEG [g/mol]
Cf = cmass./MW*1000; % molar concentration PEG [mol/m^3]
% %MWC1
% D_inf = 1.25E-8*(T/298.15)*(0.89E-3/eta)*MW.^(-0.55); % Diffusion Coefficient PEG [m^2/s]
% rS = kB*T./(6*pi*eta*D_inf); % Stokes Radii PEG [m]
%MWC2
D_inf = 6.279E-9*(T/303.15)*(0.973E-3/eta)*MW.^(-0.43); % Diffusion Coefficient PEG [m^2/s]
rS = kB*T./(6*pi*eta*D_inf); % Stokes Radii PEG [m]

%% Model Fit Pore Radius and Effective Membrane Thickness
%initial guess pore size and thickness
rp_0=3.3E-10; %effective pore radius [m]
dxe_0=5E-6; %effective membrane thickness [m]
%numerical solution
Jvn=reshape(fluxMW',[size(fluxMW,1)*size(fluxMW,2),1])';
par = [Jvn ret62 ret106 ret200 ret400 ret600 ret1000 ret2000 ret3000 ...
    Cf vm L d Ri maxIter n relax residual D_inf rS rho eta F Rg T Pw_P Pw_F];
var0=[rp_0*10^10 dxe_0*10^6]; %starting value pore radius
lb=[2 0];
ub=[30 100];
options = optimset('Display','iter','TolFun',10^(-8),'TolX',10^(-8)); % see the sum of squared deviations per iteration
fitfun = @(x) SinglePoreSizeFit(x,par);
[parm1,resnorm1,res1,exitflag1,output1,lambda1,jac1] = lsqnonlin(fitfun,var0,lb,ub,options); 
rp = parm1(1);
dxe = parm1(2);
%get SSE without weighing
nPEG=size(ret62,2)+size(ret106,2)+size(ret200,2)+size(ret400,2)+size(ret600,2)+size(ret1000,2)+size(ret2000,2)+size(ret3000,2);
nPWP=size(Pw_F,2);
res2=ones(1,size(res1,2));
res2(end-nPWP+1:end)=res1(end-nPWP+1:end).*(0.05*Pw_F)*nPWP;%from (Pw_F-PWP.*Pw_P)/n_PWP/(0.05*Pw_F)
res2(1:end-nPWP)=res1(1:end-nPWP).*(0.01)*(nPEG);%from (r_62-ret_62)/n_PEG/(0.01)
SSE_PEG=sum(res2(1:end-nPWP).^2);
MSE_PEG=SSE_PEG/(nPEG-2);
SSE_PWP=sum(res2(end-nPWP+1:end).^2);
MSE_PWP=SSE_PWP/(nPWP-2);
SSE=sum(res2.^2);
MSE=SSE/(size(res1,2)-2);
%confidence
ci=nlparci([rp dxe],res1,'Jacobian',jac1);  
rp=rp*10^(-10);
RpCI=rp-ci(1,1)*10^(-10);
dxe=dxe*10^(-6);
dxeCI=dxe-ci(2,1)*10^(-6);
PWP=rp^2/dxe*1000*60*60*10^5/8/eta;
jac=full(jac1);
xtx=jac'*jac;
xtxinv=inv(xtx);
%calc correlation matrix cor and variance inflation varinf
varinf = diag(xtxinv);
cor = xtxinv./sqrt(varinf*varinf');

%normal plot for PEG retention fit error
figure;
normplot(res2(1:end-nPWP));

%retention vs flux plot
Jv = 0.2E-6:0.1E-6:1.8E-6;
K1=PWP/1000/60/60/10^5*8*eta;
par = [Jv(1) Jv(end) Jv(2)-Jv(1) Cf K1 vm L d Ri maxIter n relax residual D_inf rS rho eta F Rg T];
mod = SinglePoreSizePlot(rp,par);

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(fluxMWavg(1,:),ret62avg,'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
plot(fluxMWavg(2,:),ret106avg,'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
plot(fluxMWavg(3,:),ret200avg,'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
plot(fluxMWavg(4,:),ret400avg,'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
plot(fluxMWavg(5,:),ret600avg,'.','MarkerSize',16,'Color',[118,230,67]./255);%'k'
plot(fluxMWavg(6,:),ret1000avg,'.','MarkerSize',16,'Color',[230,68,62]./255);%'b'
plot(fluxMWavg(7,:),ret2000avg,'.','MarkerSize',16,'Color',[96,58,232]./255);%'r'
plot(fluxMWavg(8,:),ret3000avg,'.','MarkerSize',16,'Color',[0,0,0]./255);%[.5 0 .5]
errorbar(fluxMWavg(1,:),ret62avg,ret62ci,ret62ci,fluxMWci(1,:),fluxMWci(1,:),'.','MarkerSize',16,'Color',[0,0,0]);
errorbar(fluxMWavg(2,:),ret106avg,ret106ci,ret106ci,fluxMWci(2,:),fluxMWci(2,:),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(fluxMWavg(3,:),ret200avg,ret200ci,ret200ci,fluxMWci(3,:),fluxMWci(3,:),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(fluxMWavg(4,:),ret400avg,ret400ci,ret400ci,fluxMWci(4,:),fluxMWci(4,:),'.','MarkerSize',16,'Color',[118,230,67]./255);
errorbar(fluxMWavg(5,:),ret600avg,ret600ci,ret600ci,fluxMWci(5,:),fluxMWci(5,:),'.','MarkerSize',16,'Color',[0,0,0]);
errorbar(fluxMWavg(6,:),ret1000avg,ret1000ci,ret1000ci,fluxMWci(6,:),fluxMWci(6,:),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(fluxMWavg(7,:),ret2000avg,ret2000ci,ret2000ci,fluxMWci(7,:),fluxMWci(7,:),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(fluxMWavg(8,:),ret3000avg,ret3000ci,ret3000ci,fluxMWci(8,:),fluxMWci(8,:),'.','MarkerSize',16,'Color',[118,230,67]./255);
plot(Jv,mod(1,:),'--','Color',[0,0,0]);
plot(Jv,mod(2,:),'--','Color',[96,58,232]./255);
plot(Jv,mod(3,:),'--','Color',[230,68,62]./255);
plot(Jv,mod(4,:),'--','Color',[118,230,67]./255);
plot(Jv,mod(5,:),'--','Color',[0,0,0]);
plot(Jv,mod(6,:),'--','Color',[96,58,232]./255);
plot(Jv,mod(7,:),'--','Color',[230,68,62]./255);
plot(Jv,mod(8,:),'--','Color',[118,230,67]./255);
axis([0 1.8E-6 0 1])
xlabel('Flux [m/s]');
ylabel('Retention [-]');
xticks([10 20 30 40 50]);
set(gca,'FontSize',15)
ylabel('Retention [-]');
yticks([0.2 0.4 0.6 0.8 1]);
legend('3000','2000','1000','600','400','200','106','62');
[leg, icons, plots, txt]  = legend('show');
title(leg,{'PEG MW','[Da]'})
legend('boxoff');
leg.FontSize = 13;
hold off;

Out1=['The effetive pore radius is: ',num2str(rp,10)];
disp(Out1);
Out1=['The 95% Confidence of pore radius is: ',num2str(RpCI,10)];
disp(Out1);
Out1=['The effetive membrane thickness is: ',num2str(dxe,10)];
disp(Out1);
Out1=['The 95% Confidence of thickness is: ',num2str(dxeCI,10)];
disp(Out1);
Out1=['The Chi squared is: ',num2str(resnorm1,10)];
disp(Out1);
Out1=['The sum of squared error for PEG is: ',num2str(SSE_PEG,10)];
disp(Out1);
Out1=['The mean squared error for PEG is: ',num2str(MSE_PEG,10)];
disp(Out1);

%residual plot
figure;
hold on;
box on;
pbaspect([1 1 1])
plot(fluxMW(1,:),res1(1:size(fluxMW,2)).^2,'.');
plot(fluxMW(2,:),res1(size(fluxMW,2)+1:2*size(fluxMW,2)).^2,'.');
plot(fluxMW(3,:),res1(2*size(fluxMW,2)+1:3*size(fluxMW,2)).^2,'.');
plot(fluxMW(4,:),res1(3*size(fluxMW,2)+1:4*size(fluxMW,2)).^2,'.');
plot(fluxMW(5,:),res1(4*size(fluxMW,2)+1:5*size(fluxMW,2)).^2,'.');
plot(fluxMW(6,:),res1(5*size(fluxMW,2)+1:6*size(fluxMW,2)).^2,'.');
plot(fluxMW(7,:),res1(6*size(fluxMW,2)+1:7*size(fluxMW,2)).^2,'.');
plot(fluxMW(8,:),res1(7*size(fluxMW,2)+1:8*size(fluxMW,2)).^2,'.');
hold off;
%% Model Fit Pore Radius + Imperfections and Effective Membrane Thickness
%initial guess pore size, imperfections and thickness
rp_0=3.0E-9; %effective pore radius [m]
dxe_0=rp_0^2/K1; %effective membrane thickness [m]
f0=0.02; % relative flux through imperfections [-]
%numerical solution
Jvn=reshape(fluxMW',[size(fluxMW,1)*size(fluxMW,2),1])';
par = [Jvn ret62 ret106 ret200 ret400 ret600 ret1000 ret2000 ret3000 ...
    Cf vm L d Ri maxIter n relax residual D_inf rS rho eta F Rg T Pw_P Pw_F];
var0 = [rp_0*10^10 dxe_0*10^6 f0]; %starting value pore radius
lb = [2 0 0];
ub = [16 100 0.5];
options = optimset('Display','iter','TolFun',10^(-8),'TolX',10^(-8)); % see the sum of squared deviations per iteration
fitfun = @(x) SinglePoreSizeImperfectionFit(x,par);
[parm1,resnorm1,res1,exitflag1,output1,lambda1,jac1] = lsqnonlin(fitfun,var0,lb,ub,options); 
rp = parm1(1);
dxe = parm1(2);
f = parm1(3);
%get SSE without weighing
nPEG=size(ret62,2)+size(ret106,2)+size(ret200,2)+size(ret400,2)+size(ret600,2)+size(ret1000,2)+size(ret2000,2)+size(ret3000,2);
nPWP=size(Pw_F,2);
res2=ones(1,size(res1,2));
res2(end-nPWP+1:end)=res1(end-nPWP+1:end).*(0.05*Pw_F)*nPWP;%from (Pw_F-PWP.*Pw_P)/n_PWP/(0.05*Pw_F)
res2(1:end-nPWP)=res1(1:end-nPWP).*(0.01)*(nPEG);%from (r_62-ret_62)/n_PEG/(0.01)
SSE_PEG=sum(res2(1:end-nPWP).^2);
MSE_PEG=SSE_PEG/(nPEG-2);
SSE_PWP=sum(res2(end-nPWP+1:end).^2);
MSE_PWP=SSE_PWP/(nPWP-2);
SSE=sum(res2.^2);
MSE=SSE/(size(res1,2)-2);
%confidence
ci=nlparci([rp dxe f],res1,'Jacobian',jac1); 
rp=rp*10^(-10);
RpCI=rp-ci(1,1)*10^(-10);
dxe=dxe*10^(-6);
dxeCI=dxe-ci(2,1)*10^(-6);
fCi=f-ci(3,1);
PWP=rp^2/dxe*1000*60*60*10^5/8/eta;
jac=full(jac1);
xtx=jac'*jac;
xtxinv=inv(xtx);
      
%calc correlation matrix cor and variance inflation varinf
varinf = diag(xtxinv);
cor = xtxinv./sqrt(varinf*varinf');

%normal plot for PEG retention fit error
figure;
normplot(res2(1:end-nPWP));

%retention vs flux plot
Jv = 0.2E-6:0.1E-6:1.8E-6;%for plot more Jv
Jtest=Jv*(1-f);

par = [Jtest(1) Jtest(end) Jtest(2)-Jtest(1) Cf K1 vm L d Ri maxIter n relax residual D_inf rS rho eta F Rg T];
mod = SinglePoreSizePlot(rp,par);

ret_62=mod(1,:);
ret_106=mod(2,:);
ret_200=mod(3,:);
ret_400=mod(4,:);
ret_600=mod(5,:);
ret_1000=mod(6,:);
ret_2000=mod(7,:);
ret_3000=mod(8,:);

c_p1=(1-ret_62)*Cf(1);
c_p2=(1-ret_106)*Cf(2);
c_p3=(1-ret_200)*Cf(3);
c_p4=(1-ret_400)*Cf(4);
c_p5=(1-ret_600)*Cf(5);
c_p6=(1-ret_1000)*Cf(6);
c_p7=(1-ret_2000)*Cf(7);
c_p8=(1-ret_3000)*Cf(8);

Re0=rho*2*Ri*vm/eta; %inlet Reynolds number [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jtest/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
Sc2=eta/rho/D_inf(2); %inlet Schmidt number [-]
Sh2=1.62*Re0^(1/3)*Sc2^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc2^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc2=Sh2/(2*Ri/D_inf(2)); 
phi2=Jtest/kc2;
suc2=phi2+(1+0.26*phi2.^(1.4)).^(-1.7);
kc2s=kc2*suc2;
Sc3=eta/rho/D_inf(3); %inlet Schmidt number [-]
Sh3=1.62*Re0^(1/3)*Sc3^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc3^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc3=Sh3/(2*Ri/D_inf(3)); 
phi3=Jtest/kc3;
suc3=phi3+(1+0.26*phi3.^(1.4)).^(-1.7);
kc3s=kc3*suc3;
Sc4=eta/rho/D_inf(4); %inlet Schmidt number [-]
Sh4=1.62*Re0^(1/3)*Sc4^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc4^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc4=Sh4/(2*Ri/D_inf(4)); 
phi4=Jtest/kc4;
suc4=phi4+(1+0.26*phi4.^(1.4)).^(-1.7);
kc4s=kc4*suc4;
Sc5=eta/rho/D_inf(5); %inlet Schmidt number [-]
Sh5=1.62*Re0^(1/3)*Sc5^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc5^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc5=Sh5/(2*Ri/D_inf(5)); 
phi5=Jtest/kc5;
suc5=phi5+(1+0.26*phi5.^(1.4)).^(-1.7);
kc5s=kc5*suc5;
Sc6=eta/rho/D_inf(6); %inlet Schmidt number [-]
Sh6=1.62*Re0^(1/3)*Sc6^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc6^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc6=Sh6/(2*Ri/D_inf(6)); 
phi6=Jtest/kc6;
suc6=phi6+(1+0.26*phi6.^(1.4)).^(-1.7);
kc6s=kc6*suc6;
Sc7=eta/rho/D_inf(7); %inlet Schmidt number [-]
Sh7=1.62*Re0^(1/3)*Sc7^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc7^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc7=Sh7/(2*Ri/D_inf(7)); 
phi7=Jtest/kc7;
suc7=phi7+(1+0.26*phi7.^(1.4)).^(-1.7);
kc7s=kc7*suc7;
Sc8=eta/rho/D_inf(8); %inlet Schmidt number [-]
Sh8=1.62*Re0^(1/3)*Sc8^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc8^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc8=Sh8/(2*Ri/D_inf(8)); 
phi8=Jtest/kc8;
suc8=phi8+(1+0.26*phi8.^(1.4)).^(-1.7);
kc8s=kc8*suc8;

C62M=(c_p1.*Jtest-Cf(1)*kc1s)./(Jtest-kc1s);
C106M=(c_p2.*Jtest-Cf(2)*kc2s)./(Jtest-kc2s);
C200M=(c_p3.*Jtest-Cf(3)*kc3s)./(Jtest-kc3s);
C400M=(c_p4.*Jtest-Cf(4)*kc4s)./(Jtest-kc4s);
C600M=(c_p5.*Jtest-Cf(5)*kc5s)./(Jtest-kc5s);
C1000M=(c_p6.*Jtest-Cf(6)*kc6s)./(Jtest-kc6s);
C2000M=(c_p7.*Jtest-Cf(7)*kc7s)./(Jtest-kc7s);
C3000M=(c_p8.*Jtest-Cf(8)*kc8s)./(Jtest-kc8s);

ret_62=1-(c_p1*(1-f)+C62M*f)./Cf(1);
ret_106=1-(c_p2*(1-f)+C106M*f)./Cf(2);
ret_200=1-(c_p3*(1-f)+C200M*f)./Cf(3);
ret_400=1-(c_p4*(1-f)+C400M*f)./Cf(4);
ret_600=1-(c_p5*(1-f)+C600M*f)./Cf(5);
ret_1000=1-(c_p6*(1-f)+C1000M*f)./Cf(6);
ret_2000=1-(c_p7*(1-f)+C2000M*f)./Cf(7);
ret_3000=1-(c_p8*(1-f)+C3000M*f)./Cf(8);

figure;
hold on;
errorbar(fluxMWavg(1,:),ret62avg,ret62ci,ret62ci,fluxMWci(1,:),fluxMWci(1,:),'.','MarkerSize',16,'Color',[0,0,0]);
errorbar(fluxMWavg(2,:),ret106avg,ret106ci,ret106ci,fluxMWci(2,:),fluxMWci(2,:),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(fluxMWavg(3,:),ret200avg,ret200ci,ret200ci,fluxMWci(3,:),fluxMWci(3,:),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(fluxMWavg(4,:),ret400avg,ret400ci,ret400ci,fluxMWci(4,:),fluxMWci(4,:),'.','MarkerSize',16,'Color',[118,230,67]./255);
errorbar(fluxMWavg(5,:),ret600avg,ret600ci,ret600ci,fluxMWci(5,:),fluxMWci(5,:),'.','MarkerSize',16,'Color',[0,0,0]);
errorbar(fluxMWavg(6,:),ret1000avg,ret1000ci,ret1000ci,fluxMWci(6,:),fluxMWci(6,:),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(fluxMWavg(7,:),ret2000avg,ret2000ci,ret2000ci,fluxMWci(7,:),fluxMWci(7,:),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(fluxMWavg(8,:),ret3000avg,ret3000ci,ret3000ci,fluxMWci(8,:),fluxMWci(8,:),'.','MarkerSize',16,'Color',[118,230,67]./255);
plot(Jv,ret_62,'--','Color',[0,0,0]);
plot(Jv,ret_106,'--','Color',[96,58,232]./255);
plot(Jv,ret_200,'--','Color',[230,68,62]./255);
plot(Jv,ret_400,'--','Color',[118,230,67]./255);
plot(Jv,ret_600,'--','Color',[0,0,0]);
plot(Jv,ret_1000,'--','Color',[96,58,232]./255);
plot(Jv,ret_2000,'--','Color',[230,68,62]./255);
plot(Jv,ret_3000,'--','Color',[118,230,67]./255);
axis([0 1.8E-6 0 1])
xlabel('Flux [m/s]');
ylabel('Retention [-]');
box on;
hold off;

Out1=['The effetive pore radius is: ',num2str(rp,10)];
disp(Out1);
Out1=['The 95% Confidence of pore radius is: ',num2str(RpCI,10)];
disp(Out1);
Out1=['The effetive membrane thickness is: ',num2str(dxe,10)];
disp(Out1);
Out1=['The 95% Confidence of thickness is: ',num2str(dxeCI,10)];
disp(Out1);
Out1=['The f Factor in % is: ',num2str(f*100,10)];
disp(Out1);
Out1=['The 95% Confidence of the f Factor in % is: ',num2str(fCi*100,10)];
disp(Out1);
Out1=['The Chi squared is: ',num2str(resnorm1,10)];
disp(Out1);
Out1=['The sum of squared error for PEG is: ',num2str(SSE_PEG,10)];
disp(Out1);
Out1=['The mean squared error for PEG is: ',num2str(MSE_PEG,10)];
disp(Out1);

%residual plot
figure;
hold on;
box on;
pbaspect([1 1 1])
plot(fluxMW(1,:),res1(1:size(fluxMW,2)).^2,'.');
plot(fluxMW(2,:),res1(size(fluxMW,2)+1:2*size(fluxMW,2)).^2,'.');
plot(fluxMW(3,:),res1(2*size(fluxMW,2)+1:3*size(fluxMW,2)).^2,'.');
plot(fluxMW(4,:),res1(3*size(fluxMW,2)+1:4*size(fluxMW,2)).^2,'.');
plot(fluxMW(5,:),res1(4*size(fluxMW,2)+1:5*size(fluxMW,2)).^2,'.');
plot(fluxMW(6,:),res1(5*size(fluxMW,2)+1:6*size(fluxMW,2)).^2,'.');
plot(fluxMW(7,:),res1(6*size(fluxMW,2)+1:7*size(fluxMW,2)).^2,'.');
plot(fluxMW(8,:),res1(7*size(fluxMW,2)+1:8*size(fluxMW,2)).^2,'.');
hold off;
%% Pore Size Distribution Fit
clear cor
minfval=100;
dxe_0 = 17E-25; %effective membrane thickness [m]
dxecor_0 = 5E-6; %effective membrane thickness [m]
for l=1:1:5
%single start value
if l==1
rmean_0 = 3.3E-10;% standard distribution [m] 
std_0 = 0.22E-10;% standard distribution [m] 
end
if l==2
rmean_0 = 3.3E-10*1.05;% standard distribution [m]
std_0 = 0.22E-10;% standard distribution [m]
end
if l==3
rmean_0 = 3.3E-10;% standard distribution [m]
std_0 = 0.22E-10*1.05;% standard distribution [m]
end
if l==4
rmean_0 = 3.3E-10*0.95;% standard distribution [m]
std_0 = 0.22E-10;% standard distribution [m]
end
if l==5
rmean_0 = 3.3E-10;% standard distribution [m]
std_0 = 0.22E-10*0.95;% standard distribution [m]
end
%variable flux
Jvn=reshape(fluxMW',[size(fluxMW,1)*size(fluxMW,2),1])';
par = [Jvn ret62 ret106 ret200 ret400 ret600 ret1000 ret2000 ret3000 ...
    Cf vm L d Ri maxIter n relax residual D_inf rS rho eta F Rg T Pw_P Pw_F];
var0 = [rmean_0*10^(10) std_0*10^(11) dxe_0*10^(25) dxecor_0*10^(6)]; %starting value pore radius
lb = [0.1 0 0 0];
ub = [12 100 100 50];
options = optimset('Display','iter','TolFun',10^(-8),'TolX',10^(-8)); % see the sum of squared deviations per iteration
fitfun = @(x) PoreSizeDistributionFit(x,par);
[parm1,resnorm1,res1,exitflag1,output1,lambda1,jac1] = lsqnonlin(fitfun,var0,lb,ub,options); 
rmean(l) = parm1(1);
std(l) = parm1(2);
dxen(l) = parm1(3);
dxecor(l) = parm1(4);
jac2{l,:,:}=jac1;
resnorm(l)=resnorm1;
%get SSE without weighing
nPEG=size(ret62,2)+size(ret106,2)+size(ret200,2)+size(ret400,2)+size(ret600,2)+size(ret1000,2)+size(ret2000,2)+size(ret3000,2);
nPWP=size(Pw_F,2);
res2=ones(1,size(res1,2));
res2(end)=res1(end)/10^6;%from (rmaxflux^2/K1-dxecor)*10^6
res2(end-nPWP:end-1)=res1(end-nPWP:end-1).*(0.05*Pw_F)*nPWP;%from (Pw_F-PWP.*Pw_P)/n_PWP/(0.05*Pw_F)
res2(1:nPEG)=res1(1:nPEG).*(0.01)*(nPEG);%from (r_62-ret_62)/n_PEG/(0.01)
SSE_PEG(l)=sum(res2(1:nPEG).^2);
MSE_PEG(l)=SSE_PEG(l)/(nPEG-4);
SSE_PWP(l)=sum(res2(end-nPWP:end-1).^2);
MSE_PWP(l)=SSE_PWP(l)/(nPWP-4);
SSE=sum(res2.^2);
MSE=SSE/(size(res1,2)-4);
%confidence
ci=nlparci([rmean(l) std(l) dxen(l) dxecor(l)],res1,'Jacobian',jac1); 
rmean(l)=rmean(l)*10^(-10);
rmeanCI(l)=rmean(l)-ci(1,1)*10^(-10);
std(l)=std(l)*10^(-11);
stdCI(l)=std(l)-ci(2,1)*10^(-11);
dxen(l)=dxen(l)*10^(-25);
dxenCI(l)=dxen(l)-ci(3,1)*10^(-25);
dxecor(l)=dxecor(l)*10^(-6);
dxecorCI(l)=dxecor(l)-ci(4,1)*10^(-6);

jac=full(jac2{l,:,:});
xtx=jac'*jac;
xtxinv=inv(xtx);
%calc correlation matrix cor and variance inflation varinf
varinf = diag(xtxinv);
cor1 = xtxinv./sqrt(varinf*varinf');
cor{l,:,:}=cor1;

%normal plot for PEG retention fit error
figure;
normplot(res2(1:nPEG));

%residual plot
figure;
hold on;
box on;
pbaspect([1 1 1])
plot(fluxMW(1,:),res2(1:size(fluxMW,2)),'.');
plot(fluxMW(2,:),res2(size(fluxMW,2)+1:2*size(fluxMW,2)),'.');
plot(fluxMW(3,:),res2(2*size(fluxMW,2)+1:3*size(fluxMW,2)),'.');
plot(fluxMW(4,:),res2(3*size(fluxMW,2)+1:4*size(fluxMW,2)),'.');
plot(fluxMW(5,:),res2(4*size(fluxMW,2)+1:5*size(fluxMW,2)),'.');
plot(fluxMW(6,:),res2(5*size(fluxMW,2)+1:6*size(fluxMW,2)),'.');
plot(fluxMW(7,:),res2(6*size(fluxMW,2)+1:7*size(fluxMW,2)),'.');
plot(fluxMW(8,:),res2(7*size(fluxMW,2)+1:8*size(fluxMW,2)),'.');
hold off;
end

Out1=['The mean pore radius is: ',num2str(rmean,10)];
disp(Out1);
Out1=['The 95% Confidence of mean pore radius is: ',num2str(rmeanCI,10)];
disp(Out1);
Out2=['The pore radius spread is: ',num2str(std,10)];
disp(Out2);
Out2=['The 95% Confidence of pore radius spread is: ',num2str(stdCI,10)];
disp(Out2);
Out2=['The effective membrane thickness is: ',num2str(dxen,10)];
disp(Out2);
Out2=['The corected effective membrane thickness is: ',num2str(dxecor,10)];
disp(Out2);
Out1=['The 95% Confidence of corrected membrane thickness is: ',num2str(dxecorCI,10)];
disp(Out1);
Out1=['The Chi squared is: ',num2str(resnorm,10)];
disp(Out1);
Out1=['The sum of squared error for PEG is: ',num2str(SSE_PEG,10)];
disp(Out1);
Out1=['The mean squared error for PEG is: ',num2str(MSE_PEG,10)];
disp(Out1);
%% Pore size distribution Plot
rmean= 3.269529922e-10;
std= 2.190535387e-11;
b = log(1+(std/rmean)^2);
%fprop=1./(r*(2*pi()*b).^0.5).*exp(-(log(r./rmean)+b/2).^2/2/b); %continuous function
deltar = 1E-11; %discretization size [m]
maxr = 10E-9; %upper limit [m]
rDist=deltar:deltar:maxr; %radius range [m]
for i=1:1:maxr/deltar %discrete function
Fr(i) = integral(@(r) 1./(r*(2*pi()*b).^0.5).*exp(-(log(r./rmean)+b/2).^2/2/b),deltar*(i)-deltar/2,deltar*(i)+deltar/2); %relative ammount
end
Jvr=Fr.*rDist.^4; %flux as function of radius *dPeff /dxen/8/eta*pi()
RelFr=Jvr./sum(Jvr);
%truncation
maxf=max(RelFr);
minf=maxf*0.05; %5% of maximum value cut off
minc=1;
maxc=1.1;
for i=1:1:size(rDist,2)
if RelFr(i)>minf && minc<maxc
    minc=i;
end
if RelFr(i)<minf && minc>maxc
    maxc=i;
    break;
end
end
if maxc==1.1
   maxc=length(RelFr); 
end
rDist=rDist(minc:maxc);
Fr=Fr(minc:maxc);
scale=sum(Fr); %normalize distribution to sumfR=1
Fr=Fr./scale; 
Jvr=Fr.*rDist.^4; %flux as function of radius *dPeff /dxen/8/eta*pi()
RelFr=Jvr./sum(Jvr);
figure;
hold on;
plot(rDist,RelFr,'.');
xlabel('Pore Size [m]');
ylabel('Relative Flux [-]');
box on;
hold off;

%updated thickness
dxen=sum(pi()*rDist.^4.*Fr)/K1; 
Jtest=0.2E-6:0.1E-6:3E-6;
for j=1:1:size(Jtest,2)
%flux as function of r
dPeff=Jtest(j)*8*eta/K1;
Jvr=Fr.*pi().*rDist.^4.*dPeff/8/eta/dxen;
%retention as function of r

par=[Cf K1 vm L d Ri maxIter dxen n relax residual D_inf rS rho eta F Rg T];
for i=1:1:size(Fr,2)
Ret(:,i,j)=PoreSizeDistributionPlot([Jtest(j) rDist(i) Fr(i)],par);
end
%overal retention
Reto(1,j)=sum((Ret(1,:,j)).*Jvr)/Jtest(j);
Reto(2,j)=sum((Ret(2,:,j)).*Jvr)/Jtest(j);
Reto(3,j)=sum((Ret(3,:,j)).*Jvr)/Jtest(j);
Reto(4,j)=sum((Ret(4,:,j)).*Jvr)/Jtest(j);
Reto(5,j)=sum((Ret(5,:,j)).*Jvr)/Jtest(j);
Reto(6,j)=sum((Ret(6,:,j)).*Jvr)/Jtest(j);
Reto(7,j)=sum((Ret(7,:,j)).*Jvr)/Jtest(j);
Reto(8,j)=sum((Ret(8,:,j)).*Jvr)/Jtest(j);
end

figure;
hold on;
errorbar(fluxMWavg(1,:),ret62avg,ret62ci,ret62ci,fluxMWci(1,:),fluxMWci(1,:),'.','MarkerSize',16,'Color',[0,0,0]);
errorbar(fluxMWavg(2,:),ret106avg,ret106ci,ret106ci,fluxMWci(2,:),fluxMWci(2,:),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(fluxMWavg(3,:),ret200avg,ret200ci,ret200ci,fluxMWci(3,:),fluxMWci(3,:),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(fluxMWavg(4,:),ret400avg,ret400ci,ret400ci,fluxMWci(4,:),fluxMWci(4,:),'.','MarkerSize',16,'Color',[118,230,67]./255);
errorbar(fluxMWavg(5,:),ret600avg,ret600ci,ret600ci,fluxMWci(5,:),fluxMWci(5,:),'.','MarkerSize',16,'Color',[0,0,0]);
errorbar(fluxMWavg(6,:),ret1000avg,ret1000ci,ret1000ci,fluxMWci(6,:),fluxMWci(6,:),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(fluxMWavg(7,:),ret2000avg,ret2000ci,ret2000ci,fluxMWci(7,:),fluxMWci(7,:),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(fluxMWavg(8,:),ret3000avg,ret3000ci,ret3000ci,fluxMWci(8,:),fluxMWci(8,:),'.','MarkerSize',16,'Color',[118,230,67]./255);
plot(Jtest,Reto(1,:),'--','Color',[0,0,0]);
plot(Jtest,Reto(2,:),'--','Color',[96,58,232]./255);
plot(Jtest,Reto(3,:),'--','Color',[230,68,62]./255);
plot(Jtest,Reto(4,:),'--','Color',[118,230,67]./255);
plot(Jtest,Reto(5,:),'--','Color',[0,0,0]);
plot(Jtest,Reto(6,:),'--','Color',[96,58,232]./255);
plot(Jtest,Reto(7,:),'--','Color',[230,68,62]./255);
plot(Jtest,Reto(8,:),'--','Color',[118,230,67]./255);
axis([0 1.6E-6 0 1])
xlabel('Flux [m/s]');
ylabel('Retention [-]');
box on;
hold off;

%% Pore Size + Imperfections
clear stderr stddev cor
dxe_0 = 17E-25; %effective membrane thickness [m]
dxecor_0 = 5.1E-6; %effective membrane thickness [m]
minfval=100;
for l=1:1:7
    if l==1
%initial guess pore size, thickness and imperfections
rmean0 = 3.3e-10; %effective pore radius [m] 
std0 = 0.19e-10; % standard distribution [m] 
f0 = 0.03; %percentage of volume flow going through imperfections Jvi/(Jvi+Jvm)
    end
    if l==2
%initial guess pore size, thickness and imperfections
rmean0 = 3.3e-10*1.05; %effective pore radius [m]
std0 = 0.19e-10; % standard distribution [m]
f0 = 0.03; %percentage of volume flow going through imperfections Jvi/(Jvi+Jvm)
    end  
    if l==3
%initial guess pore size, thickness and imperfections
rmean0 = 3.3e-10; %effective pore radius [m]
std0 = 0.19e-10*1.05; % standard distribution [m]
f0 = 0.03; %percentage of volume flow going through imperfections Jvi/(Jvi+Jvm)
    end
    if l==4
%initial guess pore size, thickness and imperfections
rmean0 = 3.3E-10; %effective pore radius [m]
std0 = 0.19e-10; % standard distribution [m]
f0 = 0.03*1.05; %percentage of volume flow going through imperfections Jvi/(Jvi+Jvm)
    end
    if l==5
%initial guess pore size, thickness and imperfections
rmean0 = 3.3E-10*0.95; %effective pore radius [m]
std0 = 0.19e-10; % standard distribution [m]
f0 = 0.03; %percentage of volume flow going through imperfections Jvi/(Jvi+Jvm)
    end    
    if l==6
%initial guess pore size, thickness and imperfections
rmean0 = 3.3E-10; %effective pore radius [m]
std0 = 0.19e-10*0.95; % standard distribution [m]
f0 = 0.03; %percentage of volume flow going through imperfections Jvi/(Jvi+Jvm)
    end
    if l==7
%initial guess pore size, thickness and imperfections
rmean0 = 3.3E-10; %effective pore radius [m]
std0 = 0.19e-10; % standard distribution [m]
f0 = 0.03*0.95; %percentage of volume flow going through imperfections Jvi/(Jvi+Jvm)
    end   
Jvn=reshape(fluxMW',[size(fluxMW,1)*size(fluxMW,2),1])';
par = [Jvn ret62 ret106 ret200 ret400 ret600 ret1000 ret2000 ret3000 ...
    Cf vm L d Ri maxIter n relax residual D_inf rS rho eta F Rg T Pw_P Pw_F];
var0 = [rmean0*10^(10) std0*10^(11) dxe_0*10^(25) f0 dxecor_0*10^(6)]; %starting value pore radius
lb = [0.5 0.5 0 0 0];
ub = [12 120 100 0.2 50];
options = optimset('Display','iter','TolFun',10^(-8),'TolX',10^(-8)); % see the sum of squared deviations per iteration
fitfun = @(x) PoreSizeDistributionImperfectionsFit(x,par);
[parm1,resnorm1,res1,exitflag1,output1,lambda1,jac1] = lsqnonlin(fitfun,var0,lb,ub,options); 
jac2{l,:,:}=jac1;
resnorm(l)=resnorm1;
minfval=resnorm1;
rmean(l) = parm1(1);
std(l) = parm1(2);
dxen(l) = parm1(3);
f(l) = parm1(4);
dxecor(l) = parm1(5);
%get SSE without weighing
nPEG=size(ret62,2)+size(ret106,2)+size(ret200,2)+size(ret400,2)+size(ret600,2)+size(ret1000,2)+size(ret2000,2)+size(ret3000,2);
nPWP=size(Pw_F,2);
res2=ones(1,size(res1,2));
res2(end)=res1(end)/10^6;%(rmaxflux^2/K1-dxecor)*10^6
res2(end-nPWP:end-1)=res1(end-nPWP:end-1).*(0.05*Pw_F)*nPWP;%(Pw_F-PWP.*Pw_P)/n_PWP/(0.05*Pw_F)
res2(1:nPEG)=res1(1:nPEG).*(0.01)*(nPEG);%(r_62-ret_62)/n_PEG/(0.01)
SSE_PEG(l)=sum(res2(1:nPEG).^2);
MSE_PEG(l)=SSE_PEG(l)/(nPEG-5);
SSE_PWP(l)=sum(res2(end-nPWP:end-1).^2);
MSE_PWP(l)=SSE_PWP(l)/(nPWP-5);
SSE=sum(res2.^2);
MSE=SSE/(size(res1,2)-5);
%confidence
ci=nlparci([rmean(l) std(l) dxen(l) f(l) dxecor(l)],res1,'Jacobian',jac1); 
rmean(l)=rmean(l)*10^(-10);
rmeanCI(l)=rmean(l)-ci(1,1)*10^(-10);
std(l)=std(l)*10^(-11);
stdCI(l)=std(l)-ci(2,1)*10^(-11);
dxen(l)=dxen(l)*10^(-25);
dxenCI(l)=dxen(l)-ci(3,1)*10^(-25);
fCI(l)=f(l)-ci(4,1);
dxecor(l)=dxecor(l)*10^(-6);
dxecorCI(l)=dxecor(l)-ci(5,1)*10^(-6);

jac=full(jac2{l,:,:});
xtx=jac'*jac;
xtxinv=inv(xtx);
%calc correlation matrix cor and variance inflation varinf
varinf = diag(xtxinv);
cor{l,:,:} = xtxinv./sqrt(varinf*varinf');

figure;
normplot(res2(1:nPEG));

figure;
hold on;
box on;
pbaspect([1 1 1])
plot(fluxMW(1,:),res2(1:size(fluxMW,2)),'.');
plot(fluxMW(2,:),res2(size(fluxMW,2)+1:2*size(fluxMW,2)),'.');
plot(fluxMW(3,:),res2(2*size(fluxMW,2)+1:3*size(fluxMW,2)),'.');
plot(fluxMW(4,:),res2(3*size(fluxMW,2)+1:4*size(fluxMW,2)),'.');
plot(fluxMW(5,:),res2(4*size(fluxMW,2)+1:5*size(fluxMW,2)),'.');
plot(fluxMW(6,:),res2(5*size(fluxMW,2)+1:6*size(fluxMW,2)),'.');
plot(fluxMW(7,:),res2(6*size(fluxMW,2)+1:7*size(fluxMW,2)),'.');
plot(fluxMW(8,:),res2(7*size(fluxMW,2)+1:8*size(fluxMW,2)),'.');
hold off;
end

Out1=['The mean pore radius is: ',num2str(rmean,10)];
disp(Out1);
Out1=['The 95% Confidence of mean pore radius is: ',num2str(rmeanCI,10)];
disp(Out1);
Out2=['The pore radius spread is: ',num2str(std,10)];
disp(Out2);
Out2=['The 95% Confidence of pore radius spread is: ',num2str(stdCI,10)];
disp(Out2);
Out3=['The ammount of imperfections in % is: ',num2str(f*100,10)];
disp(Out3);
Out3=['The 95% Confidence of ammount of imperfections in % is: ',num2str(fCI*100,10)];
disp(Out3);
Out2=['The effective membrane thickness is: ',num2str(dxen,10)];
disp(Out2);
Out2=['The corected effective membrane thickness is: ',num2str(dxecor,10)];
disp(Out2);
Out1=['The 95% Confidence of corrected membrane thickness is: ',num2str(dxecorCI,10)];
disp(Out1);
Out1=['The Chi squared is: ',num2str(resnorm,10)];
disp(Out1);
Out1=['The sum of squared error for PEG is: ',num2str(SSE_PEG,10)];
disp(Out1);
Out1=['The mean squared error for PEG is: ',num2str(MSE_PEG,10)];
disp(Out1);
%% Pore Size + Imperfections Plot
clear Ret Reto

rmean = 3.255692837e-10;
std = 1.810228668e-11;
f = 2.229338125/100;

b = log(1+(std/rmean)^2);
%fprop=1./(r*(2*pi()*b).^0.5).*exp(-(log(r./rmean)+b/2).^2/2/b); %continuous function
deltar = 1E-11; %discretization size [m]
maxr = 10E-9; %upper limit [m]
rDist=deltar:deltar:maxr; %radius range [m]
for i=1:1:maxr/deltar %discrete function
Fr(i) = integral(@(r) 1./(r*(2*pi()*b).^0.5).*exp(-(log(r./rmean)+b/2).^2/2/b),deltar*(i)-deltar/2,deltar*(i)+deltar/2); %relative ammount
end
Jvr=Fr.*rDist.^4; %flux as function of radius *dPeff /dxen/8/eta*pi()
RelFr=Jvr./sum(Jvr);
%truncation
maxf=max(RelFr);
minf=maxf*0.05; %5% of maximum value cut off
minc=1;
maxc=1.1;
for i=1:1:size(rDist,2)
if RelFr(i)>minf && minc<maxc
    minc=i;
end
if RelFr(i)<minf && minc>maxc
    maxc=i;
    break;
end
end
if maxc==1.1
   maxc=length(RelFr); 
end
rDist=rDist(minc:maxc);
Fr=Fr(minc:maxc);
scale=sum(Fr); %normalize distribution to sumfR=1
Fr=Fr./scale; 
Jvr=Fr.*rDist.^4; %flux as function of radius *dPeff /dxen/8/eta*pi()
RelFr=Jvr./sum(Jvr);
figure;
hold on;
plot(rDist,RelFr,'.');
xlabel('Pore Size [m]');
ylabel('Relative Flux [-]');
box on;
hold off;

%updated thickness
dxen=sum(pi()*rDist.^4.*Fr)/K1; 

Jtest=0.2E-6:0.1E-6:1.8E-6;
Jtest=Jtest*(1-f); 

for j=1:1:size(Jtest,2)
   %flux as function of r
dPeff=Jtest(j)*8*eta/K1;
Jvr=Fr.*pi().*rDist.^4.*dPeff/8/eta/dxen;

%retention as function of r
par=[Cf K1 vm L d Ri maxIter dxen n relax residual D_inf rS rho eta F Rg T];

for i=1:1:size(Fr,2)
Ret(:,i,j)=PoreSizeDistributionPlot([Jtest(j) rDist(i) Fr(i)],par);
end
%overal retention

Reto(1,j)=1-sum((1-Ret(1,:,j)).*Jvr)/Jtest(j);
Reto(2,j)=1-sum((1-Ret(2,:,j)).*Jvr)/Jtest(j);
Reto(3,j)=1-sum((1-Ret(3,:,j)).*Jvr)/Jtest(j);
Reto(4,j)=1-sum((1-Ret(4,:,j)).*Jvr)/Jtest(j);
Reto(5,j)=1-sum((1-Ret(5,:,j)).*Jvr)/Jtest(j);
Reto(6,j)=1-sum((1-Ret(6,:,j)).*Jvr)/Jtest(j);
Reto(7,j)=1-sum((1-Ret(7,:,j)).*Jvr)/Jtest(j);
Reto(8,j)=1-sum((1-Ret(8,:,j)).*Jvr)/Jtest(j);
end

ret_62=Reto(1,:);
ret_106=Reto(2,:);
ret_200=Reto(3,:);
ret_400=Reto(4,:);
ret_600=Reto(5,:);
ret_1000=Reto(6,:);
ret_2000=Reto(7,:);
ret_3000=Reto(8,:);

c_p1=(1-ret_62)*Cf(1);
c_p2=(1-ret_106)*Cf(2);
c_p3=(1-ret_200)*Cf(3);
c_p4=(1-ret_400)*Cf(4);
c_p5=(1-ret_600)*Cf(5);
c_p6=(1-ret_1000)*Cf(6);
c_p7=(1-ret_2000)*Cf(7);
c_p8=(1-ret_3000)*Cf(8);

%film model to get surface concentration
Re0=rho*2*Ri*vm/eta; %inlet Reynolds number [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jtest/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
Sc2=eta/rho/D_inf(2); %inlet Schmidt number [-]
Sh2=1.62*Re0^(1/3)*Sc2^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc2^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc2=Sh2/(2*Ri/D_inf(2)); 
phi2=Jtest/kc2;
suc2=phi2+(1+0.26*phi2.^(1.4)).^(-1.7);
kc2s=kc2*suc2;
Sc3=eta/rho/D_inf(3); %inlet Schmidt number [-]
Sh3=1.62*Re0^(1/3)*Sc3^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc3^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc3=Sh3/(2*Ri/D_inf(3)); 
phi3=Jtest/kc3;
suc3=phi3+(1+0.26*phi3.^(1.4)).^(-1.7);
kc3s=kc3*suc3;
Sc4=eta/rho/D_inf(4); %inlet Schmidt number [-]
Sh4=1.62*Re0^(1/3)*Sc4^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc4^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc4=Sh4/(2*Ri/D_inf(4)); 
phi4=Jtest/kc4;
suc4=phi4+(1+0.26*phi4.^(1.4)).^(-1.7);
kc4s=kc4*suc4;
Sc5=eta/rho/D_inf(5); %inlet Schmidt number [-]
Sh5=1.62*Re0^(1/3)*Sc5^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc5^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc5=Sh5/(2*Ri/D_inf(5)); 
phi5=Jtest/kc5;
suc5=phi5+(1+0.26*phi5.^(1.4)).^(-1.7);
kc5s=kc5*suc5;
Sc6=eta/rho/D_inf(6); %inlet Schmidt number [-]
Sh6=1.62*Re0^(1/3)*Sc6^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc6^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc6=Sh6/(2*Ri/D_inf(6)); 
phi6=Jtest/kc6;
suc6=phi6+(1+0.26*phi6.^(1.4)).^(-1.7);
kc6s=kc6*suc6;
Sc7=eta/rho/D_inf(7); %inlet Schmidt number [-]
Sh7=1.62*Re0^(1/3)*Sc7^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc7^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc7=Sh7/(2*Ri/D_inf(7)); 
phi7=Jtest/kc7;
suc7=phi7+(1+0.26*phi7.^(1.4)).^(-1.7);
kc7s=kc7*suc7;
Sc8=eta/rho/D_inf(8); %inlet Schmidt number [-]
Sh8=1.62*Re0^(1/3)*Sc8^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc8^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc8=Sh8/(2*Ri/D_inf(8)); 
phi8=Jtest/kc8;
suc8=phi8+(1+0.26*phi8.^(1.4)).^(-1.7);
kc8s=kc8*suc8;

C62M=(c_p1.*Jtest-Cf(1)*kc1s)./(Jtest-kc1s);
C106M=(c_p2.*Jtest-Cf(2)*kc2s)./(Jtest-kc2s);
C200M=(c_p3.*Jtest-Cf(3)*kc3s)./(Jtest-kc3s);
C400M=(c_p4.*Jtest-Cf(4)*kc4s)./(Jtest-kc4s);
C600M=(c_p5.*Jtest-Cf(5)*kc5s)./(Jtest-kc5s);
C1000M=(c_p6.*Jtest-Cf(6)*kc6s)./(Jtest-kc6s);
C2000M=(c_p7.*Jtest-Cf(7)*kc7s)./(Jtest-kc7s);
C3000M=(c_p8.*Jtest-Cf(8)*kc8s)./(Jtest-kc8s);

ret_62=1-(c_p1*(1-f)+C62M*f)./Cf(1);
ret_106=1-(c_p2*(1-f)+C106M*f)./Cf(2);
ret_200=1-(c_p3*(1-f)+C200M*f)./Cf(3);
ret_400=1-(c_p4*(1-f)+C400M*f)./Cf(4);
ret_600=1-(c_p5*(1-f)+C600M*f)./Cf(5);
ret_1000=1-(c_p6*(1-f)+C1000M*f)./Cf(6);
ret_2000=1-(c_p7*(1-f)+C2000M*f)./Cf(7);
ret_3000=1-(c_p8*(1-f)+C3000M*f)./Cf(8);

Jtest=Jtest/(1-f); 

figure;
hold on;
errorbar(fluxMWavg(1,:),ret62avg,ret62ci,ret62ci,fluxMWci(1,:),fluxMWci(1,:),'.','MarkerSize',16,'Color',[0,0,0]);
errorbar(fluxMWavg(2,:),ret106avg,ret106ci,ret106ci,fluxMWci(2,:),fluxMWci(2,:),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(fluxMWavg(3,:),ret200avg,ret200ci,ret200ci,fluxMWci(3,:),fluxMWci(3,:),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(fluxMWavg(4,:),ret400avg,ret400ci,ret400ci,fluxMWci(4,:),fluxMWci(4,:),'.','MarkerSize',16,'Color',[118,230,67]./255);
errorbar(fluxMWavg(5,:),ret600avg,ret600ci,ret600ci,fluxMWci(5,:),fluxMWci(5,:),'.','MarkerSize',16,'Color',[0,0,0]);
errorbar(fluxMWavg(6,:),ret1000avg,ret1000ci,ret1000ci,fluxMWci(6,:),fluxMWci(6,:),'.','MarkerSize',16,'Color',[96,58,232]./255);
errorbar(fluxMWavg(7,:),ret2000avg,ret2000ci,ret2000ci,fluxMWci(7,:),fluxMWci(7,:),'.','MarkerSize',16,'Color',[230,68,62]./255);
errorbar(fluxMWavg(8,:),ret3000avg,ret3000ci,ret3000ci,fluxMWci(8,:),fluxMWci(8,:),'.','MarkerSize',16,'Color',[118,230,67]./255);
plot(Jtest,ret_62,'--','Color',[0,0,0]);
plot(Jtest,ret_106,'--','Color',[96,58,232]./255);
plot(Jtest,ret_200,'--','Color',[230,68,62]./255);
plot(Jtest,ret_400,'--','Color',[118,230,67]./255);
plot(Jtest,ret_600,'--','Color',[0,0,0]);
plot(Jtest,ret_1000,'--','Color',[96,58,232]./255);
plot(Jtest,ret_2000,'--','Color',[230,68,62]./255);
plot(Jtest,ret_3000,'--','Color',[118,230,67]./255);
xlabel('Flux [m/s]');
ylabel('Retention [-]');
ylim([0 1]);
box on;
hold off;

function [residuals] = SinglePoreSizeFit(x,param)
%parameters
Jv = param(1:96);
r_62 = param(97:108);
r_106 = param(109:120);
r_200 = param(121:132);
r_400 = param(133:144);
r_600 = param(145:156);
r_1000 = param(157:168);
r_2000 = param(169:180);
r_3000 = param(181:192);
Cf = param(193:200);
vm = param(201);
L = param(202);
d = param(203);
Ri = param(204);
maxIter = param(205);
n = param(206);
relax = param(207);
residual = param(208);
D_inf = param(209:216);
rS1 = param(217);
rS2 = param(218); 
rS3 = param(219);
rS4 = param(220);
rS5 = param(221);
rS6 = param(222);
rS7 = param(223);
rS8 = param(224);
rho = param(225);
eta = param(226);
F = param(227);
Rg = param(228);
T = param(229);
Pw_P = param(230:241);
Pw_F = param(242:253);

%variables
rp=x(1)*10^(-10);
dxe=x(2)*10^(-6);

PWP=rp^2/dxe*1000*60*60*10^5/8/eta;
K1=PWP/1000/60/60/10^5*8*eta; %Pw from Pure Water Measurement Fit

emptycnt=1;

for j = 1:12
if isnan(Jv(j))
    Jv(j)=Jv(j+1);
    empty(emptycnt)=j;
    emptycnt=emptycnt+1;
end
%%initial parameter calculations
v0=vm; %inlet velocity [m/s]
dx=dxe/(n-1); %grid node difference [m]
x=0:dx:dxe; %grid
Re0=rho*2*Ri*v0/eta; %inlet Reynolds number [-]
fD0=64/Re0; %inlet friction factor [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jv(j)/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
lam1=rS1/rp; %relative radii 1
if lam1>1
lam1=1;
end
if lam1 <= 0.95
K1d = (1+9/8*lam1*log(lam1)-1.56034*lam1+0.528155*lam1^2+1.91521*lam1^3-2.81903*lam1^4+0.270788*lam1^5+1.10115*lam1^6-0.435933*lam1^7)/(1-lam1)^2; %d hindrance factor 1
else
K1d = 0.984*((1-lam1)/lam1)^(5/2); %d hindrance factor 1
end
K1c = (1+3.867*lam1-1.907*lam1^2-0.834*lam1^3)/(1+1.867*lam1-0.741*lam1^2); %c hindrance factor 1
D1p = K1d*D_inf(1); %pore diffusion 1
theta1 = (1-lam1)^2; %steric partitioning 1

Pem=K1c/K1d*Jv(j)*dxe/D_inf(1);
ret_62_int=1-K1c*theta1/((K1c*theta1-1)*exp(-Pem)+1);
ret_62(j)=1-((1-ret_62_int)*kc1s)/(Jv(j)*(1-ret_62_int)+kc1s-Jv(j));

%%initial parameter calculations
if isnan(Jv(j+12))
    Jv(j+12)=Jv(j+13);
    empty(emptycnt)=j+12;
    emptycnt=emptycnt+1;
end
Sc2=eta/rho/D_inf(2); %inlet Schmidt number [-]
Sh2=1.62*Re0^(1/3)*Sc2^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc2^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc2=Sh2/(2*Ri/D_inf(2)); 
phi2=Jv(j+12)/kc2;
suc2=phi2+(1+0.26*phi2.^(1.4)).^(-1.7);
kc2s=kc2*suc2;
lam2=rS2/rp; %relative radii 2
if lam2>1
lam2=1;
end
if lam2 <= 0.95
K2d = (1+9/8*lam2*log(lam2)-1.56034*lam2+0.528155*lam2^2+1.91521*lam2^3-2.81903*lam2^4+0.270788*lam2^5+1.10115*lam2^6-0.435933*lam2^7)/(1-lam2)^2; %d hindrance factor 1
else
K2d = 0.984*((1-lam2)/lam2)^(5/2); %d hindrance factor 2
end
K2c = (1+3.867*lam2-1.907*lam2^2-0.834*lam2^3)/(1+1.867*lam2-0.741*lam2^2); %c hindrance factor 2
D2p = K2d*D_inf(2); %pore diffusion 2
theta2 = (1-lam2)^2; %steric partitioning 2

Pem=K2c/K2d*Jv(j+12)*dxe/D_inf(2);
ret_106_int=1-K2c*theta2/((K2c*theta2-1)*exp(-Pem)+1);
ret_106(j)=1-((1-ret_106_int)*kc2s)/(Jv(j+12)*(1-ret_106_int)+kc2s-Jv(j+12));

%%initial parameter calculations
if isnan(Jv(j+24))
    Jv(j+24)=Jv(j+25);
    empty(emptycnt)=j+24;
    emptycnt=emptycnt+1;
end
Sc3=eta/rho/D_inf(3); %inlet Schmidt number [-]
Sh3=1.62*Re0^(1/3)*Sc3^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc3^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc3=Sh3/(2*Ri/D_inf(3)); 
phi3=Jv(j+24)/kc3;
suc3=phi3+(1+0.26*phi3.^(1.4)).^(-1.7);
kc3s=kc3*suc3;
lam3=rS3/rp; %relative radii 2
if lam3>1
lam3=1;
end
if lam3 <= 0.95
K3d = (1+9/8*lam3*log(lam3)-1.56034*lam3+0.528155*lam3^2+1.91521*lam3^3-2.81903*lam3^4+0.270788*lam3^5+1.10115*lam3^6-0.435933*lam3^7)/(1-lam3)^2; %d hindrance factor 1
else
K3d = 0.984*((1-lam3)/lam3)^(5/2); %d hindrance factor 2
end
K3c = (1+3.867*lam3-1.907*lam3^2-0.834*lam3^3)/(1+1.867*lam3-0.741*lam3^2); %c hindrance factor 2
D3p = K3d*D_inf(3); %pore diffusion 2
theta3 = (1-lam3)^2; %steric partitioning 2

Pem=K3c/K3d*Jv(j+24)*dxe/D_inf(3);
ret_200_int=1-K3c*theta3/((K3c*theta3-1)*exp(-Pem)+1);
ret_200(j)=1-((1-ret_200_int)*kc3s)/(Jv(j+24)*(1-ret_200_int)+kc3s-Jv(j+24));

%%initial parameter calculations
if isnan(Jv(j+36))
    Jv(j+36)=Jv(j+37);
    empty(emptycnt)=j+36;
    emptycnt=emptycnt+1;
end
Sc4=eta/rho/D_inf(4); %inlet Schmidt number [-]
Sh4=1.62*Re0^(1/3)*Sc4^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc4^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc4=Sh4/(2*Ri/D_inf(4)); 
phi4=Jv(j+36)/kc4;
suc4=phi4+(1+0.26*phi4.^(1.4)).^(-1.7);
kc4s=kc4*suc4;
lam4=rS4/rp; %relative radii 2
if lam4>1
lam4=1;
end
if lam4 <= 0.95
K4d = (1+9/8*lam4*log(lam4)-1.56034*lam4+0.528155*lam4^2+1.91521*lam4^3-2.81903*lam4^4+0.270788*lam4^5+1.10115*lam4^6-0.435933*lam4^7)/(1-lam4)^2; %d hindrance factor 1
else
K4d = 0.984*((1-lam4)/lam4)^(5/2); %d hindrance factor 2
end
K4c = (1+3.867*lam4-1.907*lam4^2-0.834*lam4^3)/(1+1.867*lam4-0.741*lam4^2); %c hindrance factor 2
D4p = K4d*D_inf(4); %pore diffusion 2
theta4 = (1-lam4)^2; %steric partitioning 2

Pem=K4c/K4d*Jv(j+36)*dxe/D_inf(4);
ret_400_int=1-K4c*theta4/((K4c*theta4-1)*exp(-Pem)+1);
ret_400(j)=1-((1-ret_400_int)*kc4s)/(Jv(j+36)*(1-ret_400_int)+kc4s-Jv(j+36));

%%initial parameter calculations
if isnan(Jv(j+48))
    Jv(j+48)=Jv(j+49);
    empty(emptycnt)=j+48;
    emptycnt=emptycnt+1;
end
Sc5=eta/rho/D_inf(5); %inlet Schmidt number [-]
Sh5=1.62*Re0^(1/3)*Sc5^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc5^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc5=Sh5/(2*Ri/D_inf(5)); 
phi5=Jv(j+48)/kc5;
suc5=phi5+(1+0.26*phi5.^(1.4)).^(-1.7);
kc5s=kc5*suc5;
lam5=rS5/rp; %relative radii 2
if lam5>1
lam5=1;
end
if lam5 <= 0.95
K5d = (1+9/8*lam5*log(lam5)-1.56034*lam5+0.528155*lam5^2+1.91521*lam5^3-2.81903*lam5^4+0.270788*lam5^5+1.10115*lam5^6-0.435933*lam5^7)/(1-lam5)^2; %d hindrance factor 1
else
K5d = 0.984*((1-lam5)/lam5)^(5/2); %d hindrance factor 2
end
K5c = (1+3.867*lam5-1.907*lam5^2-0.834*lam5^3)/(1+1.867*lam5-0.741*lam5^2); %c hindrance factor 2
D5p = K5d*D_inf(5); %pore diffusion 2
theta5 = (1-lam5)^2; %steric partitioning 2

Pem=K5c/K5d*Jv(j+48)*dxe/D_inf(5);
ret_600_int=1-K5c*theta5/((K5c*theta5-1)*exp(-Pem)+1);
ret_600(j)=1-((1-ret_600_int)*kc5s)/(Jv(j+48)*(1-ret_600_int)+kc5s-Jv(j+48));

%%initial parameter calculations
if isnan(Jv(j+60))
    Jv(j+60)=Jv(j+61);
    empty(emptycnt)=j+60;
    emptycnt=emptycnt+1;
end
Sc6=eta/rho/D_inf(6); %inlet Schmidt number [-]
Sh6=1.62*Re0^(1/3)*Sc6^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc6^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc6=Sh6/(2*Ri/D_inf(6)); 
phi6=Jv(j+60)/kc6;
suc6=phi6+(1+0.26*phi6.^(1.4)).^(-1.7);
kc6s=kc6*suc6;
lam6=rS6/rp; %relative radii 2
if lam6>1
lam6=1;
end
if lam6 <= 0.95
K6d = (1+9/8*lam6*log(lam6)-1.56034*lam6+0.528155*lam6^2+1.91521*lam6^3-2.81903*lam6^4+0.270788*lam6^5+1.10115*lam6^6-0.435933*lam6^7)/(1-lam6)^2; %d hindrance factor 1
else
K6d = 0.984*((1-lam6)/lam6)^(5/2); %d hindrance factor 2
end
K6c = (1+3.867*lam6-1.907*lam6^2-0.834*lam6^3)/(1+1.867*lam6-0.741*lam6^2); %c hindrance factor 2
D6p = K6d*D_inf(6); %pore diffusion 2
theta6 = (1-lam6)^2; %steric partitioning 2

Pem=K6c/K6d*Jv(j+60)*dxe/D_inf(6);
ret_1000_int=1-K6c*theta6/((K6c*theta6-1)*exp(-Pem)+1);
ret_1000(j)=1-((1-ret_1000_int)*kc6s)/(Jv(j+60)*(1-ret_1000_int)+kc6s-Jv(j+60));

%%initial parameter calculations
if isnan(Jv(j+72))
    Jv(j+72)=Jv(j+73);
    empty(emptycnt)=j+72;
    emptycnt=emptycnt+1;
end
Sc7=eta/rho/D_inf(7); %inlet Schmidt number [-]
Sh7=1.62*Re0^(1/3)*Sc7^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc7^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc7=Sh7/(2*Ri/D_inf(7)); 
phi7=Jv(j+72)/kc7;
suc7=phi7+(1+0.26*phi7.^(1.4)).^(-1.7);
kc7s=kc7*suc7;
lam7=rS7/rp; %relative radii 2
if lam7>1
lam7=1;
end
if lam7 <= 0.95
K7d = (1+9/8*lam7*log(lam7)-1.56034*lam7+0.528155*lam7^2+1.91521*lam7^3-2.81903*lam7^4+0.270788*lam7^5+1.10115*lam7^6-0.435933*lam7^7)/(1-lam7)^2; %d hindrance factor 1
else
K7d = 0.984*((1-lam7)/lam7)^(5/2); %d hindrance factor 2
end
K7c = (1+3.867*lam7-1.907*lam7^2-0.834*lam7^3)/(1+1.867*lam7-0.741*lam7^2); %c hindrance factor 2
D7p = K7d*D_inf(7); %pore diffusion 2
theta7 = (1-lam7)^2; %steric partitioning 2

Pem=K7c/K7d*Jv(j+72)*dxe/D_inf(7);
ret_2000_int=1-K7c*theta7/((K7c*theta7-1)*exp(-Pem)+1);
ret_2000(j)=1-((1-ret_2000_int)*kc7s)/(Jv(j+72)*(1-ret_2000_int)+kc7s-Jv(j+72));

%%initial parameter calculations
if isnan(Jv(j+84))
    Jv(j+84)=Jv(j+85);
    empty(emptycnt)=j+84;
    emptycnt=emptycnt+1;
end
Sc8=eta/rho/D_inf(8); %inlet Schmidt number [-]
Sh8=1.62*Re0^(1/3)*Sc8^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc8^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc8=Sh8/(2*Ri/D_inf(8)); 
phi8=Jv(j+84)/kc8;
suc8=phi8+(1+0.26*phi8.^(1.4)).^(-1.7);
kc8s=kc8*suc8;
lam8=rS8/rp; %relative radii 2
if lam8>1
lam8=1;
end
if lam8 <= 0.95
K8d = (1+9/8*lam8*log(lam8)-1.56034*lam8+0.528155*lam8^2+1.91521*lam8^3-2.81903*lam8^4+0.270788*lam8^5+1.10115*lam8^6-0.435933*lam8^7)/(1-lam8)^2; %d hindrance factor 1
else
K8d = 0.984*((1-lam8)/lam8)^(5/2); %d hindrance factor 2
end
K8c = (1+3.867*lam8-1.907*lam8^2-0.834*lam8^3)/(1+1.867*lam8-0.741*lam8^2); %c hindrance factor 2
D8p = K8d*D_inf(8); %pore diffusion 2
theta8 = (1-lam8)^2; %steric partitioning 2

Pem=K8c/K8d*Jv(j+84)*dxe/D_inf(8);
ret_3000_int=1-K8c*theta8/((K8c*theta8-1)*exp(-Pem)+1);
ret_3000(j)=1-((1-ret_3000_int)*kc8s)/(Jv(j+84)*(1-ret_3000_int)+kc8s-Jv(j+84));
end

n_PEG=size(r_62,2)+size(r_106,2)+size(r_200,2)+size(r_400,2)+size(r_600,2)+size(r_1000,2)+size(r_2000,2)+size(r_3000,2)-emptycnt+1;
n_PWP=size(Pw_F,2);
residualso=[(r_62-ret_62)/n_PEG/(0.01) (r_106-ret_106)/n_PEG/(0.01) (r_200-ret_200)/n_PEG/(0.01) (r_400-ret_400)/n_PEG/(0.01) (r_600-ret_600)/n_PEG/(0.01) (r_1000-ret_1000)/n_PEG/(0.01) (r_2000-ret_2000)/n_PEG/(0.01) (r_3000-ret_3000)/n_PEG/(0.01) (Pw_F-PWP.*Pw_P)/n_PWP./(0.05*Pw_F)];

counter=1;
numbernan=1;
for i=1:1:size(residualso,2)
    if emptycnt==1
    residuals=residualso;
    break;
    end
    if i==empty(numbernan)
    numbernan=numbernan+1;
        if numbernan>emptycnt-1
            numbernan=emptycnt-1;
        end
    else
    residuals(counter)=residualso(i);
    counter=counter+1;
    end
end
end

function [residuals] = SinglePoreSizeImperfectionFit(x,param)
%parameters
Jv = param(1:96);
r_62 = param(97:108);
r_106 = param(109:120);
r_200 = param(121:132);
r_400 = param(133:144);
r_600 = param(145:156);
r_1000 = param(157:168);
r_2000 = param(169:180);
r_3000 = param(181:192);
Cf = param(193:200);
vm = param(201);
L = param(202);
d = param(203);
Ri = param(204);
maxIter = param(205);
n = param(206);
relax = param(207);
residual = param(208);
D_inf = param(209:216);
rS1 = param(217);
rS2 = param(218); 
rS3 = param(219);
rS4 = param(220);
rS5 = param(221);
rS6 = param(222);
rS7 = param(223);
rS8 = param(224);
rho = param(225);
eta = param(226);
F = param(227);
Rg = param(228);
T = param(229);
Pw_P = param(230:241);
Pw_F = param(242:253);

%variables
rp=x(1)*10^(-10);
dxe=x(2)*10^(-6);
f = x(3);

PWP=rp^2/dxe*1000*60*60*10^5/8/eta;
K1=PWP/1000/60/60/10^5*8*eta; %Pw from Pure Water Measurement Fit

Jv=Jv*(1-f);

emptycnt=1;

for j = 1:12
if isnan(Jv(j))
    Jv(j)=Jv(j+1);
    empty(emptycnt)=j;
    emptycnt=emptycnt+1;
end
%%initial parameter calculations
v0=vm; %inlet velocity [m/s]
dx=dxe/(n-1); %grid node difference [m]
x=0:dx:dxe; %grid
Re0=rho*2*Ri*v0/eta; %inlet Reynolds number [-]
fD0=64/Re0; %inlet friction factor [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jv(j)/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
lam1=rS1/rp; %relative radii 1
if lam1>1
lam1=1;
end
if lam1 <= 0.95
K1d = (1+9/8*lam1*log(lam1)-1.56034*lam1+0.528155*lam1^2+1.91521*lam1^3-2.81903*lam1^4+0.270788*lam1^5+1.10115*lam1^6-0.435933*lam1^7)/(1-lam1)^2; %d hindrance factor 1
else
K1d = 0.984*((1-lam1)/lam1)^(5/2); %d hindrance factor 1
end
K1c = (1+3.867*lam1-1.907*lam1^2-0.834*lam1^3)/(1+1.867*lam1-0.741*lam1^2); %c hindrance factor 1
D1p = K1d*D_inf(1); %pore diffusion 1
theta1 = (1-lam1)^2; %steric partitioning 1

Pem=K1c/K1d*Jv(j)*dxe/D_inf(1);
ret_62_int=1-K1c*theta1/((K1c*theta1-1)*exp(-Pem)+1);
ret_62(j)=1-((1-ret_62_int)*kc1s)/(Jv(j)*(1-ret_62_int)+kc1s-Jv(j));

%%initial parameter calculations
if isnan(Jv(j+12))
    Jv(j+12)=Jv(j+13);
    empty(emptycnt)=j+12;
    emptycnt=emptycnt+1;
end
Sc2=eta/rho/D_inf(2); %inlet Schmidt number [-]
Sh2=1.62*Re0^(1/3)*Sc2^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc2^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc2=Sh2/(2*Ri/D_inf(2)); 
phi2=Jv(j+12)/kc2;
suc2=phi2+(1+0.26*phi2.^(1.4)).^(-1.7);
kc2s=kc2*suc2;
lam2=rS2/rp; %relative radii 2
if lam2>1
lam2=1;
end
if lam2 <= 0.95
K2d = (1+9/8*lam2*log(lam2)-1.56034*lam2+0.528155*lam2^2+1.91521*lam2^3-2.81903*lam2^4+0.270788*lam2^5+1.10115*lam2^6-0.435933*lam2^7)/(1-lam2)^2; %d hindrance factor 1
else
K2d = 0.984*((1-lam2)/lam2)^(5/2); %d hindrance factor 2
end
K2c = (1+3.867*lam2-1.907*lam2^2-0.834*lam2^3)/(1+1.867*lam2-0.741*lam2^2); %c hindrance factor 2
D2p = K2d*D_inf(2); %pore diffusion 2
theta2 = (1-lam2)^2; %steric partitioning 2

Pem=K2c/K2d*Jv(j+12)*dxe/D_inf(2);
ret_106_int=1-K2c*theta2/((K2c*theta2-1)*exp(-Pem)+1);
ret_106(j)=1-((1-ret_106_int)*kc2s)/(Jv(j+12)*(1-ret_106_int)+kc2s-Jv(j+12));

%%initial parameter calculations
if isnan(Jv(j+24))
    Jv(j+24)=Jv(j+25);
    empty(emptycnt)=j+24;
    emptycnt=emptycnt+1;
end
Sc3=eta/rho/D_inf(3); %inlet Schmidt number [-]
Sh3=1.62*Re0^(1/3)*Sc3^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc3^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc3=Sh3/(2*Ri/D_inf(3)); 
phi3=Jv(j+24)/kc3;
suc3=phi3+(1+0.26*phi3.^(1.4)).^(-1.7);
kc3s=kc3*suc3;
lam3=rS3/rp; %relative radii 2
if lam3>1
lam3=1;
end
if lam3 <= 0.95
K3d = (1+9/8*lam3*log(lam3)-1.56034*lam3+0.528155*lam3^2+1.91521*lam3^3-2.81903*lam3^4+0.270788*lam3^5+1.10115*lam3^6-0.435933*lam3^7)/(1-lam3)^2; %d hindrance factor 1
else
K3d = 0.984*((1-lam3)/lam3)^(5/2); %d hindrance factor 2
end
K3c = (1+3.867*lam3-1.907*lam3^2-0.834*lam3^3)/(1+1.867*lam3-0.741*lam3^2); %c hindrance factor 2
D3p = K3d*D_inf(3); %pore diffusion 2
theta3 = (1-lam3)^2; %steric partitioning 2

Pem=K3c/K3d*Jv(j+24)*dxe/D_inf(3);
ret_200_int=1-K3c*theta3/((K3c*theta3-1)*exp(-Pem)+1);
ret_200(j)=1-((1-ret_200_int)*kc3s)/(Jv(j+24)*(1-ret_200_int)+kc3s-Jv(j+24));

%%initial parameter calculations
if isnan(Jv(j+36))
    Jv(j+36)=Jv(j+37);
    empty(emptycnt)=j+36;
    emptycnt=emptycnt+1;
end
Sc4=eta/rho/D_inf(4); %inlet Schmidt number [-]
Sh4=1.62*Re0^(1/3)*Sc4^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc4^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc4=Sh4/(2*Ri/D_inf(4)); 
phi4=Jv(j+36)/kc4;
suc4=phi4+(1+0.26*phi4.^(1.4)).^(-1.7);
kc4s=kc4*suc4;
lam4=rS4/rp; %relative radii 2
if lam4>1
lam4=1;
end
if lam4 <= 0.95
K4d = (1+9/8*lam4*log(lam4)-1.56034*lam4+0.528155*lam4^2+1.91521*lam4^3-2.81903*lam4^4+0.270788*lam4^5+1.10115*lam4^6-0.435933*lam4^7)/(1-lam4)^2; %d hindrance factor 1
else
K4d = 0.984*((1-lam4)/lam4)^(5/2); %d hindrance factor 2
end
K4c = (1+3.867*lam4-1.907*lam4^2-0.834*lam4^3)/(1+1.867*lam4-0.741*lam4^2); %c hindrance factor 2
D4p = K4d*D_inf(4); %pore diffusion 2
theta4 = (1-lam4)^2; %steric partitioning 2

Pem=K4c/K4d*Jv(j+36)*dxe/D_inf(4);
ret_400_int=1-K4c*theta4/((K4c*theta4-1)*exp(-Pem)+1);
ret_400(j)=1-((1-ret_400_int)*kc4s)/(Jv(j+36)*(1-ret_400_int)+kc4s-Jv(j+36));

%%initial parameter calculations
if isnan(Jv(j+48))
    Jv(j+48)=Jv(j+49);
    empty(emptycnt)=j+48;
    emptycnt=emptycnt+1;
end
Sc5=eta/rho/D_inf(5); %inlet Schmidt number [-]
Sh5=1.62*Re0^(1/3)*Sc5^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc5^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc5=Sh5/(2*Ri/D_inf(5)); 
phi5=Jv(j+48)/kc5;
suc5=phi5+(1+0.26*phi5.^(1.4)).^(-1.7);
kc5s=kc5*suc5;
lam5=rS5/rp; %relative radii 2
if lam5>1
lam5=1;
end
if lam5 <= 0.95
K5d = (1+9/8*lam5*log(lam5)-1.56034*lam5+0.528155*lam5^2+1.91521*lam5^3-2.81903*lam5^4+0.270788*lam5^5+1.10115*lam5^6-0.435933*lam5^7)/(1-lam5)^2; %d hindrance factor 1
else
K5d = 0.984*((1-lam5)/lam5)^(5/2); %d hindrance factor 2
end
K5c = (1+3.867*lam5-1.907*lam5^2-0.834*lam5^3)/(1+1.867*lam5-0.741*lam5^2); %c hindrance factor 2
D5p = K5d*D_inf(5); %pore diffusion 2
theta5 = (1-lam5)^2; %steric partitioning 2

Pem=K5c/K5d*Jv(j+48)*dxe/D_inf(5);
ret_600_int=1-K5c*theta5/((K5c*theta5-1)*exp(-Pem)+1);
ret_600(j)=1-((1-ret_600_int)*kc5s)/(Jv(j+48)*(1-ret_600_int)+kc5s-Jv(j+48));

%%initial parameter calculations
if isnan(Jv(j+60))
    Jv(j+60)=Jv(j+61);
    empty(emptycnt)=j+60;
    emptycnt=emptycnt+1;
end
Sc6=eta/rho/D_inf(6); %inlet Schmidt number [-]
Sh6=1.62*Re0^(1/3)*Sc6^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc6^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc6=Sh6/(2*Ri/D_inf(6)); 
phi6=Jv(j+60)/kc6;
suc6=phi6+(1+0.26*phi6.^(1.4)).^(-1.7);
kc6s=kc6*suc6;
lam6=rS6/rp; %relative radii 2
if lam6>1
lam6=1;
end
if lam6 <= 0.95
K6d = (1+9/8*lam6*log(lam6)-1.56034*lam6+0.528155*lam6^2+1.91521*lam6^3-2.81903*lam6^4+0.270788*lam6^5+1.10115*lam6^6-0.435933*lam6^7)/(1-lam6)^2; %d hindrance factor 1
else
K6d = 0.984*((1-lam6)/lam6)^(5/2); %d hindrance factor 2
end
K6c = (1+3.867*lam6-1.907*lam6^2-0.834*lam6^3)/(1+1.867*lam6-0.741*lam6^2); %c hindrance factor 2
D6p = K6d*D_inf(6); %pore diffusion 2
theta6 = (1-lam6)^2; %steric partitioning 2

Pem=K6c/K6d*Jv(j+60)*dxe/D_inf(6);
ret_1000_int=1-K6c*theta6/((K6c*theta6-1)*exp(-Pem)+1);
ret_1000(j)=1-((1-ret_1000_int)*kc6s)/(Jv(j+60)*(1-ret_1000_int)+kc6s-Jv(j+60));

%%initial parameter calculations
if isnan(Jv(j+72))
    Jv(j+72)=Jv(j+73);
    empty(emptycnt)=j+72;
    emptycnt=emptycnt+1;
end
Sc7=eta/rho/D_inf(7); %inlet Schmidt number [-]
Sh7=1.62*Re0^(1/3)*Sc7^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc7^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc7=Sh7/(2*Ri/D_inf(7)); 
phi7=Jv(j+72)/kc7;
suc7=phi7+(1+0.26*phi7.^(1.4)).^(-1.7);
kc7s=kc7*suc7;
lam7=rS7/rp; %relative radii 2
if lam7>1
lam7=1;
end
if lam7 <= 0.95
K7d = (1+9/8*lam7*log(lam7)-1.56034*lam7+0.528155*lam7^2+1.91521*lam7^3-2.81903*lam7^4+0.270788*lam7^5+1.10115*lam7^6-0.435933*lam7^7)/(1-lam7)^2; %d hindrance factor 1
else
K7d = 0.984*((1-lam7)/lam7)^(5/2); %d hindrance factor 2
end
K7c = (1+3.867*lam7-1.907*lam7^2-0.834*lam7^3)/(1+1.867*lam7-0.741*lam7^2); %c hindrance factor 2
D7p = K7d*D_inf(7); %pore diffusion 2
theta7 = (1-lam7)^2; %steric partitioning 2

Pem=K7c/K7d*Jv(j+72)*dxe/D_inf(7);
ret_2000_int=1-K7c*theta7/((K7c*theta7-1)*exp(-Pem)+1);
ret_2000(j)=1-((1-ret_2000_int)*kc7s)/(Jv(j+72)*(1-ret_2000_int)+kc7s-Jv(j+72));

%%initial parameter calculations
if isnan(Jv(j+84))
    Jv(j+84)=Jv(j+85);
    empty(emptycnt)=j+84;
    emptycnt=emptycnt+1;
end
Sc8=eta/rho/D_inf(8); %inlet Schmidt number [-]
Sh8=1.62*Re0^(1/3)*Sc8^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc8^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc8=Sh8/(2*Ri/D_inf(8)); 
phi8=Jv(j+84)/kc8;
suc8=phi8+(1+0.26*phi8.^(1.4)).^(-1.7);
kc8s=kc8*suc8;
lam8=rS8/rp; %relative radii 2
if lam8>1
lam8=1;
end
if lam8 <= 0.95
K8d = (1+9/8*lam8*log(lam8)-1.56034*lam8+0.528155*lam8^2+1.91521*lam8^3-2.81903*lam8^4+0.270788*lam8^5+1.10115*lam8^6-0.435933*lam8^7)/(1-lam8)^2; %d hindrance factor 1
else
K8d = 0.984*((1-lam8)/lam8)^(5/2); %d hindrance factor 2
end
K8c = (1+3.867*lam8-1.907*lam8^2-0.834*lam8^3)/(1+1.867*lam8-0.741*lam8^2); %c hindrance factor 2
D8p = K8d*D_inf(8); %pore diffusion 2
theta8 = (1-lam8)^2; %steric partitioning 2

Pem=K8c/K8d*Jv(j+84)*dxe/D_inf(8);
ret_3000_int=1-K8c*theta8/((K8c*theta8-1)*exp(-Pem)+1);
ret_3000(j)=1-((1-ret_3000_int)*kc8s)/(Jv(j+84)*(1-ret_3000_int)+kc8s-Jv(j+84));

end

c_p1=(1-ret_62)*Cf(1);
c_p2=(1-ret_106)*Cf(2);
c_p3=(1-ret_200)*Cf(3);
c_p4=(1-ret_400)*Cf(4);
c_p5=(1-ret_600)*Cf(5);
c_p6=(1-ret_1000)*Cf(6);
c_p7=(1-ret_2000)*Cf(7);
c_p8=(1-ret_3000)*Cf(8);

%film model to get surface concentration
Re0=rho*2*Ri*vm/eta; %inlet Reynolds number [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jv(1:12)/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
Sc2=eta/rho/D_inf(2); %inlet Schmidt number [-]
Sh2=1.62*Re0^(1/3)*Sc2^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc2^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc2=Sh2/(2*Ri/D_inf(2)); 
phi2=Jv(13:24)/kc2;
suc2=phi2+(1+0.26*phi2.^(1.4)).^(-1.7);
kc2s=kc2*suc2;
Sc3=eta/rho/D_inf(3); %inlet Schmidt number [-]
Sh3=1.62*Re0^(1/3)*Sc3^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc3^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc3=Sh3/(2*Ri/D_inf(3)); 
phi3=Jv(25:36)/kc3;
suc3=phi3+(1+0.26*phi3.^(1.4)).^(-1.7);
kc3s=kc3*suc3;
Sc4=eta/rho/D_inf(4); %inlet Schmidt number [-]
Sh4=1.62*Re0^(1/3)*Sc4^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc4^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc4=Sh4/(2*Ri/D_inf(4)); 
phi4=Jv(37:48)/kc4;
suc4=phi4+(1+0.26*phi4.^(1.4)).^(-1.7);
kc4s=kc4*suc4;
Sc5=eta/rho/D_inf(5); %inlet Schmidt number [-]
Sh5=1.62*Re0^(1/3)*Sc5^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc5^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc5=Sh5/(2*Ri/D_inf(5)); 
phi5=Jv(49:60)/kc5;
suc5=phi5+(1+0.26*phi5.^(1.4)).^(-1.7);
kc5s=kc5*suc5;
Sc6=eta/rho/D_inf(6); %inlet Schmidt number [-]
Sh6=1.62*Re0^(1/3)*Sc6^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc6^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc6=Sh6/(2*Ri/D_inf(6)); 
phi6=Jv(61:72)/kc6;
suc6=phi6+(1+0.26*phi6.^(1.4)).^(-1.7);
kc6s=kc6*suc6;
Sc7=eta/rho/D_inf(7); %inlet Schmidt number [-]
Sh7=1.62*Re0^(1/3)*Sc7^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc7^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc7=Sh7/(2*Ri/D_inf(7)); 
phi7=Jv(73:84)/kc7;
suc7=phi7+(1+0.26*phi7.^(1.4)).^(-1.7);
kc7s=kc7*suc7;
Sc8=eta/rho/D_inf(8); %inlet Schmidt number [-]
Sh8=1.62*Re0^(1/3)*Sc8^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc8^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc8=Sh8/(2*Ri/D_inf(8)); 
phi8=Jv(85:96)/kc8;
suc8=phi8+(1+0.26*phi8.^(1.4)).^(-1.7);
kc8s=kc8*suc8;

C62M=(c_p1.*Jv(1:12)-Cf(1)*kc1s)./(Jv(1:12)-kc1s);
C106M=(c_p2.*Jv(13:24)-Cf(2)*kc2s)./(Jv(13:24)-kc2s);
C200M=(c_p3.*Jv(25:36)-Cf(3)*kc3s)./(Jv(25:36)-kc3s);
C400M=(c_p4.*Jv(37:48)-Cf(4)*kc4s)./(Jv(37:48)-kc4s);
C600M=(c_p5.*Jv(49:60)-Cf(5)*kc5s)./(Jv(49:60)-kc5s);
C1000M=(c_p6.*Jv(61:72)-Cf(6)*kc6s)./(Jv(61:72)-kc6s);
C2000M=(c_p7.*Jv(73:84)-Cf(7)*kc7s)./(Jv(73:84)-kc7s);
C3000M=(c_p8.*Jv(85:96)-Cf(8)*kc8s)./(Jv(85:96)-kc8s);

ret_62=1-(c_p1*(1-f)+C62M*f)./Cf(1);
ret_106=1-(c_p2*(1-f)+C106M*f)./Cf(2);
ret_200=1-(c_p3*(1-f)+C200M*f)./Cf(3);
ret_400=1-(c_p4*(1-f)+C400M*f)./Cf(4);
ret_600=1-(c_p5*(1-f)+C600M*f)./Cf(5);
ret_1000=1-(c_p6*(1-f)+C1000M*f)./Cf(6);
ret_2000=1-(c_p7*(1-f)+C2000M*f)./Cf(7);
ret_3000=1-(c_p8*(1-f)+C3000M*f)./Cf(8);

n_PEG=size(r_62,2)+size(r_106,2)+size(r_200,2)+size(r_400,2)+size(r_600,2)+size(r_1000,2)+size(r_2000,2)+size(r_3000,2)-emptycnt+1;
n_PWP=size(Pw_F,2);
residualso=[(r_62-ret_62)/n_PEG/(0.01) (r_106-ret_106)/n_PEG/(0.01) (r_200-ret_200)/n_PEG/(0.01) (r_400-ret_400)/n_PEG/(0.01) (r_600-ret_600)/n_PEG/(0.01) (r_1000-ret_1000)/n_PEG/(0.01) (r_2000-ret_2000)/n_PEG/(0.01) (r_3000-ret_3000)/n_PEG/(0.01) (Pw_F-PWP.*Pw_P)/n_PWP./(0.05*Pw_F)];

counter=1;
numbernan=1;
for i=1:1:size(residualso,2)
    if emptycnt==1
        residuals=residualso;
        break;
    end
    if i==empty(numbernan)
    numbernan=numbernan+1;
        if numbernan>emptycnt-1
            numbernan=emptycnt-1;
        end
    else
    residuals(counter)=residualso(i);
    counter=counter+1;
    end
end
end

function [retention] = SinglePoreSizePlot(x,param)
%parameters
Jv_l = param(1); %low flux
Jv_h = param(2); %high flux
Jv_i = param(3); %flux interval
Cf = param(4:11);
K1 = param(12);
vm = param(13);
L = param(14);
d = param(15);
Ri = param(16);
maxIter = param(17);
n = param(18);
relax = param(19);
residual = param(20);
D_inf = param(21:28);
rS1 = param(29);
rS2 = param(30); 
rS3 = param(31);
rS4 = param(32);
rS5 = param(33);
rS6 = param(34);
rS7 = param(35);
rS8 = param(36);
rho = param(37);
eta = param(38);
F = param(39);
Rg = param(40);
T = param(41);

Jv = Jv_l:Jv_i:Jv_h;%for plot more Jv

%variables
rp=x(1);
dxe=rp^2/K1;

for j = 1:length(Jv) 
%%initial parameter calculations
v0=vm; %inlet velocity [m/s]
dx=dxe/(n-1); %grid node difference [m]
x=0:dx:dxe; %grid
Re0=rho*2*Ri*v0/eta; %inlet Reynolds number [-]
fD0=64/Re0; %inlet friction factor [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jv(j)/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
lam1=rS1/rp; %relative radii 1
if lam1>1
lam1=1;
end
if lam1 <= 0.95
K1d = (1+9/8*lam1*log(lam1)-1.56034*lam1+0.528155*lam1^2+1.91521*lam1^3-2.81903*lam1^4+0.270788*lam1^5+1.10115*lam1^6-0.435933*lam1^7)/(1-lam1)^2; %d hindrance factor 1
else
K1d = 0.984*((1-lam1)/lam1)^(5/2); %d hindrance factor 1
end
K1c = (1+3.867*lam1-1.907*lam1^2-0.834*lam1^3)/(1+1.867*lam1-0.741*lam1^2); %c hindrance factor 1
D1p = K1d*D_inf(1); %pore diffusion 1
theta1 = (1-lam1)^2; %steric partitioning 1

Pem=K1c/K1d*Jv(j)*dxe/D_inf(1);
ret_62_int=1-K1c*theta1/((K1c*theta1-1)*exp(-Pem)+1);
ret_62(j)=1-((1-ret_62_int)*kc1s)/(Jv(j)*(1-ret_62_int)+kc1s-Jv(j));

%%initial parameter calculations
Sc2=eta/rho/D_inf(2); %inlet Schmidt number [-]
Sh2=1.62*Re0^(1/3)*Sc2^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc2^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc2=Sh2/(2*Ri/D_inf(2)); 
phi2=Jv(j)/kc2;
suc2=phi2+(1+0.26*phi2.^(1.4)).^(-1.7);
kc2s=kc2*suc2;
lam2=rS2/rp; %relative radii 2
if lam2>1
lam2=1;
end
if lam2 <= 0.95
K2d = (1+9/8*lam2*log(lam2)-1.56034*lam2+0.528155*lam2^2+1.91521*lam2^3-2.81903*lam2^4+0.270788*lam2^5+1.10115*lam2^6-0.435933*lam2^7)/(1-lam2)^2; %d hindrance factor 1
else
K2d = 0.984*((1-lam2)/lam2)^(5/2); %d hindrance factor 2
end
K2c = (1+3.867*lam2-1.907*lam2^2-0.834*lam2^3)/(1+1.867*lam2-0.741*lam2^2); %c hindrance factor 2
D2p = K2d*D_inf(2); %pore diffusion 2
theta2 = (1-lam2)^2; %steric partitioning 2

Pem=K2c/K2d*Jv(j)*dxe/D_inf(2);
ret_106_int=1-K2c*theta2/((K2c*theta2-1)*exp(-Pem)+1);
ret_106(j)=1-((1-ret_106_int)*kc2s)/(Jv(j)*(1-ret_106_int)+kc2s-Jv(j));

%%initial parameter calculations
Sc3=eta/rho/D_inf(3); %inlet Schmidt number [-]
Sh3=1.62*Re0^(1/3)*Sc3^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc3^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc3=Sh3/(2*Ri/D_inf(3)); 
phi3=Jv(j)/kc3;
suc3=phi3+(1+0.26*phi3.^(1.4)).^(-1.7);
kc3s=kc3*suc3;
lam3=rS3/rp; %relative radii 2
if lam3>1
lam3=1;
end
if lam3 <= 0.95
K3d = (1+9/8*lam3*log(lam3)-1.56034*lam3+0.528155*lam3^2+1.91521*lam3^3-2.81903*lam3^4+0.270788*lam3^5+1.10115*lam3^6-0.435933*lam3^7)/(1-lam3)^2; %d hindrance factor 1
else
K3d = 0.984*((1-lam3)/lam3)^(5/2); %d hindrance factor 2
end
K3c = (1+3.867*lam3-1.907*lam3^2-0.834*lam3^3)/(1+1.867*lam3-0.741*lam3^2); %c hindrance factor 2
D3p = K3d*D_inf(3); %pore diffusion 2
theta3 = (1-lam3)^2; %steric partitioning 2

Pem=K3c/K3d*Jv(j)*dxe/D_inf(3);
ret_200_int=1-K3c*theta3/((K3c*theta3-1)*exp(-Pem)+1);
ret_200(j)=1-((1-ret_200_int)*kc3s)/(Jv(j)*(1-ret_200_int)+kc3s-Jv(j));

%%initial parameter calculations
Sc4=eta/rho/D_inf(4); %inlet Schmidt number [-]
Sh4=1.62*Re0^(1/3)*Sc4^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc4^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc4=Sh4/(2*Ri/D_inf(4)); 
phi4=Jv(j)/kc4;
suc4=phi4+(1+0.26*phi4.^(1.4)).^(-1.7);
kc4s=kc4*suc4;
lam4=rS4/rp; %relative radii 2
if lam4>1
lam4=1;
end
if lam4 <= 0.95
K4d = (1+9/8*lam4*log(lam4)-1.56034*lam4+0.528155*lam4^2+1.91521*lam4^3-2.81903*lam4^4+0.270788*lam4^5+1.10115*lam4^6-0.435933*lam4^7)/(1-lam4)^2; %d hindrance factor 1
else
K4d = 0.984*((1-lam4)/lam4)^(5/2); %d hindrance factor 2
end
K4c = (1+3.867*lam4-1.907*lam4^2-0.834*lam4^3)/(1+1.867*lam4-0.741*lam4^2); %c hindrance factor 2
D4p = K4d*D_inf(4); %pore diffusion 2
theta4 = (1-lam4)^2; %steric partitioning 2

Pem=K4c/K4d*Jv(j)*dxe/D_inf(4);
ret_400_int=1-K4c*theta4/((K4c*theta4-1)*exp(-Pem)+1);
ret_400(j)=1-((1-ret_400_int)*kc4s)/(Jv(j)*(1-ret_400_int)+kc4s-Jv(j));

%%initial parameter calculations
Sc5=eta/rho/D_inf(5); %inlet Schmidt number [-]
Sh5=1.62*Re0^(1/3)*Sc5^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc5^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc5=Sh5/(2*Ri/D_inf(5)); 
phi5=Jv(j)/kc5;
suc5=phi5+(1+0.26*phi5.^(1.4)).^(-1.7);
kc5s=kc5*suc5;
lam5=rS5/rp; %relative radii 2
if lam5>1
lam5=1;
end
if lam5 <= 0.95
K5d = (1+9/8*lam5*log(lam5)-1.56034*lam5+0.528155*lam5^2+1.91521*lam5^3-2.81903*lam5^4+0.270788*lam5^5+1.10115*lam5^6-0.435933*lam5^7)/(1-lam5)^2; %d hindrance factor 1
else
K5d = 0.984*((1-lam5)/lam5)^(5/2); %d hindrance factor 2
end
K5c = (1+3.867*lam5-1.907*lam5^2-0.834*lam5^3)/(1+1.867*lam5-0.741*lam5^2); %c hindrance factor 2
D5p = K5d*D_inf(5); %pore diffusion 2
theta5 = (1-lam5)^2; %steric partitioning 2

Pem=K5c/K5d*Jv(j)*dxe/D_inf(5);
ret_600_int=1-K5c*theta5/((K5c*theta5-1)*exp(-Pem)+1);
ret_600(j)=1-((1-ret_600_int)*kc5s)/(Jv(j)*(1-ret_600_int)+kc5s-Jv(j));

%%initial parameter calculations
Sc6=eta/rho/D_inf(6); %inlet Schmidt number [-]
Sh6=1.62*Re0^(1/3)*Sc6^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc6^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc6=Sh6/(2*Ri/D_inf(6)); 
phi6=Jv(j)/kc6;
suc6=phi6+(1+0.26*phi6.^(1.4)).^(-1.7);
kc6s=kc6*suc6;
lam6=rS6/rp; %relative radii 2
if lam6>1
lam6=1;
end
if lam6 <= 0.95
K6d = (1+9/8*lam6*log(lam6)-1.56034*lam6+0.528155*lam6^2+1.91521*lam6^3-2.81903*lam6^4+0.270788*lam6^5+1.10115*lam6^6-0.435933*lam6^7)/(1-lam6)^2; %d hindrance factor 1
else
K6d = 0.984*((1-lam6)/lam6)^(5/2); %d hindrance factor 2
end
K6c = (1+3.867*lam6-1.907*lam6^2-0.834*lam6^3)/(1+1.867*lam6-0.741*lam6^2); %c hindrance factor 2
D6p = K6d*D_inf(6); %pore diffusion 2
theta6 = (1-lam6)^2; %steric partitioning 2

Pem=K6c/K6d*Jv(j)*dxe/D_inf(6);
ret_1000_int=1-K6c*theta6/((K6c*theta6-1)*exp(-Pem)+1);
ret_1000(j)=1-((1-ret_1000_int)*kc6s)/(Jv(j)*(1-ret_1000_int)+kc6s-Jv(j));

%%initial parameter calculations
Sc7=eta/rho/D_inf(7); %inlet Schmidt number [-]
Sh7=1.62*Re0^(1/3)*Sc7^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc7^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc7=Sh7/(2*Ri/D_inf(7)); 
phi7=Jv(j)/kc7;
suc7=phi7+(1+0.26*phi7.^(1.4)).^(-1.7);
kc7s=kc7*suc7;
lam7=rS7/rp; %relative radii 2
if lam7>1
lam7=1;
end
if lam7 <= 0.95
K7d = (1+9/8*lam7*log(lam7)-1.56034*lam7+0.528155*lam7^2+1.91521*lam7^3-2.81903*lam7^4+0.270788*lam7^5+1.10115*lam7^6-0.435933*lam7^7)/(1-lam7)^2; %d hindrance factor 1
else
K7d = 0.984*((1-lam7)/lam7)^(5/2); %d hindrance factor 2
end
K7c = (1+3.867*lam7-1.907*lam7^2-0.834*lam7^3)/(1+1.867*lam7-0.741*lam7^2); %c hindrance factor 2
D7p = K7d*D_inf(7); %pore diffusion 2
theta7 = (1-lam7)^2; %steric partitioning 2

Pem=K7c/K7d*Jv(j)*dxe/D_inf(7);
ret_2000_int=1-K7c*theta7/((K7c*theta7-1)*exp(-Pem)+1);
ret_2000(j)=1-((1-ret_2000_int)*kc7s)/(Jv(j)*(1-ret_2000_int)+kc7s-Jv(j));

%%initial parameter calculations
Sc8=eta/rho/D_inf(8); %inlet Schmidt number [-]
Sh8=1.62*Re0^(1/3)*Sc8^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc8^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc8=Sh8/(2*Ri/D_inf(8)); 
phi8=Jv(j)/kc8;
suc8=phi8+(1+0.26*phi8.^(1.4)).^(-1.7);
kc8s=kc8*suc8;
lam8=rS8/rp; %relative radii 2
if lam8>1
lam8=1;
end
if lam8 <= 0.95
K8d = (1+9/8*lam8*log(lam8)-1.56034*lam8+0.528155*lam8^2+1.91521*lam8^3-2.81903*lam8^4+0.270788*lam8^5+1.10115*lam8^6-0.435933*lam8^7)/(1-lam8)^2; %d hindrance factor 1
else
K8d = 0.984*((1-lam8)/lam8)^(5/2); %d hindrance factor 2
end
K8c = (1+3.867*lam8-1.907*lam8^2-0.834*lam8^3)/(1+1.867*lam8-0.741*lam8^2); %c hindrance factor 2
D8p = K8d*D_inf(8); %pore diffusion 2
theta8 = (1-lam8)^2; %steric partitioning 2

Pem=K8c/K8d*Jv(j)*dxe/D_inf(8);
ret_3000_int=1-K8c*theta8/((K8c*theta8-1)*exp(-Pem)+1);
ret_3000(j)=1-((1-ret_3000_int)*kc8s)/(Jv(j)*(1-ret_3000_int)+kc8s-Jv(j));
end

retention = [ret_62;ret_106;ret_200;ret_400;ret_600;ret_1000;ret_2000;ret_3000];

end

function [residuals] = PoreSizeDistributionFit(x,param)
%parameters
Jv = param(1:96);
r_62 = param(97:108);
r_106 = param(109:120);
r_200 = param(121:132);
r_400 = param(133:144);
r_600 = param(145:156);
r_1000 = param(157:168);
r_2000 = param(169:180);
r_3000 = param(181:192);
Cf = param(193:200);
vm = param(201);
L = param(202);
d = param(203);
Ri = param(204);
maxIter = param(205);
n = param(206);
relax = param(207);
residual = param(208);
D_inf = param(209:216);
rS1 = param(217);
rS2 = param(218); 
rS3 = param(219);
rS4 = param(220);
rS5 = param(221);
rS6 = param(222);
rS7 = param(223);
rS8 = param(224);
rho = param(225);
eta = param(226);
F = param(227);
Rg = param(228);
T = param(229);
Pw_P = param(230:241);
Pw_F = param(242:253);

%variables
rmean = x(1)*10^(-10);
std = x(2)*10^(-11);
dxen = x(3)*10^(-25);
dxecor = x(4)*10^(-6);

emptycnt=1;

rS = [rS1 rS2 rS3 rS4 rS5 rS6 rS7 rS8];
Cf1 = Cf(1);
Cf2 = Cf(2);
Cf3 = Cf(3);
Cf4 = Cf(4);
Cf5 = Cf(5);
Cf6 = Cf(6);
Cf7 = Cf(7);
Cf8 = Cf(8);

b = log(1+(std/rmean)^2); %log distribution

deltar = 1E-11; %discretization size [m]
maxr = 10E-9; %upper limit [m]

rDist=deltar:deltar:maxr; %radius range [m]
for i=1:1:maxr/deltar %discrete function
Fr(i) = integral(@(r) 1./(r*(2*pi()*b).^0.5).*exp(-(log(r./rmean)+b/2).^2/2/b),deltar*(i)-deltar/2,deltar*(i)+deltar/2); %relative ammount
end

Jvr=Fr.*rDist.^4; %flux as function of radius *dPeff/dxen/8/eta*pi()
RelFr=Jvr./sum(Jvr);

%truncation
maxf=max(RelFr);
minf=maxf*0.05; %5% of maximum value cut off

minc=1;
maxc=1.1;
for i=1:1:size(rDist,2)
if RelFr(i)>=minf && minc<maxc
    minc=i;
end
if RelFr(i)<minf && minc>maxc
    maxc=i;
    break;
end
end

if maxc==1.1
   maxc=length(RelFr); 
end

maxval=0;
maxrn=0;
for i=1:1:size(rDist,2)
    if RelFr(i)>maxval
        maxval=RelFr(i);
        maxrn=i;
    end
end
rmaxflux=rDist(maxrn);

rDist=rDist(minc:maxc);
Fr=Fr(minc:maxc);

scale=sum(Fr); %normalize distribution to sumfR=1
Fr=Fr./scale; 

if isempty(Fr)
    disp("empty distribution");
end

%updated thickness
K1=sum(pi()*rDist.^4.*Fr)/dxen;
PWP=K1*1000*60*60*10^5/8/eta;

Jtest=Jv;
for j=1:1:size(Jtest,2)

if isnan(Jtest(j))
    Jtest(j)=Jtest(j+1);
    empty(emptycnt)=j;
    emptycnt=emptycnt+1;
end    
    
%flux as function of r
dPeff=Jtest(j)*8*eta/K1;
Jvr=Fr.*pi().*rDist.^4.*dPeff/8/eta/dxen;

%retention as function of r
if j>0
Comp=1;
end
if j>12
Comp=2;
end
if j>24
Comp=3;
end
if j>36
Comp=4;
end
if j>48
Comp=5;
end
if j>60
Comp=6;
end
if j>72
Comp=7;
end
if j>84
Comp=8;
end

par=[Cf1 Cf2 Cf3 Cf4 Cf5 Cf6 Cf7 Cf8 K1 vm L d Ri maxIter dxen n relax residual D_inf rS rho eta F Rg T Comp];

for i=1:1:size(Fr,2)
Ret(i)=PoreSizeDistributionPlotSingle([Jtest(j) rDist(i) Fr(i)],par);
end
%overal retention
Reto(Comp,j)=sum(Ret.*Jvr)/Jtest(j);
end
n_PEG=size(r_62,2)+size(r_106,2)+size(r_200,2)+size(r_400,2)+size(r_600,2)+size(r_1000,2)+size(r_2000,2)+size(r_3000,2)-emptycnt+1;
n_PWP=size(Pw_F,2);
residualso=[(r_62-Reto(1,1:12))/n_PEG/(0.01) (r_106-Reto(2,13:24))/n_PEG/(0.01) (r_200-Reto(3,25:36))/n_PEG/(0.01) (r_400-Reto(4,37:48))/n_PEG/(0.01) (r_600-Reto(5,49:60))/n_PEG/(0.01) (r_1000-Reto(6,61:72))/n_PEG/(0.01) (r_2000-Reto(7,73:84))/n_PEG/(0.01) (r_3000-Reto(8,85:96))/n_PEG/(0.01) (Pw_F-PWP.*Pw_P)/n_PWP./(0.05*Pw_F) (rmaxflux^2/K1-dxecor)*10^6];
counter=1;
numbernan=1;
for i=1:1:size(residualso,2)
    if emptycnt==1
        residuals=residualso;
        break;
    end
    if i==empty(numbernan)
    numbernan=numbernan+1;
        if numbernan>emptycnt-1
            numbernan=emptycnt-1;
        end
    else
    residuals(counter)=residualso(i);
    counter=counter+1;
    end
end
end

function [retention] = PoreSizeDistributionPlot(x,param)
%parameters
Cf = param(1:8);
K1 = param(9);
vm = param(10);
L = param(11);
d = param(12);
Ri = param(13);
maxIter = param(14);
dxen=param(15);
n = param(16);
relax = param(17);
residual = param(18);
D_inf = param(19:26);
rS1 = param(27);
rS2 = param(28); 
rS3 = param(29);
rS4 = param(30);
rS5 = param(31);
rS6 = param(32);
rS7 = param(33);
rS8 = param(34);
rho = param(35);
eta = param(36);
F = param(37);
Rg = param(38);
T = param(39);

%variables
Jv=x(1); %flux
rp=x(2); %pore size
Fr=x(3); %relative ammount

dxe=dxen/Fr/pi()./(rp.^2);
dPeff=Jv*8*eta/K1;
Jv=rp^2.*dPeff/8/eta/dxe;

%%initial parameter calculations
v0=vm; %inlet velocity [m/s]
dx=dxe/(n-1); %grid node difference [m]
x=0:dx:dxe; %grid
Re0=rho*2*Ri*v0/eta; %inlet Reynolds number [-]
fD0=64/Re0; %inlet friction factor [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jv/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
lam1=rS1/rp; %relative radii 1
if lam1>1
lam1=1;
end
if lam1 <= 0.95
K1d = (1+9/8*lam1*log(lam1)-1.56034*lam1+0.528155*lam1^2+1.91521*lam1^3-2.81903*lam1^4+0.270788*lam1^5+1.10115*lam1^6-0.435933*lam1^7)/(1-lam1)^2; %d hindrance factor 1
else
K1d = 0.984*((1-lam1)/lam1)^(5/2); %d hindrance factor 1
end
K1c = (1+3.867*lam1-1.907*lam1^2-0.834*lam1^3)/(1+1.867*lam1-0.741*lam1^2); %c hindrance factor 1
D1p = K1d*D_inf(1); %pore diffusion 1
theta1 = (1-lam1)^2; %steric partitioning 1

Pem=K1c/K1d*Jv*dxe/D_inf(1);
ret_62_int=1-K1c*theta1/((K1c*theta1-1)*exp(-Pem)+1);
ret_62=1-((1-ret_62_int)*kc1s)/(Jv*(1-ret_62_int)+kc1s-Jv);

%%initial parameter calculations
Sc2=eta/rho/D_inf(2); %inlet Schmidt number [-]
Sh2=1.62*Re0^(1/3)*Sc2^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc2^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc2=Sh2/(2*Ri/D_inf(2)); 
phi2=Jv/kc2;
suc2=phi2+(1+0.26*phi2.^(1.4)).^(-1.7);
kc2s=kc2*suc2;
lam2=rS2/rp; %relative radii 2
if lam2>1
lam2=1;
end
if lam2 <= 0.95
K2d = (1+9/8*lam2*log(lam2)-1.56034*lam2+0.528155*lam2^2+1.91521*lam2^3-2.81903*lam2^4+0.270788*lam2^5+1.10115*lam2^6-0.435933*lam2^7)/(1-lam2)^2; %d hindrance factor 1
else
K2d = 0.984*((1-lam2)/lam2)^(5/2); %d hindrance factor 2
end
K2c = (1+3.867*lam2-1.907*lam2^2-0.834*lam2^3)/(1+1.867*lam2-0.741*lam2^2); %c hindrance factor 2
D2p = K2d*D_inf(2); %pore diffusion 2
theta2 = (1-lam2)^2; %steric partitioning 2

Pem=K2c/K2d*Jv*dxe/D_inf(2);
ret_106_int=1-K2c*theta2/((K2c*theta2-1)*exp(-Pem)+1);
ret_106=1-((1-ret_106_int)*kc2s)/(Jv*(1-ret_106_int)+kc2s-Jv);

%%initial parameter calculations
Sc3=eta/rho/D_inf(3); %inlet Schmidt number [-]
Sh3=1.62*Re0^(1/3)*Sc3^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc3^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc3=Sh3/(2*Ri/D_inf(3)); 
phi3=Jv/kc3;
suc3=phi3+(1+0.26*phi3.^(1.4)).^(-1.7);
kc3s=kc3*suc3;
lam3=rS3/rp; %relative radii 2
if lam3>1
lam3=1;
end
if lam3 <= 0.95
K3d = (1+9/8*lam3*log(lam3)-1.56034*lam3+0.528155*lam3^2+1.91521*lam3^3-2.81903*lam3^4+0.270788*lam3^5+1.10115*lam3^6-0.435933*lam3^7)/(1-lam3)^2; %d hindrance factor 1
else
K3d = 0.984*((1-lam3)/lam3)^(5/2); %d hindrance factor 2
end
K3c = (1+3.867*lam3-1.907*lam3^2-0.834*lam3^3)/(1+1.867*lam3-0.741*lam3^2); %c hindrance factor 2
D3p = K3d*D_inf(3); %pore diffusion 2
theta3 = (1-lam3)^2; %steric partitioning 2

Pem=K3c/K3d*Jv*dxe/D_inf(3);
ret_200_int=1-K3c*theta3/((K3c*theta3-1)*exp(-Pem)+1);
ret_200=1-((1-ret_200_int)*kc3s)/(Jv*(1-ret_200_int)+kc3s-Jv);

%%initial parameter calculations
Sc4=eta/rho/D_inf(4); %inlet Schmidt number [-]
Sh4=1.62*Re0^(1/3)*Sc4^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc4^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc4=Sh4/(2*Ri/D_inf(4)); 
phi4=Jv/kc4;
suc4=phi4+(1+0.26*phi4.^(1.4)).^(-1.7);
kc4s=kc4*suc4;
lam4=rS4/rp; %relative radii 2
if lam4>1
lam4=1;
end
if lam4 <= 0.95
K4d = (1+9/8*lam4*log(lam4)-1.56034*lam4+0.528155*lam4^2+1.91521*lam4^3-2.81903*lam4^4+0.270788*lam4^5+1.10115*lam4^6-0.435933*lam4^7)/(1-lam4)^2; %d hindrance factor 1
else
K4d = 0.984*((1-lam4)/lam4)^(5/2); %d hindrance factor 2
end
K4c = (1+3.867*lam4-1.907*lam4^2-0.834*lam4^3)/(1+1.867*lam4-0.741*lam4^2); %c hindrance factor 2
D4p = K4d*D_inf(4); %pore diffusion 2
theta4 = (1-lam4)^2; %steric partitioning 2

Pem=K4c/K4d*Jv*dxe/D_inf(4);
ret_400_int=1-K4c*theta4/((K4c*theta4-1)*exp(-Pem)+1);
ret_400=1-((1-ret_400_int)*kc4s)/(Jv*(1-ret_400_int)+kc4s-Jv);

%%initial parameter calculations
Sc5=eta/rho/D_inf(5); %inlet Schmidt number [-]
Sh5=1.62*Re0^(1/3)*Sc5^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc5^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc5=Sh5/(2*Ri/D_inf(5)); 
phi5=Jv/kc5;
suc5=phi5+(1+0.26*phi5.^(1.4)).^(-1.7);
kc5s=kc5*suc5;
lam5=rS5/rp; %relative radii 2
if lam5>1
lam5=1;
end
if lam5 <= 0.95
K5d = (1+9/8*lam5*log(lam5)-1.56034*lam5+0.528155*lam5^2+1.91521*lam5^3-2.81903*lam5^4+0.270788*lam5^5+1.10115*lam5^6-0.435933*lam5^7)/(1-lam5)^2; %d hindrance factor 1
else
K5d = 0.984*((1-lam5)/lam5)^(5/2); %d hindrance factor 2
end
K5c = (1+3.867*lam5-1.907*lam5^2-0.834*lam5^3)/(1+1.867*lam5-0.741*lam5^2); %c hindrance factor 2
D5p = K5d*D_inf(5); %pore diffusion 2
theta5 = (1-lam5)^2; %steric partitioning 2

Pem=K5c/K5d*Jv*dxe/D_inf(5);
ret_600_int=1-K5c*theta5/((K5c*theta5-1)*exp(-Pem)+1);
ret_600=1-((1-ret_600_int)*kc5s)/(Jv*(1-ret_600_int)+kc5s-Jv);

%%initial parameter calculations
Sc6=eta/rho/D_inf(6); %inlet Schmidt number [-]
Sh6=1.62*Re0^(1/3)*Sc6^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc6^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc6=Sh6/(2*Ri/D_inf(6)); 
phi6=Jv/kc6;
suc6=phi6+(1+0.26*phi6.^(1.4)).^(-1.7);
kc6s=kc6*suc6;
lam6=rS6/rp; %relative radii 2
if lam6>1
lam6=1;
end
if lam6 <= 0.95
K6d = (1+9/8*lam6*log(lam6)-1.56034*lam6+0.528155*lam6^2+1.91521*lam6^3-2.81903*lam6^4+0.270788*lam6^5+1.10115*lam6^6-0.435933*lam6^7)/(1-lam6)^2; %d hindrance factor 1
else
K6d = 0.984*((1-lam6)/lam6)^(5/2); %d hindrance factor 2
end
K6c = (1+3.867*lam6-1.907*lam6^2-0.834*lam6^3)/(1+1.867*lam6-0.741*lam6^2); %c hindrance factor 2
D6p = K6d*D_inf(6); %pore diffusion 2
theta6 = (1-lam6)^2; %steric partitioning 2

Pem=K6c/K6d*Jv*dxe/D_inf(6);
ret_1000_int=1-K6c*theta6/((K6c*theta6-1)*exp(-Pem)+1);
ret_1000=1-((1-ret_1000_int)*kc6s)/(Jv*(1-ret_1000_int)+kc6s-Jv);

%%initial parameter calculations
Sc7=eta/rho/D_inf(7); %inlet Schmidt number [-]
Sh7=1.62*Re0^(1/3)*Sc7^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc7^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc7=Sh7/(2*Ri/D_inf(7)); 
phi7=Jv/kc7;
suc7=phi7+(1+0.26*phi7.^(1.4)).^(-1.7);
kc7s=kc7*suc7;
lam7=rS7/rp; %relative radii 2
if lam7>1
lam7=1;
end
if lam7 <= 0.95
K7d = (1+9/8*lam7*log(lam7)-1.56034*lam7+0.528155*lam7^2+1.91521*lam7^3-2.81903*lam7^4+0.270788*lam7^5+1.10115*lam7^6-0.435933*lam7^7)/(1-lam7)^2; %d hindrance factor 1
else
K7d = 0.984*((1-lam7)/lam7)^(5/2); %d hindrance factor 2
end
K7c = (1+3.867*lam7-1.907*lam7^2-0.834*lam7^3)/(1+1.867*lam7-0.741*lam7^2); %c hindrance factor 2
D7p = K7d*D_inf(7); %pore diffusion 2
theta7 = (1-lam7)^2; %steric partitioning 2

Pem=K7c/K7d*Jv*dxe/D_inf(7);
ret_2000_int=1-K7c*theta7/((K7c*theta7-1)*exp(-Pem)+1);
ret_2000=1-((1-ret_2000_int)*kc7s)/(Jv*(1-ret_2000_int)+kc7s-Jv);

%%initial parameter calculations
Sc8=eta/rho/D_inf(8); %inlet Schmidt number [-]
Sh8=1.62*Re0^(1/3)*Sc8^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc8^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc8=Sh8/(2*Ri/D_inf(8)); 
phi8=Jv/kc8;
suc8=phi8+(1+0.26*phi8.^(1.4)).^(-1.7);
kc8s=kc8*suc8;
lam8=rS8/rp; %relative radii 2
if lam8>1
lam8=1;
end
if lam8 <= 0.95
K8d = (1+9/8*lam8*log(lam8)-1.56034*lam8+0.528155*lam8^2+1.91521*lam8^3-2.81903*lam8^4+0.270788*lam8^5+1.10115*lam8^6-0.435933*lam8^7)/(1-lam8)^2; %d hindrance factor 1
else
K8d = 0.984*((1-lam8)/lam8)^(5/2); %d hindrance factor 2
end
K8c = (1+3.867*lam8-1.907*lam8^2-0.834*lam8^3)/(1+1.867*lam8-0.741*lam8^2); %c hindrance factor 2
D8p = K8d*D_inf(8); %pore diffusion 2
theta8 = (1-lam8)^2; %steric partitioning 2

Pem=K8c/K8d*Jv*dxe/D_inf(8);
ret_3000_int=1-K8c*theta8/((K8c*theta8-1)*exp(-Pem)+1);
ret_3000=1-((1-ret_3000_int)*kc8s)/(Jv*(1-ret_3000_int)+kc8s-Jv);

retention = [ret_62;ret_106;ret_200;ret_400;ret_600;ret_1000;ret_2000;ret_3000];
end

function [retention] = PoreSizeDistributionPlotSingle(x,param)
%parameters
Cf0 = param(1:8);
K1 = param(9);
vm = param(10);
L = param(11);
d = param(12);
Ri = param(13);
maxIter = param(14);
dxen=param(15);
n = param(16);
relax = param(17);
residual = param(18);
D_inf0 = param(19:26);
rS0 = param(27:34);
rho = param(35);
eta = param(36);
F = param(37);
Rg = param(38);
T = param(39);
Comp = param(40);

D_inf=D_inf0(Comp);
rS1=rS0(Comp);
Cf=Cf0(Comp);

%variables
Jv=x(1); %flux
rp=x(2); %pore size
Fr=x(3); %relative ammount

dxe=dxen/Fr/pi()./(rp.^2);
dPeff=Jv*8*eta/K1;
Jv=rp^2.*dPeff/8/eta/dxe;

%%initial parameter calculations
v0=vm; %inlet velocity [m/s]
dx=dxe/(n-1); %grid node difference [m]
x=0:dx:dxe; %grid
Re0=rho*2*Ri*v0/eta; %inlet Reynolds number [-]
fD0=64/Re0; %inlet friction factor [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jv/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
lam1=rS1/rp; %relative radii 1
if lam1>1
lam1=1;
end
if lam1 <= 0.95
K1d = (1+9/8*lam1*log(lam1)-1.56034*lam1+0.528155*lam1^2+1.91521*lam1^3-2.81903*lam1^4+0.270788*lam1^5+1.10115*lam1^6-0.435933*lam1^7)/(1-lam1)^2; %d hindrance factor 1
else
K1d = 0.984*((1-lam1)/lam1)^(5/2); %d hindrance factor 1
end
K1c = (1+3.867*lam1-1.907*lam1^2-0.834*lam1^3)/(1+1.867*lam1-0.741*lam1^2); %c hindrance factor 1
D1p = K1d*D_inf(1); %pore diffusion 1
theta1 = (1-lam1)^2; %steric partitioning 1

Pem=K1c/K1d*Jv*dxe/D_inf(1);
ret_int=1-K1c*theta1/((K1c*theta1-1)*exp(-Pem)+1);
retention=1-((1-ret_int)*kc1s)/(Jv*(1-ret_int)+kc1s-Jv);
end

function [residuals] = PoreSizeDistributionImperfectionsFit(x,param)
%parameters
Jv = param(1:96);
r_62 = param(97:108);
r_106 = param(109:120);
r_200 = param(121:132);
r_400 = param(133:144);
r_600 = param(145:156);
r_1000 = param(157:168);
r_2000 = param(169:180);
r_3000 = param(181:192);
Cf = param(193:200);
vm = param(201);
L = param(202);
d = param(203);
Ri = param(204);
maxIter = param(205);
n = param(206);
relax = param(207);
residual = param(208);
D_inf = param(209:216);
rS1 = param(217);
rS2 = param(218); 
rS3 = param(219);
rS4 = param(220);
rS5 = param(221);
rS6 = param(222);
rS7 = param(223);
rS8 = param(224);
rho = param(225);
eta = param(226);
F = param(227);
Rg = param(228);
T = param(229);
Pw_P = param(230:241);
Pw_F = param(242:253);

%variables
rmean = x(1)*10^(-10);
std = x(2)*10^(-11);
dxen = x(3)*10^(-25);
f = x(4);
dxecor = x(5)*10^(-6);

Jv=Jv*(1-f);

emptycnt=1;

rS = [rS1 rS2 rS3 rS4 rS5 rS6 rS7 rS8];
Cf1 = Cf(1);
Cf2 = Cf(2);
Cf3 = Cf(3);
Cf4 = Cf(4);
Cf5 = Cf(5);
Cf6 = Cf(6);
Cf7 = Cf(7);
Cf8 = Cf(8);

b = log(1+(std/rmean)^2); %log distribution

deltar = 1E-11; %discretization size [m]  1E-11
maxr = 10E-9; %upper limit [m]

rDist=deltar:deltar:maxr; %radius range [m]
for i=1:1:maxr/deltar %discrete function
Fr(i) = integral(@(r) 1./(r*(2*pi()*b).^0.5).*exp(-(log(r./rmean)+b/2).^2/2/b),deltar*(i)-deltar/2,deltar*(i)+deltar/2); %relative ammount
end

Jvr=Fr.*rDist.^4; %flux as function of radius *dPeff /dxen/8/eta*pi()
RelFr=Jvr./sum(Jvr);

%truncation
maxf=max(RelFr);
minf=maxf*0.05; %5% of maximum value cut off

minc=1;
maxc=1.1;
for i=1:1:size(rDist,2)
if RelFr(i)>=minf && minc<maxc
    minc=i;
end
if RelFr(i)<minf && minc>maxc
    maxc=i;
    break;
end
end

if maxc==1.1
   maxc=length(RelFr); 
end

maxval=0;
maxrn=0;
for i=1:1:size(rDist,2)
    if RelFr(i)>maxval
        maxval=RelFr(i);
        maxrn=i;
    end
end
rmaxflux=rDist(maxrn);

rDist=rDist(minc:maxc);
Fr=Fr(minc:maxc);

scale=sum(Fr); %normalize distribution to sumfR=1
Fr=Fr./scale; 

if isempty(Fr)
    disp("empty distribution.");
end

%updated thickness
K1=sum(pi()*rDist.^4.*Fr)/dxen;
PWP=K1*1000*60*60*10^5/8/eta;

Jtest=Jv;
for j=1:1:size(Jtest,2)
    
if isnan(Jtest(j))
    Jtest(j)=Jtest(j+1);
    empty(emptycnt)=j;
    emptycnt=emptycnt+1;
end 
%flux as function of r
dPeff=Jtest(j)*8*eta/K1;
Jvr=Fr.*pi().*rDist.^4.*dPeff/8/eta/dxen;

%retention as function of r
if j>0
Comp=1;
end
if j>12
Comp=2;
end
if j>24
Comp=3;
end
if j>36
Comp=4;
end
if j>48
Comp=5;
end
if j>60
Comp=6;
end
if j>72
Comp=7;
end
if j>84
Comp=8;
end

par=[Cf1 Cf2 Cf3 Cf4 Cf5 Cf6 Cf7 Cf8 K1 vm L d Ri maxIter dxen n relax residual D_inf rS rho eta F Rg T Comp];

%retention as function of r
for i=1:1:size(Fr,2)
Ret(i)=PoreSizeDistributionPlotSingle([Jtest(j) rDist(i) Fr(i)],par);
end
%overal retention
Reto(Comp,j)=sum(Ret.*Jvr)/Jtest(j);
end

ret_62=Reto(1,1:12);
ret_106=Reto(2,13:24);
ret_200=Reto(3,25:36);
ret_400=Reto(4,37:48);
ret_600=Reto(5,49:60);
ret_1000=Reto(6,61:72);
ret_2000=Reto(7,73:84);
ret_3000=Reto(8,85:96);

c_p1=(1-ret_62)*Cf(1);
c_p2=(1-ret_106)*Cf(2);
c_p3=(1-ret_200)*Cf(3);
c_p4=(1-ret_400)*Cf(4);
c_p5=(1-ret_600)*Cf(5);
c_p6=(1-ret_1000)*Cf(6);
c_p7=(1-ret_2000)*Cf(7);
c_p8=(1-ret_3000)*Cf(8);

%film model to get surface concentration
Re0=rho*2*Ri*vm/eta; %inlet Reynolds number [-]
Sc1=eta/rho/D_inf(1); %inlet Schmidt number [-]
Sh1=1.62*Re0^(1/3)*Sc1^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc1^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc1=Sh1/(2*Ri/D_inf(1)); 
phi1=Jv(1:12)/kc1;
suc1=phi1+(1+0.26*phi1.^(1.4)).^(-1.7);
kc1s=kc1*suc1;
Sc2=eta/rho/D_inf(2); %inlet Schmidt number [-]
Sh2=1.62*Re0^(1/3)*Sc2^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc2^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc2=Sh2/(2*Ri/D_inf(2)); 
phi2=Jv(13:24)/kc2;
suc2=phi2+(1+0.26*phi2.^(1.4)).^(-1.7);
kc2s=kc2*suc2;
Sc3=eta/rho/D_inf(3); %inlet Schmidt number [-]
Sh3=1.62*Re0^(1/3)*Sc3^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc3^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc3=Sh3/(2*Ri/D_inf(3)); 
phi3=Jv(25:36)/kc3;
suc3=phi3+(1+0.26*phi3.^(1.4)).^(-1.7);
kc3s=kc3*suc3;
Sc4=eta/rho/D_inf(4); %inlet Schmidt number [-]
Sh4=1.62*Re0^(1/3)*Sc4^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc4^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc4=Sh4/(2*Ri/D_inf(4)); 
phi4=Jv(37:48)/kc4;
suc4=phi4+(1+0.26*phi4.^(1.4)).^(-1.7);
kc4s=kc4*suc4;
Sc5=eta/rho/D_inf(5); %inlet Schmidt number [-]
Sh5=1.62*Re0^(1/3)*Sc5^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc5^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc5=Sh5/(2*Ri/D_inf(5)); 
phi5=Jv(49:60)/kc5;
suc5=phi5+(1+0.26*phi5.^(1.4)).^(-1.7);
kc5s=kc5*suc5;
Sc6=eta/rho/D_inf(6); %inlet Schmidt number [-]
Sh6=1.62*Re0^(1/3)*Sc6^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc6^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc6=Sh6/(2*Ri/D_inf(6)); 
phi6=Jv(61:72)/kc6;
suc6=phi6+(1+0.26*phi6.^(1.4)).^(-1.7);
kc6s=kc6*suc6;
Sc7=eta/rho/D_inf(7); %inlet Schmidt number [-]
Sh7=1.62*Re0^(1/3)*Sc7^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc7^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc7=Sh7/(2*Ri/D_inf(7)); 
phi7=Jv(73:84)/kc7;
suc7=phi7+(1+0.26*phi7.^(1.4)).^(-1.7);
kc7s=kc7*suc7;
Sc8=eta/rho/D_inf(8); %inlet Schmidt number [-]
Sh8=1.62*Re0^(1/3)*Sc8^(1/3)*(Ri*2/L)^(1/3)-1.2-0.28*Re0^(-1/3)*Sc8^(-1/3)*(Ri*2/L)^(-1/3); %inlet Sherwood number according to Newman [-]
kc8=Sh8/(2*Ri/D_inf(8)); 
phi8=Jv(85:96)/kc8;
suc8=phi8+(1+0.26*phi8.^(1.4)).^(-1.7);
kc8s=kc8*suc8;

C62M=(c_p1.*Jv(1:12)-Cf(1)*kc1s)./(Jv(1:12)-kc1s);
C106M=(c_p2.*Jv(13:24)-Cf(2)*kc2s)./(Jv(13:24)-kc2s);
C200M=(c_p3.*Jv(25:36)-Cf(3)*kc3s)./(Jv(25:36)-kc3s);
C400M=(c_p4.*Jv(37:48)-Cf(4)*kc4s)./(Jv(37:48)-kc4s);
C600M=(c_p5.*Jv(49:60)-Cf(5)*kc5s)./(Jv(49:60)-kc5s);
C1000M=(c_p6.*Jv(61:72)-Cf(6)*kc6s)./(Jv(61:72)-kc6s);
C2000M=(c_p7.*Jv(73:84)-Cf(7)*kc7s)./(Jv(73:84)-kc7s);
C3000M=(c_p8.*Jv(85:96)-Cf(8)*kc8s)./(Jv(85:96)-kc8s);

ret_62=1-(c_p1*(1-f)+C62M*f)./Cf(1);
ret_106=1-(c_p2*(1-f)+C106M*f)./Cf(2);
ret_200=1-(c_p3*(1-f)+C200M*f)./Cf(3);
ret_400=1-(c_p4*(1-f)+C400M*f)./Cf(4);
ret_600=1-(c_p5*(1-f)+C600M*f)./Cf(5);
ret_1000=1-(c_p6*(1-f)+C1000M*f)./Cf(6);
ret_2000=1-(c_p7*(1-f)+C2000M*f)./Cf(7);
ret_3000=1-(c_p8*(1-f)+C3000M*f)./Cf(8);

n_PEG=size(r_62,2)+size(r_106,2)+size(r_200,2)+size(r_400,2)+size(r_600,2)+size(r_1000,2)+size(r_2000,2)+size(r_3000,2)-emptycnt+1;
n_PWP=size(Pw_F,2);
residualso=[(r_62-ret_62)/n_PEG/(0.01) (r_106-ret_106)/n_PEG/(0.01) (r_200-ret_200)/n_PEG/(0.01) (r_400-ret_400)/n_PEG/(0.01) (r_600-ret_600)/n_PEG/(0.01) (r_1000-ret_1000)/n_PEG/(0.01) (r_2000-ret_2000)/n_PEG/(0.01) (r_3000-ret_3000)/n_PEG/(0.01) (Pw_F-PWP.*Pw_P)/n_PWP./(0.05*Pw_F) (rmaxflux^2/K1-dxecor)*10^6];
counter=1;
numbernan=1;
for i=1:1:size(residualso,2)
    if emptycnt==1
        residuals=residualso;
        break;
    end
    if i==empty(numbernan)
    numbernan=numbernan+1;
        if numbernan>emptycnt-1
            numbernan=emptycnt-1;
        end
    else
    residuals(counter)=residualso(i);
    counter=counter+1;
    end
end
end