function [Vars, max_norm] = SolveMechanics(n, elmat, EssBnd, HorzBnd, ...
    VertBnd, p, Vars_tdt, Vars_t, P, Mass_tdt, Mass_t, dt)

x = p(1,:); y = p(2,:);

v1 = Vars_tdt(:,5);
v2 = Vars_tdt(:,6);
e11 = Vars_tdt(:,7);
e12 = Vars_tdt(:,8);
e22 = Vars_tdt(:,9);

v1_t = Vars_t(:,1);
v2_t = Vars_t(:,2);
e11_t = Vars_t(:,3);
e12_t = Vars_t(:,4);
e22_t = Vars_t(:,5);

N = Vars_tdt(:,1);
M = Vars_tdt(:,2);
C = Vars_tdt(:,3);
R = Vars_tdt(:,4);

% Create Mass matrices for the displacement velocity
Mv_t = P(20)*Mass_t;
Mv_tdt = P(20)*Mass_tdt;

% Allocate memory for matrices
Sv1v1 = sparse(n,n);
Sv1v2 = sparse(n,n);
Sv1e11 = sparse(n,n);
Sv1e12 = sparse(n,n);
Sv1e22 = sparse(n,n);

Sv2v1 = sparse(n,n);
Sv2v2 = sparse(n,n);
Sv2e11 = sparse(n,n);
Sv2e12 = sparse(n,n);
Sv2e22 = sparse(n,n);

Se11v1 = sparse(n,n);
Se11v2 = sparse(n,n);
Se11e11 = sparse(n,n);

Se12v1 = sparse(n,n);
Se12v2 = sparse(n,n);

Se22v1 = sparse(n,n);
Se22v2 = sparse(n,n);

Fv1 = sparse(n,1);
Fv2 = sparse(n,1);

parfor k = 1:5
    if k == 1
        [S1, S2, S3, S4] = Assemble_Svv(n, elmat, x, y, P);
        Sv1v1 = Sv1v1 + S1;
        Sv1v2 = Sv1v2 + S2;
        Sv2v1 = Sv2v1 + S3;
        Sv2v2 = Sv2v2 + S4;
    elseif k == 2
        [S1, S2, S3, S4, S5, S6] = Assemble_Sve(n, elmat, x, y, P, R);
        Sv1e11 = Sv1e11 + S1;
        Sv1e12 = Sv1e12 + S2;
        Sv1e22 = Sv1e22 + S3;
        Sv2e11 = Sv2e11 + S4;
        Sv2e12 = Sv2e12 + S5;
        Sv2e22 = Sv2e22 + S6;
    elseif k == 3
        [S1, S2, S3, S4, S5, S6] = Assemble_Sev(n, elmat, x, y, e11, e12, e22);
        Se11v1 = Se11v1 + S1;
        Se11v2 = Se11v2 + S2;
        Se12v1 = Se12v1 + S3;
        Se12v2 = Se12v2 + S4;
        Se22v1 = Se22v1 + S5;
        Se22v2 = Se22v2 + S6;
    elseif k == 4
        S1 = Assemble_See(n, elmat, x, y, N, M, C, P);
        Se11e11 = Se11e11 + S1;        
    elseif k == 5
        [F1, F2] = Assemble_Fv(n, elmat, x, y, P, M, R);
        Fv1 = Fv1 + F1;
        Fv2 = Fv2 + F2;
    end
end

Ssparse = sparse(n,n);

% Create system of matrices and vectors
A = [Sv1v1,  Sv1v2,  Sv1e11,  Sv1e12,  Sv1e22;...
     Sv2v1,  Sv2v2,  Sv2e11,  Sv2e12,  Sv2e22;...
     Se11v1, Se11v2, Se11e11, Ssparse, Ssparse;...
     Se12v1, Se12v2, Ssparse, Se11e11, Ssparse;...
     Se22v1, Se22v2, Ssparse, Ssparse, Se11e11];
 
F = [Fv1; Fv2; zeros(3*n,1)];

A = A*dt; F = F*dt;
A(1:n,1:n) = Mv_tdt + A(1:n,1:n);
A(n+1:2*n,n+1:2*n) = Mv_tdt + A(n+1:2*n,n+1:2*n);
A(2*n+1:3*n,2*n+1:3*n) = Mass_tdt + A(2*n+1:3*n,2*n+1:3*n);
A(3*n+1:4*n,3*n+1:4*n) = Mass_tdt + A(3*n+1:4*n,3*n+1:4*n);
A(4*n+1:5*n,4*n+1:5*n) = Mass_tdt + A(4*n+1:5*n,4*n+1:5*n);
F(1:n) = Mv_t*v1_t + F(1:n);
F(n+1:2*n) = Mv_t*v2_t + F(n+1:2*n);
F(2*n+1:3*n) = Mass_t*e11_t;
F(3*n+1:4*n) = Mass_t*e12_t;
F(4*n+1:5*n) = Mass_t*e22_t;

% Process boundary conditions
[A,F] = ProcessBC(A, F, EssBnd, HorzBnd, VertBnd, n);

% Solve for mechanics
All = A\F;

% Substitute solutions back into vectors
v1_1 = All(1:n);
v2_1 = All(n+1:2*n); 
e11_1 = All(2*n+1:3*n);
e12_1 = All(3*n+1:4*n);
e22_1 = All(4*n+1:5*n);

norm_v1 = norm(abs(v1_1-v1)/(abs(v1_1)+1e-20),1);
norm_v2 = norm(abs(v2_1-v2)/(abs(v2_1)+1e-20),1);
norm_e11 = norm(abs(e11_1-e11)/(abs(e11_1)+1e-20),1);
norm_e12 = norm(abs(e12_1-e12)/(abs(e12_1)+1e-20),1);
norm_e22 = norm(abs(e22_1-e22)/(abs(e22_1)+1e-20),1);
max_norm = max([norm_v1, norm_v2, norm_e11, norm_e12, norm_e22]);

Vars = [v1_1, v2_1, e11_1, e12_1, e22_1];
end