function [S, f] = ProcessBC(S, f, ess, hor, ver, n)

% On the essential boundaries, vx = 0 and vy = 0 
% On the vertical symmetry boundary, vx = 0, e12 = 0
% On the horizontal symmetry boundary, vy = 0, e12 = 0

%% The essential boundaries: v1 and v2
for k = 1:length(ess)
    S(:,ess(k)) = 0;
    S(ess(k),:) = 0;
    S(ess(k),ess(k)) = 1;
    f(ess(k)) = 0;

    S(:,n+ess(k)) = 0;
    S(n+ess(k),:) = 0;
    S(n+ess(k),n+ess(k)) = 1;
    f(n+ess(k)) = 0;
end
    
%% The vertical boundary: v1 and e12
for k = 1:length(ver)
    S(:,ver(k)) = 0;
    S(ver(k),:) = 0;
    S(ver(k),ver(k)) = 1;
    f(ver(k)) = 0;

    S(:,3*n+ver(k)) = 0;
    S(3*n+ver(k),:) = 0;
    S(3*n+ver(k),3*n+ver(k)) = 1;
    f(3*n+ver(k)) = 0;
end

%% The horizontal boundary: v2 and e12
for k = 1:length(hor)
    S(:,n+hor(k)) = 0;
    S(n+hor(k),:) = 0;
    S(n+hor(k),n+hor(k)) = 1;
    f(n+hor(k)) = 0;

    S(:,3*n+hor(k)) = 0;
    S(3*n+hor(k),:) = 0;
    S(3*n+hor(k),3*n+hor(k)) = 1;
    f(3*n+hor(k)) = 0;
end
end