function [S1, S2, S3, S4, S5, S6] = Assemble_Sve(n, elmat, x, y, P, R)
S1 = zeros(n,n); S2=S1; S3=S1; S4=S1; S5=S1; S6=S1;
for i = 1:size(elmat,1)
    a = elmat(i,:);
    [Delta,b,c] = D(x,y,a);
    
    p_vec = sqrt(R(a));
    E = P(23); nu = P(24);    
    RCx = Delta/6*b'.*p_vec';
    RCy = Delta/6*c'.*p_vec';
    
    S1(a,a) = S1(a,a) + E/(1+nu)*(1-nu)/(1-2*nu)*RCx; %v1e11
    S2(a,a) = S2(a,a) + E/(1+nu)*RCy; %v1e12
    S3(a,a) = S3(a,a) + E/(1+nu)*nu/(1-2*nu)*RCx; %v1e22
    S4(a,a) = S4(a,a) + E/(1+nu)*nu/(1-2*nu)*RCy; %v2e11
    S5(a,a) = S5(a,a) + E/(1+nu)*RCx; %v2e12
    S6(a,a) = S6(a,a) + E/(1+nu)*(1-nu)/(1-2*nu)*RCy; %v2e22
end
S1 = sparse(S1);
S2 = sparse(S2);
S3 = sparse(S3);
S4 = sparse(S4);
S5 = sparse(S5);
S6 = sparse(S6);
end