function [F1,F2] = Assemble_Fv(n, elmat, x, y, P, M, R)
F1 = zeros(n,1); F2 = F1;
for i = 1:length(elmat(:,1))
    a = elmat(i,:);
	[Delta,b,c] = D(x,y,a);
    
    f1 = @(x) R(x)./(P(26)^2 + R(x).^2);
    f2 = @(x) M(x).*(P(26)^2 - R(x).^2)./((P(26)^2 + R(x).^2).^2);

    dMdx = sum(M(a).*b');
    dRdx = sum(R(a).*b');
    dMdy = sum(M(a).*c');
    dRdy = sum(R(a).*c');

    F1(a) = F1(a) + Delta/6*P(25)*(f1(a)*dMdx + f2(a)*dRdx);
    F2(a) = F2(a) + Delta/6*P(25)*(f1(a)*dMdy + f2(a)*dRdy);    
end
end