function Mass = Mass(n, elmat, p, Ind)
%Computes the lumped mass matrix.
Mass = zeros(n,n);

x = p(1,:); y = p(2,:);
xc = x(elmat); yc = y(elmat);
Delta = xc(:,2).*yc(:,3) - xc(:,3).*yc(:,2)...
      + xc(:,3).*yc(:,1) - xc(:,1).*yc(:,3)...
      + xc(:,1).*yc(:,2) - xc(:,2).*yc(:,1);

for i = 1:size(elmat,1)
    Mass(Ind(i,:)) = Mass(Ind(i,:)) + Delta(i);
end
Mass = sparse(Mass/6);
