function R1 = Solve_R(n, elmat, p, N, M, C, R, P, Mass_tdt, Mass_t, dt, R_t)
[S,f] = Assemble_R(n, elmat, p(1,:), p(2,:), N, M, C, R, P);
R1 = (Mass_tdt + S*dt)\(Mass_t*R_t + f*dt);
end

function [S,f] = Assemble_R(n, elmat, x, y, N, M, C, R, P)
S = zeros(n,n); f = zeros(n,1);
for i = 1:size(elmat,1)    
    a = elmat(i,:);
    [Delta,~,~] = D(x,y,a);    
    S(a,a) = S(a,a) + Delta/6*P(19)*(N(a) + P(15)*M(a)).*R(a)./...
        (1 + P(16)*C(a)).*eye(3);
    f(a) = f(a) + Delta/6*(P(34)*(1 + P(17)*C(a)./(P(18) + C(a))).*(N(a) ...
        + P(12)*M(a)));
end
S = sparse(S);
f = sparse(f);
end