function N1 = Solve_N(n, EssBnd, elmatt, pp, p_half, N, M, C, P, Mass_tdt, Mass_t, ...
    N_t, M_t, C_t, dt)

S = Assemble_N(n, elmatt, pp(1,:), pp(2,:), N, M, C, P);

A = Mass_tdt + S*dt;
F = Mass_t*N_t;

[A,F] = Process_N(A, F, EssBnd, n, P);

N1 = A\F;

neg_nmbr1 = sum(N1<0);
if neg_nmbr1>0
    fprintf('FCT FB.\n');
    
    N_half = (N + N_t)/2;
    M_half = (M + M_t)/2;
    C_half = (C + C_t)/2;
    
    x_half = p_half(1,:); y_half = p_half(2,:);
    
    N1 = FCT(n, EssBnd, elmatt, pp(1,:), pp(2,:), x_half, y_half, N, N_half, ...
            M, M_half, C, C_half, [], [], P, Mass_t, Mass_tdt, dt, N_t, 1);
end
end

function S = Assemble_N(n, elmat, x, y, N, M, C, P)
S = zeros(n,n); f = @fFibro;
for i = 1:size(elmat,1)
    a = elmat(i,:);
    [Delta,b,c] = D(x,y,a);
    dcdx = sum(C(a).*b'); dcdy = sum(C(a).*c');    
    Selem = P(1)*sum(N(a) + M(a))*(b.*b' + c.*c') ...
        - P(2)*(b'*dcdx + c'*dcdy) ...
        - f(a,N,M,C,P).*eye(3) + P(8)*(eye(3)+ones(3,3))/4;
    S(a,a) = S(a,a) + Delta/6*Selem;
end
S = sparse(S);
end

function y = fFibro(a,N,M,C,P)
y = zeros(3,1); I = find(N(a)~=0);
y(I) = P(3)*(1 + P(4)*C(a(I))./(P(5) + C(a(I)))).*...
    (1 - P(6)*(N(a(I)) + M(a(I)))).*N(a(I)).^P(33) - P(7)*C(a(I));
end

function [S,f] = Process_N(S, f, EssBnd, n, P)
for i = 1:n
    for k = 1:length(EssBnd)
        f(i) = f(i) - S(i,EssBnd(k))*P(28);
    end
end
for k = 1:length(EssBnd)
    S(:,EssBnd(k)) = 0;
    S(EssBnd(k),:) = 0;
    S(EssBnd(k),EssBnd(k)) = 1;
    f(EssBnd(k)) = P(28);
end
end