function C1 = Solve_C(n, EssBnd, elmat, p, p_half, N, M, C, R, P, ...
    Mass_tdt, Mass_t, N_t, M_t, C_t, R_t, dt)

S = Assemble_C(n, elmat, p(1,:), p(2,:), N, M, C, R, P);

A = Mass_tdt + S*dt;
F = Mass_t*C_t;

[A,F] = Process_homogeneous(A,F,EssBnd);

C1 = A\F;

neg_nmbr3=sum(C1<0);
if neg_nmbr3>0
    fprintf('FCT C %d negative nodes --> ', neg_nmbr3);
    
    N_half = (N + N_t)/2;
    M_half = (M + M_t)/2;
    C_half = (C + C_t)/2;
    R_half = (R + R_t)/2;
    
    x_half = p_half(1,:); y_half = p_half(2,:);
    
    C1 = FCT(n, EssBnd, elmat, p(1,:), p(2,:), x_half, y_half, N, N_half, ...
    M, M_half, C, C_half, R, R_half, P, Mass_t, Mass_tdt, dt, C_t, 3);
end
end

function S = Assemble_C(n, elmat, x, y, N, M, C, R, P)
S = zeros(n,n);
for i = 1:size(elmat,1)    
    a = elmat(i,:);
    [Delta,b,c] = D(x,y,a);    
    f = P(11)*(N(a) + P(12)*M(a))./(P(13) + C(a)) - ...
        P(14)*(N(a) + P(15)*M(a)).*R(a)./(1 + P(16)*C(a));
    S(a,a) = S(a,a) + P(10)*Delta/2*(b.*b' + c.*c') - ...
        Delta/6*f.*eye(3);
end
S = sparse(S);
end
