function [S1, S2, S3, S4] = Assemble_Svv(n, elmat, x, y, P)
S1 = zeros(n,n); S2=S1; S3=S1; S4=S1;
for i = 1:size(elmat,1)
    a = elmat(i,:);
    [Delta,b,c] = D(x,y,a);
    
    mu1 = P(21); mu2 = P(22);

    Sxx = Delta/2*b'.*b;
    Syy = Delta/2*c'.*c;
    Sxy = Delta/2*b'.*c;
    Syx = Delta/2*c'.*b;
    
    Se1 = (mu1+mu2)*Sxx + mu1/2*Syy; %v1v1
    Se2 = mu2*Sxy + mu1/2*Syx; %v1v2
    Se3 = mu2*Syx + mu1/2*Sxy; %v2v1
    Se4 = (mu1+mu2)*Syy + mu1/2*Sxx; %v2v2
    
    S1(a,a) = S1(a,a) + Se1; %v1v1
    S2(a,a) = S2(a,a) + Se2; %v1v2
    S3(a,a) = S3(a,a) + Se3; %v2v1
    S4(a,a) = S4(a,a) + Se4; %v2v2
end
S1 = sparse(S1); S2 = sparse(S2); S3 = sparse(S3); S4 = sparse(S4);
end