function h = hburn(p, varargin)
%hburn. Depends on the distance to the boundary of the wound. 
%In case this distance is smaller or equal to s, then h=1, otherwise the
%function h increases linearly with the distance.

% Parameters
s = varargin{1}{3};
p_wbound = varargin{1}{2};

x1 = p_wbound(1:end-1,1);
y1 = p_wbound(1:end-1,2);
x2 = p_wbound(2:end,1);
y2 = p_wbound(2:end,2);
npw = length(x1);

u = x1 - x2;
v = y1 - y2;
w = sqrt(u.^2 + v.^2);

x = x1 - repmat(p(:,1)',npw,1); y = y1 - repmat(p(:,2)',npw,1);
u1 = sqrt(x.^2+y.^2);
theta1 = acosd((x.*u + y.*v)./(u1.*w));

x = x2 - repmat(p(:,1)',npw,1); y = y2 - repmat(p(:,2)',npw,1);
u2 = sqrt(x.^2 + y.^2);
u = -u; v = -v;
theta2 = acosd((x.*u + y.*v)./(u2.*w));
    
I1 = find(theta1>90); I3 = find(theta2>90);
I2 = find(double(theta1<=90).*double(theta2<=90));

D = zeros(npw,size(p,1));   
D(I1) = u1(I1); D(I3) = u2(I3);
D(I2) = sind(theta1(I2)).*u1(I2);

d = min(D,[],1);
d = d';

h = 4.5*(d-s) + 1;
h(d <= s) = 1;