%MESH
%This file contains the code to create a mesh for the given geometry (geo).
%It defines the boundary of the wound and refines the mesh around this
%boundary. The domain is fixed between 0 and 10 for X and Y in all the
%simulations.

bbox = [0,0; 10,10];
h0 = 0.08;
fd = @dsquare;
fh = @hburn;

a = 4;
s = 0.25;

if geo==1 %Diamond
    WoundBnd = [0,4;4,0];
    Pgon = polyshape([0 4 0],[0 0 4]);
    pfix = [0,0; 0,10; 10,10; 10,0; 0,4; 4,0];
    [p,elmat,~,~] = mesh(fd,fh,h0,bbox,pfix,{[],WoundBnd,s,geo});
    hold on
    plot([0,4],[4,0],'-','LineWidth',2);
    WoundBnd = [linspace(0,4,100)',flip(linspace(0,4,100))'];
elseif geo==2 %Square
    WoundBnd = [0,4;4,4;4,0];
    Pgon = polyshape([0 4 4 0],[0 0 4 4]);
    pfix = [0,0; 0,10; 10,10; 10,0; 0,4; 4,4; 4,0];
    [p,elmat,~,~] = mesh(fd,fh,h0,bbox,pfix,{[],WoundBnd,s,geo});
    hold on
    plot([0,4,4],[4,4,0],'-','LineWidth',2);
    WoundBnd = [linspace(0,4,100)',4*ones(100,1);...
        4*ones(100,1),flip(linspace(0,4,100))'];
    WoundBnd(101,:)=[];
% elseif geo==3 %Square with diagonal symmetry
%     WoundBnd = [0,4;4,4];
%     Pgon = polyshape([0 4 0],[0 4 4]);
%     pfix = [0,0; 0,10; 10,10];
%     [p,elmat,be,~] = mesh(fd,fh,h0,bbox,pfix,{[],WoundBnd,s,geo});
%     hold on
%     plot([0,4],[4,4],'-','LineWidth',2);
%     WoundBnd = {[linspace(0,4,100)',4*ones(100,1)]};
%     I = find((p(be(:,1),1) == p(be(:,1),2)).*(p(be(:,2),1) == p(be(:,2),2)));
%     DiagBnd = be(I,:);
% %     DiagBnd = find(p(:,1)==p(:,2));
end

p(abs(p)<0.01)=0; p(abs(p-10)<0.01)=10;

% Boundary nodes (cannot be used to assemble over boundaries!)
%Essential boundaries
EssBnd = unique([find(p(:,1)==10);find(p(:,2)==10)]);
%Vertical symmetrical boundary
VertBnd = find(p(:,1)==0);
%Horizontal symmetrical boundary
HorzBnd = find(p(:,2)==0);

n = size(p,1); p=p'; p_tdt=p; p_half=p;
p={p}; elmat={elmat};

T=365; dt=0.1; DT=[]; max_dt=0.5;
it=1; day=0; max_dt1=2; max_dt2=100;
Area_init=Pgon.area; RDA=1;

Quality=[]; Remeshing=[]; Remeshing_time=[];



