function alpha = FCT_alpha(f,M1_LO,Mass_t,dt,n)

% Allocate memory for alpha.
alpha = 0*full(f);

% Preliminary step.
[rInd_fct,cInd_fct] = find(f);
ind_fct = [rInd_fct,cInd_fct];
for i=1:size(ind_fct,1)
        if f(ind_fct(i,1),ind_fct(i,2))*(M1_LO(ind_fct(i,2))-...
                M1_LO(ind_fct(i,1))) > 0
            f(ind_fct(i,1),ind_fct(i,2)) = 0;
        end
end

% Step 1: computation of P vector.
Aux_fluxes = f-diag(diag(f));
Aux_plus = max(Aux_fluxes,0);
Aux_minus = min(Aux_fluxes,0);
P_plus = sum(Aux_plus,2); P_plus = full(P_plus);
P_minus = sum(Aux_minus,2); P_minus = full(P_minus);

% Step 2: computation of Q vector. 
Q_plus = zeros(n,1);
Q_minus = zeros(n,1);
for i=1:n
    Q_plus(i) = max(M1_LO - M1_LO(i));
    Q_minus(i)= min(M1_LO - M1_LO(i));
end

% Step 3: computation of R vector.
R_plus = min(1,diag(Mass_t).*Q_plus./(dt*P_plus));
R_plus = full(R_plus);
R_minus = min(1,diag(Mass_t).*Q_minus./(dt*P_minus));
R_minus = full(R_minus);
R_minus(P_minus==0) = 0;
R_plus(P_plus==0) = 0;

%Substituted by the following two modification steps
% for i=1:4*Nnodes
%     for j=1:4*Nnodes
%         if fct_fluxes(i,j)>0
%             alpha(i,j)=min(R_plus(i),R_minus(j));
%         else
%             alpha(i,j)=min(R_minus(i),R_plus(j));
%         end
%     end
% end

matR_plus = repmat(R_plus',length(R_plus),1); %rows of matrix are R+
matR_minus = repmat(R_minus,1,length(R_minus));%cols of matrix are R-

alpha = min(matR_plus,matR_minus);
[rIndPos_fct,cIndPos_fct] = find(f>0);
indPos_fct = [rIndPos_fct,cIndPos_fct];

for i=1:size(indPos_fct,1)
        alpha(indPos_fct(i,1),indPos_fct(i,2)) = ...
            min(R_plus(indPos_fct(i,1)),R_minus(indPos_fct(i,2)));
end