function Var = FCT(n, EssBnd, elmat, x, y, x_half, y_half, N, N_half, ...
    M, M_half, C, C_half, R, R_half, P, Mass_t, Mass_tdt, dt, Var_t, V)

if V==1
    S = -Assemble_N(n, elmat, x_half, y_half, N_half, M_half, C_half, P);
    [S,q] = Process_N(S, zeros(n,1), EssBnd, n, P);
elseif V==2
    [S,q] = Assemble_M(n, elmat, x_half, y_half, N_half, M_half, C_half, P);
    S = -S;
    [S,q] = Process_homogeneous(S, q, EssBnd);
elseif V==3
    S = -Assemble_C(n, elmat, x_half, y_half, N_half, M_half, C_half,...
        R_half, P);
    [S,~] = Process_homogeneous(S,[],EssBnd);
end

K_aux = min(S,0);
D = max(-K_aux, -K_aux');
D = D-diag(diag(D));
newdiag = -sum(D,2);
for i=1:length(newdiag)
    D(i,i) = newdiag(i);
end

L = S + D;
A = Mass_tdt -L*dt/2;
B = Mass_t + L*dt/2;

if V==1
    F = B*Var_t + dt*q;
    [A,F] = Process_N(A, F, EssBnd, n, P);
elseif V==2
    F = B*Var_t + dt*q;
elseif V==3
    F = B*Var_t;
end

% Low-order solution
Low_order_sol = A\F;

% Build matrices and vectors for the nodal derivatives approximation
if V==1
    S = -Assemble_N(n, elmat, x, y, N, M, C, P);
    [S,q] = Process_N(S, zeros(n,1), EssBnd, n, P);
elseif V==2
    [S,q] = Assemble_M(n, elmat, x, y, N, M, C, P);
    S = -S;
    [S,q] = Process_homogeneous(S, q, EssBnd);
elseif V==3
    S = -Assemble_C(n, elmat, x, y, N, M, C, R, P);
    [S,~] = Process_homogeneous(S,[],EssBnd);
end

% Artificial diffusion operator
K_aux = min(S,0);
D = max(-K_aux, -K_aux');
D = D-diag(diag(D));
newdiag = -sum(D,2);
for i=1:length(newdiag)
    D(i,i) = newdiag(i);
end

L = S + D;
if V==1
    F = L*Low_order_sol + q;
elseif V==2
    F = L*Low_order_sol + q;
elseif V==3
    F = L*Low_order_sol;
end

[~,F] = Process_homogeneous([],F,EssBnd);

% Time derivative solution with artificial diffusion
Deriv_sol = Mass_tdt\F;

% Antidiffusive flux terms
f = zeros(n,n);
[rInd_M, cInd_M] = find(Mass_tdt);
ind_M = [rInd_M, cInd_M];
[rInd_D, cInd_D] = find(D);
ind_D = [rInd_D, cInd_D];
ind = union(ind_M, ind_D, 'rows');
for i=1:size(ind,1)
    f(ind(i,1),ind(i,2)) = Mass_tdt(ind(i,1),ind(i,2))*...
        (Deriv_sol(ind(i,1)) - Deriv_sol(ind(i,2))) + ...
        D(ind(i,1),ind(i,2))*...
        (Low_order_sol(ind(i,1)) - Low_order_sol(ind(i,2)));
end
f = sparse(f);

% Alpha and f_bar
alpha = FCT_alpha(f, Low_order_sol, Mass_tdt, dt, n);
alpha = alpha - diag(diag(alpha));

f_bar = sum(alpha.*full(f), 2);

F = Mass_tdt*Low_order_sol + dt*f_bar;

% FCT solution
Var = Mass_tdt\F;
% neg_nmbr3=sum(Var<0);
% if V==2
%     fprintf('FCT M %d negative node(s).\n', neg_nmbr3);
% elseif V==3
%     fprintf('%d negative node(s).\n', neg_nmbr3);
% end
Var(Var<0)=0;
end

function S = Assemble_N(n, elmat, x, y, N, M, C, P)
S = zeros(n,n); f = @fFibro;
for i = 1:size(elmat,1)
    a = elmat(i,:);
    [Delta,b,c] = D(x,y,a);
    dcdx = sum(C(a).*b'); dcdy = sum(C(a).*c');    
    Selem = P(1)*sum(N(a) + M(a))*(b.*b' + c.*c') ...
        - P(2)*(b'*dcdx + c'*dcdy) ...
        - f(a,N,M,C,P).*eye(3) + P(8)*(eye(3)+ones(3,3))/4;
    S(a,a) = S(a,a) + Delta/6*Selem;
end
S = sparse(S);
end

% function y = fFibro(a,N,M,C,P)
% y = zeros(3,1); I = find(N(a)~=0);
% y(I) = P(3)*(1 + P(4)*C(a(I))./(P(5) + C(a(I)))).*...
%     (1 - P(6)*(N(a(I)) + M(a(I)))).*N(a(I)).^P(33) - P(7)*C(a(I));
% end

function y = fFibro(a,N,M,C,P)
y = zeros(3,1); I = find(N(a)~=0);
y(I) = P(35)*(1 + P(4)*C(a(I))./(P(5) + C(a(I)))).*...
    (1 - P(6)*(N(a(I)) + M(a(I)))).*N(a(I)).^P(33) - P(7)*C(a(I));
end

function [S,f] = Process_N(S, f, EssBnd, n, P)
for i = 1:n
    for k = 1:length(EssBnd)
        f(i) = f(i) - S(i,EssBnd(k))*P(28);
    end
end
for k = 1:length(EssBnd)
    S(:,EssBnd(k)) = 0;
    S(EssBnd(k),:) = 0;
    S(EssBnd(k),EssBnd(k)) = 1;
    f(EssBnd(k)) = P(28);
end
end

function [S,F] = Assemble_M(n, elmat, x, y, N, M, C, P)
S = zeros(n,n); F = zeros(n,1); f = @fMyo;
for i = 1:size(elmat, 1)    
    a = elmat(i,:);    
    [Delta,b,c] = D(x,y,a);          
    dcdx = sum(C(a).*b'); dcdy = sum(C(a).*c');           
    Selem = P(1)*sum(N(a) + M(a))*(b.*b' + c.*c') ...
        - P(2)*(b'*dcdx + c'*dcdy) ...
        - f(a,N,M,C,P).*eye(3) + P(9)*(eye(3)+ones(3,3))/4;        
    felem = P(7)*C(a).*N(a);    
    S(a,a) = S(a,a) + Delta/6*Selem;
    F(a) = F(a) + Delta/6*felem;
end
S = sparse(S);
F = sparse(F);
end

% function y = fMyo(a,N,M,C,P)
% y = zeros(3,1); I = find(M(a)~=0);
% y(I) = P(3)*((1 + P(4))*C(a(I))./(P(5) + C(a(I)))).*...
%     (1 - P(6)*(N(a(I)) + M(a(I)))).*M(a(I)).^P(33);
% y(y==Inf) = 0;
% end

function y = fMyo(a,N,M,C,P)
y = zeros(3,1); I = find(M(a)~=0);
y(I) = P(35)*((1 + P(4))*C(a(I))./(P(5) + C(a(I)))).*...
    (1 - P(6)*(N(a(I)) + M(a(I)))).*M(a(I)).^P(33);
y(y==Inf) = 0;
end

function S = Assemble_C(n, elmat, x, y, N, M, C, R, P)
S = zeros(n,n);
for i = 1:size(elmat,1)    
    a = elmat(i,:);
    [Delta,b,c] = D(x,y,a);    
    f = P(11)*(N(a) + P(12)*M(a))./(P(13) + C(a)) - ...
        P(14)*(N(a) + P(15)*M(a)).*R(a)./(1 + P(16)*C(a));
    S(a,a) = S(a,a) + P(10)*Delta/2*(b.*b' + c.*c') - ...
        Delta/6*f.*eye(3);
end
S = sparse(S);
end