function OUTPUT = TransmittingBoundary(...
                    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,SIDE,fTol,nDiv)
if nargin < 19, nDiv = 100; end
if nargin < 18, fTol = 1e-6; end
LEFT = 1; RIGHT = 2; LEFT_RIGHT = 3;
OUTPUT = [];
if SIDE ~= LEFT && SIDE ~= RIGHT && SIDE ~= LEFT_RIGHT
    fprintf(1, 'ERROR: input SIDE must be 1 (LEFT), 2 (RIGHT) or 3 (LEFT and RIGHT).\n');
    return;
end
%% Check inputs
if real(Ku) == inf, Ku = real(Ku); end
if real(Kuh) == inf, Kuh = real(Kuh); end
if Knlat(1) == inf
    Nlat = 0; Knlat = inf; Kslat = inf; Mlat = inf;
end
if length(Mlat)~=length(Knlat) || length(Mlat)~=length(Kslat) || length(Mlat)~=length(Nlat)
    fprintf(1, 'ERROR: lattice inputs must have all the same dimensions (except for Dlat)');
    return;
end
%% Calculate stiffness matrix of one row columns of the lattice
nDepth = sum(Nlat)+1;
nMass = 2*nDepth;
nDof = 2*nMass;
Kcolumn = zeros(nDof,nDof);
kDepth = 0;
for iLayer = 1: 1: length(Nlat)
    Kn = Knlat(iLayer);
    Ks = Kslat(iLayer);
    Kd = (Kn-Ks)/2;
    for iN = 1: 1: Nlat(iLayer)
        ai1Nodes = kDepth + [1;2;nDepth+1;nDepth+2];
        ai1Dofs = sort([2*ai1Nodes-1;2*ai1Nodes],'ascend');
        Kcolumn(ai1Dofs,ai1Dofs) = Kcolumn(ai1Dofs,ai1Dofs) + ...
            0.5*Kn*[ 1  0  0  0 -1  0  0  0]'*[ 1  0  0  0 -1  0  0  0] + ...
            0.5*Ks*[ 0  1  0  0  0 -1  0  0]'*[ 0  1  0  0  0 -1  0  0] + ...
            0.5*Kn*[ 0  0  1  0  0  0 -1  0]'*[ 0  0  1  0  0  0 -1  0] + ...
            0.5*Ks*[ 0  0  0  1  0  0  0 -1]'*[ 0  0  0  1  0  0  0 -1] + ...
            0.5*Kd*[ 1 -1  0  0  0  0 -1  1]'*[ 1 -1  0  0  0  0 -1  1] + ...
            0.5*Kd*[ 0  0  1  1 -1 -1  0  0]'*[ 0  0  1  1 -1 -1  0  0];
        kDepth = kDepth + 1;
    end
end
%% Calculate response due to point loads
EPS = 100*eps;
XlR = [-(N-1)/2-1-EPS -(N-1)/2+EPS]*Dlat;
IlL = [-1 0];
XoR = [-(N-1)/2-1+EPS -(N-1)/2-EPS]*Dlat;
IoL = [-1 0];
LoS = [];

OUTPUT_PL = CalculateFrequencyDomainResponse_FL_Quad(...
        EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,XlR,IlL,XoR,IoL,LoS,fTol,nDiv);
Ulattice = OUTPUT_PL.Ulattice;
Ulattice = permute(Ulattice,[1 3 2]); % [ux,z_DEPTH][LOAD][COLUMN]
Urail = OUTPUT_PL.Urail; % [u,t_POS][LOAD]
Srail = OUTPUT_PL.Srail; % [V,M_POS][LOAD]
LOAD = OUTPUT_PL.LOAD; % [RAIL][Xload][DIR_LOAD] or [RAIL][Xload][DEPTH_LOAD][DIR_LOAD]
RAIL = OUTPUT_PL.RAIL;
SLEEPER = OUTPUT_PL.SLEEPER; 
LATTICE = OUTPUT_PL.LATTICE;
XX = OUTPUT_PL.XX;
ZZ = OUTPUT_PL.ZZ;
MM = OUTPUT_PL.MM;

for iSide = 1: 1: 2
    if iSide == 1
        kSide = RIGHT;
    else
        kSide = LEFT;
    end
    
    if kSide == RIGHT && SIDE == LEFT,  continue; end
    if kSide == LEFT  && SIDE == RIGHT, continue; end
    
    %% Calculate lattice forces at interface due 'to be removed' lattice
    if kSide == RIGHT
        uRail = Urail(1:2,:);
        sRail = Srail(1:2,:);
        Ulat = Ulattice(:,:,[1 2]);
        ForceBoundary = Kcolumn(1:end/2,:)*[Ulat(:,:,1); Ulat(:,:,2)];
    else
        uRail = Urail(3:4,:);
        sRail = Srail(3:4,:);
        Ulat = Ulattice(:,:,[2 1]);
        ForceBoundary = Kcolumn(end/2+1:end,:)*[Ulat(:,:,2); Ulat(:,:,1)];
        if real(Kuh) == inf
            Ulat = Ulat(2:1:end,:,:);
            ForceBoundary = ForceBoundary(2:1:end,:);
        end
    end
    
    %% Find Order of loads
    nDepth = sum(Nlat);
    if length(Nlat)>1 && Nlat(end) == 0
        % Add last interface (elastically supoprted)
        nDepth = nDepth + 1;
    else
        % Remove last interface from forces at boundary (rigid support)
        ForceBoundary = ForceBoundary(1:end-2,:);
        Ulat = Ulat(1:end-2,:,:);
    end
    if kSide == RIGHT
        LOAD_INTERFACE = [find((LOAD(:,1)==RAIL).*(LOAD(:,2)==XlR(1)).*(LOAD(:,3)==ZZ));
                          find((LOAD(:,1)==RAIL).*(LOAD(:,2)==XlR(1)).*(LOAD(:,3)==MM))];
        LOAD_FICTITIOUS = [find((LOAD(:,1)==RAIL).*(LOAD(:,2)==XlR(2)).*(LOAD(:,3)==ZZ));
                           find((LOAD(:,1)==RAIL).*(LOAD(:,2)==XlR(2)).*(LOAD(:,3)==MM))];
        for iDepth = 1: 1: nDepth
            LOAD_INTERFACE = [LOAD_INTERFACE;
                          find((LOAD(:,1)==LATTICE).*(LOAD(:,2)==IlL(1)).*(LOAD(:,4)==XX).*(LOAD(:,3)==iDepth-1));
                          find((LOAD(:,1)==LATTICE).*(LOAD(:,2)==IlL(1)).*(LOAD(:,4)==ZZ).*(LOAD(:,3)==iDepth-1))];
            LOAD_FICTITIOUS = [LOAD_FICTITIOUS;
                          find((LOAD(:,1)==LATTICE).*(LOAD(:,2)==IlL(2)).*(LOAD(:,4)==XX).*(LOAD(:,3)==iDepth-1));
                          find((LOAD(:,1)==LATTICE).*(LOAD(:,2)==IlL(2)).*(LOAD(:,4)==ZZ).*(LOAD(:,3)==iDepth-1))];
            if iDepth == 1 && real(Kuh) == inf
                LOAD_FICTITIOUS(end-1) = [];
            end
        end
    else
        LOAD_INTERFACE = [find((LOAD(:,1)==RAIL).*(LOAD(:,2)==XlR(2)).*(LOAD(:,3)==ZZ));
                          find((LOAD(:,1)==RAIL).*(LOAD(:,2)==XlR(2)).*(LOAD(:,3)==MM))];
        LOAD_FICTITIOUS = [find((LOAD(:,1)==RAIL).*(LOAD(:,2)==XlR(1)).*(LOAD(:,3)==ZZ));
                           find((LOAD(:,1)==RAIL).*(LOAD(:,2)==XlR(1)).*(LOAD(:,3)==MM))];
        for iDepth = 1: 1: nDepth
            LOAD_INTERFACE = [LOAD_INTERFACE;
                          find((LOAD(:,1)==LATTICE).*(LOAD(:,2)==IlL(2)).*(LOAD(:,4)==XX).*(LOAD(:,3)==iDepth-1));
                          find((LOAD(:,1)==LATTICE).*(LOAD(:,2)==IlL(2)).*(LOAD(:,4)==ZZ).*(LOAD(:,3)==iDepth-1))];
            LOAD_FICTITIOUS = [LOAD_FICTITIOUS;
                          find((LOAD(:,1)==LATTICE).*(LOAD(:,2)==IlL(1)).*(LOAD(:,4)==XX).*(LOAD(:,3)==iDepth-1));
                          find((LOAD(:,1)==LATTICE).*(LOAD(:,2)==IlL(1)).*(LOAD(:,4)==ZZ).*(LOAD(:,3)==iDepth-1))];
            if iDepth == 1 && real(Kuh) == inf
                LOAD_INTERFACE(end-1) = [];
            end
        end
    end
    %% Find amplitude of fictitious forces
    FictitiousForces = -[sRail(:,LOAD_FICTITIOUS);ForceBoundary(:,LOAD_FICTITIOUS)]\...
                        [sRail(:,LOAD_INTERFACE);ForceBoundary(:,LOAD_INTERFACE)];
    %% Calculate flexibility matrix
    Flex = [uRail(:,LOAD_INTERFACE); Ulat(:,LOAD_INTERFACE,1)] + ...
            [uRail(:,LOAD_FICTITIOUS); Ulat(:,LOAD_FICTITIOUS,1)] * FictitiousForces;
    %% Calculate stiffness matrix
    K = inv(Flex);
    if kSide == RIGHT
        OUTPUT.KRight = K;
        OUTPUT.FlexRight = Flex;
    else
        if real(Kuh) == inf
           K1 = K;
           K = zeros(size(K)+1);
           K([1:2 4:end],[1:2 4:end]) = K1;
           K(3,3) = inf;
           F1 = Flex;
           Flex = zeros(size(Flex)+1);
           Flex([1:2 4:end],[1:2 4:end]) = F1;
        end
        OUTPUT.KLeft = K;
        OUTPUT.FlexLeft = Flex;
    end
end
end