function W_K = TrackDispersion(Inputs,Ky, nMode)
clc
close all
%% Constants
VISCOUS = 1;
DampType = VISCOUS;
PLOT = 0;

%% Track properties
Track = Inputs.Track;
Track.EI;
Track.m;
DampEI = Track.DampRail;
EI = Track.EI; EI = EI*(1+1i*DampEI);
m = Track.m;
a = Track.a;
% Sleepers
Width = Track.Width;
Spacing = Track.Spacing;
Ms = Track.Ms;
Js = Track.Js;
% Rail pads
DampRP = Track.DampRP;
Kv = Track.Kv; Kv = Kv*(1+1i*DampRP);
Kt = Track.Kt; Kt = Kt*(1+1i*DampRP);
% Under sleeper pads
DampUSP = Track.DampUSP;
Ku = Track.Ku; Ku = Ku*(1+1i*DampUSP);
Kuh = Track.Kuh; Kuh = Kuh*(1+1i*DampUSP);

%% Ballast properties
Ballast = Inputs.Ballast;
Dampb = Ballast.Damp;
D = Ballast.D;
Hb = Ballast.H;
Rhob = Ballast.Rho;
Knb = Ballast.Kn*(1+1i*Dampb);
Ksb = Ballast.Ks*(1+1i*Dampb);
Kdb = Ballast.Kd*(1+1i*Dampb);
Mb  = Rhob*D^2*a;
Nb = round(Hb/D);
%% Foundation properties - ballast and soil - Left side
Soil = Inputs.Soil;
DampLeft = Soil.Left.Damp;
HLeft = Soil.Left.H;
RhoLeft = Soil.Left.Rho;
CsLeft = Soil.Left.Cs;
CpLeft = Soil.Left.Cp;
KvBotLeft = Soil.Left.KvBot;
KhBotLeft = Soil.Left.KhBot;
CvBotLeft = Soil.Left.CvBot;
ChBotLeft = Soil.Left.ChBot;
% Generate left lattice vectors
nLayerLeft = length(HLeft);
NLeft = zeros(nLayerLeft,1);
MLeft = zeros(nLayerLeft,1);
KnLeft = zeros(nLayerLeft,1);
KsLeft = zeros(nLayerLeft,1);
KdLeft = zeros(nLayerLeft,1);
for iLayer = 1: 1: nLayerLeft
    Cs = CsLeft(iLayer);
    Cp = CpLeft(iLayer);
    Rho = RhoLeft(iLayer);
    G = Cs^2*Rho;
    Lambda = Cp^2*Rho - 2*G;
    Mat = [1/2 -3/2; 1/2 1/2];
    B = Mat^-1*[Lambda;G];
    KnLeft(iLayer) = B(1);
    KsLeft(iLayer) = B(2);
    KdLeft(iLayer) = (KnLeft(iLayer) - KsLeft(iLayer)) / 2;
    MLeft(iLayer) = Rho*D^2;
    NLeft(iLayer) = round(HLeft(iLayer)/D);
end
KnLeft = KnLeft.*(1+1i*DampLeft);
KsLeft = KsLeft.*(1+1i*DampLeft);
KdLeft = KdLeft.*(1+1i*DampLeft);
% Add ballast layer
KnLeft = [Knb;KnLeft];
KsLeft = [Ksb;KsLeft];
KdLeft = [Kdb;KdLeft];
MLeft = [Mb;MLeft];
NLeft = [Nb;NLeft];
% Add bottom layer
if ~isempty(KvBotLeft)
    KnLeft = [KnLeft;(KvBotLeft+1i*CvBotLeft)*D];
    KsLeft = [KsLeft;(KhBotLeft+1i*ChBotLeft)*D];
    KdLeft = [KdLeft;0];
    MLeft = [MLeft;0];
    NLeft = [NLeft;0];
end

Knlat = KnLeft;
Kslat = KsLeft;
Kdlat = KdLeft;
Mlat = MLeft;
Nlat = NLeft;
%% Mid sections
MidSections = [3 1 0 0];

%% Geometrcal approximations
N = round(Width/D)+1;
M = round(Spacing/D); M = M - N;
Ku  = Ku/N;
Kuh = Kuh/N;
%% Inputs
if Kuh == inf, Kuh = 100*Ku; end

%% Assemble FEM matrices for mid section
nNodePerColLat = sum(Nlat(:,1)) + 1;
nNodePerCell = nNodePerColLat*(N+M) + 2*(N+M);
nNodeTotal = nNodePerCell * sum(MidSections(:,1));
NODE_TYPE = zeros(nNodeTotal,5); % [TYPE X Y Mass J]
RAIL = 1; SLEEPER = 2; BALLAST = 3; SOIL = 4; FIXED = 5;
ad2Connection = zeros(10000, 9); % [RAIL Node1 Node2 EI CEI m] or [SPRING Node1 Node2 Dofs1 Dofs2 K C]
kCon = 0;
BEAM = 1;
SPRING = 2;
kCell = 0;
knlatPrev = Knlat(:,1);
kslatPrev = Kslat(:,1);
kdlatPrev = (knlatPrev-kslatPrev)/2;
fprintf(1, '\n');
fprintf(1, 'Assembling element matrices for %d cells...\n', sum(MidSections(:,1)));
fprintf(1, '[0%%                                            100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
FIXED_BALLAST_NODES = [];
for iCell = 1: 1: size(MidSections,1)
    mlat = Mlat(:,1);
    knlat = Knlat(:,1);
    kslat = Kslat(:,1);
    kdlat = Kdlat(:,1);
    for jCell = 1: 1: MidSections(iCell,1)
        if mod(kCell+1,round(sum(MidSections(:,1)/50)))==0
            star = star + 1;
            if star <= 50 && STARS(star) == 0
                fprintf(1, '*');
                STARS(star) = 1;
            end
        end
        kNode_RR = kCell*nNodePerCell + 1;
        % Column by column assemble the elements
        SurfaceNodes = zeros(1,N+M);
        for iN = 0: 1: N+M-2
            if kCon + 1000 > size(ad2Connection,1)
                ad2Connection = [ad2Connection; zeros(10000,size(ad2Connection,2))];
            end
            %% Define rail nodes, ballast nodes and sleeper node
            kNode_RS = [];
            kNode_RL = kNode_RR;
            kNode_RM = kNode_RL + nNodePerColLat + 1;
            kNode_RR = kNode_RM + 1;
            kNode_BL = kNode_RL + 1;
            kNode_BR = kNode_RR + 1;
            if mod(N,2)==1 && iN == (N-1)/2
                kNode_RS = kNode_RL;
                kNode_S = kNode_RL + 1;
                kNode_RM = kNode_RM + 1;
                kNode_RR = kNode_RR + 1;
                kNode_BL = kNode_BL + 1;
                kNode_BR = kNode_BR + 1;
            elseif mod(N,2)==1 && iN == (N-1)/2-1
                kNode_BR = kNode_BR + 1;
            elseif mod(N,2)==0 && iN == N/2-1
                kNode_RS = kNode_RM;
                kNode_S = kNode_RM + 1;
                kNode_RR = kNode_RR + 1;
                kNode_BR = kNode_BR + 1;
            end
            if iN == 0
                kNode_RLS = kNode_RL;
                kNode_BLS = kNode_BL;
            end
            SurfaceNodes(iN+1) = kNode_BL;
            if iN == N+M-2, SurfaceNodes(iN+2) = kNode_BR; end
            NODE_TYPE([kNode_RL kNode_RM kNode_RR],1) = RAIL;
            NODE_TYPE([kNode_RL kNode_RM kNode_RR],2) = (kCell*(N+M)+iN-1+(1:0.5:2))*D;
            NODE_TYPE([kNode_RL kNode_RM kNode_RR],3) = N*D;
            NODE_TYPE([kNode_BL:(kNode_RM-1) kNode_BR:(kNode_BR+nNodePerColLat-1)],1) = BALLAST;
            NODE_TYPE(kNode_BL:(kNode_RM-1),2) = (kCell*(N+M)+iN)*D;
            NODE_TYPE(kNode_BL:(kNode_RM-1),3) = -(0:1:(nNodePerColLat-1))*D;
            NODE_TYPE(kNode_BR:(kNode_BR+nNodePerColLat-1),2) = (kCell*(N+M)+iN+1)*D;
            NODE_TYPE(kNode_BR:(kNode_BR+nNodePerColLat-1),3) = -(0:1:(nNodePerColLat-1))*D;
            if ~isempty(kNode_RS)
                NODE_TYPE(kNode_S,1) = SLEEPER;
                NODE_TYPE(kNode_S,2) = NODE_TYPE(kNode_RS,2);
                NODE_TYPE(kNode_S,3) = N*D/2;
                NODE_TYPE(kNode_S,4) = Ms;
                NODE_TYPE(kNode_S,5) = Js;
            end
                
            %% Assemble rails
            kCon = kCon + 1; ad2Connection(kCon,1:6) = [BEAM kNode_RL kNode_RM real(EI) imag(EI) m];
            kCon = kCon + 1; ad2Connection(kCon,1:6) = [BEAM kNode_RM kNode_RR real(EI) imag(EI) m];
            
            %% Assemble rail pads
            if ~isempty(kNode_RS)
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_RS kNode_S [1 0 -1  0] real(Kv) imag(Kv)];
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_RS kNode_S [0 1  0 -1] real(Kt) imag(Kt)];
            end
            
            %% Assemble ballast springs
            kDepth = 0;
            for iLayer = 1: 1: size(Nlat,1)
            for iDiv = 1: 1: Nlat(iLayer,1)
                % Add mass to the nodes
                NODE_TYPE([kNode_BL+kDepth+(0:1) kNode_BR+kDepth+(0:1)],4) = ...
                    NODE_TYPE([kNode_BL+kDepth+(0:1) kNode_BR+kDepth+(0:1)],4) + 0.25*mlat(iLayer);
                if iLayer > 1
                    NODE_TYPE([kNode_BL+kDepth+(0:1) kNode_BR+kDepth+(0:1)],1) = SOIL;
                end
                if iN == 0
                    NODE_TYPE(kNode_BL+kDepth+(0:1),4) = ...
                        NODE_TYPE(kNode_BL+kDepth+(0:1),4) + 0.25*mlat(iLayer);
                elseif iN == N+M-2
                    NODE_TYPE(kNode_BR+kDepth+(0:1),4) = ...
                        NODE_TYPE(kNode_BR+kDepth+(0:1),4) + 0.25*mlat(iLayer);
                end
                if isinf(real(knlat(iLayer))) || isinf(real(kslat(iLayer))) || isinf(real(kdlat(iLayer)))
                    FIXED_BALLAST_NODES = [FIXED_BALLAST_NODES;kNode_BL+kDepth+(0:1)';kNode_BR+kDepth+(0:1)'];
                end
                % Add springs Left
                if iN == 0
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth+(0:1) [0 1 0 -1] real(knlat(iLayer)) imag(knlat(iLayer))];
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth+(0:1) [1 0 -1 0] real(kslat(iLayer)) imag(kslat(iLayer))];
                else
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth+(0:1) [0 1 0 -1] 0.5*real(knlat(iLayer)) 0.5*imag(knlat(iLayer))];
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth+(0:1) [1 0 -1 0] 0.5*real(kslat(iLayer)) 0.5*imag(kslat(iLayer))];
                end
                % Add springs right
                if iN == N+M-2
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR+kDepth+(0:1) [0 1 0 -1] real(knlat(iLayer)) imag(knlat(iLayer))];
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR+kDepth+(0:1) [1 0 -1 0] real(kslat(iLayer)) imag(kslat(iLayer))];
                else
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR+kDepth+(0:1) [0 1 0 -1] 0.5*real(knlat(iLayer)) 0.5*imag(knlat(iLayer))];
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR+kDepth+(0:1) [1 0 -1 0] 0.5*real(kslat(iLayer)) 0.5*imag(kslat(iLayer))];
                end
                % Add top and bottom springs
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth kNode_BR+kDepth [1 0 -1 0] 0.5*real(knlat(iLayer)) 0.5*imag(knlat(iLayer))];
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth kNode_BR+kDepth [0 1 0 -1] 0.5*real(kslat(iLayer)) 0.5*imag(kslat(iLayer))];
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth+1 kNode_BR+kDepth+1 [1 0 -1 0] 0.5*real(knlat(iLayer)) 0.5*imag(knlat(iLayer))];
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth+1 kNode_BR+kDepth+1 [0 1 0 -1] 0.5*real(kslat(iLayer)) 0.5*imag(kslat(iLayer))];
                % Add diagonal springs
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth kNode_BR+kDepth+1 sqrt(2)/2*[-1 1 1 -1] real(kdlat(iLayer)) imag(kdlat(iLayer))];
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth+1 kNode_BR+kDepth sqrt(2)/2*[-1 -1 1 1] real(kdlat(iLayer)) imag(kdlat(iLayer))];
                kDepth = kDepth + 1;
            end
            if Nlat(iLayer,1) == 0
                if isinf(real(knlat(iLayer))) || isinf(real(kslat(iLayer))) || isinf(real(kdlat(iLayer)))
                    FIXED_BALLAST_NODES = [FIXED_BALLAST_NODES;kNode_BL+kDepth;kNode_BR+kDepth];
                end
                if iLayer > 1
                    NODE_TYPE([kNode_BL+kDepth;kNode_BR+kDepth],1) = SOIL;
                end
                % Add top and bottom springs
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth -1 [0 1 0 0] 0.5*real(knlat(iLayer)) 0.5*imag(knlat(iLayer))];
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth -1 [1 0 0 0] 0.5*real(kslat(iLayer)) 0.5*imag(kslat(iLayer))];
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR+kDepth -1 [0 1 0 0] 0.5*real(knlat(iLayer)) 0.5*imag(knlat(iLayer))];
                kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR+kDepth -1 [1 0 0 0] 0.5*real(kslat(iLayer)) 0.5*imag(kslat(iLayer))];
                if iN == 0
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth -1 [0 1 0 0] 0.5*real(knlat(iLayer)) 0.5*imag(knlat(iLayer))];
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BL+kDepth -1 [1 0 0 0] 0.5*real(kslat(iLayer)) 0.5*imag(kslat(iLayer))];
                elseif iN == N+M-2
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR+kDepth -1 [0 1 0 0] 0.5*real(knlat(iLayer)) 0.5*imag(knlat(iLayer))];
                    kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR+kDepth -1 [1 0 0 0] 0.5*real(kslat(iLayer)) 0.5*imag(kslat(iLayer))];
                end
            end
            end
        end
        % Add springs between sleeper and ballast
        SurfaceNodes = SurfaceNodes(1:N);
        for iNode = 1: 1: N
            kNode = SurfaceNodes(iNode);
            % Vertical connection
            dist = (-(N-1)/2+iNode-1)*D;
            kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode kNode_S [0 -1 1 dist] real(Ku) imag(Ku)];
            % Horizontal connection
            kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode -1 [1 0 0 0] real(Kuh) imag(Kuh)];
        end
        kCell = kCell + 1;
        if kCell == 1
            % save this
            knlatPrev = knlat;
            kslatPrev = kslat;
            kdlatPrev = kdlat;
            kNode_BR_Prev = kNode_BR;
            kNode_RR_Prev = kNode_RR;
            continue;
        end
        % Assemble connection with Previous cell
        kCon = kCon + 1; ad2Connection(kCon,1:6) = [BEAM kNode_RR_Prev kNode_RLS real(EI) imag(EI) m];
        kDepth = 0;
        for iLayer = 1: 1: size(Nlat,1)
        for iDiv = 1: 1: Nlat(iLayer,1)
            % Add top and bottom springs
            kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR_Prev+kDepth kNode_BLS+kDepth [1 0 -1 0] 0.5*real(knlat(iLayer)+knlatPrev(iLayer))/2 0.5*imag(knlat(iLayer)+knlatPrev(iLayer))/2];
            kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR_Prev+kDepth kNode_BLS+kDepth [0 1 0 -1] 0.5*real(kslat(iLayer)+kslatPrev(iLayer))/2 0.5*imag(kslat(iLayer)+kslatPrev(iLayer))/2];
            kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR_Prev+kDepth+1 kNode_BLS+kDepth+1 [1 0 -1 0] 0.5*real(knlat(iLayer)+knlatPrev(iLayer))/2 0.5*imag(knlat(iLayer)+knlatPrev(iLayer))/2];
            kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR_Prev+kDepth+1 kNode_BLS+kDepth+1 [0 1 0 -1] 0.5*real(kslat(iLayer)+kslatPrev(iLayer))/2 0.5*imag(kslat(iLayer)+kslatPrev(iLayer))/2];
            % Add diagonal springs
            kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR_Prev+kDepth kNode_BLS+kDepth+1 sqrt(2)/2*[-1 1 1 -1] real(kdlat(iLayer)+kdlatPrev(iLayer))/2 imag(kdlat(iLayer)+kdlatPrev(iLayer))/2];
            kCon = kCon + 1; ad2Connection(kCon,1:9) = [SPRING kNode_BR_Prev+kDepth+1 kNode_BLS+kDepth sqrt(2)/2*[-1 -1 1 1] real(kdlat(iLayer)+kdlatPrev(iLayer))/2 imag(kdlat(iLayer)+kdlatPrev(iLayer))/2];
            kDepth = kDepth + 1;
        end
        end
        
        % save this
        knlatPrev = knlat;
        kslatPrev = kslat;
        kdlatPrev = kdlat;
        kNode_BR_Prev = kNode_BR;
        kNode_RR_Prev = kNode_RR;
    end
end
FIXED_BALLAST_NODES = unique(sort(FIXED_BALLAST_NODES,'ascend'));
% %% Split the rail connections which are longer than D/2 into two,
% %  for coherence purposes
% nCon = kCon;
% for iCon = 1: 1: nCon
%     if ad2Connection(iCon,1) ~= BEAM, continue; end
%     Node1 = ad2Connection(iCon,2);
%     Node2 = ad2Connection(iCon,3);
%     dX = NODE_TYPE(Node2,2) - NODE_TYPE(Node1,2);
%     if abs(dX) < D/2*(1+1e-5), continue; end
%     NODE_TYPE = [NODE_TYPE(1:Node2-1,:); (NODE_TYPE(Node2,:)+NODE_TYPE(Node1,:))/2; NODE_TYPE(Node2:end,:)];
%     Node3 = Node2;
%     ad2Connection(ad2Connection(:,2)>=Node3,2) = ad2Connection(ad2Connection(:,2)>=Node3,2) + 1;
%     ad2Connection(ad2Connection(:,3)>=Node3,3) = ad2Connection(ad2Connection(:,3)>=Node3,3) + 1;
%     FIXED_BALLAST_NODES(FIXED_BALLAST_NODES>=Node3) = FIXED_BALLAST_NODES(FIXED_BALLAST_NODES>=Node3) + 1;
%     kCon = kCon + 1;  ad2Connection(kCon,1:6) = [BEAM Node3 Node3+1 real(EI) imag(EI) m];
%     ad2Connection(iCon,3) = Node3;
% end
ad2Connection = ad2Connection(1:kCon,:);
for iStar = star+1:1:50
    fprintf(1, '*');
end
fprintf(1, ']\n');
NODE_TYPE(FIXED_BALLAST_NODES,1) = FIXED;
%% Shift the x coordinate such that x=0 corresponds first Sleeper
SLEEPER_NODES = find(NODE_TYPE(:,1)==SLEEPER);
NODE_TYPE(:,2) = NODE_TYPE(:,2) - min(NODE_TYPE(SLEEPER_NODES,2));
ad2Connection = ad2Connection(1:kCon,:);

%% Plot modeled section
if PLOT
    figure; hold on
    plot(NODE_TYPE(NODE_TYPE(:,1)==BALLAST,2),NODE_TYPE(NODE_TYPE(:,1)==BALLAST,3),'ob');
    plot(NODE_TYPE(NODE_TYPE(:,1)==SOIL,2),NODE_TYPE(NODE_TYPE(:,1)==SOIL,3),'om');
    plot(NODE_TYPE(NODE_TYPE(:,1)==FIXED,2),NODE_TYPE(NODE_TYPE(:,1)==FIXED,3),'.k');
    plot(NODE_TYPE(NODE_TYPE(:,1)==SLEEPER,2),NODE_TYPE(NODE_TYPE(:,1)==SLEEPER,3),'or');
    plot(NODE_TYPE(NODE_TYPE(:,1)==RAIL,2),NODE_TYPE(NODE_TYPE(:,1)==RAIL,3),'ok');
    for iCon = 1: 1: size(ad2Connection,1)
        Nodes = ad2Connection(iCon,2:3);
        if Nodes(1) == -1, Nodes(1) = [];
        elseif Nodes(2) == -1, Nodes(2) = []; end
        if length(Nodes) == 1
            COLOR = 'vk';
            plot(NODE_TYPE(Nodes,2),NODE_TYPE(Nodes,3),COLOR);
        elseif ad2Connection(iCon,1) == SPRING
            COLOR = '.-g';
            if any(NODE_TYPE(Nodes)==SLEEPER) || any(NODE_TYPE(Nodes)==RAIL)
                plot(NODE_TYPE(Nodes,2),NODE_TYPE(Nodes,3),COLOR);
            end
        elseif ad2Connection(iCon,1) == BEAM
            COLOR = '.-r';
            plot(NODE_TYPE(Nodes,2),NODE_TYPE(Nodes,3),COLOR);
        end
    end
end
%% Assemble stuctural elements
nNode = size(NODE_TYPE,1);
nElem = size(ad2Connection,1);
nDof = 2*nNode;
ad2M = zeros(16*nElem,3); NZT_M = 0;
ad2K = zeros(16*nElem,3); NZT_K = 0;
ad2C = zeros(16*nElem,3); NZT_C = 0;
% Assemble lumped masses
for iNode = 1:1:nNode
    if NODE_TYPE(iNode,1) == RAIL, continue; end
    if NODE_TYPE(iNode,1) == SLEEPER
        ad2M(NZT_M+(1:2),:) = [NODE_TYPE(iNode,4) 2*iNode-1 2*iNode-1;
                               NODE_TYPE(iNode,5) 2*iNode-0 2*iNode-0];
        NZT_M = NZT_M + 2;
    end
    if NODE_TYPE(iNode,1) == BALLAST || NODE_TYPE(iNode,1) == SOIL
        ad2M(NZT_M+(1:2),:) = [NODE_TYPE(iNode,4) 2*iNode-1 2*iNode-1;
                               NODE_TYPE(iNode,4) 2*iNode-0 2*iNode-0];
        NZT_M = NZT_M + 2;
    end
end
% Assemble elastic elements - springs and beams
for iElem = 1: 1: nElem
    kNode1 = ad2Connection(iElem,2);
    kNode2 = ad2Connection(iElem,3);
    ROW = [2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2;
           2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2;
           2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2;
           2*kNode1-1; 2*kNode1; 2*kNode2-1; 2*kNode2];
    COL = [2*kNode1-1; 2*kNode1-1; 2*kNode1-1; 2*kNode1-1 ;
           2*kNode1  ; 2*kNode1  ; 2*kNode1  ; 2*kNode1   ;
           2*kNode2-1; 2*kNode2-1; 2*kNode2-1; 2*kNode2-1 ;
           2*kNode2  ; 2*kNode2  ; 2*kNode2  ; 2*kNode2  ];
    if ad2Connection(iElem,1) == BEAM
        EI = ad2Connection(iElem,4);
        CEI = ad2Connection(iElem,5);
        m = real(ad2Connection(iElem,6));
        l = NODE_TYPE(kNode2,2)-NODE_TYPE(kNode1,2);
        l2 = l*l;
        l3 = l2*l;
        
        Kelem = EI*[ 12/l3  6/l2  -12/l3  6/l2 ;
                      6/l2   4/l   -6/l2   2/l ;
                    -12/l3 -6/l2   12/l3 -6/l2 ;
                      6/l2   2/l   -6/l2   4/l ];
                  
        Celem =CEI*[ 12/l3  6/l2  -12/l3  6/l2 ;
                      6/l2   4/l   -6/l2   2/l ;
                    -12/l3 -6/l2   12/l3 -6/l2 ;
                      6/l2   2/l   -6/l2   4/l ];
                  
        Melem = m*l/420*[  156  22*l    54 -13*l ;
                          22*l  4*l2  13*l -3*l2 ;
                            54  13*l   156 -22*l ;
                         -13*l -3*l2 -22*l  4*l2];
        ad2K(NZT_K+(1:16),:) = [Kelem(:) ROW COL]; NZT_K = NZT_K + 16;
        ad2C(NZT_C+(1:16),:) = [Celem(:) ROW COL]; NZT_C = NZT_C + 16;
        ad2M(NZT_M+(1:16),:) = [Melem(:) ROW COL]; NZT_M = NZT_M + 16;
    elseif ad2Connection(iElem,1) == SPRING
        K = ad2Connection(iElem,8);
        C = ad2Connection(iElem,9);
        dofs = ad2Connection(iElem,4:7);
        if kNode1 == -1
            dofs = dofs(3:4);
            ROW = [2*kNode2-1; 2*kNode2;
                   2*kNode2-1; 2*kNode2];
            COL = [2*kNode2-1; 2*kNode2-1;
                   2*kNode2  ; 2*kNode2 ];
        elseif kNode2 == -1
            dofs = dofs(1:2);
            ROW = [2*kNode1-1; 2*kNode1;
                   2*kNode1-1; 2*kNode1];
            COL = [2*kNode1-1; 2*kNode1-1;
                   2*kNode1  ; 2*kNode1 ];
        end
        NZT = length(dofs)^2;
        Kelem = K*(dofs'*dofs);
        Celem = C*(dofs'*dofs);
        ad2K(NZT_K+(1:NZT),:) = [Kelem(:) ROW COL]; NZT_K = NZT_K + NZT;
        ad2C(NZT_C+(1:NZT),:) = [Celem(:) ROW COL]; NZT_C = NZT_C + NZT;
    end
end
ad2K = ad2K(1:NZT_K,:); ad2K = sparse(ad2K(:,2),ad2K(:,3),ad2K(:,1),nDof,nDof);
ad2C = ad2C(1:NZT_C,:); ad2C = sparse(ad2C(:,2),ad2C(:,3),ad2C(:,1),nDof,nDof);
ad2M = ad2M(1:NZT_M,:); ad2M = sparse(ad2M(:,2),ad2M(:,3),ad2M(:,1),nDof,nDof);
%% Free dofs - remove last row of ballast nodes if bottom of lattice is
%  fixed
ai1FreeDof = 1:1:nDof;
ai1FixedDof = sort([FIXED_BALLAST_NODES*2-1;
                    FIXED_BALLAST_NODES*2-0],'ascend');
if Nlat(end,1) ~= 0
    ai1FixedNode = find(((NODE_TYPE(:,1)==BALLAST)+(NODE_TYPE(:,1)==SOIL)).*(NODE_TYPE(:,3)==min(NODE_TYPE(:,3))));
    ai1FixedDof = [ai1FixedDof; ai1FixedNode*2-1; ai1FixedNode*2];
    ai1FixedDof = unique(sort(ai1FixedDof(:),'ascend'));
    ai1FreeDof(ai1FixedDof) = [];
end
if PLOT
    ai1FixedNode = ai1FixedDof(2:2:end)/2;
    plot(NODE_TYPE(ai1FixedNode,2),NODE_TYPE(ai1FixedNode,3),'*m');
end
%% Split dofs into left, middle and right
nDof = size(ad2K,1);
DofFP = zeros(nDof,1);
DofFP(ai1FixedDof) = 0;
DofFP(ai1FreeDof) = 1;
DofsL = 1:1:nDof/3;   DofsL_FP = DofFP(DofsL);
DofsM = DofsL+nDof/3; DofsM_FP = DofFP(DofsM);
DofsR = DofsM+nDof/3; DofsR_FP = DofFP(DofsR);
ad2KL = ad2K(DofsM,DofsL); ad2CL = ad2C(DofsM,DofsL); ad2ML = ad2M(DofsM,DofsL); 
ad2KM = ad2K(DofsM,DofsM); ad2CM = ad2C(DofsM,DofsM); ad2MM = ad2M(DofsM,DofsM); 
ad2KR = ad2K(DofsM,DofsR); ad2CR = ad2C(DofsM,DofsR); ad2MR = ad2M(DofsM,DofsR);
%% Loop on wavenumbers and calculate the frequencies:
fprintf(1, '\n');
fprintf(1, 'Calculating dispersion lines for %d wavenumbers...\n', length(Ky));
fprintf(1, '[0%%                                            100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
W_K = [];
for iK = 1: 1: length(Ky)
    if mod(iK+1,round(length(Ky)/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end

    ky = Ky(iK);
    ad2K = ad2KL*exp(1i*ky*(N+M)*D)+ad2KM+ad2KR*exp(-1i*ky*(N+M)*D);
    ad2M = ad2ML*exp(1i*ky*(N+M)*D)+ad2MM+ad2MR*exp(-1i*ky*(N+M)*D);
    ai1FreeDof = find(DofsM_FP==1);
    W2 = eigs(ad2K(ai1FreeDof,ai1FreeDof),ad2M(ai1FreeDof,ai1FreeDof),2*nMode,'smallestabs');
    W = sqrt(W2);
    W = real(W(abs(imag(W))<abs(real(W))*1e-6));
    W = sort(abs(W),'ascend');
    W = W(:);
    W_K = [W_K  W(1:nMode) ones(nMode,1)*ky]; 
end
for iStar = star+1:1:50
    fprintf(1, '*');
end
fprintf(1, ']\n');
end