% Script for moving load transition
clc
%% Track properties
% Rail
Track.a = 2;
Track.EI = 2*6.044e6;
Track.m = 2*60;
Track.DampRail = 0.0001;
% Sleepers
Track.Width = 0.3;
Track.Spacing = 0.6;
Track.Ms = 315;
Track.Js = Track.Ms/6*Track.Width^2;
% Rail pads
Track.Kv = 100e6;
Track.Kt = Track.Kv*Track.Width^2/4;
Track.DampRP = 0.001;
% Under sleeper pads
Track.DampUSP = 0.001;
Track.Ku = 45e9;
Track.Kuh = Track.Ku*1e2*0;
%% Ballast and soil - stiffness properties for full track (2m cross section)
% Test box stifness
D = 0.03;
K0 = 300e6; % Pa/m
WidthLoad = 1;
LxLoad = 0.25;
Lz = 0.3;
K0 = K0*LxLoad*WidthLoad;
Ratio = 1/8;
nXLoad = round(LxLoad/D);
nZ = round(Lz/D);
[Kn,Ks,Kd,Fn,Fs,Fd] = FindStiffnesses(K0,Ratio,nXLoad,nZ);
Kn = Kn/WidthLoad*Track.a; % 7.4488e7
Ks = Ks/WidthLoad*Track.a; % 9.3110e6
Kd = Kd/WidthLoad*Track.a; % 3.2588e7
Ballast.Damp = 0.001;
Ballast.D = D;
Ballast.H = 0.3;
Ballast.Rho = 1800;
Ballast.Kn = Kn;
Ballast.Ks = Ks;
Ballast.Kd = Kd;

% Example Ballast only
Soil.Left.FilenameDM = 'Section4/DM_BallastOnly_0p001s.mat';
Soil.Left.FilenameID = 'Section4/ID_BallastOnly_0p001s.mat';
Soil.Left.Cs = [];
Soil.Left.Cp = [];
Soil.Left.Rho = [];
Soil.Left.Damp = [];
Soil.Left.H = [];
Soil.Left.KvBot = [];
Soil.Left.KhBot = [];
Soil.Left.CvBot = [];
Soil.Left.ChBot = [];
Soil.Right = Soil.Left;
Soil.Mid = Soil.Left;

Soil.MidSections = [10 1 0 0];

ApproachSlab = [];

%% Inputs
Inputs.Track = Track;
Inputs.Ballast = Ballast;
Inputs.Soil = Soil;
Inputs.ApproachSlab = ApproachSlab;
%% Calculate response to moving load
if ~isempty(strfind(Soil.Left.FilenameDM,'0p001s'))
    dt = 0.001;
elseif ~isempty(strfind(Soil.Left.FilenameDM,'0p0001s'))
    dt = 0.0001;
end
Tmax = 1;
V = 60;
dW = 2*pi/10/Tmax;
Wf = 2*pi/dt;
W = [dW/100 dW:dW:Wf/100 Wf/100+10*dW:10*dW:Wf];

return
%% Calculate
OUTPUT = MovingLoadTransition(Inputs,dt,Tmax,V,W);
SLEEPER = OUTPUT.SLEEPER;
RAIL = OUTPUT.RAIL;
BALLAST = OUTPUT.BALLAST;
BEAM = OUTPUT.BEAM;
SPRING = OUTPUT.SPRING;
NODE_TYPE = OUTPUT.NODE_TYPE;
ad2Connection = OUTPUT.ad2Connection;
T = OUTPUT.T;
ad2Displ = OUTPUT.ad2Displ;
ad2Vel = OUTPUT.ad2Vel;

%% Calculate theoretical response
dW = 2*pi/10/Tmax;
Wf = 2*pi/0.001;
W = [dW/100 dW:dW:Wf/100 Wf/100+10*dW:10*dW:Wf];
OUTPUT_Theor = MovingLoadTheoretical(Inputs,1,0.001,Tmax,V,W,...
                                        [], 0);
return
%% Calculate output nodes
RAIL_NODES = find(NODE_TYPE(:,1)==RAIL);
[Min,kNodeStart] = min(NODE_TYPE(RAIL_NODES,2));
[Max,kNodeEnd] = max(NODE_TYPE(RAIL_NODES,2));
kNodeStart = RAIL_NODES(kNodeStart);
kNodeEnd = RAIL_NODES(kNodeEnd);
NODES_MID = find(NODE_TYPE(:,1) == SLEEPER);
NODES_MID = NODES_MID - 1;
COLOR = 'brgcm';
tenter = Min/V;
tleave = Max/V;

%% Plot - Section 4.3
close all
if isempty(tleave)
    tleave = xMax/V;
end
if isempty(tenter)
    tenter = xMin/V;
end
for iNode = 1: 1: length(NODES_MID)
    figure(1);
    plot(T, -ad2Displ(2*NODES_MID(iNode)-1,:),COLOR(1+mod(iNode-1,length(COLOR))), 'LineWidth', 2); hold on;
    [MAX,kT] = max(ad2Displ(2*NODES_MID(iNode)-1,:));
    figure(2);
    plot(T-T(kT), -ad2Displ(2*NODES_MID(iNode)-1,:),COLOR(1+mod(iNode-1,length(COLOR))), 'LineWidth', 1); hold on
end
figure(1);
plot(tenter*[1 1], -[min(min(ad2Displ(2*NODES_MID-1,:))) max(max(ad2Displ(2*NODES_MID-1,:)))], '--k', 'LineWidth', 2);
plot(tleave*[1 1], -[min(min(ad2Displ(2*NODES_MID-1,:))) max(max(ad2Displ(2*NODES_MID-1,:)))], '--k', 'LineWidth', 2);
xlabel('Time (s)');
ylabel('u_r_a_i_l (m)');
title('a)');
xlim([-0.1 0.2]);
grid on;
figure(2);
UrailTheor = permute(OUTPUT_Theor.Urail(1,:,:), [3 1 2]);
[MAX,kT] = max(UrailTheor);
plot((OUTPUT_Theor.T-OUTPUT_Theor.T(kT)), -UrailTheor,'--k', 'LineWidth', 2);
xlabel('Time (s)');
ylabel('u_r_a_i_l (m)');
title('b)');
xlim([-0.1 0.1]);
grid on;
return;

%% Time domain incident displacements and duhamel matrices
%  Sections 4.1 and 4.2
COMPARE_1 = 0;
COMPARE_2 = 0;
if COMPARE_1
    CALC_TD = 0;
    if CALC_TD
        OUTPUT_TD = IncidentDisplacement_TD(Inputs,0.001,Tmax,V,100);
        save('Section4/ID_DM_TD.mat', 'OUTPUT_TD');
    end
    load Section4/ID_DM_TD.mat
end
if COMPARE_2
    CALC_TD = 0;
    if CALC_TD
%         OUTPUT_TD_2 = IncidentDisplacement_TD(Inputs,D/2/V,Tmax,V,100);
        OUTPUT_TD_2 = IncidentDisplacement_TD(Inputs,0.0001,Tmax,V,100);
        save('Section4/ID_DM_TD_2.mat', 'OUTPUT_TD_2');
    end
    load Section4/ID_DM_TD_2.mat
end

%% Compare results - Section 4.1 of paper - Figure 5 and Figure 6
close all
COMPARE_1 = 1; if COMPARE_1, load('Section4/ID_DM_TD.mat'); end
COMPARE_2 = 0; if COMPARE_2, load('Section4/ID_DM_TD_2.mat'); end
load(Soil.Left.FilenameDM);
W = OUTPUT_Freq.W;
Tlim = Tmax;
nDof = size(OUTPUT_Freq.Mats(1).KRight,1);
FlexRight = zeros(nDof,nDof,length(W));
FlexLeft = zeros(nDof,nDof,length(W));
for iW = 1: 1: length(W)
    FlexRight(:,:,iW) = inv(OUTPUT_Freq.Mats(iW).KRight);
    FlexLeft(:,:,iW) = inv(OUTPUT_Freq.Mats(iW).KLeft);
end

iDof = 13;
jDof = 13;
figure;
plot(Tout,permute(Fright(iDof,jDof,:),[3 1 2]),'b', 'LineWidth', 2); hold on;
if COMPARE_1
    plot(OUTPUT_TD.T,permute(OUTPUT_TD.IR_L(iDof,jDof,:),[3 1 2]),'--r', 'LineWidth', 2);
end
if COMPARE_2
    plot(OUTPUT_TD_2.T,permute(OUTPUT_TD_2.IR_L(iDof,jDof,:),[3 1 2]),'--k', 'LineWidth', 2);
end
xlim([0 0.1]*Tlim);
legend('Eq. (15)', 'Time solver', 'Time solver');
xlabel('Time (s)');
ylabel('F_l^j (m)');
grid on
hold off;
title('a)');
figure;
plot(Tout,permute(Fleft(iDof,jDof,:),[3 1 2]),'b', 'LineWidth', 2); hold on;
if COMPARE_1
    plot(OUTPUT_TD.T,permute(OUTPUT_TD.IR_R(iDof,jDof,:),[3 1 2]),'--r', 'LineWidth', 2);
end
if COMPARE_2
    plot(OUTPUT_TD_2.T,permute(OUTPUT_TD_2.IR_R(iDof,jDof,:),[3 1 2]),'--k', 'LineWidth', 2);
end
xlim([0 0.1]*Tlim);
legend('Eq. (15)', 'Time solver', 'Time solver');
xlabel('Time (s)');
ylabel('F_r^j (m)');
grid on
hold off;
title('b)');
figure;
plot(W/2/pi,real(permute(FlexRight(iDof,jDof,:),[3 1 2])),'b', ...
     W/2/pi,imag(permute(FlexRight(iDof,jDof,:),[3 1 2])),'r', 'LineWidth', 2);
legend('real', 'imaginary');
xlabel('Frequency (Hz)');
ylabel('H_l (m.s)');
grid on
title('c)');
figure;
plot(W/2/pi,real(permute(FlexLeft(iDof,jDof,:),[3 1 2])),'b', ...
     W/2/pi,imag(permute(FlexLeft(iDof,jDof,:),[3 1 2])),'r', 'LineWidth', 2);
legend('real', 'imaginary');
xlabel('Frequency (Hz)');
ylabel('H_r (m.s)');
grid on
title('d)');

%% Compare results - Section 4.2 of paper - Figure 7 and Figure 8
close all
COMPARE_1 = 1; if COMPARE_1, load('Section4/ID_DM_TD.mat'); end
COMPARE_2 = 0; if COMPARE_2, load('Section4/ID_DM_TD_2.mat'); end
load(Soil.Left.FilenameID);
W = sInputFile.W;
Tlim = Tmax;
iDof = 13;
figure;
plot(T,Uleft(iDof,:),'b','LineWidth',2); hold on;
if COMPARE_1
    plot(OUTPUT_TD.Tl,OUTPUT_TD.ULeft(iDof,:),'--r','LineWidth',2);
end
if COMPARE_2
    plot(OUTPUT_TD_2.Tl,OUTPUT_TD_2.ULeft(iDof,:),'--k','LineWidth',2);
end
xlim([-0.1 0.1]*Tlim);
legend('Eq. (31)', 'Time solver', 'Time solver');
xlabel('Time (s)');
ylabel('u_l^j (m)');
grid on
hold off;
title('a)');
figure;
plot(T,Uright(iDof,:),'b','LineWidth',2); hold on;
if COMPARE_1
    plot(OUTPUT_TD.Tl,OUTPUT_TD.URight(iDof,:),'--r','LineWidth',2);
end
if COMPARE_2
    plot(OUTPUT_TD_2.Tl,OUTPUT_TD_2.URight(iDof,:),'--k','LineWidth',2);
end
xlim([-0.1 0.1]*Tlim);
legend('Eq. (31)', 'Time solver', 'Time solver');
xlabel('Time (s)');
ylabel('u_r^j (m)');
grid on
hold off;
title('b)');
figure;
plot(W(2:end)/2/pi,real(Uleft_W(iDof,2:end)),'b',W(2:end)/2/pi,imag(Uleft_W(iDof,2:end)),'r','LineWidth',2); hold on;
legend('real', 'imaginary');
xlabel('Frequency (Hz)');
ylabel('u_l (m.s)');
grid on
hold off;
title('c)');
figure;
plot(W(2:end)/2/pi,real(Uright_W(iDof,2:end)),'b',W(2:end)/2/pi,imag(Uright_W(iDof,2:end)),'r','LineWidth',2); hold on;
legend('real', 'imaginary');
xlabel('Frequency (Hz)');
ylabel('u_r (m.s)');
grid on
hold off;
title('d)');
