clc; clear; close all
LEFT = 1; RIGHT = 2; LEFT_RIGHT = 3;
%% Material properties
Damp = 0.001;
VISCOUS = 1;
HYSTERETIC = 0;
DampType = VISCOUS;
% Rail
EI = 2*6.044e6;
m = 2*60;
DampEI = 0.0001;
% Sleepers
Width = 0.3;
Spacing = 0.6;
Ms = 315;
Js = Ms/6*Width^2;
% Sleeper pads
Kv = 100e6;
Kt = Kv*Width^2/4;
% Under sleeper pads
Ku = 45e9;
Kuh = inf; Kuh = Ku*1e2;
% Ballast - stiffness properties for half track (1m cross section)
Hlat = 0.3;
Dlat = 0.03;
Rho = 1800;
Knlat = 1.4222e+07;
Kslat = 1.7778e+06;
Kdlat = 6.2222e+06;
Mlat = Rho*Dlat^2;

%% Calculate geometrical quantities
Nlat = round(Hlat/Dlat);
Hlat = Dlat*Nlat;
N = round(Width/Dlat)+1;
M = round(Spacing/Dlat); M = M - N;
Width = (N-1)*Dlat;
Spacing = (M+N)*Dlat;
% Under-sleeper pads divided by each grain of ballast
Ku  = Ku/N;
Kuh = Kuh/N;
%% Frequency of interest, loading locations and output locations
freq = 0.02;
w = 2*pi*freq;
% Damped constants
if (DampType == VISCOUS)
    EI = EI*(1+1i*w*DampEI);
    Kv = Kv*(1+1i*w*Damp);
    Kt = Kt*(1+1i*w*Damp);
    Ku = Ku*(1+1i*w*Damp);
    Kuh = Kuh*(1+1i*w*Damp);
    Knlat = Knlat*(1+1i*w*Damp);
    Kslat = Kslat*(1+1i*w*Damp);
else
    EI = EI*(1+2i*DampEI);
    Kv = Kv*(1+2i*Damp);
    Kt = Kt*(1+2i*Damp);
    Ku = Ku*(1+2i*Damp);
    Kuh = Kuh*(1+2i*Damp);
    Knlat = Knlat*(1+2i*Damp);
    Kslat = Kslat*(1+2i*Damp);
end
%% Calculate transmitting boundary
start = clock;
if DampType == VISCOUS
    DF = 1;
else
    DF = 2;
end
dt = 1e-3;
Tmax = 1;
[Fleft2,Fright2,Tout2] = DuhamelMatrices(real(EI)*(1+1i*DampEI*DF),m,...
                                     real(Kv)*(1+1i*Damp*DF),...
                                     real(Kt)*(1+1i*Damp*DF),Ms,Js,...
                                     real(Ku)*(1+1i*Damp*DF),...
                                     real(Kuh)*(1+1i*Damp*DF),Dlat,[Mlat 0],...
                                     real(Knlat)*(1+1i*Damp*DF)*[1 0.2],...
                                     real(Kslat)*(1+1i*Damp*DF)*[1 0.2],...
                                     Nlat*[1 0],N,M,DampType,dt,Tmax);

fprintf(1, ['Time spent with FEM TB: ' num2str(etime(clock,start)) ' s.\n']);
load Mats.mat
for iComp = 1:1:size(Fleft,1)
    for jComp = 1:1:size(Fleft,2)
        subplot(1,2,1);
        z = Fleft(iComp,jComp,:); z = z(:);
        Z = Fleft2(iComp,jComp,:); Z = Z(:);
        plot(Tout,z,'b',Tout2,Z,'r');
        title(['a_' num2str(iComp) '_,_' num2str(jComp)]);
        xlim([0 Tmax]);
        subplot(1,2,2);
        z = Fright(iComp,jComp,:); z = z(:);
        Z = Fright2(iComp,jComp,:); Z = Z(:);
        plot(Tout,z,'b',Tout2,Z,'r');
        title(['a_' num2str(iComp) '_,_' num2str(jComp)]);
        xlim([0 Tmax]);
        pause
    end
end