function [Kn,Ks,Kd,Fn,Fs,Fd] = FindStiffnesses(K0,Ratio,nX,nZ)

K1 = (1+(1-Ratio)/2)*nX;
K2 = 2*Ratio;

MAT = zeros(nZ,nZ);
for iZ = 1: 1: nZ-1
    MAT(iZ,iZ) = MAT(iZ,iZ)+K1;
    MAT(iZ,iZ+1) = -K1;
    MAT(iZ+1,iZ) = -K1;
    MAT(iZ+1,iZ+1) = MAT(iZ+1,iZ+1)+K1;
end
MAT(end,end) = MAT(end,end)+K1;
for iZ = 1: 1: nZ
    MAT(iZ,iZ) = MAT(iZ,iZ)+K2;
end

F = zeros(nZ,1); F(1) = 1;
Stiff = 1/(F'*MAT^-1*F);

Kn = K0/Stiff;
Ks = Kn*Ratio;
Kd = (Kn-Ks)/2;

Stiff = Kn*MAT;
U = Stiff^-1*F;

Fn = Kn*(U(1)-U(2));
Fs = Ks*U(1);
Fd = Kd*(U(1)-U(2))*sqrt(2)/2;
end
