function [Fleft,Fright,Tout] = DuhamelMatrices_quadv(EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Nlat,N,M,DampType,dt,Tmax)
global nW
nW = 0;
Tout = 0:dt:Tmax;
iDiv = 0;
while 1
    iDiv = iDiv + 1;
    [Z0,nW0] = quadv(@(w)StepLoad(w,EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Nlat,N,M,DampType,dt,Tout),(iDiv-1)*2*pi/(10*dt),iDiv*2*pi/(10*dt),1e-12);
    if iDiv == 1
        Z = Z0;
    else
        Z = Z+Z0;
        if max(max(abs(Z0./Z))) < 1e-4, break; end
    end
end
Z = reshape(Z,[length(Z)/length(Tout) length(Tout)]);
Fleft = Z(1:end/2,:);
Fright = Z(end/2+1:end,:);
Z = [];
Fleft = reshape(Fleft(:),[sqrt(size(Fleft,1))*[1 1] size(Fleft,2)]);
Fright = reshape(Fright(:),[sqrt(size(Fright,1))*[1 1] size(Fright,2)]);
end

function Z = StepLoad(w,EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Nlat,N,M,DampType,dt,Tout)
global nW
nW = nW + 1;

fprintf(1, 'Frequency %d = %f Hz ... \n', nW, w/2/pi);
OUTPUT = TransmittingBoundaryFEM(...
                    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Nlat,N,M,w,DampType);
Fw = sin(w*dt)/pi/w;
if w == 0, Fw = dt/2/pi; end
Fleft = OUTPUT.FlexLeft*Fw;
Fright = OUTPUT.FlexRight*Fw;
F = [Fleft(:);Fright(:)]; Fr = real(F); Fi = imag(F);
Z = zeros(length(Tout)*length(F),1);

for iT = 1: 1: length(Tout)
    Z((iT-1)*length(F)+(1:1:length(F)))=Fr*cos(w*Tout(iT))-Fi*sin(w*Tout(iT));
end
end