function [Fleft,Fright,Tout,OUTPUT_Freq] = DuhamelMatrices(EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,DampType,dt,Tmax,Filename,W,INPUT_Freq)
if nargin < 20, Filename = []; end
if nargin < 21, W = []; end
if nargin < 22, INPUT_Freq = []; end

if isempty(W)
    dW = 2*pi/10/Tmax;
    Wf = 2*pi/dt;
    W = 0:dW:Wf;
end
DO = 1;
if ~isempty(Filename)
    try
        load(Filename);
        VALID = CheckInputs(sInputFile,...
            EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,DampType,dt,Tmax,W);
        if VALID, DO = 0; end
        Fleft = Fleft(:,:,Tout<=Tmax);
        Fright = Fright(:,:,Tout<=Tmax);
        Tout = Tout(Tout<=Tmax);
    catch
        DO = 1;
    end
end
if ~DO, return; end
OUTPUT_Freq.W = W;
Tout = 0:dt:Tmax;
fprintf(1, '\n');
fprintf(1, 'Calculating Duhamel matrices (%d frequencies)...\n', length(W));
fprintf(1, '[0%%     20%%       40%%       60%%       80%%      100%%]\n');
fprintf(1, '[');
STARS = zeros(50,1); star = 0;
for iW = 1: 1: length(W)
    %% TRanfer function
    if mod(iW,round(length(W)/50))==0
        star = star + 1;
        if star <= 50 && STARS(star) == 0
            fprintf(1, '*');
            STARS(star) = 1;
        end
    end
    w = W(iW);
    DO = 1;
    if ~isempty(INPUT_Freq)
        kIndex = find(INPUT_Freq.W == w);
        if ~isempty(kIndex)
            DO = 0;
            OUTPUT = INPUT_Freq.Mats(kIndex);
        end
    end
    if DO
        OUTPUT = TransmittingBoundaryFEM(...
                    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,w,DampType);
    end
    OUTPUT_Freq.Mats(iW) = OUTPUT;
    % Amplitude 0.5 between -dt and dt
    Fw = sin(w*dt)/w;
%     % Amplitude 1 between -dt*2 and dt/2
%     Fw = 2*sin(w*dt/2)/pi/w;
%     % Amplitude 1 between -dt and 0
%     Fw = 1i*(1-exp(1i*dt*w))/pi/w;
%     % Amplitude 0 at -dt, 1 at 0, and 0 at dt - linear in between
%     Fw = (2-2*cos(dt*w))/(dt*w^2)/pi;
    if w == 0, Fw = dt; end
    FlexLeft = inv(OUTPUT.KLeft);
    Fl = FlexLeft*Fw;  FlR = real(Fl); FlI = imag(Fl);
    FlexRight = inv(OUTPUT.KRight);
    Fr = FlexRight*Fw; FrR = real(Fr); FrI = imag(Fr);
    if iW == 1
        Fleft  = zeros([size(Fl) length(Tout)]);
        Fright = zeros([size(Fr) length(Tout)]);
        FlRp = FlR;
        FlIp = FlI;
        FrRp = FrR;
        FrIp = FrI;
        continue;
    end
    dw = W(iW)-W(iW-1);
    %% Real component of integral
    COS1 = cos(W(iW-1)*Tout)./Tout.^2/pi;
    SIN1 = sin(W(iW-1)*Tout)./Tout/pi;
    COS2 = cos(W(iW)*Tout)./Tout.^2/pi;
    SIN2 = sin(W(iW)*Tout)./Tout/pi;
    SIN1(Tout==0) = -dw/(2*pi);
    SIN2(Tout==0) = dw/(2*pi);
    COS1(Tout==0) = 0;
    COS2(Tout==0) = 0;
    % Left part
    A = FlRp;
    C = FlR; 
    B = (C-A)/dw;
    for iT = 1: 1: length(Tout)
        Fleft(:,:,iT)  = Fleft(:,:,iT)  + C*SIN2(iT) - A*SIN1(iT) + B*(COS2(iT)-COS1(iT));
    end
    % Right part
    A = FrRp;
    C = FrR;
    B = (C-A)/dw;
    for iT = 1: 1: length(Tout)
        Fright(:,:,iT)  = Fright(:,:,iT)  + C*SIN2(iT) - A*SIN1(iT) + B*(COS2(iT)-COS1(iT));
    end
    %% Imaginary component of integral
    COS1 = cos(W(iW-1)*Tout)./Tout/pi;
    SIN1 = sin(W(iW-1)*Tout)./Tout.^2/pi;
    COS2 = cos(W(iW)*Tout)./Tout/pi;
    SIN2 = sin(W(iW)*Tout)./Tout.^2/pi;
    SIN1(Tout==0) = 0;
    SIN2(Tout==0) = 0;
    COS1(Tout==0) = 0;
    COS2(Tout==0) = 0;
    % Left part
    A = FlIp;
    C = FlI;
    B = (C-A)/dw;
    for iT = 1: 1: length(Tout)
        Fleft(:,:,iT)  = Fleft(:,:,iT)  + C*COS2(iT) - A*COS1(iT) - B*(SIN2(iT)-SIN1(iT));
    end
    % Right part
    A = FrIp;
    C = FrI;
    B = (C-A)/dw;
    for iT = 1: 1: length(Tout)
        Fright(:,:,iT)  = Fright(:,:,iT)  + C*COS2(iT) - A*COS1(iT) - B*(SIN2(iT)-SIN1(iT));
    end
    
    FlRp = FlR;
    FlIp = FlI;
    FrRp = FrR;
    FrIp = FrI;
end
for iStar = star+1:1:50
    fprintf(1, '*');
end
fprintf(1, ']\n');
% Store results in Filename
if ~isempty(Filename)
    sInputFile.EI = EI;
    sInputFile.m = m;
    sInputFile.Kv = Kv;
    sInputFile.Kt = Kt;
    sInputFile.Ms = Ms;
    sInputFile.Js = Js;
    sInputFile.Ku = Ku;
    sInputFile.Kuh = Kuh;
    sInputFile.D = D;
    sInputFile.Mlat = Mlat;
    sInputFile.Knlat = Knlat;
    sInputFile.Kdlat = Kdlat;
    sInputFile.Kslat = Kslat;
    sInputFile.Nlat = Nlat;
    sInputFile.N = N;
    sInputFile.M = M;
    sInputFile.DampType = DampType;
    sInputFile.dt = dt;
    sInputFile.Tmax = Tmax;
    sInputFile.W = W;
    save(Filename, 'sInputFile', 'Fleft', 'Fright', 'Tout', 'OUTPUT_Freq','-v7.3');
end

end

%% CheckInputs
function VALID = CheckInputs(sInputFile,EI,m,Kv,Kt,Ms,Js,Ku,Kuh,D,Mlat,Knlat,Kslat,Kdlat,Nlat,N,M,DampType,dt,Tmax,W)
VALID = 0;
if EI ~= sInputFile.EI, return; end
if m ~= sInputFile.m, return; end
if Kv ~= sInputFile.Kv, return; end
if Kt ~= sInputFile.Kt, return; end
if Ms ~= sInputFile.Ms, return; end
if Js ~= sInputFile.Js, return; end
if Ku ~= sInputFile.Ku, return; end
if Kuh ~= sInputFile.Kuh, return; end
if D ~= sInputFile.D, return; end
if length(Mlat) ~= length(sInputFile.Mlat), return; end
if length(Knlat) ~= length(sInputFile.Knlat), return; end
if length(Kslat) ~= length(sInputFile.Kslat), return; end
if length(Kdlat) ~= length(sInputFile.Kdlat), return; end
if length(Nlat) ~= length(sInputFile.Nlat), return; end
for iLayer = 1: 1: length(Nlat)
    if Mlat(iLayer) ~= sInputFile.Mlat(iLayer), return; end
    if Knlat(iLayer) ~= sInputFile.Knlat(iLayer), return; end
    if Kslat(iLayer) ~= sInputFile.Kslat(iLayer), return; end
    if Kdlat(iLayer) ~= sInputFile.Kdlat(iLayer), return; end
    if Nlat(iLayer) ~= sInputFile.Nlat(iLayer), return; end
end
if N ~= sInputFile.N, return; end
if M ~= sInputFile.M, return; end
if DampType ~= sInputFile.DampType, return; end
if dt ~= sInputFile.dt, return; end
if Tmax > sInputFile.Tmax, return; end
if length(W) ~= length(sInputFile.W), return; end
for iW = 1: 1: length(W)
    if W(iW) ~= sInputFile.W(iW), return; end
end

VALID = 1;
end