% Script for moving load transition
clc
clear
% Time step
dt = 0.001;
TS = [num2str(dt) 's'];
TS(find(TS=='.')) = 'p';
%% Sleepers at the sides
nSleeperSide = 5;
% Resutls type
% OutputFilename = ['ExampleGouda/ApproachSlab_' num2str(nSleeperSide) 'Sleepers_'];
OutputFilename = ['ExampleGouda/Culvert_' num2str(nSleeperSide) 'Sleepers_'];
% OutputFilename = ['ExampleGouda/NoCulvert_' num2str(nSleeperSide) 'Sleepers_'];
close all
%% Loop on speeds
VV = [33 60 100];
COLOR = 'brk';
for iV = 1: 1: length(VV)
    V = VV(iV);
    VS = [num2str(V) 'mps'];
    Filename = [OutputFilename VS '_' TS '.mat'];
    load(Filename);
    SLEEPER = OUTPUT.SLEEPER;
    RAIL = OUTPUT.RAIL;
    BALLAST = OUTPUT.BALLAST;
    BEAM = OUTPUT.BEAM;
    SPRING = OUTPUT.SPRING;
    NODE_TYPE = OUTPUT.NODE_TYPE;
    ad2Connection = OUTPUT.ad2Connection;
    T = OUTPUT.T;
    ad2Displ = OUTPUT.ad2Displ;
    ad2Vel = OUTPUT.ad2Vel;
    
    %% Calculate energy transfer to ballast by each sleeper
    SLEEPER_NODES = find(NODE_TYPE(:,1)==SLEEPER);
    nSleeper = length(SLEEPER_NODES);
    SleeperEnergy = zeros(nSleeper,1);
    MAX_FORCE = zeros(nSleeper,2);
    for iSleeper = 1: 1: nSleeper
        Node = SLEEPER_NODES(iSleeper);
        xSleeper = NODE_TYPE(Node,2);
        TIME_STAPM = find((T>=xSleeper/V-0.1).*(T<=xSleeper/V+0.1));
        Connections = find((ad2Connection(:,2)==Node)+(ad2Connection(:,3)==Node));
        Connections = ad2Connection(Connections,:);
        nConnections = size(Connections,1);
        SleeperForce = zeros(1,size(ad2Displ,2));
        for iConnection = 1: 1: nConnections
            if Connections(iConnection,1) ~= SPRING, continue; end
            Node1 = Connections(iConnection,2);
            Node2 = Connections(iConnection,3);
            if NODE_TYPE(Node1,1) == RAIL || NODE_TYPE(Node2,1) == RAIL
                continue;
            end
            % Calculate force on spring
            dofs =  Connections(iConnection,4:7);
            K = Connections(iConnection,8);
            C = Connections(iConnection,9);
            K = K*(dofs'*dofs);
            C = C*(dofs'*dofs);
            F = K*ad2Displ([2*Node1-1; 2*Node1; 2*Node2-1; 2*Node2],:) + ...
                C*ad2Vel([2*Node1-1; 2*Node1; 2*Node2-1; 2*Node2],:);
            if NODE_TYPE(Node1,1) == SLEEPER && NODE_TYPE(Node2,1) == BALLAST
                SleeperEnergy(iSleeper) = SleeperEnergy(iSleeper) + ...
                    sum(sum(-F(3:4,TIME_STAPM).*ad2Vel([2*Node2-1; 2*Node2],TIME_STAPM)))*(T(2)-T(1));
                SleeperForce = SleeperForce - F(4,:);
            elseif NODE_TYPE(Node1,1) == BALLAST && NODE_TYPE(Node2,1) == SLEEPER
                SleeperEnergy(iSleeper) = SleeperEnergy(iSleeper) + ...
                    sum(sum(-F(1:2,TIME_STAPM).*ad2Vel([2*Node1-1; 2*Node1],TIME_STAPM)))*(T(2)-T(1));
                SleeperForce = SleeperForce - F(2,:);
            else
                fprintf(1, 'ERROR: something went wrong...\n');
                return;
            end
        end
        MAX_FORCE(iSleeper,1) = max(SleeperForce);
        MAX_FORCE(iSleeper,2) = -min(SleeperForce);
    end
    MARKER = ['-o' COLOR(iV)];
    figure(1);
    plot((1:1:nSleeper)-nSleeperSide+5, SleeperEnergy, MARKER); hold on;
    xlabel('Sleeper number');
    ylabel('Energy transmitted per sleeper (J/N^2)');
    grid on;
    figure(2);
    plot((2:1:nSleeper)-nSleeperSide+5, MAX_FORCE(2:end,1),MARKER); hold on;
    xlabel('Sleeper number');
    ylabel('Maximum transmitted force (N/N)');
    grid on;
end

