function OUTPUT = CalculateFrequencyDomainResponse_FL_AI(...
    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,K,XlR,IlL,XoR,IoL,LoS,fTol)

if nargin<23, fTol = 1e-2; end

if real(Ku) == inf, Ku = real(Ku); end
if real(Kuh) == inf, Kuh = real(Kuh); end
if Knlat == inf
    Nlat = 0;
    IlL = [];
    IoL = [];
end
if ~isempty(IoL)
    IoL = IoL(:)';
end
%% Define load
SLEEPER = 0;
RAIL = 1;
LATTICE = 2;
XX = 1; % Horzintal
ZZ = 2; % Vertical
MM = 3; % Moment
nLoad = 2*length(XlR);
nLoad = nLoad + 2*length(IlL)*Nlat;
LOAD = zeros(nLoad,4);
kLoad = 0;
for iLoad = 1: 1: length(XlR)
    kLoad = kLoad + 1;
    LOAD(kLoad,1) = RAIL;
    LOAD(kLoad,2) = XlR(iLoad);
    LOAD(kLoad,3) = ZZ;
    kLoad = kLoad + 1;
    LOAD(kLoad,1) = RAIL;
    LOAD(kLoad,2) = XlR(iLoad);
    LOAD(kLoad,3) = MM;
end
for iLoad = 1: 1: length(IlL)
    for iZ = 1: 1: Nlat
        kLoad = kLoad + 1;
        LOAD(kLoad,1) = LATTICE;
        LOAD(kLoad,2) = IlL(iLoad);
        LOAD(kLoad,3) = iZ-1;
        LOAD(kLoad,4) = XX;
        kLoad = kLoad + 1;
        LOAD(kLoad,1) = LATTICE;
        LOAD(kLoad,2) = IlL(iLoad);
        LOAD(kLoad,3) = iZ-1;
        LOAD(kLoad,4) = ZZ;
    end
end

%% Initialize outputs
OUTPUT = [];
Urail = zeros(2*length(XoR), nLoad);
Srail = zeros(2*length(XoR), nLoad);
Urail_K = zeros(2*length(XoR), nLoad, length(K));
Srail_K = zeros(2*length(XoR), nLoad, length(K));
Ulattice = zeros(2*Nlat+2,length(IoL), nLoad);
Usleeper = zeros(2*length(LoS), nLoad);

%% Add to Urail and Srail responses due to external load at the rails
kb = (w^2*m/EI)^.25;
for iLoad = 1: 1: nLoad
    if LOAD(iLoad,1) ~= RAIL, continue; end
    xp = LOAD(iLoad,2);
    for iOutput = 1: 1: length(XoR)
        x = XoR(iOutput) - xp;
        exp1 = exp(-1i*kb*abs(x));
        exp2 = exp(-kb*abs(x));
        if LOAD(iLoad,3) == ZZ
            Urail(2*iOutput-1,iLoad) = 1/(4*EI*kb^3)*(-1i*exp1-exp2);
            Urail(2*iOutput-0,iLoad) = sign(x)/(4*EI*kb^2)*(-exp1+exp2);
            Srail(2*iOutput-1,iLoad) = sign(x)/4*(exp1+exp2);
            Srail(2*iOutput-0,iLoad) = 1/(4*kb)*(1i*exp1-exp2);
        elseif LOAD(iLoad,3) == MM
            Urail(2*iOutput-1,iLoad) = sign(x)/(4*EI*kb^2)*(exp1-exp2);
            Urail(2*iOutput-0,iLoad) = 1/(4*EI*kb)*(-1i*exp1+exp2);
            Srail(2*iOutput-1,iLoad) = kb/4*(1i*exp1+exp2);
            Srail(2*iOutput-0,iLoad) = sign(x)/4*(-exp1-exp2);
        end
    end
end
%% Periodicity and wavenumber
L = (N+M)*Dlat;

%% Position of contact points
Dist = zeros(1,N);
for iN = 0: 1: N-1
    Dist(iN+1) = (iN-(N-1)/2)*Dlat;
end

%% Loop on wavenumbers
fprintf(1, '\n');
fprintf(1, 'Frequency = %f Hz ...\n', w/2/pi);
fprintf(1, 'Solving for %d wavenumbers ...\n', length(K));
fprintf(1, '[0%%                     50%%                    100%%]\n');
fprintf(1, '[');

k1 = K(1);
[urail_K1, srail_K1, usleeper_K1, ulattice_K1] = CalculateResponseK(...
    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,k1,XoR,IoL,LoS,LOAD,L,Dist);
urail_K = zeros([size(urail_K1) 1000]);
srail_K = zeros([size(srail_K1) 1000]);
usleeper_K = zeros([size(usleeper_K1) 1000]);
ulattice_K = zeros([size(ulattice_K1) 1000]);
nK = 1;
for iK = 2: 1: length(K)
    if mod(iK,round(length(K)/50)) == 0
        fprintf(1, '*');
    end
    k2 = K(iK);
    
    [urail_K2, srail_K2, usleeper_K2, ulattice_K2] = CalculateResponseK(...
    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,k2,XoR,IoL,LoS,LOAD,L,Dist);
    nK = nK + 1;

    Kall = [k1 k2 1 2];
    urail_K(:,:,1) = urail_K1; urail_K(:,:,2) = urail_K2;
    srail_K(:,:,1) = srail_K1; srail_K(:,:,2) = srail_K2;
    usleeper_K(:,:,1) = usleeper_K1; usleeper_K(:,:,2) = usleeper_K2;
    ulattice_K(:,:,:,1) = ulattice_K1; ulattice_K(:,:,:,2) = ulattice_K2;
    AVAILABLE = ones(1000,1); AVAILABLE(1:2) = 0;
    while ~isempty(Kall)
        kl = Kall(end,1); il = Kall(end,3);
        kr = Kall(end,2); ir = Kall(end,4);
        km = (kl+kr)/2;
        dk = (kr-kl);
        ur_total = (urail_K(:,:,il)+urail_K(:,:,ir))*dk/2;
        sr_total = (srail_K(:,:,il)+srail_K(:,:,ir))*dk/2;
        us_total = (usleeper_K(:,:,il)+usleeper_K(:,:,ir))*dk/2;
        ul_total = (ulattice_K(:,:,:,il)+ulattice_K(:,:,:,ir))*dk/2;
        
        [urail_Km, srail_Km, usleeper_Km, ulattice_Km] = CalculateResponseK(...
            EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,km,XoR,IoL,LoS,LOAD,L,Dist);
        nK = nK + 1;
        
        ur_new = ur_total/2 + urail_Km*dk/2;
        sr_new = sr_total/2 + srail_Km*dk/2;
        us_new = us_total/2 + usleeper_Km*dk/2;
        ul_new = ul_total/2 + ulattice_Km*dk/2;
        
        Kall(end,:) = [];
        fError = 0;
        for iLoad = 1: 1: nLoad
            fError = max([fError;
                          max(max(abs((ur_new(:,iLoad)-ur_total(:,iLoad))./max(ur_total(:,iLoad)))));
                          max(max(abs((sr_new(:,iLoad)-sr_total(:,iLoad))./max(sr_total(:,iLoad)))));
                          max(max(abs((us_new(:,iLoad)-us_total(:,iLoad))./max(us_total(:,iLoad)))));
                          max(max(max(abs((ul_new(:,:,iLoad)-ul_total(:,:,iLoad))./max(ul_total(:,:,iLoad))))))]);
        end
%         fprintf(1, 'kl = %f, km = %f, kr = %f, dk = %e\n', kl, km, kr, dk);
        if (fError < fTol)
            Urail = Urail + ur_new;
            Srail = Srail + sr_new;
            Usleeper = Usleeper + us_new;
            Ulattice = Ulattice + ul_new;
            if isempty(find(Kall(:,3:4)==il)), AVAILABLE(il) = 1; end
            if isempty(find(Kall(:,3:4)==ir)), AVAILABLE(ir) = 1; end
        else
            im = find(AVAILABLE == 1);
            if isempty(im) || dk < 10*eps
                fprintf(1, 'ERROR: too many subdivisions during the evauation of the integral.\n');
                return;
            end
            im = im(1);
            Kall = [Kall; kl km il im];
            Kall = [Kall; km kr im ir];
            urail_K(:,:,im) = urail_Km;
            srail_K(:,:,im) = srail_Km;
            usleeper_K(:,:,im) = usleeper_Km;
            ulattice_K(:,:,:,im) = ulattice_Km;
            AVAILABLE(im) = 0;
        end
        
    end

    % End of iteration
    k1 = k2;
    urail_K1 = urail_K2;
    srail_K1 = srail_K2;
    usleeper_K1 = usleeper_K2;
    ulattice_K1 = ulattice_K2;
end
fprintf(1, ']\n');
fprintf(1, 'Number of wavenumbers used in integration: %d\n', nK);

%% Store results
OUTPUT.RAIL = RAIL;
OUTPUT.SLEEPER = SLEEPER;
OUTPUT.LATTICE = LATTICE;
OUTPUT.XX = XX;
OUTPUT.ZZ = ZZ;
OUTPUT.MM = MM;
OUTPUT.LOAD = LOAD;
OUTPUT.XoR=XoR;
OUTPUT.LoS=LoS;
OUTPUT.IoL=IoL;
OUTPUT.Urail = Urail;
OUTPUT.Srail = Srail;
OUTPUT.Urail_K = Urail_K;
OUTPUT.Srail_K = Srail_K;
OUTPUT.Ulattice = Ulattice;
OUTPUT.Usleeper = Usleeper;

end

%% Integrating function
function [Urail, Srail, Usleeper, Ulattice] = CalculateResponseK(...
    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,k,XoR,IoL,LoS,LOAD,L,Dist)
SLEEPER = 0;
RAIL = 1;
LATTICE = 2;
XX = 1; % Horzintal
ZZ = 2; % Vertical
MM = 3; % Moment
%% Calculate matrix E
E = CalculateE(Kv,Kt,Ms,Js,Ku,Kuh,Dlat,N,w);

%% Calculate U
U = CalculateU(EI,m,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,w,k);

%% Flexibility - inverse of U+E
if Kuh == 0
    Flex = inv(U(1:N+2,1:N+2)+E(1:N+2,1:N+2));
else
    Flex = inv(U+E);
end

%% Calculate Ulat
Ulat = zeros(2*Nlat+2, 2*Nlat+2, N+M); FREE = 0;
if Knlat ~= inf
    for iM = 1: 1: N+M
        km = k + 2*pi*(iM-1)/L;
        Kelem = LayeredLattice_PSV(Mlat,Knlat,Kslat,...
                                        1, Dlat, w, km, FREE, FREE);
        Klat = zeros(2*Nlat+2,2*Nlat+2);
        for iZ = 1: 1: Nlat
            Klat((iZ-1)*2+(1:4),(iZ-1)*2+(1:4)) = ...
                        Klat((iZ-1)*2+(1:4),(iZ-1)*2+(1:4)) + Kelem;
        end
        Ulat(1:end-2,1:end-2,iM) = inv(Klat(1:end-2,1:end-2));
    end
end

%% characteristic wavelength of rail
kb = (w^2*m/EI)^.25;
if abs(kb-k)<eps
    kb = (w^2*m/(EI*(1+1i*0.00001)))^.25;
end

%% Loop on loads
nLoad = size(LOAD,1);
Urail = zeros(2*length(XoR), nLoad);
Srail = zeros(2*length(XoR), nLoad);
Usleeper = zeros(2*length(LoS), nLoad);
Ulattice = zeros(2*Nlat+2, length(IoL), nLoad);
for iLoad = 1: 1: nLoad
    ulattice = zeros(2*Nlat+2, length(IoL));
    CONTINUE = 0;
    if LOAD(iLoad,1) == RAIL
        xp = LOAD(iLoad,2);
        [c1,d1] = CalcCD(1i*kb,k,xp,L);
        [c2,d2] = CalcCD(kb,k,xp,L);
        u_ext = zeros(2*N+2,1);
        if LOAD(iLoad,3) == ZZ
            u_ext(N+(1:2),1) = 1/(4*EI)*[(-1i*c1-c2)/kb^3; (-d1+d2)/kb^2];
        else
            u_ext(N+(1:2),1) = 1/(4*EI)*[(d1-d2)/kb^2; (-1i*c1+c2)/kb];
        end
    elseif LOAD(iLoad,1) == LATTICE
        iL = LOAD(iLoad,2);
        u_ext = zeros(2*N+2,1);
        % Add to lattice outputs the contribution due to point load
        if mod(iL,N+M)>=N || LOAD(iLoad,3) ~= 0 || LOAD(iLoad,4) ~= XX || Kuh ~= inf
            for iM = 1: 1: N+M
                km = k + 2*pi*(iM-1)/L;
                exp1 = exp(-1i*km*Dlat*((0:1:(N-1))'-iL));
                u_ext(1:N) = u_ext(1:N) + exp1.*Ulat(2,2*LOAD(iLoad,3)+LOAD(iLoad,4),iM);
                u_ext(N+3:end) = u_ext(N+3:end) + exp1.*Ulat(1,2*LOAD(iLoad,3)+LOAD(iLoad,4),iM);
            end
            u_ext = -u_ext/(N+M);

            for iM = 1: 1: N+M
                km = k + 2*pi*(iM-1)/L;
                exp1 = exp(-1i*km*Dlat*(IoL-iL));
                ulat = Dlat/(2*pi)*Ulat(:,2*LOAD(iLoad,3)+LOAD(iLoad,4),iM);
                ulattice = ulattice + ulat*exp1;
            end
        else
            CONTINUE = 1;
        end
    end
    if CONTINUE; continue; end
    %% Calculate forces and dispalcemetns of sleepers/rail
    if Kuh == 0
        Forces = zeros(2*N+2,1);
        Forces(1:N+2) = Flex*u_ext(1:N+2);
    else
        Forces = Flex*u_ext;
    end

    %% Calculate response of rail - contribution of interaction forces
    Fk = Forces(N+1);
    Mk = Forces(N+2);
    for iOutput = 1:1:length(XoR)
        xp = -XoR(iOutput);
        [c1,d1] = CalcCD(1i*kb,k,xp,L);
        [c2,d2] = CalcCD(kb,k,xp,L);
        Urail((iOutput-1)*2+(1:2),iLoad) = ...
               -[(-1i*c1-c2)/kb^3 (d1-d2)/kb^2;
                 (-d1+d2)/kb^2 (-1i*c1+c2)/kb]*[Fk;Mk]*L/(8*pi*EI);
        Srail((iOutput-1)*2+[2 1], iLoad) = ...
               -[(1i*c1-c2)/kb^3 (-d1-d2)/kb^2;
                 (+d1+d2)/kb^2 (1i*c1+c2)/kb]*[Fk;Mk]*L*kb^2/(8*pi);
    end

    %% Calculate response of sleepers - contribution of interaction forces
    for iOutput = 1: 1: length(LoS)
        exp1 = exp(-1i*k*LoS(iOutput)*L);
        Usleeper(2*iOutput-1,iLoad) = ...
            (sum(Forces(1:N))-Forces(N+1))/(w^2*Ms) * exp1 * L/(2*pi);
        Usleeper(2*iOutput-0,iLoad) = ...
            (Dist*Forces(1:N)-Forces(N+2))/(w^2*Js) * exp1 * L/(2*pi);
    end

    %% Calculate response of lattice - contribution of interaction forces
    for iM = 1: 1: N+M
        km = k + 2*pi*(iM-1)/L;
        Flat = zeros(2,1);
        for iN = 0:1:N-1
            Flat = Flat + Forces(iN+1+[N+2;0])*exp(1i*km*Dlat*iN);
        end
        ulat = Dlat/(2*pi)*Ulat(:,[1 2],iM)*Flat;
        exp1 = exp(-1i*km*IoL*Dlat);
        ulattice = ulattice + ulat*exp1;
    end
%     ulattice(abs(ulattice)<1e-8*max(max(abs(ulattice)))) = 0;
    Ulattice(:,:,iLoad) = ulattice;
end
end

%% CalcCD
function [c,d] = CalcCD(k1,k2,x,L)
    X = floor(x/L);
    exp1 = exp(1i*k2*L*(X+1));
    exp2 = exp(-k1*(x-(X+1)*L));
    exp3 = 1/exp2;
    exp4 = exp((1i*k2+k1)*L);
    exp5 = exp((1i*k2-k1)*L);
    c = exp1*(exp2/(-1+exp4)-exp3/(-1+exp5));
    d = exp1*(-exp2/(-1+exp4)-exp3/(-1+exp5));
end

