function [ForcesP, ForcesM, UP, UM, UlatP, UlatM] = CalculateFrequencyDomainForces(...
    EI,m,Kv,Kt,Ms,Js,Ku,Kuh,Dlat,Mlat,Knlat,Kslat,Nlat,N,M,V,w0,W,DampType)
%% Check inputs
if real(Ku) == inf, Ku = real(Ku); end
if real(Kuh) == inf, Kuh = real(Kuh); end
if Knlat(1) == inf
    Nlat = 0; Knlat = inf; Kslat = inf; Mlat = inf;
end
if length(Mlat)~=length(Knlat) || length(Mlat)~=length(Kslat) || length(Mlat)~=length(Nlat)
    fprintf(1, 'ERROR: lattice inputs must have all the same dimensions (except for Dlat)');
    return;
end
%% Damping
VISCOUS = 1;
HYSTERETIC = 0;
if nargin < 18, DampType = HYSTERETIC; end
Cv = imag(Kv); Kv = real(Kv);
Ct = imag(Kt); Kt = real(Kt);
Cu = imag(Ku); Ku = real(Ku);
Cuh = imag(Kuh); Kuh = real(Kuh);
Cnlat = imag(Knlat); Knlat = real(Knlat);
Cslat = imag(Kslat); Kslat = real(Kslat);
CEI = imag(EI); EI = real(EI);

%% Calculate forces
ForcesP = zeros(2*N+2,length(W));
ForcesM = zeros(2*N+2,length(W));
UP = zeros(4,length(W));
UM = zeros(4,length(W));
if Knlat(1) ~= inf
    UlatP = zeros(2*sum(Nlat)+2,N+M,length(W));
    UlatM = zeros(2*sum(Nlat)+2,N+M,length(W));
else
    UlatP = [];
    UlatM = [];
end
Dist = zeros(1,N);
for iN = 0: 1: N-1
    Dist(iN+1) = (iN-(N-1)/2)*Dlat;
end
if length(W) > 1
    fprintf(1, '\n');
    fprintf(1, 'Calculating Sleeper Pad and Under Sleeper Pad forces  ...\n');
    fprintf(1, 'Solving for %d frequencies between %f and %f ...\n', length(W), W(1)/2/pi, W(end)/2/pi);
    fprintf(1, '[0%%                     50%%                    100%%]\n');
    fprintf(1, '[');
end
for iFreq = 1: 1: length(W)
    if mod(iFreq,round(length(W)/50)) == 0 && length(W) > 1
        fprintf(1, '*');
    end
    w = W(iFreq);
    if (w==0)
        continue;
    elseif DampType == HYSTERETIC
        wd = 1;
    elseif DampType == VISCOUS
        wd = w;
    end
    %% Calculate matrix E
    E = CalculateE(Kv+1i*wd*Cv,Kt+1i*wd*Ct,Ms,Js,Ku+1i*wd*Cu,Kuh+1i*wd*Cuh,Dlat,N,w);
    for iK = 1: 1: 2
        if iK == 1, k = (w-w0)/V;
        else, k = (w+w0)/V;
        end
        
        %% Calculate U
        U = CalculateU(EI+1i*wd*CEI,m,Dlat,Mlat,Knlat+1i*wd*Cnlat,Kslat+1i*wd*Cslat,Nlat,N,M,w,k,iK);
        
        %% Calculate u_ext
        u_ext = zeros(2*N+2,1);
        u_ext(N+1) = 1;
        u_ext(N+2) = -1i*k;
        u_ext = u_ext/V/(k^4*(EI+1i*wd*CEI)-w^2*m);
        
        %% Calculate forces and dispalcemetns of sleepers/rail
        if Kuh == 0
            Forces = zeros(2*N+2,1);
            Forces(1:N+2) = (U(1:N+2,1:N+2)+E(1:N+2,1:N+2))\u_ext(1:N+2);
        else
            Forces = (U+E)\u_ext;
        end
        us = [ones(1,N) -1 0]*Forces(1:N+2);
        us = us/w^2/Ms;
        rs = [Dist 0 -1]*Forces(1:N+2);
        rs = rs/w^2/Js;
        ur = us + Forces(N+1)/(Kv+1i*wd*Cv);
        rr = rs + Forces(N+2)/(Kt+1i*wd*Ct);
        
        %% Calculate Ulat
        if Knlat(1) ~= inf
            FREE = 0;
            Ulat = zeros(2*sum(Nlat)+2,N+M);
            for iM = 0: 1: N+M-1
                if iK == 1, km = k + 2*pi*iM/(N+M)/Dlat;
                else,       km = k - 2*pi*iM/(N+M)/Dlat;
                end
                Klat = zeros(2*sum(Nlat)+2,2*sum(Nlat)+2);
                kZ = 0;
                for iLayer = 1: 1: length(Nlat)
                    if iLayer == length(Nlat) && Nlat(iLayer) == 0
                        Klat(end-1,end-1) = Klat(end-1,end-1) + ...
                                        Kslat(iLayer)+1i*wd*Cslat(iLayer);
                        Klat(end,end) = Klat(end,end) + ...
                                        Knlat(iLayer)+1i*wd*Cnlat(iLayer);
                        continue;
                    end
                    Kelem = LayeredLattice_PSV(Mlat(iLayer), ...
                                          (Knlat(iLayer)+1i*wd*Cnlat(iLayer)),...
                                          (Kslat(iLayer)+1i*wd*Cslat(iLayer)),...
                                          1, Dlat, w, km, FREE, FREE);
                    for iZ = 1: 1: Nlat(iLayer)
                        kZ = kZ + 1;
                        Klat((kZ-1)*2+(1:4),(kZ-1)*2+(1:4)) = ...
                            Klat((kZ-1)*2+(1:4),(kZ-1)*2+(1:4)) + Kelem;
                    end
                end
                if Nlat(end) ~= 0
                    Klat = Klat(1:end-2,1:end-2);
                end
                Flat = zeros(size(Klat,1),1);
                for iN = 0:1:N-1
                    Flat(1:2) = Flat(1:2) + Forces(iN+1+[N+2;0])*exp(1i*km*iN*Dlat);
                end
                Flat(1:2) = Flat(1:2)/(M+N);
                if Nlat(end) ~= 0
                    Ulat(1:end-2,iM+1) = Klat\Flat;
                else
                    Ulat(:,iM+1) = Klat\Flat;
                end
            end
        end
        %% Store results
        if iK == 1
            ForcesP(:,iFreq) = Forces;
            UP(:,iFreq) = [us; rs; ur; rr];
            if Knlat(1) ~= inf
                UlatP(:,:,iFreq) = Ulat;
            end
        else
            ForcesM(:,iFreq) = Forces;
            UM(:,iFreq) = [us; rs; ur; rr];
            if Knlat(1) ~= inf
                UlatM(:,:,iFreq) = Ulat;
            end
        end
    end
end
if length(W) > 1
    fprintf(1, ']\n');
end

%% Interpolate forces and displacements for frequency 0
if W(1) == 0
    ForcesP(:,1) = 2*ForcesP(:,2)-ForcesP(:,3);
    ForcesM(:,1) = 2*ForcesM(:,2)-ForcesM(:,3);
    UP(:,1) = 2*UP(:,2)-UP(:,3);
    UM(:,1) = 2*UM(:,2)-UM(:,3);
    if Knlat(1) ~= inf
        UlatP(:,:,1) = 2*UlatP(:,:,2)-UlatP(:,:,3);
        UlatM(:,:,1) = 2*UlatM(:,:,2)-UlatM(:,:,3);
    end
end
end
