% Paired samples t-test

function p = ttest_output(v1,v2,nrdigits)
[~,p,~,stats]=ttest(v1,v2);
M1=mean(v1,'omitnan');
M2=mean(v2,'omitnan');
S1=std(v1,'omitnan');
S2=std(v2,'omitnan');
if p<0.001
    pstring = ' < 0.001.';
else
    pstring = [' = ' sprintf('%0.3f',p)];
end

disp(['Mean (SD) 1: ' sprintf(['%0.' num2str(nrdigits) 'f'],M1) ' (' sprintf(['%0.' num2str(nrdigits) 'f'],S1) ...
    '), Mean (SD) 2: ' sprintf(['%0.' num2str(nrdigits) 'f'],M2) ' (' sprintf(['%0.' num2str(nrdigits) 'f'],S2) ')' ...
    ', t(' num2str(stats.df) ') = '  sprintf('%0.2f',stats.tstat) ', p' pstring])
p=0;
