function createHeatmaps(x,y,colorbaradded)
Xres = -200:20:1000; % horizontal resolution
Yres = -300:20:200; % vertical resolution

C=NaN(length(Xres),length(Yres)); % pre-allocate matrix with NaNs (number of participants, x, y)

tempX=x(:);
tempY=y(:);
for i=1:length(Xres)-1
    for i2=1:length(Yres)-1
        C(i,i2)=sum(tempX>=Xres(i) & tempX<Xres(i+1) & tempY>=Yres(i2) & tempY<Yres(i2+1) ); 
        % C(1,1) corresponds to X between -200 and -180, and Y between -300 and -280
    end
end
set(gcf,'Renderer','Painters')
pcolor(Xres(1:end),Yres(1:end),1000*C'./sum(sum(C,'omitnan'),'omitnan')) % add 10 to the coordinates so that the middle of the 
shading flat
mycolormap=colormap("hsv");
ft=customcolormap([0 1],[mycolormap(52,:);0.5 0.5 0.5]);
mycolormap(1:52,:)=ft(1:5:end,:);
colormap(mycolormap);

view(0,90);
box off;axis off
if colorbaradded==1
    c=colorbar;
end
c.FontSize = 13;
c.TickDirection = 'out';
c.Ticks=5:5:40;
axis equal
set (gca,'YDir','reverse')
set(gca,'xlim',[-200 1000])
set(gca,'ylim',[-300 200])

clim([0 40])

if colorbaradded==0
    colorbar off
end