clear all;

font2=20;

X=[3, 4, 5, 6, 7];
YAM=[9.3, 23.2, 97.33, 99.71, 99.83];
YAEM=[2.52, 4.88, 75, 94.74, 95.8];
AbYAM=[9.2, 22.9, 96.16, 98.5, 98.63];
AbYAEM=[2.15, 4.16, 64.1, 80.9, 81.84];
YLatency=[7, 10, 16, 26, 44];
YEnergy=[1.573, 1.66, 1.85, 2.216, 2.96];

subplot(3,1,1)
plot (X,YAM,'b-.s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','k','MarkerFaceColor',[0 0 1]);
hold on;
plot (X,YAEM,'r-.s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','k','MarkerFaceColor',[1 0 0]);
hold on;
set(gca,'FontSize',font2);
xlim([2.6 7.4]);
ylim([0 100]);
set(gca,'xtick',[3, 4, 5, 6, 7]);
% set(gca,'ytick',[0, 1.1]);
% xyo=xlabel('');
yyo=ylabel('Relative Accuracy (%)');
% set(xyo,'FontSize',font);
% set(yyo,'FontSize',font);
% h=legend('WL','Location','SouthEast');
% set(h,'FontSize',font2);
grid(gca,'minor');
grid on;

subplot(3,1,2)
plot (X,YEnergy*1000/255,'k-.s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','k','MarkerFaceColor',[0.5 0.5 0.5]);
hold on;
set(gca,'FontSize',font2);
xlim([2.6 7.4]);
ylim([5 13]);
set(gca,'xtick',[3, 4, 5, 6, 7]);
% set(gca,'ytick',[0, 1.1]);
% xyo=xlabel('');
yyo=ylabel('Energy/Op (\itfJ)');
% set(xyo,'FontSize',font);
% set(yyo,'FontSize',font);
% h=legend('WL','Location','SouthEast');
% set(h,'FontSize',font2);
grid(gca,'minor');
grid on;

subplot(3,1,3)
plot (X,YLatency,'k-.s','LineWidth',1,'MarkerSize',10,'MarkerEdgeColor','k','MarkerFaceColor',[0.5 0.5 0.5]);
hold on;
set(gca,'FontSize',font2);
xlim([2.6 7.4]);
ylim([4 52]);
set(gca,'xtick',[3, 4, 5, 6, 7]);
% set(gca,'ytick',[0, 1.1]);
xyo=xlabel('ADC bit resolution');
yyo=ylabel('Latency (\itns)');
% set(xyo,'FontSize',font);
% set(yyo,'FontSize',font);
% h=legend('WL','Location','SouthEast');
% set(h,'FontSize',font2);
grid(gca,'minor');
grid on;
