import os, csv
import numpy as np
import pandas as pd
from scipy.optimize import curve_fit

def gaussian_1d(x, A, mu, sigma, offset):
    return offset + A * np.exp(-(x - mu)**2 / (2*sigma**2))

folder = r'data'
fn = r"xc100_yc0_passes_summary.npy"
passes = np.load(os.path.join(folder, fn), allow_pickle=True).item()

x = np.array(passes["modes"][(2,0)]["coeffs"])
y = np.array(passes["modes"][(2,0)]["amp"])
y = y/y.max()
A0      = y.max() - y.min()
mu0     = x[np.argmax(y)]
sigma0 = (x.max() - x.min())/4
off0    = y.min()
p0 = [A0, mu0, sigma0, off0]
popt, pcov = curve_fit(gaussian_1d, x, y, p0=p0, maxfev=10000)
A_fit, mu_fit, sigma_fit, off_fit = popt
xq = np.linspace(x.min(), x.max(), 200)
yq = gaussian_1d(xq, *popt)
y20 = y
yq20 = yq 
coeff20 = mu_fit

x = np.array(passes["modes"][(2,2)]["coeffs"])
y = np.array(passes["modes"][(2,2)]["amp"])
y = y/y.max()
A0      = y.max() - y.min()
mu0     = x[np.argmax(y)]
sigma0 = (x.max() - x.min())/4
off0    = y.min()
p0 = [A0, mu0, sigma0, off0]
popt, pcov = curve_fit(gaussian_1d, x, y, p0=p0, maxfev=10000)
A_fit, mu_fit, sigma_fit, off_fit = popt
xq = np.linspace(x.min(), x.max(), 200)
yq = gaussian_1d(xq, *popt)
y22 = y
yq22 = yq 
coeff22 = mu_fit

x = np.array(passes["modes"][(2,-2)]["coeffs"])
y = np.array(passes["modes"][(2,-2)]["amp"])
y = y/y.max()
A0      = y.max() - y.min()
mu0     = x[np.argmax(y)]
sigma0 = (x.max() - x.min())/4
off0    = y.min()
p0 = [A0, mu0, sigma0, off0]
popt, pcov = curve_fit(gaussian_1d, x, y, p0=p0, maxfev=10000)
A_fit, mu_fit, sigma_fit, off_fit = popt
xq = np.linspace(x.min(), x.max(), 200)
yq = gaussian_1d(xq, *popt)
y2n2 = y
yq2n2 = yq 
coeff2n2 = mu_fit


data = np.vstack([x, y20, y22, y2n2]).T

np.savetxt(
    'aberration_opt_100_0_coeffs_fitting_original.csv',
    data,
    delimiter=',',
    header='coeffs,def,ast,oast',
    comments=''
)


data = np.vstack([xq, yq20, yq22, yq2n2]).T

np.savetxt(
    'aberration_opt_100_0_coeffs_fitting_fine.csv',
    data,
    delimiter=',',
    header='coeffsq,defq,astq,oastq',
    comments=''
)

data = np.vstack([coeff20, coeff22, coeff2n2]).T

np.savetxt(
    'aberration_opt_100_0_coeffs_fitting_coeffs.csv',
    data,
    delimiter=',',
    header='defcoef,astcoef,oastcoef',
    comments=''
)