import os, csv
import numpy as np
import pandas as pd
import matplotlib.pyplot as plt

folder = r'\data\'
fn = r"xc100_yc0_passes_summary.npy"
passes = np.load(os.path.join(folder, fn), allow_pickle=True)

# --- flatten into a table of steps ---
rows = []
mode_order = [(2, 0), (2, 2), (2, -2), (3, 1), (3, -1), (3, 3), (3, -3),
              (4, 0), (4, 2), (4, -2), (5, 1), (5, -1), (5, 3), (5, -3)]

step = 0
for p in passes:
    modes = p["modes"]
    for (n, m) in mode_order:
        if (n, m) not in modes:
            continue
        md = modes[(n, m)]
        step += 1
        rows.append({
            "step": step,
            "pass": p["pass"],
            "fwhm_x": md.get("fwhm_x_opt", np.nan),
            "fwhm_y": md.get("fwhm_y_opt", np.nan),
            "peak_opt": md.get("peak_opt", np.nan),
            "label": f"({n},{m})"
        })

df = pd.DataFrame(rows)
peak_norm = df["peak_opt"] / df["peak_opt"].max()
pixel_size = 3.5
df["eps"] = np.abs(df["fwhm_x"] - df["fwhm_y"]) / (df["fwhm_x"] + df["fwhm_y"])


# rebuild your table as before into df (with column 'label')
out = pd.DataFrame({
    "modes": df["step"],
    "peak":  df["peak_opt"]/df["peak_opt"].max(),
    "fwhm_x": df["fwhm_x"]*3.5,
    "fwhm_y": df["fwhm_y"]*3.5,
    "eps":   np.abs(df["fwhm_x"]-df["fwhm_y"])/(df["fwhm_x"]+df["fwhm_y"]),
    "modelabel": df["label"].apply(lambda s: '{'+s+'}')   # <- brace it
})
out.to_csv('aberration_opt_100_0_convergence.csv',
           index=False, quoting=csv.QUOTE_NONE, escapechar='\\')



