inputFile="geneMethy.tsv"               
normalNum=50                            
tumorNum=375 ##删除了复发的肿瘤组织                           
fdrFilter=0.05                          
logFCfilter=0.2                           

#if (!requireNamespace("BiocManager", quietly = TRUE))
 # install.packages("BiocManager")

#BiocManager::install("affy")

#???????
library(limma)
library(affy)
outTab=data.frame()

##grade=c(rep(1,normalNum),rep(2,tumorNum))
##Type=c(rep("Normal",normalNum),rep("Tumor",tumorNum))

##grade
library(Biobase)
#import phenotype data
phenoData = read.AnnotatedDataFrame('target.txt')
pheno = pData(phenoData)
View(pheno)

#model design
Group = factor(pheno$Group,levels=c('tumor','control'))
design = model.matrix(~0+Group)
colnames(design) <- c('tumor','control')
design
Group


rt=read.table(inputFile,sep="\t",header=T,check.names=F)
rt=as.matrix(rt)
rownames(rt)=rt[,1]
exp=rt[,2:ncol(rt)]
dimnames=list(rownames(exp),colnames(exp))
data=matrix(as.numeric(as.matrix(exp)),nrow=nrow(exp),dimnames=dimnames)
data=avereps(data)
data=data[rowMeans(data)>0,]
data=normalizeBetweenArrays(data)
normalData=cbind(id=row.names(data),data)
write.table(normalData,file="normalizeMethy.txt",sep="\t",row.names=F,quote=F)

  
##去删除所有包含Na的行
data<-normalizeMethy[rowSums(is.na(normalizeMethy)) == 0,]
write.table(data,file="normalizeMethy-除去na行后.txt",sep="\t",row.names=F,quote=F)


#删掉复发组织包含：复发02A*2，02B*1,01B*2
data<-data[,-c("TCGA.DD.AACA.02B","TCGA.DD.AACA.02A","TCGA.ZS.A9CF.02A","TCGA.BC.4072.01B","TCGA.BC.4073.01B")]
data<-data[,-c(116,181,149,249,317)]
rownames(data)<-data[,1]
data<-data[,-1]
data[1:10,1:10]
data<-as.matrix(data)


  for(i in row.names(data)){
  rt=rbind(expression=data[i,],grade=Group)
  rt=as.matrix(t(rt))
  wilcoxTest<-wilcox.test(expression ~ Group, data=rt)

  normalGeneMeans=mean(data[i,1:normalNum])
  tumorGeneMeans=mean(data[i,(normalNum+1):ncol(data)])
  logFC=log2(tumorGeneMeans)-log2(normalGeneMeans)  
  pvalue=wilcoxTest$p.value
  normalMed=median(data[i,1:normalNum])
  tumorMed=median(data[i,(normalNum+1):ncol(data)])
  diffMed=tumorMed-normalMed
	if( ((logFC>0) & (diffMed>0)) | ((logFC<0) & (diffMed<0)) ){  
		  outTab=rbind(outTab,
		               cbind(gene=i,
		               normalMean=normalGeneMeans,
		               TumorMean=tumorGeneMeans,
		               logFC=logFC,
		               pValue=pvalue))
	 }
}

#??p?????????
pValue=outTab[,"pValue"]
fdr=p.adjust(as.numeric(as.vector(pValue)),method="fdr")
outTab=cbind(outTab,fdr=fdr)

#保存所有的甲基化位点的信息
write.table(outTab,file="allGene.xls",sep="\t",row.names=F,quote=F)

#保存差异甲基化位点
outDiff=outTab[( abs(as.numeric(as.vector(outTab$logFC)))>logFCfilter & as.numeric(as.vector(outTab$fdr))<fdrFilter),]
write.table(outDiff,file="diff.xls",sep="\t",row.names=F,quote=F)


#读取注释文件，将甲基化位点注释
ann = read.delim(file="ann.txt")
names(ann)[1] <- names(outTab)[1]
names(ann)[1] <- names(outDiff)[1]
allGene<-merge(ann, outTab, by = c('gene')  ) 
outDiff<-merge(ann, outDiff, by = c('gene')  ) 
allGene<-allGene[,-c(2:5)]
outDiff<-outDiff[,-c(2:5)]
allGene<-allGene[,-c(3:7)]
outDiff<-outDiff[,-c(3:7)]
write.table(allGene,file="allGene-转换后.txt",sep="\t",quote=F,row.names=FALSE)
write.table(outDiff,file="outDiff-转换后.txt",sep="\t",quote=F,row.names=FALSE)


#热图的绘制
heatmap=data[as.vector(outDiff[,1]),]
heatmap=cbind(id=row.names(heatmap),heatmap)
write.table(heatmap,file="heatmap.txt",sep="\t",row.names=F,quote=F)


rt=read.table("heatmap.txt",sep="\t",header=T,row.names=1,check.names=F)
#rt=rt[1:100,]   #选择所有的差异甲基化基因画热图

library(pheatmap)
Type=c(rep("normal",50),rep("tumor",375))    #修改正常和癌症样品数目
names(Type)=colnames(rt)
Type=as.data.frame(Type)

tiff(file="heatmap.tiff",
     width = 45,            #图片的宽度
     height =70,            #图片的高度
     units ="cm",
     compression="lzw",
     bg="white",
     res=300)
pheatmap(rt, annotation=Type, 
         color = colorRampPalette(c("green", "black", "red"))(50),
         cluster_cols =F,
         fontsize_row=5,
         fontsize_col=4)
dev.off()
  

