#install.packages("rms")
library(rms)
#TCGA
riskFile="tcgaRisk.txt"
cliFile="tcgaClinical.txt"
outFile="tcga.Nomogram.pdf"
risk=read.table(riskFile,header=T,sep="\t",check.names=F,row.names=1)        
cli=read.table(cliFile,sep="\t",check.names=F,header=T,row.names=1)          
sameSample=intersect(row.names(cli),row.names(risk))
risk=risk[sameSample,]
cli=cli[sameSample,]
rt=cbind(futime=risk[,1],fustat=risk[,2],cli,riskScore=risk[,(ncol(risk)-1)])

dd <- datadist(rt)
options(datadist="dd")

f <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=1)
surv <- Survival(f)
nomogram
nom <- nomogram(f, fun=list(function(x) surv(1, x), function(x) surv(2, x), function(x) surv(3, x)), 
    lp=F, funlabel=c("1-year survival", "3-year survival", "5-year survival"), 
    maxscale=100, 
    fun.at=c(0.99, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3,0.2,0.1,0.05))  
#nomogram???ӻ?
pdf(file=outFile,height=7.5,width=11)
plot(nom)
dev.off()

##1. discrimination：C-index、AUC
validate(f, method="boot", B=1000, dxy=T)
rcorrcens(Surv(futime, fustat) ~ predict(f), data = rt)


f5 <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=5)


#2.calibration，including 1-，3-，and 5 years
#3-year survival calibration curve
f1 <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=1*1*1)
cal1 <- calibrate(f1, cmethod="KM", method="boot", u=1*1*1, m=70, B=1000)  #m为样本数除以3  ##B越大效果越好，时间越久
plot(cal1)
plot(cal1,lwd=3,lty=2,errbar.col="black",xlim = c(0,1),ylim = c(0,1),xlab ="Nomogram-Predicted Probability of 1-Year Survival",ylab="Actual 1-Year Survival",col="blue")

f3 <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=3)
cal3 <- calibrate(f3, cmethod="KM", method="boot", u=3, m=70, B=1000)  #m为样本数除以3  ##B越大效果越好，时间越久
plot(cal3)
plot(cal3,lwd=3,lty=2,errbar.col="black",xlim = c(0,1),ylim = c(0,1),xlab ="Nomogram-Predicted Probability of 3-Year Survival",ylab="Actual 3-Year Survival",col="blue")

f5 <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=5)
cal5 <- calibrate(f5, cmethod="KM", method="boot", u=5, m=70, B=1000)  #m为样本数除以3  ##B越大效果越好，时间越久
plot(cal5)
plot(cal5,lwd=3,lty=2,errbar.col="black",xlim = c(0,1),ylim = c(0,1),xlab ="Nomogram-Predicted Probability of 5-Year Survival",ylab="Actual 5-Year Survival",col="blue")


#C-index和95% CI
validate(f, method="boot", B=1000, dxy=T)
rcorrcens(Surv(futime, fustat) ~ predict(f), data = rt)
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("survcomp", version = "3.8")
library(survcomp)
cindex <- concordance.index(predict(f),
                            surv.time = rt$futime, surv.event = rt$fustat,method = "noether")
cindex$c.index; cindex$lower; cindex$upper


##ROC curve
##install.packages("survivalROC")
library(survivalROC)
pdf(file="TCGA-ROC-5.pdf",width=6,height=6)
par(oma=c(0.5,1,0,1),font.lab=1.5,font.axis=1.5)
roc=survivalROC(Stime=rt$futime, status=rt$fustat, marker = rt$riskScore, 
                predict.time =5, method="KM")
 plot(roc$FP, roc$TP, type="l", xlim=c(0,1), ylim=c(0,1),col='red', 
     xlab="False positive rate", ylab="True positive rate",
     main=paste("ROC curve (", "AUC = ",sprintf("%.3f",roc$AUC),")"),
     lwd = 2, cex.main=1.3, cex.lab=1.2, cex.axis=1.2, font=1.2)
abline(0,1)
dev.off()

pdf(file="TCGA-ROC-3.pdf",width=6,height=6)
par(oma=c(0.5,1,0,1),font.lab=1.5,font.axis=1.5)
roc=survivalROC(Stime=rt$futime, status=rt$fustat, marker = rt$riskScore, 
                predict.time =3, method="KM")
plot(roc$FP, roc$TP, type="l", xlim=c(0,1), ylim=c(0,1),col='red', 
     xlab="False positive rate", ylab="True positive rate",
     main=paste("ROC curve (", "AUC = ",sprintf("%.3f",roc$AUC),")"),
     lwd = 2, cex.main=1.3, cex.lab=1.2, cex.axis=1.2, font=1.2)
abline(0,1)
dev.off()


pdf(file="TCGA-ROC-1.pdf",width=6,height=6)
par(oma=c(0.5,1,0,1),font.lab=1.5,font.axis=1.5)
roc=survivalROC(Stime=rt$futime, status=rt$fustat, marker = rt$riskScore, 
                predict.time =1, method="KM")
plot(roc$FP, roc$TP, type="l", xlim=c(0,1), ylim=c(0,1),col='red', 
     xlab="False positive rate", ylab="True positive rate",
     main=paste("ROC curve (", "AUC = ",sprintf("%.3f",roc$AUC),")"),
     lwd = 2, cex.main=1.3, cex.lab=1.2, cex.axis=1.2, font=1.2)
abline(0,1)
dev.off()



#GEO
riskFile="geoRisk.txt"
cliFile="geoClinical.txt"
outFile="geo.Nomogram.pdf"
risk=read.table(riskFile,header=T,sep="\t",check.names=F,row.names=1)      
cli=read.table(cliFile,sep="\t",check.names=F,header=T,row.names=1)         
sameSample=intersect(row.names(cli),row.names(risk))
risk=risk[sameSample,]
cli=cli[sameSample,]
rt=cbind(futime=risk[,1],fustat=risk[,2],cli,riskScore=risk[,(ncol(risk)-1)])
#???ݴ???
dd <- datadist(rt)
options(datadist="dd")
#???ɺ???
f <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=1)
surv <- Survival(f)
#??��nomogram
nom <- nomogram(f, fun=list(function(x) surv(1, x), function(x) surv(2, x), function(x) surv(3, x)), 
    lp=F, funlabel=c("1-year survival", "3-year survival", "5-year survival"), 
    maxscale=100, 
    fun.at=c(0.99, 0.9, 0.8, 0.7, 0.6, 0.5, 0.4, 0.3,0.2,0.1,0.05))  
#nomogram???ӻ?
pdf(file=outFile,height=6,width=9)
plot(nom)
dev.off()

#C-index和95%CI
validate(f, method="boot", B=1000, dxy=T)
rcorrcens(Surv(futime, fustat) ~ predict(f), data = rt)
if (!requireNamespace("BiocManager", quietly = TRUE))
    install.packages("BiocManager")
BiocManager::install("survcomp", version = "3.8")
library(survcomp)
cindex <- concordance.index(predict(f),
                            surv.time = rt$futime, surv.event = rt$fustat,method = "noether")
cindex$c.index; cindex$lower; cindex$upper



pdf(file="geo-ROC-5.pdf",width=6,height=6)
par(oma=c(0.5,1,0,1),font.lab=1.5,font.axis=1.5)
roc=survivalROC(Stime=rt$futime, status=rt$fustat, marker = rt$riskScore, 
                predict.time =5, method="KM")
plot(roc$FP, roc$TP, type="l", xlim=c(0,1), ylim=c(0,1),col='red', 
     xlab="False positive rate", ylab="True positive rate",
     main=paste("ROC curve (", "AUC = ",sprintf("%.3f",roc$AUC),")"),
     lwd = 2, cex.main=1.3, cex.lab=1.2, cex.axis=1.2, font=1.2)
abline(0,1)
dev.off()

pdf(file="geo-ROC-3.pdf",width=6,height=6)
par(oma=c(0.5,1,0,1),font.lab=1.5,font.axis=1.5)
roc=survivalROC(Stime=rt$futime, status=rt$fustat, marker = rt$riskScore, 
                predict.time =3, method="KM")
plot(roc$FP, roc$TP, type="l", xlim=c(0,1), ylim=c(0,1),col='red', 
     xlab="False positive rate", ylab="True positive rate",
     main=paste("ROC curve (", "AUC = ",sprintf("%.3f",roc$AUC),")"),
     lwd = 2, cex.main=1.3, cex.lab=1.2, cex.axis=1.2, font=1.2)
abline(0,1)
dev.off()

pdf(file="geo-ROC-1.pdf",width=6,height=6)
par(oma=c(0.5,1,0,1),font.lab=1.5,font.axis=1.5)
roc=survivalROC(Stime=rt$futime, status=rt$fustat, marker = rt$riskScore, 
                predict.time =1, method="KM")
plot(roc$FP, roc$TP, type="l", xlim=c(0,1), ylim=c(0,1),col='red', 
     xlab="False positive rate", ylab="True positive rate",
     main=paste("ROC curve (", "AUC = ",sprintf("%.3f",roc$AUC),")"),
     lwd = 2, cex.main=1.3, cex.lab=1.2, cex.axis=1.2, font=1.2)
abline(0,1)
dev.off()


#2. calibration，包括3年 5年 10年的calibration curve
#3-year survival calibration curve
f5 <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=5)
cal5 <- calibrate(f5, cmethod="KM", method="boot", u=5, m=70, B=1000)  #m为样本数除以3  ##B越大效果越好，时间越久
plot(cal5)
plot(cal5,lwd=3,lty=2,errbar.col="black",xlim = c(0,1),ylim = c(0,1),xlab ="Nomogram-Predicted Probability of 5-Year Survival",ylab="Actual 5-Year Survival",col="blue")


f3 <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=3)
cal3 <- calibrate(f3, cmethod="KM", method="boot", u=3, m=70, B=1000)  #m为样本数除以3  ##B越大效果越好，时间越久
plot(cal3)
plot(cal3,lwd=3,lty=2,errbar.col="black",xlim = c(0,1),ylim = c(0,1),xlab ="Nomogram-Predicted Probability of 3-Year Survival",ylab="Actual 3-Year Survival",col="blue")

f1 <- cph(Surv(futime, fustat) ~ ., x=T, y=T, surv=T, data=rt, time.inc=5)
cal1 <- calibrate(f5, cmethod="KM", method="boot", u=5, m=70, B=1000)  #m为样本数除以3  ##B越大效果越好，时间越久
plot(cal1)
plot(cal1,lwd=3,lty=2,errbar.col="black",xlim = c(0,1),ylim = c(0,1),xlab ="Nomogram-Predicted Probability of 1-Year Survival",ylab="Actual 1-Year Survival",col="blue")


