###更换工作目录，可以在Rstudio中完成
# Session,Set working directory,Choose working directory,选择Document/GSE17548

#清除所有的数据
rm(list = ls())

getwd()
#安装bioconductor包（第一次需要安装）
#options(BioC_mirror="https://mirrors.ustc.edu.cn/bioc/")
#if(!require("limma")) BiocManager::install("limma",update = F,ask = F)

##下载数据(如果不需要下载平台数据，则把所有的T改为F即可)
library(GEOquery)
library(Biobase)
options( 'download.file.method.GEOquery' = 'libcurl' ) 
gset <- getGEO('GSE76427',destdir = ".",
               AnnotGPL = F,
               getGPL = T)

###读取数据(直接读取未解压的文件即可)
exprSet <- read.table("geoMatrix.txt",comment.char="!",stringsAsFactors=F,header=T)

##安装所需的包（原始数据一般用affy包，一般我们的二次数据最好选用limma包）
##source("http://bioconductor.org/biocLite.R")
##biocLite("Limma")
##biocLite("gplots")
library(limma)
library(affy)

#import phenotype data（自己整理表型文件target.txt)
phenoData = read.AnnotatedDataFrame('target.txt')
pheno = pData(phenoData)
View(pheno)
class(pheno)

#model design
Group = factor(pheno$Group,levels=c('tumor','normal'))
design = model.matrix(~0+Group)
colnames(design) <- c('cancer','control')
design
Group

##首先看一下我们的数据类型
class(exprSet)
##需要转换成矩阵文件(如果已经是矩阵的话就不需要再转了)
rownames(exprSet) <- exprSet[,1]
exprSet <- exprSet[,-1]

##看是否需要log2转换：
ex <- exprSet
qx <- as.numeric(quantile(ex, c(0., 0.25, 0.5, 0.75, 0.99, 1.0), na.rm=T))
LogC <- (qx[5] > 100) ||
  (qx[6]-qx[1] > 50 && qx[2] > 0) ||
  (qx[2] > 0 && qx[2] < 1 && qx[4] > 1 && qx[4] < 2)

if (LogC) { ex[which(ex <= 0)] <- NaN
exprSet <- log2(ex)
print("log2 transform finished")}else{print("log2 transform not needed")}


#linear model fitness
fit <- lmFit(exprSet,design)

#generate contrast matrix（ #1,FC正值的为上调，负的为下调）
contrast.matrix <- makeContrasts(cancer-control,        
                                 levels=design)

#constrast model fit
fit2 <- contrasts.fit(fit, contrast.matrix)

#bayes model
fit2 <- eBayes(fit2)

#输出基因,我们保存一下未进行探针转换和去重的全部基因和差异基因
allDiff=topTable(fit2,adjust='fdr',coef=1,number=Inf) 
save(allDiff,file = "allDiff.Rda")
write.table(allDiff,file="allDiff-2.xls",sep="\t",quote=F)

#get DEGs（log2 2 中的第一个2指的是倍数，第二个2指的是底数）（在此，我们得到我们想要的差异基因了）
diff = topTable(fit2,adjust.method="fdr",coef=1,p.value=0.05,
                lfc=log(1,2),number=50000,sort.by = 'logFC')
write.table(diff,file="diff-2.xls",sep="\t",quote=F)

##注意：我们上面得到了全部基因和差异基因，但都是探针名，我们需要的是基因名，所以需要转换2次
##探针基因名称的转换
##将差异基因列表diff转换为和注释文件一样的类型
diff <- cbind(rownames(diff), data.frame(diff, row.names=NULL))
allDiff <- cbind(rownames(allDiff), data.frame(allDiff, row.names=NULL))
exprSet <- cbind(rownames(exprSet), data.frame(exprSet, row.names=NULL))

##ann.txt是处理过的注释文件
platformMap <- data.table::fread("ann.txt")


#两个数据框的行名第一个使用相同的名称，便于以后合并
names(diff)[1] <- names(probe2symbol_df)[1]
names(allDiff)[1] <- names(probe2symbol_df)[1]
names(exprSet)[1] <- names(probe2symbol_df)[1]

#看一下symbol有没有重复，这一步先去重再看长度
length(unique(probe2symbol_df$symbol))
## 而探针和基因的对应关系要更多
nrow(probe2symbol_df)
# 所以需要去重，多个探针对应一个基因

#之后要合并数据，看看数据类型
class(diff$probe_id)
class(probe2symbol_df$probe_id)

class(allDiff$probe_id)
class(probe2symbol_df$probe_id)

class(exprSet$probe_id)
class(probe2symbol_df$probe_id)

#如果发现这两个类型不一样，下面这句为经典的转换语句
diff$probe_id <- as.character(diff$probe_id)
allDiff$probe_id <- as.character(allDiff$probe_id)
exprSet$probe_id <- as.character(exprSet$probe_id)

###探针转换以及去重，获得最终的表达矩阵（超级强大的代码组合）
### 拆分体会
library(dplyr)
diff <- diff %>%
  inner_join(probe2symbol_df,by="probe_id") %>% #合并探针的信息
  select(-probe_id) %>%  #去掉多余信息
  select(symbol,1:(length(diff)-1)) %>%  #重新排列，
  mutate(rowMean =rowMeans(.[grep("GSM", names(.))])) %>% #求出平均数(这边的.真的是画龙点睛)
  arrange(desc(rowMean)) %>% #把表达量的平均值按从大到小排序
  distinct(symbol,.keep_all = T) %>% # symbol留下第一个
  select(-rowMean) #反向选择去除rowMean这一列

##提前保存
write.table(diff,'DEG.txt',col.names=T,row.names=F,sep="\t",quote=F)
##继续列转行名
rownames(diff) <- diff[,1]
diff <- diff[,-1]

##获取我们需要的数据,如果直接保存为DGE.txt格式打开的时候会丢失行名
##write.table(diff,'DEG.txt',col.names=T,row.names=F,sep="\t",quote=F)
save(diff,Group,file = "diffLab.Rda")



##继续我们对所有基因的转换过程啦
### 拆分体会
library(dplyr)
allDiff <- allDiff %>%
  inner_join(probe2symbol_df,by="probe_id") %>% #合并探针的信息
  select(-probe_id) %>%  #去掉多余信息
  select(symbol,1:(length(allDiff)-1)) %>%  #重新排列，
  mutate(rowMean =rowMeans(.[grep("GSM", names(.))])) %>% #求出平均数(这边的.真的是画龙点睛)
  arrange(desc(rowMean)) %>% #把表达量的平均值按从大到小排序
  distinct(symbol,.keep_all = T) %>% # symbol留下第一个
  select(-rowMean) #反向选择去除rowMean这一列

##获取我们需要的数据
write.table(allDiff,'allDiff.txt',col.names=T,row.names=F,sep="\t",quote=F)

##继续列转行名
rownames(allDiff) <- allDiff[,1]
allDiff <- allDiff[,-1]

##获取我们需要的数据
##write.table(allDiff,'allDiff.txt',col.names=T,row.names=F,sep="\t",quote=F)
##这个保存是为了下一步热图做准备
save(allDiff,file = "allDiff.Rda")


##继续我们对所有基因的转换过程啦
### 拆分体会
library(dplyr)
exprSet <- exprSet %>%
  inner_join(probe2symbol_df,by="probe_id") %>% #合并探针的信息
  select(-probe_id) %>%  #去掉多余信息
  select(symbol,1:(length(exprSet)-1)) %>%  #重新排列，
  mutate(rowMean =rowMeans(.[grep("GSM", names(.))])) %>% #求出平均数(这边的.真的是画龙点睛)
  arrange(desc(rowMean)) %>% #把表达量的平均值按从大到小排序
  distinct(symbol,.keep_all = T) %>% # symbol留下第一个
  select(-rowMean) #反向选择去除rowMean这一列

##同理，我们先保存一下
write.table(exprSet,'exprSet.txt',col.names=T,row.names=F,sep="\t",quote=F)
##继续列转行名
rownames(exprSet) <- exprSet[,1]
exprSet <- exprSet[,-1]

##获取我们需要的数据
##write.table(exprSet,'exprSet.txt',col.names=T,row.names=F,sep="\t",quote=F)
##这个保存是为了下一步热图做准备
save(exprSet,file = "exprSet_20190812.Rdata")
##做完这些，我们得到了4个文件，分别是总基因和差异基因的两种格式的文件

