clear variables;close all;clc
%% Read the data from the Excel files
Qualtrics_data = readtable('ChatGPT_September+11,+2023_19.47.xlsx','VariableNamingRule','preserve');
Qualtrics_data(strcmp(Qualtrics_data{:,19},'I do not agree to participate.'),:) = []; % remove participants who did not give consent
Prolific_data = readtable('Demographic_data_Prolific_September_2023.xlsx','VariableNamingRule','preserve');
[~,reorderIdx] = ismember(Qualtrics_data{:,93},Prolific_data{:,2});
Prolific_data_reordered = Prolific_data(reorderIdx,:);

if any(strcmp(Prolific_data_reordered.Properties.VariableNames,'Status'))
    Prolific_data_reordered.Properties.VariableNames{'Status'} = 'Status_Prolific'; % adjust the header in case of identical headers between Qualtrics_data and Prolific_data
end

All_data = [Qualtrics_data,Prolific_data_reordered]; % append Prolific data to All_data: 1975 x 112 table
All_data(strcmp(All_data{:,25},'No') | strcmp(All_data{:,25},'I prefer not to respond'),:) = []; % remove participants who responded 'No' or 'I prefer not to respond' to the question 'Have you ever heard of ChatGPT?'
All_data_c=table2cell(All_data);
%% Create the prompt
clear response
v=[28 55];
% 28: G8. Describe what you use ChatGPT for in a number of sentences.
% 55: G11. Please explain your answers. What are the strengths and weaknesses of ChatGPT? (Text entry with a minimum of 20 characters.)
for i=1:length(v)
    AllTextofItem=All_data_c(:,v(i));
    all_responses=[];

    for line=1:size(AllTextofItem,1)
        all_responses=[all_responses 'Reponse number: ' num2str(line) ': ' AllTextofItem{line} newline]; %#ok<AGROW>
    end

    if v(i)==28
        prompt = ['Describe what respondents use ChatGPT for. Provide a dense yet comprehensive summary: ' newline all_responses];
    elseif v(i)==55
        prompt = ['What strengths and weaknesses of ChatGPT are mentioned in the responses below? Provide a dense yet comprehensive summary: ' newline all_responses];
    end
    %% Send the Prompt the OpenAI API
    import matlab.net.* matlab.net.http.* matlab.net.http.io.*
    uri = URI('https://api.openai.com/v1/chat/completions');

    disp(datetime('now'))    
    body = JSONProvider(struct('model','gpt-4-1106-preview','temperature',0,'n',1,'messages', {{struct('role', 'user','content', prompt')}}));
    response = RequestMessage('post', [HeaderField('Content-Type', 'application/json') HeaderField('Authorization', 'Bearer sk-xxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxxx')], body).send(uri.EncodedURI);
    disp(datetime('now'))
    disp(response.Body.Data.choices.message.content)
end